/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Vector;

public class FlowLabel
extends Canvas {
    private String labelText = "";
    private Vector textVector = new Vector();
    private transient Object textVectorLock = new Object();
    private static Font labelFont = null;
    private static String[] addAttr = new String[]{"<bold>", "<b>", "<italics>", "<i>", "<tt>", "<br>", "<p>"};
    private static int attrBold = 3;
    private static int attrItalics = 12;
    private static int attrTt = 16;
    private static int attrBreak = 32;
    private static int attrParagraph = 64;
    private static int attrFlowControlOnly = attrBreak | attrParagraph;
    private static String[] removeAttr = new String[]{"</bold>", "</b>", "</italics>", "</i>", "</tt>", "</br>", "</p>"};
    private transient Dimension currentSize = new Dimension(0, 0);
    private transient Object currentSizeLock = new Object();
    private transient Vector paintVector = new Vector();
    private transient Object paintVectorLock = new Object();
    private int horizontalMargin = 10;
    private int verticalMargin = 5;
    static final long serialVersionUID = -4025711393515048887L;

    public FlowLabel() {
    }

    public FlowLabel(String text) {
        this.labelText = text;
        this.textVector = this.createTextVector();
    }

    /*
     * Unable to fully structure code
     */
    private Vector createPaintVector(Dimension size) {
        paintVector = new Vector<Vector<E>>();
        try {
            s = new Dimension(size);
            s.width -= this.horizontalMargin * 2;
            s.height -= this.verticalMargin * 2;
            currentWidth = 0;
            line = false;
            lineVector = new Vector<E>();
            currentLine = new String();
            textObjects = null;
            begin = 0;
            end = 0;
            testEnd = 0;
            wordCount = 0;
            currentFont = this.getFont();
            currentFont = new Font(currentFont.getName(), 0, currentFont.getSize());
            fm = this.getFontMetrics(currentFont);
            var15_15 = this.textVector;
            synchronized (var15_15) {
                textObjects = this.textVector.elements();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var15_15
                if (true) ** GOTO lbl73
            }
            do {
                if ((textObject = textObjects.nextElement()) instanceof Integer) {
                    newAttribute = (Integer)textObject;
                    if ((newAttribute & FlowLabel.attrBreak) != 0) {
                        paintVector.addElement(lineVector);
                        lineVector = new Vector<E>();
                        begin = end;
                        wordCount = 0;
                        currentWidth = 0;
                    } else if ((newAttribute & FlowLabel.attrParagraph) != 0) {
                        paintVector.addElement(lineVector);
                        lineVector = new Vector<E>();
                        paintVector.addElement(lineVector);
                        lineVector = new Vector<E>();
                        begin = end;
                        wordCount = 0;
                        currentWidth = 0;
                    }
                    currentFont = this.getNewFont(currentFont, (Integer)textObject);
                    fm = this.getFontMetrics(currentFont);
                    lineVector.addElement(textObject);
                    continue;
                }
                currentLine = (String)textObject;
                begin = 0;
                end = 0;
                while (end < currentLine.length() - 1) {
                    if (wordCount == 0) {
                        begin = this.skipWhitespace(currentLine, begin);
                        end = this.getNextWordIndex(currentLine, end);
                        ++wordCount;
                    }
                    testEnd = this.getNextWordIndex(currentLine, end);
                    while (testEnd <= currentLine.length() && fm.stringWidth(currentLine.substring(begin, testEnd)) + currentWidth < s.width) {
                        end = testEnd;
                        testEnd = this.getNextWordIndex(currentLine, end);
                        ++wordCount;
                    }
                    if (end >= currentLine.length() - 1) {
                        currentWidth = fm.stringWidth(currentLine.substring(begin, end)) + currentWidth;
                        lineVector.addElement(currentLine.substring(begin, end));
                        continue;
                    }
                    lineVector.addElement(currentLine.substring(begin, end));
                    paintVector.addElement(lineVector);
                    lineVector = new Vector<E>();
                    begin = end;
                    wordCount = 0;
                    currentWidth = 0;
                }
lbl73:
                // 3 sources

            } while (textObjects.hasMoreElements());
            if (lineVector.size() > 0) {
                paintVector.addElement(lineVector);
            }
        }
        catch (Exception v1) {
            return this.createPaintVector(size);
        }
        return paintVector;
    }

    private Vector createTextVector() {
        Vector<Object> textVector = new Vector<Object>();
        int currentPosition = 0;
        int currentAttribute = 0;
        StringBuffer text = new StringBuffer();
        boolean attributeChanged = false;
        while (currentPosition < this.labelText.length()) {
            attributeChanged = false;
            while (currentPosition < this.labelText.length() && this.labelText.charAt(currentPosition) == '<') {
                int index = 0;
                while (index < addAttr.length) {
                    if (this.labelText.length() >= currentPosition + addAttr[index].length() && this.labelText.substring(currentPosition, currentPosition + addAttr[index].length()).equalsIgnoreCase(addAttr[index])) {
                        currentAttribute |= 1 << index;
                        currentPosition += addAttr[index].length();
                        attributeChanged = true;
                    }
                    if (this.labelText.length() >= currentPosition + removeAttr[index].length() && this.labelText.substring(currentPosition, currentPosition + removeAttr[index].length()).equalsIgnoreCase(removeAttr[index])) {
                        currentAttribute &= 255 - (1 << index);
                        currentPosition += removeAttr[index].length();
                        attributeChanged = (1 << index & attrFlowControlOnly) == 0;
                    }
                    ++index;
                }
                if (!attributeChanged) break;
            }
            if (attributeChanged) {
                int tl = text.length();
                if (tl > 0) {
                    textVector.addElement(text.toString());
                    text = new StringBuffer();
                }
                textVector.addElement(new Integer(currentAttribute));
                currentAttribute &= ~attrFlowControlOnly;
                continue;
            }
            if (this.labelText.charAt(currentPosition) == '\n') {
                if (text.length() > 0) {
                    textVector.addElement(text.toString());
                    text = new StringBuffer();
                }
                textVector.addElement(new Integer(attrBreak));
                ++currentPosition;
            }
            if (currentPosition >= this.labelText.length()) continue;
            text.append(this.labelText.charAt(currentPosition));
            ++currentPosition;
        }
        if (text.length() > 0) {
            textVector.addElement(text.toString());
        }
        return textVector;
    }

    public String getContentString() {
        String result = "";
        Vector tv = this.createTextVector();
        Enumeration comps = tv.elements();
        while (comps.hasMoreElements()) {
            Object nextComp = comps.nextElement();
            if (!(nextComp instanceof String)) continue;
            result = String.valueOf(result) + nextComp;
        }
        return result;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private Font getNewFont(Font currentFont, int attribute) {
        if (currentFont != null) {
            if (labelFont == null && (attribute & attrTt) != 0) {
                labelFont = currentFont;
                if ((currentFont = new Font("Monospaced", 0, currentFont.getSize())) == null) {
                    currentFont = labelFont;
                    labelFont = null;
                }
            } else if (labelFont != null && (attribute & attrTt) == 0) {
                currentFont = labelFont;
                labelFont = null;
            }
            currentFont = new Font(currentFont.getName(), ((attribute & attrBold) != 0 ? 1 : 0) | ((attribute & attrItalics) != 0 ? 2 : 0), currentFont.getSize());
        }
        return currentFont;
    }

    private int getNextWordIndex(String input, int offset) {
        int currentIndex = offset + 1;
        while (currentIndex < input.length() && Character.isWhitespace(input.charAt(currentIndex))) {
            ++currentIndex;
        }
        if (currentIndex < input.length()) {
            BreakIterator boundary = BreakIterator.getLineInstance();
            boundary.setText(input.substring(currentIndex, input.length()));
            int nextBreakIndex = boundary.first();
            nextBreakIndex = boundary.next();
            if (nextBreakIndex != -1) {
                if (input.charAt(nextBreakIndex + currentIndex - 1) == '.') {
                    BreakIterator sentenceIterator = BreakIterator.getSentenceInstance();
                    sentenceIterator.setText(input);
                    int sentenceIndex = sentenceIterator.first();
                    while (sentenceIndex != -1 && sentenceIndex < nextBreakIndex + currentIndex) {
                        sentenceIndex = sentenceIterator.next();
                    }
                    if (sentenceIndex != nextBreakIndex + currentIndex) {
                        return this.getNextWordIndex(input, nextBreakIndex + currentIndex);
                    }
                }
                return nextBreakIndex + currentIndex;
            }
        }
        return currentIndex;
    }

    public Dimension getPreferredSize() {
        Container parent = this.getParent();
        Dimension parentSize = parent.getSize();
        Dimension componentSize = new Dimension(1, 1);
        if (parentSize.width == 0) {
            parentSize = new Dimension(400, 200);
        }
        Insets insets = parent.getInsets();
        try {
            Font testFont = this.getNewFont(this.getFont(), 0);
            FontMetrics fm = this.getFontMetrics(testFont);
            componentSize = new Dimension(parentSize.width - insets.right - insets.left, parentSize.height - insets.top - insets.bottom);
            Object object = this.getTreeLock();
            synchronized (object) {
                Object object2 = this.currentSizeLock;
                synchronized (object2) {
                    Object object3 = this.paintVectorLock;
                    synchronized (object3) {
                        Vector paintVector = this.createPaintVector(componentSize);
                        componentSize.height = this.verticalMargin * 2 + fm.getHeight() * paintVector.size();
                    }
                }
            }
        }
        catch (Error error) {
            return this.getPreferredSize();
        }
        return componentSize;
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        Object object = this.currentSizeLock;
        synchronized (object) {
            if (this.currentSize.width != size.width) {
                this.sizeChanged(size);
            }
        }
        g.setClip(0, 0, size.width, size.height);
        g.setColor(this.getForeground());
        Font currentFont = this.getFont();
        currentFont = new Font(currentFont.getName(), 0, currentFont.getSize());
        FontMetrics fm = this.getFontMetrics(currentFont);
        g.setFont(currentFont);
        int x = this.horizontalMargin;
        int y = fm.getMaxAscent() + this.verticalMargin;
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            Object object3 = this.paintVectorLock;
            synchronized (object3) {
                int index = 0;
                while (index < this.paintVector.size()) {
                    Vector lineVector = (Vector)this.paintVector.elementAt(index);
                    int lineIndex = 0;
                    while (lineIndex < lineVector.size()) {
                        Object obj = lineVector.elementAt(lineIndex);
                        if (obj instanceof Integer) {
                            currentFont = this.getNewFont(currentFont, (Integer)obj);
                            fm = this.getFontMetrics(currentFont);
                            g.setFont(currentFont);
                        }
                        if (obj instanceof String) {
                            try {
                                g.drawString((String)obj, x, y);
                                x += fm.stringWidth((String)obj);
                            }
                            catch (Exception exception) {
                                this.repaint();
                            }
                        }
                        ++lineIndex;
                    }
                    x = this.horizontalMargin;
                    y += fm.getHeight();
                    ++index;
                }
            }
        }
    }

    public void setHgap(int hgap) {
        this.horizontalMargin = hgap;
    }

    public void setText(String text) {
        this.labelText = text;
        Object object = this.textVectorLock;
        synchronized (object) {
            this.textVector = this.createTextVector();
        }
        Dimension currentSize = this.getSize();
        if (currentSize.width > 0 || currentSize.height > 0) {
            Object object2 = this.paintVectorLock;
            synchronized (object2) {
                this.paintVector = this.createPaintVector(currentSize);
            }
        }
        if (this.isShowing()) {
            this.invalidate();
            this.repaint();
        }
    }

    public void setVgap(int vgap) {
        this.verticalMargin = vgap;
    }

    public void sizeChanged(Dimension newSize) {
        Object object = this.currentSizeLock;
        synchronized (object) {
            Object object2;
            Dimension oldSize = this.currentSize;
            if (!newSize.equals(oldSize)) {
                object2 = this.getTreeLock();
                synchronized (object2) {
                    try {
                        Graphics g = this.getGraphics();
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, oldSize.width + 1, oldSize.height + 1);
                    }
                    catch (Exception exception) {}
                }
            }
            if (newSize.width != oldSize.width) {
                object2 = this.paintVectorLock;
                synchronized (object2) {
                    this.paintVector = this.createPaintVector(newSize);
                }
            }
            this.currentSize = newSize;
        }
    }

    private int skipWhitespace(String input, int offset) {
        int currentIndex = offset;
        while (currentIndex < input.length() && Character.isWhitespace(input.charAt(currentIndex))) {
            ++currentIndex;
        }
        return currentIndex;
    }
}

