/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.KioskCanvas;
import com.sun.prodreg.awt.Node;
import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.event.ExpansionListener;
import com.sun.prodreg.view.ComponentSelectableViewListener;
import com.sun.prodreg.view.TreeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.util.Vector;

public class AWTTreeView
extends Panel
implements TreeView {
    private KioskCanvas csv = null;

    public AWTTreeView(ProdRegTreeNode data) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image damageImage = tk.getImage(this.getClass().getResource("/images/damage.gif"));
        Node root = new Node(data, true);
        Vector<Node> tree = new Vector<Node>();
        tree.addElement(root);
        this.csv = new KioskCanvas(tree, null, null, damageImage);
        ScrollPane sp = new ScrollPane(0);
        sp.getVAdjustable().setUnitIncrement(20);
        sp.add(this.csv);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
    }

    public void addComponentSelectableViewListener(ComponentSelectableViewListener c) {
        if (this.csv != null) {
            this.csv.addComponentSelectableViewListener(c);
        }
    }

    public void addExpansionListener(ExpansionListener l) {
        if (this.csv != null) {
            this.csv.addExpansionListener(l);
        }
    }

    public void refresh(Vector idsToExpand, boolean expand) {
        this.csv.refresh(idsToExpand, expand);
    }

    public void removeComponentSelectableViewListener(ComponentSelectableViewListener c) {
        if (this.csv != null) {
            this.csv.removeComponentSelectableViewListener(c);
        }
    }

    public void removeExpansionListener(ExpansionListener l) {
        if (this.csv != null) {
            this.csv.removeExpansionListener(l);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.csv.setEnabled(enabled);
    }
}

