/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.core.ProgressBar;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class AWTProgressBar
extends Canvas
implements ProgressBar {
    private int progress = 0;
    private Color fg;
    private String message = null;
    private boolean appendProgress = true;
    private Image offscreen = null;
    private int currentHeight = 0;
    private int currentWidth = 0;

    public AWTProgressBar(Color bg, Color fg, String message, boolean appendProgress) {
        this.fg = fg;
        this.setBackground(bg);
        this.setFont(new Font("Dialog", 1, 12));
        this.progress = 0;
        this.message = message;
        this.appendProgress = appendProgress;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 20);
    }

    public int getProgress() {
        return this.progress;
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        FontMetrics fm = g.getFontMetrics();
        String progString = this.message;
        if (this.appendProgress) {
            progString = String.valueOf(progString) + " : " + this.progress + "%";
        }
        int percentHeight = 12;
        int percentLength = 25;
        if (fm != null) {
            percentHeight = fm.getMaxAscent() + fm.getMaxDescent();
            percentLength = fm.stringWidth(progString);
        }
        int percentX = size.width / 2 - percentLength / 2;
        int percentY = size.height / 2 + percentHeight / 2;
        int filled = (int)Math.round((double)this.progress / 100.0 * (double)size.width);
        g.setColor(this.fg);
        g.fillRect(0, 0, filled, size.height);
        g.setColor(this.getBackground().darker());
        g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        g.drawLine(size.width - 1, 0, size.width - 1, size.height - 1);
        g.setColor(this.getBackground().brighter());
        g.drawLine(0, 0, size.width - 1, 0);
        g.drawLine(0, 0, 0, size.height - 1);
        g.setColor(this.fg);
        g.setXORMode(Color.white);
        g.drawString(progString, percentX, percentY);
        g.setPaintMode();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setProgress(int progress) {
        if (progress <= 100) {
            this.progress = progress;
            this.repaint();
        }
    }

    public void update(Graphics g) {
        Dimension size = this.getSize();
        if (this.offscreen == null || size.width != this.currentWidth || size.height != this.currentHeight) {
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(size.width, size.height);
            this.currentWidth = size.width;
            this.currentHeight = size.height;
        }
        Graphics bufferGraphics = this.offscreen.getGraphics();
        bufferGraphics.setColor(this.getBackground());
        bufferGraphics.fillRect(0, 0, size.width, size.height);
        bufferGraphics.setColor(this.getForeground());
        this.paint(bufferGraphics);
        g.drawImage(this.offscreen, 0, 0, this);
    }
}

