/* $NetBSD: aoutm68k_syscalls.c,v 1.52 2019/06/18 01:39:09 christos Exp $ */

/*
 * System call names.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.44 2019/06/18 01:39:01 christos Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: aoutm68k_syscalls.c,v 1.52 2019/06/18 01:39:09 christos Exp $");

#if defined(_KERNEL_OPT)
#if defined(_KERNEL_OPT)
#include "opt_ktrace.h"
#include "opt_nfsserver.h"
#include "opt_ntp.h"
#include "opt_compat_netbsd.h"
#include "opt_sysv.h"
#include "opt_compat_43.h"
#include "opt_quota.h"
#endif
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/signal.h>
#include <sys/mount.h>
#include <sys/sched.h>
#include <sys/syscallargs.h>
#include <compat/aoutm68k/aoutm68k_syscallargs.h>
#else /* _KERNEL_OPT */
#include <sys/null.h>
#endif /* _KERNEL_OPT */

const char *const aoutm68k_syscallnames[] = {
	/*   0 */	"syscall",
	/*   1 */	"exit",
	/*   2 */	"fork",
	/*   3 */	"read",
	/*   4 */	"write",
	/*   5 */	"open",
	/*   6 */	"close",
	/*   7 */	"wait4",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*   8 */	"ocreat",
#else
	/*   8 */	"#8 (excluded compat_43_sys_creat)",
#endif
	/*   9 */	"link",
	/*  10 */	"unlink",
	/*  11 */	"#11 (obsolete execv)",
	/*  12 */	"chdir",
	/*  13 */	"fchdir",
	/*  14 */	"mknod",
	/*  15 */	"chmod",
	/*  16 */	"chown",
	/*  17 */	"break",
#if defined(COMPAT_20) || !defined(_KERNEL)
	/*  18 */	"getfsstat",
#else
	/*  18 */	"#18 (excluded compat_20_sys_getfsstat)",
#endif
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  19 */	"olseek",
#else
	/*  19 */	"#19 (excluded compat_43_sys_lseek)",
#endif
	/*  20 */	"getpid",
	/*  21 */	"mount",
	/*  22 */	"unmount",
	/*  23 */	"setuid",
	/*  24 */	"getuid",
	/*  25 */	"geteuid",
	/*  26 */	"ptrace",
	/*  27 */	"recvmsg",
	/*  28 */	"sendmsg",
	/*  29 */	"recvfrom",
	/*  30 */	"accept",
	/*  31 */	"getpeername",
	/*  32 */	"getsockname",
	/*  33 */	"access",
	/*  34 */	"chflags",
	/*  35 */	"fchflags",
	/*  36 */	"sync",
	/*  37 */	"kill",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  38 */	"stat43",
#else
	/*  38 */	"#38 (excluded aoutm68k_compat_43_sys_stat)",
#endif
	/*  39 */	"getppid",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  40 */	"lstat43",
#else
	/*  40 */	"#40 (excluded aoutm68k_compat_43_sys_lstat)",
#endif
	/*  41 */	"dup",
	/*  42 */	"pipe",
	/*  43 */	"getegid",
	/*  44 */	"profil",
#if defined(KTRACE) || !defined(_KERNEL)
	/*  45 */	"ktrace",
#else
	/*  45 */	"#45 (excluded ktrace)",
#endif
#if defined(COMPAT_13) || !defined(_KERNEL)
	/*  46 */	"sigaction13",
#else
	/*  46 */	"#46 (excluded compat_13_sys_sigaction)",
#endif
	/*  47 */	"getgid",
#if defined(COMPAT_13) || !defined(_KERNEL)
	/*  48 */	"sigprocmask13",
#else
	/*  48 */	"#48 (excluded compat_13_sys_sigprocmask)",
#endif
	/*  49 */	"__getlogin",
	/*  50 */	"__setlogin",
	/*  51 */	"acct",
#if defined(COMPAT_13) || !defined(_KERNEL)
	/*  52 */	"sigpending13",
	/*  53 */	"sigaltstack13",
#else
	/*  52 */	"#52 (excluded compat_13_sys_sigpending)",
	/*  53 */	"#53 (excluded compat_13_sys_sigaltstack)",
#endif
	/*  54 */	"ioctl",
#if defined(COMPAT_12) || !defined(_KERNEL)
	/*  55 */	"oreboot",
#else
	/*  55 */	"#55 (excluded compat_12_sys_reboot)",
#endif
	/*  56 */	"revoke",
	/*  57 */	"symlink",
	/*  58 */	"readlink",
	/*  59 */	"execve",
	/*  60 */	"umask",
	/*  61 */	"chroot",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  62 */	"fstat43",
	/*  63 */	"ogetkerninfo",
	/*  64 */	"ogetpagesize",
#else
	/*  62 */	"#62 (excluded aoutm68k_compat_43_sys_fstat)",
	/*  63 */	"#63 (excluded compat_43_sys_getkerninfo)",
	/*  64 */	"#64 (excluded compat_43_sys_getpagesize)",
#endif
#if defined(COMPAT_12) || !defined(_KERNEL)
	/*  65 */	"msync",
#else
	/*  65 */	"#65 (excluded compat_12_sys_msync)",
#endif
	/*  66 */	"vfork",
	/*  67 */	"#67 (obsolete vread)",
	/*  68 */	"#68 (obsolete vwrite)",
	/*  69 */	"#69 (obsolete sbrk)",
	/*  70 */	"#70 (obsolete sstk)",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  71 */	"ommap",
#else
	/*  71 */	"#71 (excluded compat_43_sys_mmap)",
#endif
	/*  72 */	"vadvise",
	/*  73 */	"munmap",
	/*  74 */	"mprotect",
	/*  75 */	"madvise",
	/*  76 */	"#76 (obsolete vhangup)",
	/*  77 */	"#77 (obsolete vlimit)",
	/*  78 */	"mincore",
	/*  79 */	"getgroups",
	/*  80 */	"setgroups",
	/*  81 */	"getpgrp",
	/*  82 */	"setpgid",
	/*  83 */	"setitimer",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  84 */	"owait",
#else
	/*  84 */	"#84 (excluded compat_43_sys_wait)",
#endif
#if defined(COMPAT_12) || !defined(_KERNEL)
	/*  85 */	"oswapon",
#else
	/*  85 */	"#85 (excluded compat_12_sys_swapon)",
#endif
	/*  86 */	"getitimer",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  87 */	"ogethostname",
	/*  88 */	"osethostname",
	/*  89 */	"ogetdtablesize",
#else
	/*  87 */	"#87 (excluded compat_43_sys_gethostname)",
	/*  88 */	"#88 (excluded compat_43_sys_sethostname)",
	/*  89 */	"#89 (excluded compat_43_sys_getdtablesize)",
#endif
	/*  90 */	"dup2",
	/*  91 */	"#91 (unimplemented getdopt)",
	/*  92 */	"fcntl",
	/*  93 */	"select",
	/*  94 */	"#94 (unimplemented setdopt)",
	/*  95 */	"fsync",
	/*  96 */	"setpriority",
#if defined(COMPAT_30) || !defined(_KERNEL)
	/*  97 */	"socket",
#else
	/*  97 */	"#97 (excluded compat_30_sys_socket)",
#endif
	/*  98 */	"connect",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  99 */	"oaccept",
#else
	/*  99 */	"#99 (excluded compat_43_sys_accept)",
#endif
	/* 100 */	"getpriority",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 101 */	"osend",
	/* 102 */	"orecv",
#else
	/* 101 */	"#101 (excluded compat_43_sys_send)",
	/* 102 */	"#102 (excluded compat_43_sys_recv)",
#endif
#if defined(COMPAT_13) || !defined(_KERNEL)
	/* 103 */	"sigreturn13",
#else
	/* 103 */	"#103 (excluded compat_13_sys_sigreturn)",
#endif
	/* 104 */	"bind",
	/* 105 */	"setsockopt",
	/* 106 */	"listen",
	/* 107 */	"#107 (obsolete vtimes)",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 108 */	"osigvec",
	/* 109 */	"osigblock",
	/* 110 */	"osigsetmask",
#else
	/* 108 */	"#108 (excluded compat_43_sys_sigvec)",
	/* 109 */	"#109 (excluded compat_43_sys_sigblock)",
	/* 110 */	"#110 (excluded compat_43_sys_sigsetmask)",
#endif
#if defined(COMPAT_13) || !defined(_KERNEL)
	/* 111 */	"sigsuspend13",
#else
	/* 111 */	"#111 (excluded compat_13_sys_sigsuspend)",
#endif
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 112 */	"osigstack",
	/* 113 */	"orecvmsg",
	/* 114 */	"osendmsg",
#else
	/* 112 */	"#112 (excluded compat_43_sys_sigstack)",
	/* 113 */	"#113 (excluded compat_43_sys_recvmesg)",
	/* 114 */	"#114 (excluded compat_43_sys_sendmesg)",
#endif
	/* 115 */	"#115 (obsolete vtrace)",
	/* 116 */	"gettimeofday",
	/* 117 */	"getrusage",
	/* 118 */	"getsockopt",
	/* 119 */	"#119 (obsolete resuba)",
	/* 120 */	"readv",
	/* 121 */	"writev",
	/* 122 */	"settimeofday",
	/* 123 */	"fchown",
	/* 124 */	"fchmod",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 125 */	"orecvfrom",
#else
	/* 125 */	"#125 (excluded compat_43_sys_recvfrom)",
#endif
	/* 126 */	"setreuid",
	/* 127 */	"setregid",
	/* 128 */	"rename",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 129 */	"otruncate",
	/* 130 */	"oftruncate",
#else
	/* 129 */	"#129 (excluded compat_43_sys_truncate)",
	/* 130 */	"#130 (excluded compat_43_sys_ftruncate)",
#endif
	/* 131 */	"flock",
	/* 132 */	"mkfifo",
	/* 133 */	"sendto",
	/* 134 */	"shutdown",
	/* 135 */	"socketpair",
	/* 136 */	"mkdir",
	/* 137 */	"rmdir",
	/* 138 */	"utimes",
	/* 139 */	"#139 (obsolete 4.2 sigreturn)",
	/* 140 */	"adjtime",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 141 */	"ogetpeername",
	/* 142 */	"ogethostid",
	/* 143 */	"osethostid",
	/* 144 */	"ogetrlimit",
	/* 145 */	"osetrlimit",
	/* 146 */	"okillpg",
#else
	/* 141 */	"#141 (excluded compat_43_sys_getpeername)",
	/* 142 */	"#142 (excluded compat_43_sys_gethostid)",
	/* 143 */	"#143 (excluded compat_43_sys_sethostid)",
	/* 144 */	"#144 (excluded compat_43_sys_getrlimit)",
	/* 145 */	"#145 (excluded compat_43_sys_setrlimit)",
	/* 146 */	"#146 (excluded compat_43_sys_killpg)",
#endif
	/* 147 */	"setsid",
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* 148 */	"quotactl",
#else
	/* 148 */	"#148 (excluded compat_50_sys_quotactl)",
#endif
#if (defined(QUOTA) && defined(COMPAT_43)) || !defined(_KERNEL_OPT)
	/* 149 */	"oquota",
#else
	/* 149 */	"#149 (excluded compat_43_sys_quota)",
#endif
#if defined(COMPAT_43) || !defined(_KERNEL_OPT)
	/* 150 */	"ogetsockname",
#else
	/* 150 */	"#150 (excluded compat_43_sys_getsockname)",
#endif
	/* 151 */	"#151 (unimplemented)",
	/* 152 */	"#152 (unimplemented)",
	/* 153 */	"#153 (unimplemented)",
	/* 154 */	"#154 (unimplemented)",
	/* 155 */	"#155 (excluded nfssvc)",
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 156 */	"ogetdirentries",
#else
	/* 156 */	"#156 (excluded compat_43_sys_getdirentries)",
#endif
#if defined(COMPAT_20) || !defined(_KERNEL)
	/* 157 */	"statfs",
#else
	/* 157 */	"#157 (excluded compat_20_sys_statfs)",
#endif
#if defined(COMPAT_20) || !defined(_KERNEL)
	/* 158 */	"fstatfs",
#else
	/* 158 */	"#158 (excluded compat_20_sys_statfs)",
#endif
	/* 159 */	"#159 (unimplemented)",
	/* 160 */	"#160 (unimplemented)",
#if defined(COMPAT_30) || !defined(_KERNEL)
	/* 161 */	"getfh",
#else
	/* 161 */	"#161 (excluded compat_30_sys_getfh)",
#endif
#if defined(COMPAT_09) || !defined(_KERNEL)
	/* 162 */	"ogetdomainname",
	/* 163 */	"osetdomainname",
	/* 164 */	"ouname",
#else
	/* 162 */	"#162 (excluded compat_09_sys_getdomainname)",
	/* 163 */	"#163 (excluded compat_09_sys_setdomainname)",
	/* 164 */	"#164 (excluded compat_09_sys_uname)",
#endif
	/* 165 */	"sysarch",
	/* 166 */	"#166 (unimplemented)",
	/* 167 */	"#167 (unimplemented)",
	/* 168 */	"#168 (unimplemented)",
#if (defined(SYSVSEM) || !defined(_KERNEL)) && !defined(_LP64) && defined(COMPAT_10)
	/* 169 */	"osemsys",
#else
	/* 169 */	"#169 (excluded 1.0 semsys)",
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL)) && !defined(_LP64) && defined(COMPAT_10)
	/* 170 */	"omsgsys",
#else
	/* 170 */	"#170 (excluded 1.0 msgsys)",
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL)) && !defined(_LP64) && defined(COMPAT_10)
	/* 171 */	"oshmsys",
#else
	/* 171 */	"#171 (excluded 1.0 shmsys)",
#endif
	/* 172 */	"#172 (unimplemented)",
	/* 173 */	"pread",
	/* 174 */	"pwrite",
	/* 175 */	"#175 (unimplemented sys_ntp_gettime)",
#if defined(NTP) || !defined(_KERNEL)
	/* 176 */	"ntp_adjtime",
#else
	/* 176 */	"#176 (excluded ntp_adjtime)",
#endif
	/* 177 */	"#177 (unimplemented)",
	/* 178 */	"#178 (unimplemented)",
	/* 179 */	"#179 (unimplemented)",
	/* 180 */	"#180 (unimplemented)",
	/* 181 */	"setgid",
	/* 182 */	"setegid",
	/* 183 */	"seteuid",
	/* 184 */	"#184 (excluded lfs_bmapv)",
	/* 185 */	"#185 (excluded lfs_markv)",
	/* 186 */	"#186 (excluded lfs_segclean)",
	/* 187 */	"#187 (excluded lfs_segwait)",
#if defined(COMPAT_12) || !defined(_KERNEL)
	/* 188 */	"stat12",
	/* 189 */	"fstat12",
	/* 190 */	"lstat12",
#else
	/* 188 */	"#188 (excluded aoutm68k_compat_12_sys_stat)",
	/* 189 */	"#189 (excluded aoutm68k_compat_12_sys_fstat)",
	/* 190 */	"#190 (excluded aoutm68k_compat_12_sys_lstat)",
#endif
	/* 191 */	"pathconf",
	/* 192 */	"fpathconf",
	/* 193 */	"#193 (unimplemented)",
	/* 194 */	"getrlimit",
	/* 195 */	"setrlimit",
#if defined(COMPAT_12) || !defined(_KERNEL)
	/* 196 */	"getdirentries",
#else
	/* 196 */	"#196 (excluded compat_12_sys_getdirentries)",
#endif
	/* 197 */	"mmap",
	/* 198 */	"__syscall",
	/* 199 */	"lseek",
	/* 200 */	"truncate",
	/* 201 */	"ftruncate",
	/* 202 */	"__sysctl",
	/* 203 */	"mlock",
	/* 204 */	"munlock",
	/* 205 */	"undelete",
	/* 206 */	"futimes",
	/* 207 */	"getpgid",
	/* 208 */	"reboot",
	/* 209 */	"poll",
	/* 210 */	"#210 (unimplemented)",
	/* 211 */	"#211 (unimplemented)",
	/* 212 */	"#212 (unimplemented)",
	/* 213 */	"#213 (unimplemented)",
	/* 214 */	"#214 (unimplemented)",
	/* 215 */	"#215 (unimplemented)",
	/* 216 */	"#216 (unimplemented)",
	/* 217 */	"#217 (unimplemented)",
	/* 218 */	"#218 (unimplemented)",
	/* 219 */	"#219 (unimplemented)",
#if defined(SYSVSEM) || !defined(_KERNEL)
#if defined(COMPAT_14) || !defined(_KERNEL)
	/* 220 */	"__semctl",
#else
	/* 220 */	"#220 (excluded compat_14_semctl)",
#endif
	/* 221 */	"semget",
	/* 222 */	"semop",
	/* 223 */	"semconfig",
#else
	/* 220 */	"#220 (excluded compat_14_semctl)",
	/* 221 */	"#221 (excluded semget)",
	/* 222 */	"#222 (excluded semop)",
	/* 223 */	"#223 (excluded semconfig)",
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
#if defined(COMPAT_14) || !defined(_KERNEL)
	/* 224 */	"msgctl",
#else
	/* 224 */	"#224 (excluded compat_14_sys_msgctl)",
#endif
	/* 225 */	"msgget",
	/* 226 */	"msgsnd",
	/* 227 */	"msgrcv",
#else
	/* 224 */	"#224 (excluded compat_14_msgctl)",
	/* 225 */	"#225 (excluded msgget)",
	/* 226 */	"#226 (excluded msgsnd)",
	/* 227 */	"#227 (excluded msgrcv)",
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
	/* 228 */	"shmat",
#if defined(COMPAT_14) || !defined(_KERNEL)
	/* 229 */	"shmctl",
#else
	/* 229 */	"#229 (excluded compat_14_sys_shmctl)",
#endif
	/* 230 */	"shmdt",
	/* 231 */	"shmget",
#else
	/* 228 */	"#228 (excluded shmat)",
	/* 229 */	"#229 (excluded compat_14_shmctl)",
	/* 230 */	"#230 (excluded shmdt)",
	/* 231 */	"#231 (excluded shmget)",
#endif
	/* 232 */	"clock_gettime",
	/* 233 */	"clock_settime",
	/* 234 */	"clock_getres",
	/* 235 */	"#235 (unimplemented timer_create)",
	/* 236 */	"#236 (unimplemented timer_delete)",
	/* 237 */	"#237 (unimplemented timer_settime)",
	/* 238 */	"#238 (unimplemented timer_gettime)",
	/* 239 */	"#239 (unimplemented timer_getoverrun)",
	/* 240 */	"nanosleep",
	/* 241 */	"fdatasync",
	/* 242 */	"mlockall",
	/* 243 */	"munlockall",
	/* 244 */	"#244 (unimplemented)",
	/* 245 */	"#245 (unimplemented)",
	/* 246 */	"#246 (unimplemented)",
	/* 247 */	"#247 (unimplemented)",
	/* 248 */	"#248 (unimplemented)",
	/* 249 */	"#249 (unimplemented)",
	/* 250 */	"#250 (unimplemented)",
	/* 251 */	"#251 (unimplemented)",
	/* 252 */	"#252 (unimplemented)",
	/* 253 */	"#253 (unimplemented)",
	/* 254 */	"#254 (unimplemented)",
	/* 255 */	"#255 (unimplemented)",
	/* 256 */	"#256 (unimplemented)",
	/* 257 */	"#257 (unimplemented)",
	/* 258 */	"#258 (unimplemented)",
	/* 259 */	"#259 (unimplemented)",
	/* 260 */	"#260 (unimplemented)",
	/* 261 */	"#261 (unimplemented)",
	/* 262 */	"#262 (unimplemented)",
	/* 263 */	"#263 (unimplemented)",
	/* 264 */	"#264 (unimplemented)",
	/* 265 */	"#265 (unimplemented)",
	/* 266 */	"#266 (unimplemented)",
	/* 267 */	"#267 (unimplemented)",
	/* 268 */	"#268 (unimplemented)",
	/* 269 */	"#269 (unimplemented)",
	/* 270 */	"__posix_rename",
	/* 271 */	"swapctl",
#if defined(COMPAT_30) || !defined(_KERNEL)
	/* 272 */	"getdents",
#else
	/* 272 */	"#272 (excluded compat_30_sys_getdents)",
#endif
	/* 273 */	"minherit",
	/* 274 */	"lchmod",
	/* 275 */	"lchown",
	/* 276 */	"lutimes",
	/* 277 */	"__msync13",
	/* 278 */	"__stat13",
	/* 279 */	"__fstat13",
	/* 280 */	"__lstat13",
	/* 281 */	"__sigaltstack14",
	/* 282 */	"__vfork14",
	/* 283 */	"__posix_chown",
	/* 284 */	"__posix_fchown",
	/* 285 */	"__posix_lchown",
	/* 286 */	"getsid",
	/* 287 */	"#287 (unimplemented)",
#if defined(KTRACE) || !defined(_KERNEL)
	/* 288 */	"fktrace",
#else
	/* 288 */	"#288 (excluded ktrace)",
#endif
	/* 289 */	"preadv",
	/* 290 */	"pwritev",
#if defined(COMPAT_16) || !defined(_KERNEL)
	/* 291 */	"__sigaction14",
#else
	/* 291 */	"#291 (excluded compat_16_sys___sigaction14)",
#endif
	/* 292 */	"__sigpending14",
	/* 293 */	"__sigprocmask14",
	/* 294 */	"__sigsuspend14",
#if defined(COMPAT_16) || !defined(_KERNEL)
	/* 295 */	"__sigreturn14",
#else
	/* 295 */	"#295 (excluded compat_16_sys___sigreturn14)",
#endif
	/* 296 */	"__getcwd",
	/* 297 */	"fchroot",
#if defined(COMPAT_30) || ! defined(_KERNEL)
	/* 298 */	"fhopen",
#else
	/* 298 */	"#298 (excluded compat_30_sys_fhopen)",
#endif
	/* 299 */	"fhstat",
#if defined(COMPAT_20) || !defined(_KERNEL)
	/* 300 */	"fhstatfs",
#else
	/* 300 */	"#300 (excluded compat_20_sys_fhstatfs)",
#endif
#if defined(SYSVSEM) || !defined(_KERNEL)
	/* 301 */	"____semctl13",
#else
	/* 301 */	"#301 (excluded ____semctl13)",
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
	/* 302 */	"__msgctl13",
#else
	/* 302 */	"#302 (excluded __msgctl13)",
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
	/* 303 */	"__shmctl13",
#else
	/* 303 */	"#303 (excluded __shmctl13)",
#endif
	/* 304 */	"lchflags",
	/* 305 */	"issetugid",
	/* 306 */	"getcontext",
	/* 307 */	"setcontext",
	/* 308 */	"# filler",
	/* 309 */	"# filler",
	/* 310 */	"# filler",
	/* 311 */	"# filler",
	/* 312 */	"# filler",
	/* 313 */	"# filler",
	/* 314 */	"# filler",
	/* 315 */	"# filler",
	/* 316 */	"# filler",
	/* 317 */	"# filler",
	/* 318 */	"# filler",
	/* 319 */	"# filler",
	/* 320 */	"# filler",
	/* 321 */	"# filler",
	/* 322 */	"# filler",
	/* 323 */	"# filler",
	/* 324 */	"# filler",
	/* 325 */	"# filler",
	/* 326 */	"# filler",
	/* 327 */	"# filler",
	/* 328 */	"# filler",
	/* 329 */	"# filler",
	/* 330 */	"# filler",
	/* 331 */	"# filler",
	/* 332 */	"# filler",
	/* 333 */	"# filler",
	/* 334 */	"# filler",
	/* 335 */	"# filler",
	/* 336 */	"# filler",
	/* 337 */	"# filler",
	/* 338 */	"# filler",
	/* 339 */	"# filler",
	/* 340 */	"# filler",
	/* 341 */	"# filler",
	/* 342 */	"# filler",
	/* 343 */	"# filler",
	/* 344 */	"# filler",
	/* 345 */	"# filler",
	/* 346 */	"# filler",
	/* 347 */	"# filler",
	/* 348 */	"# filler",
	/* 349 */	"# filler",
	/* 350 */	"# filler",
	/* 351 */	"# filler",
	/* 352 */	"# filler",
	/* 353 */	"# filler",
	/* 354 */	"# filler",
	/* 355 */	"# filler",
	/* 356 */	"# filler",
	/* 357 */	"# filler",
	/* 358 */	"# filler",
	/* 359 */	"# filler",
	/* 360 */	"# filler",
	/* 361 */	"# filler",
	/* 362 */	"# filler",
	/* 363 */	"# filler",
	/* 364 */	"# filler",
	/* 365 */	"# filler",
	/* 366 */	"# filler",
	/* 367 */	"# filler",
	/* 368 */	"# filler",
	/* 369 */	"# filler",
	/* 370 */	"# filler",
	/* 371 */	"# filler",
	/* 372 */	"# filler",
	/* 373 */	"# filler",
	/* 374 */	"# filler",
	/* 375 */	"# filler",
	/* 376 */	"# filler",
	/* 377 */	"# filler",
	/* 378 */	"# filler",
	/* 379 */	"# filler",
	/* 380 */	"# filler",
	/* 381 */	"# filler",
	/* 382 */	"# filler",
	/* 383 */	"# filler",
	/* 384 */	"# filler",
	/* 385 */	"# filler",
	/* 386 */	"# filler",
	/* 387 */	"# filler",
	/* 388 */	"# filler",
	/* 389 */	"# filler",
	/* 390 */	"# filler",
	/* 391 */	"# filler",
	/* 392 */	"# filler",
	/* 393 */	"# filler",
	/* 394 */	"# filler",
	/* 395 */	"# filler",
	/* 396 */	"# filler",
	/* 397 */	"# filler",
	/* 398 */	"# filler",
	/* 399 */	"# filler",
	/* 400 */	"# filler",
	/* 401 */	"# filler",
	/* 402 */	"# filler",
	/* 403 */	"# filler",
	/* 404 */	"# filler",
	/* 405 */	"# filler",
	/* 406 */	"# filler",
	/* 407 */	"# filler",
	/* 408 */	"# filler",
	/* 409 */	"# filler",
	/* 410 */	"# filler",
	/* 411 */	"# filler",
	/* 412 */	"# filler",
	/* 413 */	"# filler",
	/* 414 */	"# filler",
	/* 415 */	"# filler",
	/* 416 */	"# filler",
	/* 417 */	"# filler",
	/* 418 */	"# filler",
	/* 419 */	"# filler",
	/* 420 */	"# filler",
	/* 421 */	"# filler",
	/* 422 */	"# filler",
	/* 423 */	"# filler",
	/* 424 */	"# filler",
	/* 425 */	"# filler",
	/* 426 */	"# filler",
	/* 427 */	"# filler",
	/* 428 */	"# filler",
	/* 429 */	"# filler",
	/* 430 */	"# filler",
	/* 431 */	"# filler",
	/* 432 */	"# filler",
	/* 433 */	"# filler",
	/* 434 */	"# filler",
	/* 435 */	"# filler",
	/* 436 */	"# filler",
	/* 437 */	"# filler",
	/* 438 */	"# filler",
	/* 439 */	"# filler",
	/* 440 */	"# filler",
	/* 441 */	"# filler",
	/* 442 */	"# filler",
	/* 443 */	"# filler",
	/* 444 */	"# filler",
	/* 445 */	"# filler",
	/* 446 */	"# filler",
	/* 447 */	"# filler",
	/* 448 */	"# filler",
	/* 449 */	"# filler",
	/* 450 */	"# filler",
	/* 451 */	"# filler",
	/* 452 */	"# filler",
	/* 453 */	"# filler",
	/* 454 */	"# filler",
	/* 455 */	"# filler",
	/* 456 */	"# filler",
	/* 457 */	"# filler",
	/* 458 */	"# filler",
	/* 459 */	"# filler",
	/* 460 */	"# filler",
	/* 461 */	"# filler",
	/* 462 */	"# filler",
	/* 463 */	"# filler",
	/* 464 */	"# filler",
	/* 465 */	"# filler",
	/* 466 */	"# filler",
	/* 467 */	"# filler",
	/* 468 */	"# filler",
	/* 469 */	"# filler",
	/* 470 */	"# filler",
	/* 471 */	"# filler",
	/* 472 */	"# filler",
	/* 473 */	"# filler",
	/* 474 */	"# filler",
	/* 475 */	"# filler",
	/* 476 */	"# filler",
	/* 477 */	"# filler",
	/* 478 */	"# filler",
	/* 479 */	"# filler",
	/* 480 */	"# filler",
	/* 481 */	"# filler",
	/* 482 */	"# filler",
	/* 483 */	"# filler",
	/* 484 */	"# filler",
	/* 485 */	"# filler",
	/* 486 */	"# filler",
	/* 487 */	"# filler",
	/* 488 */	"# filler",
	/* 489 */	"# filler",
	/* 490 */	"# filler",
	/* 491 */	"# filler",
	/* 492 */	"# filler",
	/* 493 */	"# filler",
	/* 494 */	"# filler",
	/* 495 */	"# filler",
	/* 496 */	"# filler",
	/* 497 */	"# filler",
	/* 498 */	"# filler",
	/* 499 */	"# filler",
	/* 500 */	"# filler",
	/* 501 */	"# filler",
	/* 502 */	"# filler",
	/* 503 */	"# filler",
	/* 504 */	"# filler",
	/* 505 */	"# filler",
	/* 506 */	"# filler",
	/* 507 */	"# filler",
	/* 508 */	"# filler",
	/* 509 */	"# filler",
	/* 510 */	"# filler",
	/* 511 */	"# filler",
};


/* libc style syscall names */
const char *const altaoutm68k_syscallnames[] = {
	/*   0 */	NULL, /* syscall */
	/*   1 */	NULL, /* exit */
	/*   2 */	NULL, /* fork */
	/*   3 */	NULL, /* read */
	/*   4 */	NULL, /* write */
	/*   5 */	NULL, /* open */
	/*   6 */	NULL, /* close */
	/*   7 */	NULL, /* wait4 */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*   8 */	"creat",
#else
	/*   8 */	NULL, /* excluded compat_43_sys_creat */
#endif
	/*   9 */	NULL, /* link */
	/*  10 */	NULL, /* unlink */
	/*  11 */	NULL, /* obsolete execv */
	/*  12 */	NULL, /* chdir */
	/*  13 */	NULL, /* fchdir */
	/*  14 */	NULL, /* mknod */
	/*  15 */	NULL, /* chmod */
	/*  16 */	NULL, /* chown */
	/*  17 */	"obreak",
#if defined(COMPAT_20) || !defined(_KERNEL)
	/*  18 */	NULL, /* getfsstat */
#else
	/*  18 */	NULL, /* excluded compat_20_sys_getfsstat */
#endif
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  19 */	"lseek",
#else
	/*  19 */	NULL, /* excluded compat_43_sys_lseek */
#endif
	/*  20 */	NULL, /* getpid */
	/*  21 */	NULL, /* mount */
	/*  22 */	NULL, /* unmount */
	/*  23 */	NULL, /* setuid */
	/*  24 */	NULL, /* getuid */
	/*  25 */	NULL, /* geteuid */
	/*  26 */	NULL, /* ptrace */
	/*  27 */	NULL, /* recvmsg */
	/*  28 */	NULL, /* sendmsg */
	/*  29 */	NULL, /* recvfrom */
	/*  30 */	NULL, /* accept */
	/*  31 */	NULL, /* getpeername */
	/*  32 */	NULL, /* getsockname */
	/*  33 */	NULL, /* access */
	/*  34 */	NULL, /* chflags */
	/*  35 */	NULL, /* fchflags */
	/*  36 */	NULL, /* sync */
	/*  37 */	NULL, /* kill */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  38 */	"stat",
#else
	/*  38 */	NULL, /* excluded aoutm68k_compat_43_sys_stat */
#endif
	/*  39 */	NULL, /* getppid */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  40 */	"lstat",
#else
	/*  40 */	NULL, /* excluded aoutm68k_compat_43_sys_lstat */
#endif
	/*  41 */	NULL, /* dup */
	/*  42 */	NULL, /* pipe */
	/*  43 */	NULL, /* getegid */
	/*  44 */	NULL, /* profil */
#if defined(KTRACE) || !defined(_KERNEL)
	/*  45 */	NULL, /* ktrace */
#else
	/*  45 */	NULL, /* excluded ktrace */
#endif
#if defined(COMPAT_13) || !defined(_KERNEL)
	/*  46 */	"sigaction",
#else
	/*  46 */	NULL, /* excluded compat_13_sys_sigaction */
#endif
	/*  47 */	NULL, /* getgid */
#if defined(COMPAT_13) || !defined(_KERNEL)
	/*  48 */	"sigprocmask",
#else
	/*  48 */	NULL, /* excluded compat_13_sys_sigprocmask */
#endif
	/*  49 */	NULL, /* __getlogin */
	/*  50 */	NULL, /* __setlogin */
	/*  51 */	NULL, /* acct */
#if defined(COMPAT_13) || !defined(_KERNEL)
	/*  52 */	"sigpending",
	/*  53 */	"sigaltstack",
#else
	/*  52 */	NULL, /* excluded compat_13_sys_sigpending */
	/*  53 */	NULL, /* excluded compat_13_sys_sigaltstack */
#endif
	/*  54 */	NULL, /* ioctl */
#if defined(COMPAT_12) || !defined(_KERNEL)
	/*  55 */	"reboot",
#else
	/*  55 */	NULL, /* excluded compat_12_sys_reboot */
#endif
	/*  56 */	NULL, /* revoke */
	/*  57 */	NULL, /* symlink */
	/*  58 */	NULL, /* readlink */
	/*  59 */	NULL, /* execve */
	/*  60 */	NULL, /* umask */
	/*  61 */	NULL, /* chroot */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  62 */	"fstat",
	/*  63 */	"getkerninfo",
	/*  64 */	"getpagesize",
#else
	/*  62 */	NULL, /* excluded aoutm68k_compat_43_sys_fstat */
	/*  63 */	NULL, /* excluded compat_43_sys_getkerninfo */
	/*  64 */	NULL, /* excluded compat_43_sys_getpagesize */
#endif
#if defined(COMPAT_12) || !defined(_KERNEL)
	/*  65 */	NULL, /* msync */
#else
	/*  65 */	NULL, /* excluded compat_12_sys_msync */
#endif
	/*  66 */	NULL, /* vfork */
	/*  67 */	NULL, /* obsolete vread */
	/*  68 */	NULL, /* obsolete vwrite */
	/*  69 */	NULL, /* obsolete sbrk */
	/*  70 */	NULL, /* obsolete sstk */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  71 */	"mmap",
#else
	/*  71 */	NULL, /* excluded compat_43_sys_mmap */
#endif
	/*  72 */	"ovadvise",
	/*  73 */	NULL, /* munmap */
	/*  74 */	NULL, /* mprotect */
	/*  75 */	NULL, /* madvise */
	/*  76 */	NULL, /* obsolete vhangup */
	/*  77 */	NULL, /* obsolete vlimit */
	/*  78 */	NULL, /* mincore */
	/*  79 */	NULL, /* getgroups */
	/*  80 */	NULL, /* setgroups */
	/*  81 */	NULL, /* getpgrp */
	/*  82 */	NULL, /* setpgid */
	/*  83 */	NULL, /* setitimer */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  84 */	"wait",
#else
	/*  84 */	NULL, /* excluded compat_43_sys_wait */
#endif
#if defined(COMPAT_12) || !defined(_KERNEL)
	/*  85 */	"swapon",
#else
	/*  85 */	NULL, /* excluded compat_12_sys_swapon */
#endif
	/*  86 */	NULL, /* getitimer */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  87 */	"gethostname",
	/*  88 */	"sethostname",
	/*  89 */	"getdtablesize",
#else
	/*  87 */	NULL, /* excluded compat_43_sys_gethostname */
	/*  88 */	NULL, /* excluded compat_43_sys_sethostname */
	/*  89 */	NULL, /* excluded compat_43_sys_getdtablesize */
#endif
	/*  90 */	NULL, /* dup2 */
	/*  91 */	NULL, /* unimplemented getdopt */
	/*  92 */	NULL, /* fcntl */
	/*  93 */	NULL, /* select */
	/*  94 */	NULL, /* unimplemented setdopt */
	/*  95 */	NULL, /* fsync */
	/*  96 */	NULL, /* setpriority */
#if defined(COMPAT_30) || !defined(_KERNEL)
	/*  97 */	NULL, /* socket */
#else
	/*  97 */	NULL, /* excluded compat_30_sys_socket */
#endif
	/*  98 */	NULL, /* connect */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/*  99 */	"accept",
#else
	/*  99 */	NULL, /* excluded compat_43_sys_accept */
#endif
	/* 100 */	NULL, /* getpriority */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 101 */	"send",
	/* 102 */	"recv",
#else
	/* 101 */	NULL, /* excluded compat_43_sys_send */
	/* 102 */	NULL, /* excluded compat_43_sys_recv */
#endif
#if defined(COMPAT_13) || !defined(_KERNEL)
	/* 103 */	"sigreturn",
#else
	/* 103 */	NULL, /* excluded compat_13_sys_sigreturn */
#endif
	/* 104 */	NULL, /* bind */
	/* 105 */	NULL, /* setsockopt */
	/* 106 */	NULL, /* listen */
	/* 107 */	NULL, /* obsolete vtimes */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 108 */	"sigvec",
	/* 109 */	"sigblock",
	/* 110 */	"sigsetmask",
#else
	/* 108 */	NULL, /* excluded compat_43_sys_sigvec */
	/* 109 */	NULL, /* excluded compat_43_sys_sigblock */
	/* 110 */	NULL, /* excluded compat_43_sys_sigsetmask */
#endif
#if defined(COMPAT_13) || !defined(_KERNEL)
	/* 111 */	"sigsuspend",
#else
	/* 111 */	NULL, /* excluded compat_13_sys_sigsuspend */
#endif
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 112 */	"sigstack",
	/* 113 */	"recvmsg",
	/* 114 */	"sendmsg",
#else
	/* 112 */	NULL, /* excluded compat_43_sys_sigstack */
	/* 113 */	NULL, /* excluded compat_43_sys_recvmesg */
	/* 114 */	NULL, /* excluded compat_43_sys_sendmesg */
#endif
	/* 115 */	NULL, /* obsolete vtrace */
	/* 116 */	NULL, /* gettimeofday */
	/* 117 */	NULL, /* getrusage */
	/* 118 */	NULL, /* getsockopt */
	/* 119 */	NULL, /* obsolete resuba */
	/* 120 */	NULL, /* readv */
	/* 121 */	NULL, /* writev */
	/* 122 */	NULL, /* settimeofday */
	/* 123 */	NULL, /* fchown */
	/* 124 */	NULL, /* fchmod */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 125 */	"recvfrom",
#else
	/* 125 */	NULL, /* excluded compat_43_sys_recvfrom */
#endif
	/* 126 */	NULL, /* setreuid */
	/* 127 */	NULL, /* setregid */
	/* 128 */	NULL, /* rename */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 129 */	"truncate",
	/* 130 */	"ftruncate",
#else
	/* 129 */	NULL, /* excluded compat_43_sys_truncate */
	/* 130 */	NULL, /* excluded compat_43_sys_ftruncate */
#endif
	/* 131 */	NULL, /* flock */
	/* 132 */	NULL, /* mkfifo */
	/* 133 */	NULL, /* sendto */
	/* 134 */	NULL, /* shutdown */
	/* 135 */	NULL, /* socketpair */
	/* 136 */	NULL, /* mkdir */
	/* 137 */	NULL, /* rmdir */
	/* 138 */	NULL, /* utimes */
	/* 139 */	NULL, /* obsolete 4.2 sigreturn */
	/* 140 */	NULL, /* adjtime */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 141 */	"getpeername",
	/* 142 */	"gethostid",
	/* 143 */	"sethostid",
	/* 144 */	"getrlimit",
	/* 145 */	"setrlimit",
	/* 146 */	"killpg",
#else
	/* 141 */	NULL, /* excluded compat_43_sys_getpeername */
	/* 142 */	NULL, /* excluded compat_43_sys_gethostid */
	/* 143 */	NULL, /* excluded compat_43_sys_sethostid */
	/* 144 */	NULL, /* excluded compat_43_sys_getrlimit */
	/* 145 */	NULL, /* excluded compat_43_sys_setrlimit */
	/* 146 */	NULL, /* excluded compat_43_sys_killpg */
#endif
	/* 147 */	NULL, /* setsid */
#if defined(QUOTA) || !defined(_KERNEL_OPT)
	/* 148 */	NULL, /* quotactl */
#else
	/* 148 */	NULL, /* excluded compat_50_sys_quotactl */
#endif
#if (defined(QUOTA) && defined(COMPAT_43)) || !defined(_KERNEL_OPT)
	/* 149 */	"quota",
#else
	/* 149 */	NULL, /* excluded compat_43_sys_quota */
#endif
#if defined(COMPAT_43) || !defined(_KERNEL_OPT)
	/* 150 */	"getsockname",
#else
	/* 150 */	NULL, /* excluded compat_43_sys_getsockname */
#endif
	/* 151 */	NULL, /* unimplemented */
	/* 152 */	NULL, /* unimplemented */
	/* 153 */	NULL, /* unimplemented */
	/* 154 */	NULL, /* unimplemented */
	/* 155 */	NULL, /* excluded nfssvc */
#if defined(COMPAT_43) || !defined(_KERNEL)
	/* 156 */	"getdirentries",
#else
	/* 156 */	NULL, /* excluded compat_43_sys_getdirentries */
#endif
#if defined(COMPAT_20) || !defined(_KERNEL)
	/* 157 */	NULL, /* statfs */
#else
	/* 157 */	NULL, /* excluded compat_20_sys_statfs */
#endif
#if defined(COMPAT_20) || !defined(_KERNEL)
	/* 158 */	NULL, /* fstatfs */
#else
	/* 158 */	NULL, /* excluded compat_20_sys_statfs */
#endif
	/* 159 */	NULL, /* unimplemented */
	/* 160 */	NULL, /* unimplemented */
#if defined(COMPAT_30) || !defined(_KERNEL)
	/* 161 */	NULL, /* getfh */
#else
	/* 161 */	NULL, /* excluded compat_30_sys_getfh */
#endif
#if defined(COMPAT_09) || !defined(_KERNEL)
	/* 162 */	"getdomainname",
	/* 163 */	"setdomainname",
	/* 164 */	"uname",
#else
	/* 162 */	NULL, /* excluded compat_09_sys_getdomainname */
	/* 163 */	NULL, /* excluded compat_09_sys_setdomainname */
	/* 164 */	NULL, /* excluded compat_09_sys_uname */
#endif
	/* 165 */	NULL, /* sysarch */
	/* 166 */	NULL, /* unimplemented */
	/* 167 */	NULL, /* unimplemented */
	/* 168 */	NULL, /* unimplemented */
#if (defined(SYSVSEM) || !defined(_KERNEL)) && !defined(_LP64) && defined(COMPAT_10)
	/* 169 */	"semsys",
#else
	/* 169 */	NULL, /* excluded 1.0 semsys */
#endif
#if (defined(SYSVMSG) || !defined(_KERNEL)) && !defined(_LP64) && defined(COMPAT_10)
	/* 170 */	"msgsys",
#else
	/* 170 */	NULL, /* excluded 1.0 msgsys */
#endif
#if (defined(SYSVSHM) || !defined(_KERNEL)) && !defined(_LP64) && defined(COMPAT_10)
	/* 171 */	"shmsys",
#else
	/* 171 */	NULL, /* excluded 1.0 shmsys */
#endif
	/* 172 */	NULL, /* unimplemented */
	/* 173 */	NULL, /* pread */
	/* 174 */	NULL, /* pwrite */
	/* 175 */	NULL, /* unimplemented sys_ntp_gettime */
#if defined(NTP) || !defined(_KERNEL)
	/* 176 */	NULL, /* ntp_adjtime */
#else
	/* 176 */	NULL, /* excluded ntp_adjtime */
#endif
	/* 177 */	NULL, /* unimplemented */
	/* 178 */	NULL, /* unimplemented */
	/* 179 */	NULL, /* unimplemented */
	/* 180 */	NULL, /* unimplemented */
	/* 181 */	NULL, /* setgid */
	/* 182 */	NULL, /* setegid */
	/* 183 */	NULL, /* seteuid */
	/* 184 */	NULL, /* excluded lfs_bmapv */
	/* 185 */	NULL, /* excluded lfs_markv */
	/* 186 */	NULL, /* excluded lfs_segclean */
	/* 187 */	NULL, /* excluded lfs_segwait */
#if defined(COMPAT_12) || !defined(_KERNEL)
	/* 188 */	"stat",
	/* 189 */	"fstat",
	/* 190 */	"lstat",
#else
	/* 188 */	NULL, /* excluded aoutm68k_compat_12_sys_stat */
	/* 189 */	NULL, /* excluded aoutm68k_compat_12_sys_fstat */
	/* 190 */	NULL, /* excluded aoutm68k_compat_12_sys_lstat */
#endif
	/* 191 */	NULL, /* pathconf */
	/* 192 */	NULL, /* fpathconf */
	/* 193 */	NULL, /* unimplemented */
	/* 194 */	NULL, /* getrlimit */
	/* 195 */	NULL, /* setrlimit */
#if defined(COMPAT_12) || !defined(_KERNEL)
	/* 196 */	NULL, /* getdirentries */
#else
	/* 196 */	NULL, /* excluded compat_12_sys_getdirentries */
#endif
	/* 197 */	NULL, /* mmap */
	/* 198 */	NULL, /* __syscall */
	/* 199 */	NULL, /* lseek */
	/* 200 */	NULL, /* truncate */
	/* 201 */	NULL, /* ftruncate */
	/* 202 */	NULL, /* __sysctl */
	/* 203 */	NULL, /* mlock */
	/* 204 */	NULL, /* munlock */
	/* 205 */	NULL, /* undelete */
	/* 206 */	NULL, /* futimes */
	/* 207 */	NULL, /* getpgid */
	/* 208 */	NULL, /* reboot */
	/* 209 */	NULL, /* poll */
	/* 210 */	NULL, /* unimplemented */
	/* 211 */	NULL, /* unimplemented */
	/* 212 */	NULL, /* unimplemented */
	/* 213 */	NULL, /* unimplemented */
	/* 214 */	NULL, /* unimplemented */
	/* 215 */	NULL, /* unimplemented */
	/* 216 */	NULL, /* unimplemented */
	/* 217 */	NULL, /* unimplemented */
	/* 218 */	NULL, /* unimplemented */
	/* 219 */	NULL, /* unimplemented */
#if defined(SYSVSEM) || !defined(_KERNEL)
#if defined(COMPAT_14) || !defined(_KERNEL)
	/* 220 */	NULL, /* __semctl */
#else
	/* 220 */	NULL, /* excluded compat_14_semctl */
#endif
	/* 221 */	NULL, /* semget */
	/* 222 */	NULL, /* semop */
	/* 223 */	NULL, /* semconfig */
#else
	/* 220 */	NULL, /* excluded compat_14_semctl */
	/* 221 */	NULL, /* excluded semget */
	/* 222 */	NULL, /* excluded semop */
	/* 223 */	NULL, /* excluded semconfig */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
#if defined(COMPAT_14) || !defined(_KERNEL)
	/* 224 */	NULL, /* msgctl */
#else
	/* 224 */	NULL, /* excluded compat_14_sys_msgctl */
#endif
	/* 225 */	NULL, /* msgget */
	/* 226 */	NULL, /* msgsnd */
	/* 227 */	NULL, /* msgrcv */
#else
	/* 224 */	NULL, /* excluded compat_14_msgctl */
	/* 225 */	NULL, /* excluded msgget */
	/* 226 */	NULL, /* excluded msgsnd */
	/* 227 */	NULL, /* excluded msgrcv */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
	/* 228 */	NULL, /* shmat */
#if defined(COMPAT_14) || !defined(_KERNEL)
	/* 229 */	NULL, /* shmctl */
#else
	/* 229 */	NULL, /* excluded compat_14_sys_shmctl */
#endif
	/* 230 */	NULL, /* shmdt */
	/* 231 */	NULL, /* shmget */
#else
	/* 228 */	NULL, /* excluded shmat */
	/* 229 */	NULL, /* excluded compat_14_shmctl */
	/* 230 */	NULL, /* excluded shmdt */
	/* 231 */	NULL, /* excluded shmget */
#endif
	/* 232 */	NULL, /* clock_gettime */
	/* 233 */	NULL, /* clock_settime */
	/* 234 */	NULL, /* clock_getres */
	/* 235 */	NULL, /* unimplemented timer_create */
	/* 236 */	NULL, /* unimplemented timer_delete */
	/* 237 */	NULL, /* unimplemented timer_settime */
	/* 238 */	NULL, /* unimplemented timer_gettime */
	/* 239 */	NULL, /* unimplemented timer_getoverrun */
	/* 240 */	NULL, /* nanosleep */
	/* 241 */	NULL, /* fdatasync */
	/* 242 */	NULL, /* mlockall */
	/* 243 */	NULL, /* munlockall */
	/* 244 */	NULL, /* unimplemented */
	/* 245 */	NULL, /* unimplemented */
	/* 246 */	NULL, /* unimplemented */
	/* 247 */	NULL, /* unimplemented */
	/* 248 */	NULL, /* unimplemented */
	/* 249 */	NULL, /* unimplemented */
	/* 250 */	NULL, /* unimplemented */
	/* 251 */	NULL, /* unimplemented */
	/* 252 */	NULL, /* unimplemented */
	/* 253 */	NULL, /* unimplemented */
	/* 254 */	NULL, /* unimplemented */
	/* 255 */	NULL, /* unimplemented */
	/* 256 */	NULL, /* unimplemented */
	/* 257 */	NULL, /* unimplemented */
	/* 258 */	NULL, /* unimplemented */
	/* 259 */	NULL, /* unimplemented */
	/* 260 */	NULL, /* unimplemented */
	/* 261 */	NULL, /* unimplemented */
	/* 262 */	NULL, /* unimplemented */
	/* 263 */	NULL, /* unimplemented */
	/* 264 */	NULL, /* unimplemented */
	/* 265 */	NULL, /* unimplemented */
	/* 266 */	NULL, /* unimplemented */
	/* 267 */	NULL, /* unimplemented */
	/* 268 */	NULL, /* unimplemented */
	/* 269 */	NULL, /* unimplemented */
	/* 270 */	NULL, /* __posix_rename */
	/* 271 */	NULL, /* swapctl */
#if defined(COMPAT_30) || !defined(_KERNEL)
	/* 272 */	NULL, /* getdents */
#else
	/* 272 */	NULL, /* excluded compat_30_sys_getdents */
#endif
	/* 273 */	NULL, /* minherit */
	/* 274 */	NULL, /* lchmod */
	/* 275 */	NULL, /* lchown */
	/* 276 */	NULL, /* lutimes */
	/* 277 */	"msync",
	/* 278 */	"stat",
	/* 279 */	"fstat",
	/* 280 */	"lstat",
	/* 281 */	"sigaltstack",
	/* 282 */	"vfork",
	/* 283 */	NULL, /* __posix_chown */
	/* 284 */	NULL, /* __posix_fchown */
	/* 285 */	NULL, /* __posix_lchown */
	/* 286 */	NULL, /* getsid */
	/* 287 */	NULL, /* unimplemented */
#if defined(KTRACE) || !defined(_KERNEL)
	/* 288 */	NULL, /* fktrace */
#else
	/* 288 */	NULL, /* excluded ktrace */
#endif
	/* 289 */	NULL, /* preadv */
	/* 290 */	NULL, /* pwritev */
#if defined(COMPAT_16) || !defined(_KERNEL)
	/* 291 */	"sigaction",
#else
	/* 291 */	NULL, /* excluded compat_16_sys___sigaction14 */
#endif
	/* 292 */	"sigpending",
	/* 293 */	"sigprocmask",
	/* 294 */	"sigsuspend",
#if defined(COMPAT_16) || !defined(_KERNEL)
	/* 295 */	"sigreturn",
#else
	/* 295 */	NULL, /* excluded compat_16_sys___sigreturn14 */
#endif
	/* 296 */	NULL, /* __getcwd */
	/* 297 */	NULL, /* fchroot */
#if defined(COMPAT_30) || ! defined(_KERNEL)
	/* 298 */	NULL, /* fhopen */
#else
	/* 298 */	NULL, /* excluded compat_30_sys_fhopen */
#endif
	/* 299 */	NULL, /* fhstat */
#if defined(COMPAT_20) || !defined(_KERNEL)
	/* 300 */	NULL, /* fhstatfs */
#else
	/* 300 */	NULL, /* excluded compat_20_sys_fhstatfs */
#endif
#if defined(SYSVSEM) || !defined(_KERNEL)
	/* 301 */	"__semctl",
#else
	/* 301 */	NULL, /* excluded ____semctl13 */
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
	/* 302 */	"msgctl",
#else
	/* 302 */	NULL, /* excluded __msgctl13 */
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
	/* 303 */	"shmctl",
#else
	/* 303 */	NULL, /* excluded __shmctl13 */
#endif
	/* 304 */	NULL, /* lchflags */
	/* 305 */	NULL, /* issetugid */
	/* 306 */	NULL, /* getcontext */
	/* 307 */	NULL, /* setcontext */
	/* 308 */	NULL, /* filler */
	/* 309 */	NULL, /* filler */
	/* 310 */	NULL, /* filler */
	/* 311 */	NULL, /* filler */
	/* 312 */	NULL, /* filler */
	/* 313 */	NULL, /* filler */
	/* 314 */	NULL, /* filler */
	/* 315 */	NULL, /* filler */
	/* 316 */	NULL, /* filler */
	/* 317 */	NULL, /* filler */
	/* 318 */	NULL, /* filler */
	/* 319 */	NULL, /* filler */
	/* 320 */	NULL, /* filler */
	/* 321 */	NULL, /* filler */
	/* 322 */	NULL, /* filler */
	/* 323 */	NULL, /* filler */
	/* 324 */	NULL, /* filler */
	/* 325 */	NULL, /* filler */
	/* 326 */	NULL, /* filler */
	/* 327 */	NULL, /* filler */
	/* 328 */	NULL, /* filler */
	/* 329 */	NULL, /* filler */
	/* 330 */	NULL, /* filler */
	/* 331 */	NULL, /* filler */
	/* 332 */	NULL, /* filler */
	/* 333 */	NULL, /* filler */
	/* 334 */	NULL, /* filler */
	/* 335 */	NULL, /* filler */
	/* 336 */	NULL, /* filler */
	/* 337 */	NULL, /* filler */
	/* 338 */	NULL, /* filler */
	/* 339 */	NULL, /* filler */
	/* 340 */	NULL, /* filler */
	/* 341 */	NULL, /* filler */
	/* 342 */	NULL, /* filler */
	/* 343 */	NULL, /* filler */
	/* 344 */	NULL, /* filler */
	/* 345 */	NULL, /* filler */
	/* 346 */	NULL, /* filler */
	/* 347 */	NULL, /* filler */
	/* 348 */	NULL, /* filler */
	/* 349 */	NULL, /* filler */
	/* 350 */	NULL, /* filler */
	/* 351 */	NULL, /* filler */
	/* 352 */	NULL, /* filler */
	/* 353 */	NULL, /* filler */
	/* 354 */	NULL, /* filler */
	/* 355 */	NULL, /* filler */
	/* 356 */	NULL, /* filler */
	/* 357 */	NULL, /* filler */
	/* 358 */	NULL, /* filler */
	/* 359 */	NULL, /* filler */
	/* 360 */	NULL, /* filler */
	/* 361 */	NULL, /* filler */
	/* 362 */	NULL, /* filler */
	/* 363 */	NULL, /* filler */
	/* 364 */	NULL, /* filler */
	/* 365 */	NULL, /* filler */
	/* 366 */	NULL, /* filler */
	/* 367 */	NULL, /* filler */
	/* 368 */	NULL, /* filler */
	/* 369 */	NULL, /* filler */
	/* 370 */	NULL, /* filler */
	/* 371 */	NULL, /* filler */
	/* 372 */	NULL, /* filler */
	/* 373 */	NULL, /* filler */
	/* 374 */	NULL, /* filler */
	/* 375 */	NULL, /* filler */
	/* 376 */	NULL, /* filler */
	/* 377 */	NULL, /* filler */
	/* 378 */	NULL, /* filler */
	/* 379 */	NULL, /* filler */
	/* 380 */	NULL, /* filler */
	/* 381 */	NULL, /* filler */
	/* 382 */	NULL, /* filler */
	/* 383 */	NULL, /* filler */
	/* 384 */	NULL, /* filler */
	/* 385 */	NULL, /* filler */
	/* 386 */	NULL, /* filler */
	/* 387 */	NULL, /* filler */
	/* 388 */	NULL, /* filler */
	/* 389 */	NULL, /* filler */
	/* 390 */	NULL, /* filler */
	/* 391 */	NULL, /* filler */
	/* 392 */	NULL, /* filler */
	/* 393 */	NULL, /* filler */
	/* 394 */	NULL, /* filler */
	/* 395 */	NULL, /* filler */
	/* 396 */	NULL, /* filler */
	/* 397 */	NULL, /* filler */
	/* 398 */	NULL, /* filler */
	/* 399 */	NULL, /* filler */
	/* 400 */	NULL, /* filler */
	/* 401 */	NULL, /* filler */
	/* 402 */	NULL, /* filler */
	/* 403 */	NULL, /* filler */
	/* 404 */	NULL, /* filler */
	/* 405 */	NULL, /* filler */
	/* 406 */	NULL, /* filler */
	/* 407 */	NULL, /* filler */
	/* 408 */	NULL, /* filler */
	/* 409 */	NULL, /* filler */
	/* 410 */	NULL, /* filler */
	/* 411 */	NULL, /* filler */
	/* 412 */	NULL, /* filler */
	/* 413 */	NULL, /* filler */
	/* 414 */	NULL, /* filler */
	/* 415 */	NULL, /* filler */
	/* 416 */	NULL, /* filler */
	/* 417 */	NULL, /* filler */
	/* 418 */	NULL, /* filler */
	/* 419 */	NULL, /* filler */
	/* 420 */	NULL, /* filler */
	/* 421 */	NULL, /* filler */
	/* 422 */	NULL, /* filler */
	/* 423 */	NULL, /* filler */
	/* 424 */	NULL, /* filler */
	/* 425 */	NULL, /* filler */
	/* 426 */	NULL, /* filler */
	/* 427 */	NULL, /* filler */
	/* 428 */	NULL, /* filler */
	/* 429 */	NULL, /* filler */
	/* 430 */	NULL, /* filler */
	/* 431 */	NULL, /* filler */
	/* 432 */	NULL, /* filler */
	/* 433 */	NULL, /* filler */
	/* 434 */	NULL, /* filler */
	/* 435 */	NULL, /* filler */
	/* 436 */	NULL, /* filler */
	/* 437 */	NULL, /* filler */
	/* 438 */	NULL, /* filler */
	/* 439 */	NULL, /* filler */
	/* 440 */	NULL, /* filler */
	/* 441 */	NULL, /* filler */
	/* 442 */	NULL, /* filler */
	/* 443 */	NULL, /* filler */
	/* 444 */	NULL, /* filler */
	/* 445 */	NULL, /* filler */
	/* 446 */	NULL, /* filler */
	/* 447 */	NULL, /* filler */
	/* 448 */	NULL, /* filler */
	/* 449 */	NULL, /* filler */
	/* 450 */	NULL, /* filler */
	/* 451 */	NULL, /* filler */
	/* 452 */	NULL, /* filler */
	/* 453 */	NULL, /* filler */
	/* 454 */	NULL, /* filler */
	/* 455 */	NULL, /* filler */
	/* 456 */	NULL, /* filler */
	/* 457 */	NULL, /* filler */
	/* 458 */	NULL, /* filler */
	/* 459 */	NULL, /* filler */
	/* 460 */	NULL, /* filler */
	/* 461 */	NULL, /* filler */
	/* 462 */	NULL, /* filler */
	/* 463 */	NULL, /* filler */
	/* 464 */	NULL, /* filler */
	/* 465 */	NULL, /* filler */
	/* 466 */	NULL, /* filler */
	/* 467 */	NULL, /* filler */
	/* 468 */	NULL, /* filler */
	/* 469 */	NULL, /* filler */
	/* 470 */	NULL, /* filler */
	/* 471 */	NULL, /* filler */
	/* 472 */	NULL, /* filler */
	/* 473 */	NULL, /* filler */
	/* 474 */	NULL, /* filler */
	/* 475 */	NULL, /* filler */
	/* 476 */	NULL, /* filler */
	/* 477 */	NULL, /* filler */
	/* 478 */	NULL, /* filler */
	/* 479 */	NULL, /* filler */
	/* 480 */	NULL, /* filler */
	/* 481 */	NULL, /* filler */
	/* 482 */	NULL, /* filler */
	/* 483 */	NULL, /* filler */
	/* 484 */	NULL, /* filler */
	/* 485 */	NULL, /* filler */
	/* 486 */	NULL, /* filler */
	/* 487 */	NULL, /* filler */
	/* 488 */	NULL, /* filler */
	/* 489 */	NULL, /* filler */
	/* 490 */	NULL, /* filler */
	/* 491 */	NULL, /* filler */
	/* 492 */	NULL, /* filler */
	/* 493 */	NULL, /* filler */
	/* 494 */	NULL, /* filler */
	/* 495 */	NULL, /* filler */
	/* 496 */	NULL, /* filler */
	/* 497 */	NULL, /* filler */
	/* 498 */	NULL, /* filler */
	/* 499 */	NULL, /* filler */
	/* 500 */	NULL, /* filler */
	/* 501 */	NULL, /* filler */
	/* 502 */	NULL, /* filler */
	/* 503 */	NULL, /* filler */
	/* 504 */	NULL, /* filler */
	/* 505 */	NULL, /* filler */
	/* 506 */	NULL, /* filler */
	/* 507 */	NULL, /* filler */
	/* 508 */	NULL, /* filler */
	/* 509 */	NULL, /* filler */
	/* 510 */	NULL, /* filler */
	/* 511 */	NULL, /* filler */
};
