/* -*-C++-*-	$NetBSD: mips_tx39.cpp,v 1.5 2008/04/28 20:23:20 martin Exp $	*/

/*-
 * Copyright (c) 2001 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by UCHIYAMA Yasushi.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <console.h>
#include <memory.h>
#include <mips/mips_tx39.h>

TX39XX::TX39XX(Console *&cons, MemoryManager *&mem, enum ArchitectureOps arch)
	: MIPSArchitecture(cons, mem)
{
	_boot_func = TX39XX::boot_func;
}

TX39XX::~TX39XX()
{
	/* NO-OP */
}

BOOT_FUNC_(TX39XX)

	BOOL
TX39XX::init()
{
	MIPSArchitecture::init();

	// set D-RAM information
	_mem->loadBank(0x04000000, // D-RAM bank 0/1
	    0x04000000);

	return TRUE;
}

void
TX39XX::systemInfo()
{
	MIPSArchitecture::systemInfo();
	DPRINTF((TEXT("TX39\n")));
}

void
TX39XX::cacheFlush()
{
	MIPS_TX39XX_CACHE_FLUSH();
}
