# Contributing

Thank you for taking the time to contribute! There are several areas where you can help: code, UX, bugs, talking about the DevTools, etc...

---

## 👉 Code of conduct 👈

We strive for collaboration with [mutual respect](https://searchfox.org/mozilla-central/source/devtools/CODE_OF_CONDUCT.md) for each other. Mozilla also has a set of [participation guidelines](https://www.mozilla.org/en-US/about/governance/policies/participation/) which goes into greater detail specific to Mozilla employees and contributors.

Please read the two links above before getting involved. **Contributions that don't abide by the code of conduct and participation guidelines will be rejected**.

---

## Help with code

Whether you're an external contributor or a Mozilla employee, the process to get your code into the repository is essentially the same:

* You [find a bug to work on](./contributing/find-bugs.md) (*note: we use bugs to track 'broken' things, new features and even discussions*).
* [Work on the bug](./contributing/fixing-bugs.md).
* [Request a review](./contributing/making-prs.md) for your code.
* Land the code in the repository.
* And you've contributed—well done 😀

## Help with design and UX

If you're more interested in user experience (think: wireframes, workflows, navigations... and not necessarily implementation details), please have a look at the [UX](https://github.com/firefox-devtools/ux) repository—our friendly designers will be more than happy to welcome you onboard. You can also have a look at the [issues](https://github.com/firefox-devtools/ux/issues) they are considering right now, to get an idea of how it works.

## Help with BUGS! 🐛🐞 <!--TODO: we might want to split this out to another page with more detail, in addition to this introductory section-->

Not less importantly, we also love **when people file bugs**. They help us a lot and are very valuable (specially when they come with reproducible steps, e.g. in the case of crashes or malfunctions). Here is a short [guide on how to file good bugs](./filing-good-bugs.md) if you've never done it before (or if you need a reminder).

Another thing that is super valuable is **reproducing** bugs (to validate they're happening in more than one environment), and also **completing** bugs, i.e. ensuring the bug has steps to reproduce, a test case, etc, as [mentioned on the guide](./filing-good-bugs.md). This saves time for the person(s) who will work on the bug, as then they can jump straight to fixing or implementing whatever is needed, instead of doing research work. If you can do any of these for a given bug, add a comment with the additional data that you found out.

Likewise, if you think that a bug is solved, because you can't reproduce it and doesn't happen any more, this is also useful to know. We can always do with closing more bugs, so please leave a comment detailing as much information as you can provide 😀

## Talking about the tools <!--TODO: same as above, might want a separate page on talking and maybe collecting talks?-->

We really love when people talk about our work. Be it in a blog post, or in your favourite social media network, or user group, conference, you name it! We'd love to read/watch your article/talk, so please get in touch if you do.

Answering other people's questions in [our Discourse forum](https://discourse.mozilla.org/c/devtools) or [developer mailing list](https://groups.google.com/forum/#!forum/mozilla.dev.developer-tools) is also helpful.

## Other areas

The above is not a comprehensive list; if you think you can help some other way that is not here, feel free to do it!

**Whatever you choose to do, thank you so much for helping us** ❤️
