/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.Color;
import javax.swing.AbstractButton;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.AbstractColorDelegate;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class ButtonColorDelegate
extends AbstractColorDelegate {
    protected AbstractButton button;
    protected boolean isForeground;

    public ButtonColorDelegate(AbstractButton button, boolean isForeground) {
        super(isForeground ? button.getForeground().getRGB() : button.getBackground().getRGB());
        this.button = button;
        this.isForeground = isForeground;
    }

    protected Color getDelegate() {
        Color c2;
        ColorScheme defaultScheme;
        boolean isActive;
        ColorScheme colorScheme;
        ComponentState state = ComponentState.getState(this.button.getModel(), this.button);
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        SubstanceTheme theme = SubstanceCoreUtilities.getComponentTheme(this.button, kind);
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme) && theme.getKind() != SubstanceTheme.ThemeKind.NEGATED;
        ColorScheme colorScheme2 = colorScheme = theme.getColorScheme();
        float cyclePos = state.getCycleCount();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(this.button, FadeTracker.FadeKind.SELECTION)) {
            isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.button);
            defaultScheme = SubstanceCoreUtilities.getDefaultScheme(this.button);
            if (state == ComponentState.DEFAULT) {
                colorScheme = SubstanceCoreUtilities.getActiveScheme(this.button);
                colorScheme2 = isActive ? colorScheme : defaultScheme;
                cyclePos = fadeTracker.getFade10(this.button, FadeTracker.FadeKind.SELECTION);
            }
            if (state == ComponentState.SELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = isActive ? colorScheme : defaultScheme;
                cyclePos = 10.0f - fadeTracker.getFade10(this.button, FadeTracker.FadeKind.SELECTION);
            }
        }
        if (fadeTracker.isTracked(this.button, FadeTracker.FadeKind.ROLLOVER)) {
            isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.button);
            defaultScheme = SubstanceCoreUtilities.getDefaultScheme(this.button);
            if (state == ComponentState.DEFAULT) {
                colorScheme = SubstanceCoreUtilities.getActiveScheme(this.button);
                colorScheme2 = isActive ? colorScheme : defaultScheme;
                cyclePos = fadeTracker.getFade10(this.button, FadeTracker.FadeKind.ROLLOVER);
            }
            if (state == ComponentState.ROLLOVER_UNSELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = isActive ? colorScheme : defaultScheme;
                cyclePos = 10.0f - fadeTracker.getFade10(this.button, FadeTracker.FadeKind.ROLLOVER);
            }
        }
        if (this.isForeground) {
            Color c1 = colorScheme.getForegroundColor();
            c2 = colorScheme2.getForegroundColor();
            return SubstanceColorUtilities.getInterpolatedColor(c1, c2, (double)cyclePos / 10.0);
        }
        Color c1 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        c2 = isDark ? colorScheme2.getUltraLightColor() : colorScheme2.getDarkColor();
        return SubstanceColorUtilities.getInterpolatedColor(c1, c2, (double)cyclePos / 10.0);
    }
}

