//---------------------------------------------------------------------------------------
//    LenMus Phonascus: The teacher of music
//    Copyright (c) 2002-2014 LenMus project
//
//    This program is free software; you can redistribute it and/or modify it under the
//    terms of the GNU General Public License as published by the Free Software Foundation,
//    either version 3 of the License, or (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful, but WITHOUT ANY
//    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
//    PARTICULAR PURPOSE.  See the GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License along with this
//    program. If not, see <http://www.gnu.org/licenses/>.
//
//    For any comment, suggestion or feature request, please contact the manager of
//    the project at cecilios@users.sourceforge.net
//
//---------------------------------------------------------------------------------------

#include "lenmus_metronome.h"

namespace lenmus
{


//=======================================================================================
// MetronomeTimer implementation
//=======================================================================================
void MetronomeTimer::Notify()
{
    m_pOwner->OnTimerEvent();
}



//=======================================================================================
// GlobalMetronome implementation
//=======================================================================================
GlobalMetronome::GlobalMetronome(ApplicationScope& appScope, long nMM)
    : Metronome(nMM)
    , m_nSound(-1)
    , m_pTimer(NULL)
{
    m_pMidiServer = appScope.get_midi_server();
}

//---------------------------------------------------------------------------------------
GlobalMetronome::~GlobalMetronome()
{
    if (m_pTimer)
        m_pTimer->Stop();
    delete m_pTimer;
}

//---------------------------------------------------------------------------------------
void GlobalMetronome::start()
{
    if (!m_pTimer)
    {
        m_pTimer = new MetronomeTimer(this);
    }
    m_pTimer->Start(m_nInterval);
    m_fRunning = true;
}

//---------------------------------------------------------------------------------------
void GlobalMetronome::stop()
{
    if (m_pTimer)
    {
        m_pTimer->Stop();
    }
    m_fRunning = false;
    ClickOff();
}

//---------------------------------------------------------------------------------------
void GlobalMetronome::OnTimerEvent()
{
    //If metronome active and not playing, generate metronome click. If currently playing
    //the metronome clicks will be generated by lmSoundManager.Play() as part of the MIDI events
    //table processing.
    if (!m_fMuted)
    {
        m_pTimer->Start(m_nInterval);
        DoClick();
    }
}

//---------------------------------------------------------------------------------------
void GlobalMetronome::DoClick(bool fFirstBeatOfBar)
{
    Synthesizer* pSynth = m_pMidiServer->get_current_synth();
    if (pSynth)
    {
        ClickOff();
        ClickOn(fFirstBeatOfBar);
    }
}

//---------------------------------------------------------------------------------------
void GlobalMetronome::ClickOn(bool fFirstBeatOfBar)
{
    //TODO: Switch on metronome LED
    //Me.picMtrLEDOff.Visible = False
    //Me.picMtrLEDRojoOn.Visible = True

    //generate metronome click
    m_nSound = (fFirstBeatOfBar ? m_pMidiServer->MtrTone1() : m_pMidiServer->MtrTone2() );
    Synthesizer* pSynth = m_pMidiServer->get_current_synth();
    if (pSynth)
        pSynth->note_on(m_pMidiServer->MtrChannel(), m_nSound, 127);
}

//---------------------------------------------------------------------------------------
void GlobalMetronome::ClickOff()
{
    Synthesizer* pSynth = m_pMidiServer->get_current_synth();
    if (pSynth && m_nSound >= 0)
        pSynth->note_off(m_pMidiServer->MtrChannel(), m_nSound, 127);
    m_nSound = -1;

    //TODO: Switch off metronome LED
    //Me.picMtrLEDOff.Visible = True
    //Me.picMtrLEDRojoOn.Visible = False
}


}   // namespace lenmus
