// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/search_engines/ui_thread_search_terms_data_android.h"

#include "chrome/browser/android/locale/locale_manager.h"
#include "chrome/browser/search_engines/ui_thread_search_terms_data.h"
#include "content/public/browser/browser_thread.h"

base::LazyInstance<base::string16>::Leaky
    SearchTermsDataAndroid::rlz_parameter_value_ = LAZY_INSTANCE_INITIALIZER;
base::LazyInstance<std::string>::Leaky
    SearchTermsDataAndroid::search_client_ = LAZY_INSTANCE_INITIALIZER;

base::string16 UIThreadSearchTermsData::GetRlzParameterValue(
    bool from_app_list) const {
  DCHECK(!content::BrowserThread::IsThreadInitialized(
             content::BrowserThread::UI) ||
         content::BrowserThread::CurrentlyOn(content::BrowserThread::UI));
  // Android doesn't use the rlz library.  Instead, it manages the rlz string
  // on its own.
  return SearchTermsDataAndroid::rlz_parameter_value_.Get();
}

std::string UIThreadSearchTermsData::GetSearchClient() const {
  DCHECK(!content::BrowserThread::IsThreadInitialized(
             content::BrowserThread::UI) ||
         content::BrowserThread::CurrentlyOn(content::BrowserThread::UI));
  return SearchTermsDataAndroid::search_client_.Get();
}

std::string UIThreadSearchTermsData::GetYandexReferralID() const {
  return LocaleManager::GetYandexReferralID();
}

std::string UIThreadSearchTermsData::GetMailRUReferralID() const {
  return LocaleManager::GetMailRUReferralID();
}
