// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef ASH_PUBLIC_CPP_NOTIFICATION_UTILS_H_
#define ASH_PUBLIC_CPP_NOTIFICATION_UTILS_H_

#include <string>

#include "ash/public/cpp/ash_public_export.h"
#include "base/callback_forward.h"
#include "base/memory/scoped_refptr.h"
#include "base/strings/string16.h"
#include "ui/gfx/color_palette.h"
#include "ui/message_center/public/cpp/notification.h"
#include "ui/message_center/public/cpp/notification_types.h"
#include "ui/message_center/public/cpp/notifier_id.h"

class GURL;

namespace gfx {
struct VectorIcon;
}

namespace ui {
namespace message_center {
class NotificationDelegate;
}
}  // namespace ui

namespace ash {

// Accent colors of system notifications.
constexpr SkColor kSystemNotificationColorNormal = gfx::kGoogleBlue700;
constexpr SkColor kSystemNotificationColorWarning = gfx::kGoogleYellow900;
constexpr SkColor kSystemNotificationColorCriticalWarning = gfx::kGoogleRed700;

// Helper method to create a simple system notification. |click_callback|
// will be invoked when the notification is clicked.
//
// It should only be used for critical notification, as SetSystemPriority and
// CRITICAL_WARNING color are set inside, which means the notification would
// not go away without user interaction.
//
// TODO(tetsui): Add a function parameter |small_image| of gfx::VectorIcon, so
// display source of critical system notification is illustrated by icon.
ASH_PUBLIC_EXPORT std::unique_ptr<message_center::Notification>
CreateSystemNotification(const std::string& notification_id,
                         const base::string16& title,
                         const base::string16& message,
                         const std::string& system_component_id,
                         const base::RepeatingClosure& click_callback);

// Factory method to create all kinds of notifications generated by system,
// from normal priority ones to critical priority ones.
// |small_image| is a small icon show on the upper left header to illustrate
// |display_source| of the notification.
// One specified in the |optional_fields| is overridden.
ASH_PUBLIC_EXPORT std::unique_ptr<message_center::Notification>
CreateSystemNotification(
    message_center::NotificationType type,
    const std::string& id,
    const base::string16& title,
    const base::string16& message,
    const base::string16& display_source,
    const GURL& origin_url,
    const message_center::NotifierId& notifier_id,
    const message_center::RichNotificationData& optional_fields,
    scoped_refptr<message_center::NotificationDelegate> delegate,
    const gfx::VectorIcon& small_image,
    message_center::SystemNotificationWarningLevel warning_level);

}  // namespace ash

#endif  // ASH_PUBLIC_CPP_NOTIFICATION_UTILS_H_
