'\" t
.\" -*-nroff-*-
.\"
.\"     Copyright (C) 1996-2000 Michael R. Elkins <me@cs.hmc.edu>
.\"	Copyright (C) 1999-2000 Thomas Roessler <roessler@does-not-exist.org>
.\" 
.\"     This program is free software; you can redistribute it and/or modify
.\"     it under the terms of the GNU General Public License as published by
.\"     the Free Software Foundation; either version 2 of the License, or
.\"     (at your option) any later version.
.\" 
.\"     This program is distributed in the hope that it will be useful,
.\"     but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"     GNU General Public License for more details.
.\" 
.\"     You should have received a copy of the GNU General Public License
.\"     along with this program; if not, write to the Free Software
.\"     Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
.\"
.de EX
.nf
.ft CW
..
.de EE
.ft
.fi
..
.TH muttrc 5 "January 2019" Unix "User Manuals"
.SH NAME
muttrc \- Configuration file for the Mutt Mail User Agent
.SH DESCRIPTION
.PP
A mutt configuration file consists of a series of \(lqcommands\(rq.
Each line of the file may contain one or more commands.  When
multiple commands are used, they must be separated by a semicolon
(\(lq\fB;\fP\(rq).
.PP
The hash mark, or pound sign (\(lq\fB#\fP\(rq), is used as a
\(lqcomment\(rq character. You can use it to annotate your
initialization file. All text after the comment character to the end
of the line is ignored.
.PP
Single quotes (\(lq\fB'\fP\(rq) and double quotes (\(lq\fB"\fP\(rq)
can be used to quote strings which contain spaces or other special
characters.  The difference between the two types of quotes is
similar to that of many popular shell programs, namely that a single
quote is used to specify a literal string (one that is not
interpreted for shell variables or quoting with a backslash [see
next paragraph]), while double quotes indicate a string which
should be evaluated.  For example, backticks are evaluated inside of
double quotes, but not single quotes.
.PP
\fB\(rs\fP quotes the next character, just as in shells such as bash and zsh.
For example, if want to put quotes (\(lq\fB"\fP\(rq) inside of a
string, you can use \(lq\fB\(rs\fP\(rq to force the next character
to be a literal instead of interpreted character.
.PP
\(lq\fB\(rs\(rs\fP\(rq means to insert a literal \(lq\fB\(rs\fP\(rq into the
line.  \(lq\fB\(rsn\fP\(rq and \(lq\fB\(rsr\fP\(rq have their usual
C meanings of linefeed and carriage-return, respectively.
.PP
A \(lq\fB\(rs\fP\(rq at the end of a line can be used to split commands over
multiple lines, provided that the split points don't appear in the
middle of command names.
.PP
It is also possible to substitute the output of a Unix command in an
initialization file.  This is accomplished by enclosing the command
in backticks (\fB`\fP\fIcommand\fP\fB`\fP).
.PP
UNIX environment variables can be accessed like the way it is done in shells
like sh and bash: Prepend the name of the variable by a dollar
(\(lq\fB\(Do\fP\(rq) sign.
.
.
.PP
.SH COMMANDS
.
.PP
.nf
\fBalias\fP [\fB-group\fP \fIname\fP [...]] \fIkey\fP \fIaddress\fP [\fB,\fP \fIaddress\fP [ ... ]]
\fBunalias\fP [\fB * \fP | \fIkey\fP ]
.fi
.IP
\fBalias\fP defines an alias \fIkey\fP for the given addresses. Each
\fIaddress\fP will be resolved into either an email address (user@example.com)
or a named email address (User Name <user@example.com>). The address may be specified in either format, or in the format \(lquser@example.com (User
Name)\(rq.
\fBunalias\fP removes the alias corresponding to the given \fIkey\fP or
all aliases when \(lq\fB*\fP\(rq is used as an argument. The optional
\fB-group\fP argument to \fBalias\fP causes the aliased address(es) to be
added to the named \fIgroup\fP.
.
.PP
.nf
\fBgroup\fP [\fB-group\fP \fIname\fP] [\fB-rx\fP \fIEXPR\fP [ \fI...\fP ]] [\fB-addr\fP \fIaddress\fP [ \fI...\fP ]]
\fBungroup\fP [\fB-group\fP \fIname\fP ] [ \fB*\fP | [[\fB-rx\fP \fIEXPR\fP [ \fI...\fP ]] [\fB-addr\fP \fIaddress\fP [ \fI...\fP ]]]
.fi
.IP
\fBgroup\fP is used to directly add either addresses or regular expressions to
the specified group or groups. The different categories of arguments to the
\fBgroup\fP command can be in any order. The flags \fI-rx\fP and \fI-addr\fP
specify what the following strings (that cannot begin with a hyphen) should be
interpreted as: either a regular expression or an email address, respectively.
\fBungroup\fP is used to remove addresses or regular expressions from the
specified group or groups. The syntax is similar to the \fBgroup\fP command,
however the special character \fB*\fP can be used to empty a group of all of
its contents.
.IP
These address groups can also be created implicitly by the \fBalias\fP, \fBlists\fP,
\fBsubscribe\fP and \fBalternates\fP commands by specifying the optional \fI-group\fP
option.
.IP
Once defined, these address groups can be used in patterns to search for and limit the
display to messages matching a group.
.
.PP
.nf
\fBalternates\fP [\fB-group\fP \fIname\fP] \fIregexp\fP [ \fIregexp\fP [ ... ]]
\fBunalternates\fP [\fB * \fP | \fIregexp\fP [ \fIregexp\fP [ ... ]] ]
.fi
.IP
\fBalternates\fP is used to inform mutt about alternate addresses
where you receive mail; you can use regular expressions to specify
alternate addresses.  This affects mutt's idea about messages
from you, and messages addressed to you.  \fBunalternates\fP removes
a regular expression from the list of known alternates. The \fB-group\fP flag
causes all of the subsequent regular expressions to be added to the named group.
.
.PP
.nf
\fBalternative_order\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
\fBunalternative_order\fP [\fB * \fP | \fItype\fP/\fIsubtype\fP] [...]
.fi
.IP
\fBalternative_order\fP command permits you to define an order of preference which is
used by mutt to determine which part of a
\fBmultipart/alternative\fP body to display.
A subtype of \(lq\fB*\fP\(rq matches any subtype, as does an empty
subtype.   \fBunalternative_order\fP removes entries from the
ordered list or deletes the entire list when \(lq\fB*\fP\(rq is used
as an argument.
.
.PP
.nf
\fBattachments\fP [ \fB+\fP | \fB-\fP ]\fIdisposition\fP \fImime-type\fP
\fBunattachments\fP [ \fB+\fP | \fB-\fP ]\fIdisposition\fI \fImime-type\fP
\fBattachments\fP \fB?\fP
\fBunattachments\fP \fB*\fP
.fi
.IP
\fBattachments\fP specifies what kinds of attachments are used for Mutt's
attachment counting and searching support.
.IP
\fIdisposition\fP is the attachment's Content-Disposition type - either
inline or attachment. You can abbreviate this to I or A.
.IP
The first part of a message or multipart group, if inline, is counted
separately than other inline parts. Specify root or R for disposition
to count these as attachments. If this first part is of type
multipart/alternative, note that its top-level inline parts are also
counted via root disposition (if $count_alternatives is set).
.IP
\fIdisposition\fP is prefixed by either a \fB+\fP symbol or a \fB-\fP
symbol. If it's a \fB+\fP, you're saying that you want to allow this
disposition and MIME type to qualify. If it's a \fB-\fP, you're saying
that this disposition and MIME type is an exception to previous \fB+\fP
rules.
.IP
\fImime-type\fP is the MIME type of the attachment you want the
command to affect. A MIME type is always of the format major/minor,
where major describes the broad category of document you're looking
at, and minor describes the specific type within that category. The
major part of mime-type must be literal text (or the special token
\fB*\fP), but the minor part may be a regular expression. (Therefore,
\fB*/.*\fP matches any MIME type.)
.IP
The MIME types you give to the attachments directive are a kind of
pattern. When you use the attachments directive, the patterns you
specify are added to a list. When you use unattachments, the pattern
is removed from the list. The patterns are not expanded and matched to
specific MIME types at this time - they're just text in a
list. They're only matched when actually evaluating a message.
.
.PP
.nf
\fBauto_view\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
\fBunauto_view\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
.fi
.IP
This commands permits you to specify that mutt should automatically
convert the given MIME types to text/plain when displaying messages.
For this to work, there must be a 
.BR mailcap (5)
entry for the given MIME type with the 
.B copiousoutput
flag set.  A subtype of \(lq\fB*\fP\(rq 
matches any subtype, as does an empty subtype.
.
.PP
.nf
\fBmime_lookup\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
\fBunmime_lookup\fP \fItype\fP[\fB/\fP\fIsubtype\fP] [ ... ]
.fi
.IP
This command permits you to define a list of "data" MIME content
types for which mutt will try to determine the actual file type from
the file name, and not use a 
.BR mailcap (5)
entry given for the original MIME type.  For instance, you may add
the \fBapplication/octet-stream\fP MIME type to this list.
.
.TP
\fBbind\fP \fImap1,map2,...\fP \fIkey\fP \fIfunction\fP
This command binds the given \fIkey\fP for the given \fImap\fP or maps
to the given \fIfunction\fP. Multiple maps may be specified by
separating them with commas (no whitespace is allowed).
.IP
Valid maps are:
.BR generic ", " alias ", " attach ", " 
.BR browser ", " editor ", "
.BR index ", " compose ", " 
.BR pager ", " pgp ", " postpone ", "
.BR mix .
.IP
For more information on keys and functions, please consult the Mutt
Manual. Note that the function name is to be specified without
angle brackets.
.
.TP
\fBaccount-hook\fP [\fB!\fP]\fIregexp\fP \fIcommand\fP
This hook is executed whenever you access a remote mailbox. Useful
to adjust configuration settings to different IMAP or POP servers.
.
.TP
\fBcharset-hook\fP \fIalias\fP \fIcharset\fP
This command defines an alias for a character set.  This is useful
to properly display messages which are tagged with a character set
name not known to mutt.
.
.TP
\fBiconv-hook\fP \fIcharset\fP \fIlocal-charset\fP
This command defines a system-specific name for a character set.
This is useful when your system's 
.BR iconv (3)
implementation does not understand MIME character set names (such as 
.BR iso-8859-1 ),
but instead insists on being fed with implementation-specific
character set names (such as
.BR 8859-1 ).
In this specific case, you'd put this into your configuration file:
.IP
.B "iconv-hook iso-8859-1 8859-1"
.
.TP
\fBmessage-hook\fP [\fB!\fP]\fIpattern\fP \fIcommand\fP
Before mutt displays (or formats for replying or forwarding) a
message which matches the given \fIpattern\fP (or, when it is
preceded by an exclamation mark, does not match the \fIpattern\fP),
the given \fIcommand\fP is executed.  When multiple
\fBmessage-hook\fPs match, they are  executed  in  the order in
which they occur in the configuration file.
.
.TP
\fBfolder-hook\fP [\fB!\fP]\fIregexp\fP \fIcommand\fP
When mutt enters a folder which matches \fIregexp\fP (or, when
\fIregexp\fP is preceded by an exclamation mark, does not match
\fIregexp\fP), the given \fIcommand\fP is executed.
.IP
When several \fBfolder-hook\fPs match a given mail folder, they are
executed in the order given in the configuration file.
.
.TP
\fBmacro\fP \fImap\fP \fIkey\fP \fIsequence\fP [ \fIdescription\fP ]
This command binds the given \fIsequence\fP of keys to the given
\fIkey\fP in the given \fImap\fP or maps.  For valid maps, see \fBbind\fP. To
specify multiple maps, put only a comma between the maps.
.PP
.nf
\fBcolor\fP \fIobject\fP [ \fIattribute\fP ... ] \fIforeground\fP \fIbackground\fP [ \fIregexp\fP ]
\fBcolor\fP index [ \fIattribute\fP ... ] \fIforeground\fP \fIbackground\fP [ \fIpattern\fP ]
\fBcolor\fP compose \fIcomposeobject\fP [ \fIattribute\fP ... ] \fIforeground\fP \fIbackground\fP
\fBuncolor\fP index \fIpattern\fP [ \fIpattern\fP ... ]
.fi
.IP
If your terminal supports color, these commands can be used to
assign \fIforeground\fP/\fIbackground\fP combinations to certain
objects.  Valid objects are:
.BR attachment ", " body ", " bold ", " error ", " header ", "
.BR hdrdefault ", " index ", " indicator ", " markers ", "
.BR message ", " normal ", " prompt ", " quoted ", " quoted\fIN\fP ", "
.BR search ", " signature ", " status ", " tilde ", " tree ", "
.BR underline .
If the sidebar is enabled the following objects are also valid:
.BR sidebar_divider ", " sidebar_flagged ", " sidebar_highlight ", "
.BR sidebar_indicator ", " sidebar_new ", " sidebar_spoolfile .
The
.BR body " and " header
objects allow you to restrict the colorization to a regular
expression.  The \fBindex\fP object permits you to select colored
messages by pattern.
.IP
Valid composeobjects include
.BR header ", " security_encrypt ", " security_sign ", "
.BR security_both ", " security_none .
.IP
Valid colors include:
.BR white ", " black ", " green ", " magenta ", " blue ", "
.BR cyan ", " yellow ", " red ", " default ", " color\fIN\fP .
.IP
Valid attributes include:
.BR none ", " bold ", " underline ", "
.BR reverse ", and " standout .
.
.PP
.nf
\fBmono\fP \fIobject\fP \fIattribute\fP [ \fIregexp\fP ]
\fBmono\fP index \fIattribute\fP [ \fIpattern\fP ]
.fi
.IP
For terminals which don't support color, you can still assign
attributes to objects.
.
.TP
[\fBun\fP]\fBignore\fP \fIpattern\fP [ \fIpattern\fP ... ]
The \fBignore\fP command permits you to specify header fields which
you usually don't wish to see.  Any header field whose tag
\fIbegins\fP with an \(lqignored\(rq pattern will be ignored.
.IP
The \fBunignore\fP command permits you to define exceptions from
the above mentioned list of ignored headers.
.
.PP
.nf
\fBlists\fP [\fB-group\fP \fIname\fP] \fIregexp\fP [ \fIregexp\fP ... ]
\fBunlists\fP \fIregexp\fP [ \fIregexp\fP ... ]
\fBsubscribe\fP [\fB-group\fP \fIname\fP] \fIregexp\fP [ \fIregexp\fP ... ]
\fBunsubscribe\fP \fIregexp\fP [ \fIregexp\fP ... ]
.fi
.IP
Mutt maintains two lists of mailing list address patterns, a list of
subscribed mailing lists, and a list of known mailing lists.  All
subscribed mailing lists are known.  Patterns use regular expressions.
.IP
The \fBlists\fP command adds a mailing list address to the list of
known mailing lists.  The \fBunlists\fP command removes a mailing
list from the lists of known and subscribed mailing lists.  The
\fBsubscribe\fP command adds a mailing list to the lists of known
and subscribed mailing lists.  The \fBunsubscribe\fP command removes
it from the list of subscribed mailing lists. The \fB-group\fP flag
adds all of the subsequent regular expressions to the named group.
.
.TP
\fBmbox-hook\fP [\fB!\fP]\fIregexp\fP \fImailbox\fP
When mutt changes to a mail folder which matches \fIregexp\fP,
\fImailbox\fP will be used as the \(lqmbox\(rq folder, i.e., read
messages will be moved to that folder when the mail folder is left.
.IP
The first matching \fBmbox-hook\fP applies.
.
.PP
.nf
\fBmailboxes\fP [[\fB-notify\fP | \fB-nonotify\fP]
           [\fB-poll\fP | \fB-nopoll\fP]
           [[\fB-label\fP \fIlabel\fP] | \fB-nolabel\fP]
           \fIfilename\fP] [ ... ]
\fBunmailboxes\fP [ \fB*\fP | \fIfilename\fP ... ]
.fi
.IP
The \fBmailboxes\fP specifies folders which can receive mail and which will
be checked for new messages.  When changing folders, pressing space
will cycle through folders with new mail.  The \fBunmailboxes\fP
command is used to remove a file name from the list of folders which
can receive mail.  If "\fB*\fP" is specified as the file name, the
list is emptied.
.
.PP
.nf
\fBmy_hdr\fP \fIstring\fP
\fBunmy_hdr\fP \fIfield\fP
.fi
.IP
Using \fBmy_hdr\fP, you can define headers which will be added to
the messages you compose.  \fBunmy_hdr\fP will remove the given
user-defined headers.
.
.TP
\fBhdr_order\fP \fIheader1\fP \fIheader2\fP [ ... ]
With this command, you can specify an order in which mutt will
attempt to present headers to you when viewing messages.
.
.TP
\fBsave-hook\fP [\fB!\fP]\fIpattern\fP \fIfilename\fP
When a message matches \fIpattern\fP, the default file name when
saving it will be the given \fIfilename\fP.
.
.TP
\fBfcc-hook\fP [\fB!\fP]\fIpattern\fP \fIfilename\fP
When an outgoing message matches \fIpattern\fP, the default file
name for storing a copy (fcc) will be the given \fIfilename\fP.
.
.TP
\fBfcc-save-hook\fP [\fB!\fP]\fIpattern\fP \fIfilename\fP
This command is an abbreviation for identical \fBfcc-hook\fP and
\fBsave-hook\fP commands.
.
.TP
\fBsend-hook\fP [\fB!\fP]\fIpattern\fP \fIcommand\fP
When composing a message matching \fIpattern\fP, \fIcommand\fP is
executed.  When multiple \fBsend-hook\fPs match, they are executed
in the order in which they occur in the configuration file.
.
.TP
\fBsend2-hook\fP [\fB!\fP]\fIpattern\fP \fIcommand\fP
Whenever a message matching \fIpattern\fP is changed (either by
editing it or by using the compose menu), \fIcommand\fP
is executed. When multiple \fBsend2-hook\fPs match, they are
executed in the order in which they occur in the configuration file.
Possible applications include setting the $sendmail variable when a
message's from header is changed.
.IP
\fBsend2-hook\fP execution is not triggered by use of
\fBenter-command\fP from the compose menu.
.
.TP
\fBreply-hook\fP [\fB!\fP]\fIpattern\fP \fIcommand\fP
When replying to a message matching \fIpattern\fP, \fIcommand\fP is
executed.  When multiple \fBreply-hook\fPs match, they are executed
in the order in which they occur in the configuration file, but all
\fBreply-hook\fPs are matched and executed before \fBsend-hook\fPs,
regardless of their order in the configuration file.
.
.TP
\fBcrypt-hook\fP \fIregexp\fP \fIkey-id\fP
The crypt-hook command provides a method by which you can
specify the ID of the public key to be used when encrypting messages
to a certain recipient.  The meaning of "key ID" is to be taken
broadly: This can be a different e-mail address, a numerical key ID,
or even just an arbitrary search string.
You may use multiple
\fBcrypt-hook\fPs with the same \fIregexp\fP; multiple matching
\fBcrypt-hook\fPs result in the use of multiple \fIkey-id\fPs for
a recipient.
.
.TP
\fBindex-format-hook\fP \fIname\fP [\fB!\fP]\fIpattern\fP \fIformat-string\fP
This command is used to inject format strings dynamically into
$index_format based on pattern matching against the current message.
.IP
The $index_format expando \fI%@name@\fP specifies a placeholder for
the injection. Index-format-hooks with the same \fIname\fP are matched
using \fIpattern\fP against the current message. Matching is done in
the order specified in the .muttrc, with the first match being
used. The hook's \fIformat-string\fP is then substituted and evaluated.
.
.PP
.nf
\fBopen-hook\fP \fIregexp\fP "\fIcommand\fP"
\fBclose-hook\fP \fIregexp\fP "\fIcommand\fP"
\fBappend-hook\fP \fIregexp\fP "\fIcommand\fP"
.fi
.IP
These commands provide a way to handle compressed folders. The given
\fBregexp\fP specifies which folders are taken as compressed (e.g.
"\fI\\\\.gz$\fP"). The commands tell Mutt how to uncompress a folder
(\fBopen-hook\fP), compress a folder (\fBclose-hook\fP) or append a
compressed mail to a compressed folder (\fBappend-hook\fP). The
\fIcommand\fP string is the
.BR printf (3)
like format string, and it should accept two parameters: \fB%f\fP,
which is replaced with the (compressed) folder name, and \fB%t\fP
which is replaced with the name of the temporary folder to which to
write.
.
.PP
.nf
\fBpush\fP \fIstring\fP
\fBexec\fP \fIfunction\fP [ ... ]
.fi
.IP
\fBpush\fP adds the named \fIstring\fP to the keyboard buffer.
\(lqexec function\(rq is equivalent to \(lqpush <function>\(rq.
.
.TP
\fBrun\fP \fIMuttLisp\fP
.IP
The \fBrun\fP command evaluates the \fIMuttLisp\fP argument. The
output of the \fIMuttLisp\fP is then executed as a Mutt command, as if it
were typed in the muttrc instead.
.
.PP
.nf
\fBscore\fP \fIpattern\fP \fIvalue\fP
\fBunscore\fP [ \fB*\fP | \fIpattern\fP ... ]
.fi
.IP
The \fBscore\fP commands adds \fIvalue\fP to a message's score if
\fIpattern\fP matches it.  The \fBunscore\fP command removes score
entries from the list.
.
.PP
.nf
\fBset\fP [\fBno\fP|\fBinv\fP|\fB&\fP|\fB?\fP]\fIvariable\fP[=\fIvalue\fP] [ ... ]
\fBtoggle\fP \fIvariable\fP [ ... ]
\fBunset\fP \fIvariable\fP [ ... ]
\fBreset\fP \fIvariable\fP [ ... ]
.fi
.IP
These commands are used to set and manipulate configuration
variables.
.IP
Mutt knows four basic types of variables: boolean, number, string
and quadoption.  Boolean variables can be \fBset\fP (true),
\fBunset\fP (false), or \fBtoggle\fPd. Number variables can be assigned
a positive integer value.
.IP
String variables consist of any number of printable characters.
Strings must be enclosed in quotes if they contain spaces or tabs.
You may also use the \(lqC\(rq escape sequences \fB\\n\fP and
\fB\\t\fP for newline and tab, respectively.
.IP
Quadoption variables are used to control whether or not to be
prompted for certain actions, or to specify a default action.  A
value of \fByes\fP will cause the action to be carried out automatically
as if you had answered yes to the question.  Similarly, a value of
\fBno\fP will cause the action to be carried out as if you had
answered \(lqno.\(rq A value of \fBask-yes\fP will cause a prompt
with a default answer of \(lqyes\(rq and \fBask-no\fP will provide a
default answer of \(lqno.\(rq
.IP
The \fBreset\fP command resets all given variables to the compile
time defaults.  If you reset the special variable \fBall\fP, all
variables will reset to their compile time defaults.
.
.PP
.nf
\fBsetenv\fP [\fB?\fP]\fIvariable\fP [ \fIvalue\fP ]
\fBunsetenv\fP \fIvariable\fP
.fi
.IP
These alter the environment that Mutt passes on to its child
processes.  You can also query current environment values by prefixing
a “?” character.
.
.PP
.nf
\fBsidebar_whitelist\fP \fImailbox\fP [ \fImailbox\fP ...]
\fBunsidebar_whitelist\fP [ \fB*\fP | \fImailbox\fP ... ]
.fi
.IP
\fBsidebar_whitelist\fP specifies mailboxes that will always be
displayed in the sidebar, even if $sidebar_new_mail_only is set and
the mailbox does not contain new mail.
.IP
\fBunsidebar_whitelist\fP is used to remove a mailbox from the list of
whitelisted mailboxes. Use \fBunsidebar_whitelist *\fP to remove all
mailboxes.
.
.TP
\fBsource\fP \fIfilename\fP
The given file will be evaluated as a configuration file.
.
.PP
.nf
\fBspam\fP \fIpattern\fP \fIformat\fP
\fBnospam\fP \fIpattern\fP
.fi
.IP
These commands define spam-detection patterns from external spam
filters, so that mutt can sort, limit, and search on
``spam tags'' or ``spam attributes'', or display them
in the index. See the Mutt manual for details.
.
.PP
.nf
\fBsubjectrx\fP \fIpattern\fP \fIreplacement\fP
\fBunsubjectrx\fP [ \fB*\fP | \fIpattern\fP ]
.fi
.IP
\fBsubjectrx\fP specifies a regular expression \fIpattern\fP which, if
detected in a message subject, causes the subject to be replaced with
the \fIreplacement\fP value. The \fIreplacement\fP is subject to
substitutions in the same way as for the \fBspam\fP command: %L for
the text to the left of the match, %R for text to the right of the
match, and %1 for the first subgroup in the match (etc). If you simply
want to erase the match, set it to \(lq%L%R\(rq. Any number of
\fBsubjectrx\fP commands may coexist.
.IP
Note this well: the \fIreplacement\fP value replaces the entire
subject, not just the match!
.IP
\fBunsubjectrx\fP removes a given \fBsubjectrx\fP from the
substitution list. If \fB*\fP is used as the pattern, all
substitutions will be removed.
.
.TP
\fBunhook\fP [\fB * \fP | \fIhook-type\fP ]
This command will remove all hooks of a given type, or all hooks
when \(lq\fB*\fP\(rq is used as an argument.  \fIhook-type\fP
can be any of the \fB-hook\fP commands documented above.
.
.PP
.nf
\fBmailto_allow\fP \fIheader-field\fP [ ... ]
\fBunmailto_allow\fP [ \fB*\fP | \fIheader-field\fP ... ]
.fi
.IP
These commands allow the user to modify the list of allowed header
fields in a \fImailto:\fP URL that Mutt will include in the
the generated message.  By default the list contains only
\fBsubject\fP and \fBbody\fP, as specified by RFC2368.
.
.TP
\fBecho\fP \fImessage\fP
Prints \fImessage\fP to the message window. After printing the
message, echo will pause for the number of seconds specified by
$sleep_time.
.
.TP
\fBcd\fP \fIdirectory\fP
Changes the current working directory.
.
.
.SH PATTERNS
.PP
In various places with mutt, including some of the above mentioned
\fBhook\fP commands, you can specify patterns to match messages.
.SS Constructing Patterns
.PP
A simple pattern consists of a modifier of the form
\(lq\fB~\fP\fIcharacter\fP\(rq, possibly followed by a parameter
against which mutt is supposed to match the object specified by
this modifier.  For some \fIcharacter\fPs, the \fB~\fP may be
replaced by another character to alter the behavior of the match.
These are described in the list of modifiers, below.
.PP
With some of these modifiers, the object to be matched consists of
several e-mail addresses.  In these cases, the object is matched if
at least one of these e-mail addresses matches. You can prepend a
hat (\(lq\fB^\fP\(rq) character to such a pattern to indicate that
\fIall\fP addresses must match in order to match the object.
.PP
You can construct complex patterns by combining simple patterns with
logical operators.  Logical AND is specified by simply concatenating
two simple patterns, for instance \(lq~C mutt-dev ~s bug\(rq.
Logical OR is specified by inserting a vertical bar (\(lq\fB|\fP\(rq)
between two patterns, for instance \(lq~C mutt-dev | ~s bug\(rq.
Additionally, you can negate a pattern by prepending a bang
(\(lq\fB!\fP\(rq) character.  For logical grouping, use braces
(\(lq()\(rq). Example: \(lq!(~t mutt|~c mutt) ~f elkins\(rq.
.SS Simple Patterns
.PP
Mutt understands the following simple patterns:
.P
.PD 0
.TP 12
~A
all messages
.TP
~b \fIEXPR\fP
messages which contain \fIEXPR\fP in the message body.
.TP
=b \fISTRING\fP
If IMAP is enabled, like ~b but searches for \fISTRING\fP on the server, rather than downloading each message and searching it locally.
.TP
~B \fIEXPR\fP
messages which contain \fIEXPR\fP in the whole message.
.TP
=B \fISTRING\fP
If IMAP is enabled, like ~B but searches for \fISTRING\fP on the server, rather than downloading each message and searching it locally.
.TP
~c \fIEXPR\fP
messages carbon-copied to \fIEXPR\fP
.TP
%c \fIGROUP\fP
messages carbon-copied to any member of \fIGROUP\fP
.TP
~C \fIEXPR\fP
messages either to: or cc: \fIEXPR\fP
.TP
%C \fIGROUP\fP
messages either to: or cc: to any member of \fIGROUP\fP
.TP
~d \fIMIN\fP-\fIMAX\fP
messages with \(lqdate-sent\(rq in a Date range
.TP
~D
deleted messages
.TP
~e \fIEXPR\fP
messages which contain \fIEXPR\fP in the \(lqSender\(rq field
.TP
%e \fIGROUP\fP
messages which contain a member of \fIGROUP\fP in the \(lqSender\(rq field
.TP
~E
expired messages
.TP
~f \fIEXPR\fP
messages originating from \fIEXPR\fP
.TP
%f \fIGROUP\fP
messages originating from any member of \fIGROUP\fP
.TP
~F
flagged messages
.TP
~g
PGP signed messages
.TP
~G
PGP encrypted messages
.TP
~h \fIEXPR\fP
messages which contain \fIEXPR\fP in the message header
.TP
=h \fISTRING\fP
If IMAP is enabled, like ~h but searches for \fISTRING\fP on the server, rather than downloading each message and searching it locally.  \fISTRING\fP must be of the form \(lqheader: substring\(rq
.TP
~H \fIEXPR\fP
messages with spam tags matching \fIEXPR\fP
.TP
~i \fIEXPR\fP
messages which match \fIEXPR\fP in the \(lqMessage-ID\(rq field
.TP
~k
messages containing PGP key material
.TP
~l
messages addressed to a known mailing list (defined by either \fBsubscribe\fP or \fBlist\fP)
.TP
~L \fIEXPR\fP
messages either originated or received by \fIEXPR\fP
.TP
%L \fIGROUP\fP
messages either originated or received by any member of \fIGROUP\fP
.TP
~m \fIMIN\fP-\fIMAX\fP
message in the range \fIMIN\fP to \fIMAX\fP
.TP
~M \fIEXPR\fP
messages which contain a mime Content-Type matching \fIEXPR\fP
.TP
~n \fIMIN\fP-\fIMAX\fP
messages with a score in the range \fIMIN\fP to \fIMAX\fP
.TP
~N
new messages
.TP
~O
old messages
.TP
~p
messages addressed to you (consults $from, \fBalternates\fP, and local account/hostname information)
.TP
~P
messages from you (consults $from, \fBalternates\fP, and local account/hostname information)
.TP
~Q
messages which have been replied to
.TP
~r \fIMIN\fP-\fIMAX\fP
messages with \(lqdate-received\(rq in a Date range
.TP
~R
read messages
.TP
~s \fIEXPR\fP
messages having \fIEXPR\fP in the \(lqSubject\(rq field.
.TP
~S
superseded messages
.TP
~t \fIEXPR\fP
messages addressed to \fIEXPR\fP
.TP
~T
tagged messages
.TP
~u
messages addressed to a subscribed mailing list (defined by \fBsubscribe\fP commands)
.TP
~U
unread messages
.TP
~v
message is part of a collapsed thread.
.TP
~V
cryptographically verified messages
.TP
~x \fIEXPR\fP
messages which contain \fIEXPR\fP in the \(lqReferences\(rq or \(lqIn-Reply-To\(rq field
.TP
~X \fIMIN\fP-\fIMAX\fP
messages with MIN - MAX attachments
.TP
~y \fIEXPR\fP
messages which contain \fIEXPR\fP in the \(lqX-Label\(rq field
.TP
~z \fIMIN\fP-\fIMAX\fP
messages with a size in the range \fIMIN\fP to \fIMAX\fP
.TP
~=
duplicated messages (see $duplicate_threads)
.TP
~$
unreferenced message (requires threaded view)
.TP
~(PATTERN)
messages in threads containing messages matching a certain pattern, e.g. all threads containing messages from you: ~(~P)
.TP
~<(PATTERN)
messages whose immediate parent matches PATTERN, e.g. replies to your messages: ~<(~P)
.TP
~>(PATTERN)
messages having an immediate child matching PATTERN, e.g. messages you replied to: ~>(~P)
.PD 1
.DT
.PP
In the above, \fIEXPR\fP is a regular expression.
.PP
With the \fB~d\fP, \fB~m\fP, \fB~n\fP, \fB~r\fP, \fB~X\fP, and \fB~z\fP modifiers, you can also
specify ranges in the forms \fB<\fP\fIMAX\fP, \fB>\fP\fIMIN\fP,
\fIMIN\fP\fB-\fP, and \fB-\fP\fIMAX\fP.
.PP
With the \fB~z\fP modifier, the suffixes \(lqK\(rq and \(lqM\(rq are allowed to specify
kilobyte and megabyte respectively.
.PP
The \fB~b\fP, \fB~B\fP, \fB~h\fP, \fB~M\fP, and \fB~X\fP modifiers
require reading each message in, which can be much slower.
.PP
You can force Mutt to treat \fIEXPR\fP as a simple string instead of a
regular expression by using = instead of ~ in the pattern name.
.SS Matching dates
.PP
The \fB~d\fP and \fB~r\fP modifiers are used to match date ranges,
which are interpreted to be given in your local time zone.
.PP
A date is of the form
\fIDD\fP[\fB/\fP\fIMM\fP[\fB/\fP[\fIcc\fP]\fIYY\fP]], that is, a
two-digit date, optionally followed by a two-digit month, optionally
followed by a year specifications.  Omitted fields default to the
current month and year.
.PP
Mutt understands either two or four digit year specifications.  When
given a two-digit year, mutt will interpret values less than 70 as
lying in the 21st century (i.e., \(lq38\(rq means 2038 and not 1938,
and \(lq00\(rq is interpreted as 2000), and values
greater than or equal to 70 as lying in the 20th century.
.PP
Note that this behavior \fIis\fP Y2K compliant, but that mutt
\fIdoes\fP have a Y2.07K problem.
.PP
Alternatively, you may use \fIYYYYMMDD\fP to specify a date.
.PP
If a date range consists of a single date, the modifier in question
will match that precise date.  If the date range consists of a dash
(\(lq\fB-\fP\(rq), followed by a date, this range will match any
date before and up to the date given.  Similarly, a date followed by
a dash matches the date given and any later point of time.  Two
dates, separated by a dash, match any date which lies in the given
range of time.
.PP
You can also modify any absolute date by giving an error range.  An
error range consists of one of the characters
.BR + ,
.BR - ,
.BR * ,
followed by a positive number, followed by one of the unit
characters
.BR y ,
.BR m ,
.BR w ", or"
.BR d ,
specifying a unit of years, months, weeks, or days.  
.B +
increases the maximum date matched by the given interval of time,
.B - 
decreases the minimum date matched by the given interval of time, and
.B *
increases the maximum date and decreases the minimum date matched by
the given interval of time.  It is possible to give multiple error
margins, which cumulate.  Example:
.B "1/1/2001-1w+2w*3d"
.PP
You can also specify offsets relative to the current date.  An
offset is specified as one of the characters
.BR < ,
.BR > ,
.BR = ,
followed by a positive number, followed by one of the unit
characters
.BR y ,
.BR m ,
.BR w ,
.BR d ,
.BR H ,
.BR M ", or"
.BR S .
.B >
matches dates which are older than the specified amount of time, an
offset which begins with the character
.B < 
matches dates which are more recent than the specified amount of time,
and an offset which begins with the character
.B =
matches points of time which are precisely the given amount of time
ago.
.SH CONFIGURATION VARIABLES

.TP
.B abort_noattach
.nf
Type: quadoption
Default: no
.fi
.IP
When the body of the message matches $abort_noattach_regexp and
there are no attachments, this quadoption controls whether to
abort sending the message.


.TP
.B abort_noattach_regexp
.nf
Type: regular expression
Default: \(lqattach\(rq
.fi
.IP
Specifies a regular expression to match against the body of the
message, to determine if an attachment was mentioned but
mistakenly forgotten.  If it matches, $abort_noattach will be
consulted to determine if message sending will be aborted.
.IP
Like other regular expressions in Mutt, the search is case
sensitive if the pattern contains at least one upper case letter,
and case insensitive otherwise.


.TP
.B abort_nosubject
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
If set to \fIyes\fP, when composing messages and no subject is given
at the subject prompt, composition will be aborted.  If set to
\fIno\fP, composing messages with no subject given at the subject
prompt will never be aborted.


.TP
.B abort_unmodified
.nf
Type: quadoption
Default: yes
.fi
.IP
If set to \fIyes\fP, composition will automatically abort after
editing the message body if no changes are made to the file (this
check only happens after the \fIfirst\fP edit of the file).  When set
to \fIno\fP, composition will never be aborted.


.TP
.B alias_file
.nf
Type: path
Default: \(lq~/.muttrc\(rq
.fi
.IP
The default file in which to save aliases created by the
\fB<create-alias>\fP function. Entries added to this file are
encoded in the character set specified by $config_charset if it
is \fIset\fP or the current character set otherwise.
.IP
\fBNote:\fP Mutt will not automatically source this file; you must
explicitly use the \(lqsource\(rq command for it to be executed in case
this option points to a dedicated alias file.
.IP
The default for this option is the currently used muttrc file, or
\(lq~/.muttrc\(rq if no user muttrc was found.


.TP
.B alias_format
.nf
Type: string
Default: \(lq%4n %2f %t %\-10a   %r\(rq
.fi
.IP
Specifies the format of the data displayed for the \(lqalias\(rq menu.  The
following \fBprintf(3)\fP\-style sequences are available:
.RS
.PD 0
.TP
%a 
alias name
.TP
%f 
flags \- currently, a \(lqd\(rq for an alias marked for deletion
.TP
%n 
index number
.TP
%r 
address which alias expands to
.TP
%t 
character which indicates if the alias is tagged for inclusion
.RE
.PD 1

.TP
.B allow_8bit
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether 8\-bit data is converted to 7\-bit using either Quoted\-
Printable or Base64 encoding when sending mail.


.TP
.B allow_ansi
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether ANSI color codes in messages (and color tags in
rich text messages) are to be interpreted.
Messages containing these codes are rare, but if this option is \fIset\fP,
their text will be colored accordingly. Note that this may override
your color choices, and even present a security problem, since a
message could include a line like

.IP
.EX
[\-\- PGP output follows ...

.EE
.IP
and give it the same color as your attachment color (see also
$crypt_timestamp).


.TP
.B arrow_cursor
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, an arrow (\(lq\->\(rq) will be used to indicate the current entry
in menus instead of highlighting the whole line.  On slow network or modem
links this will make response faster because there is less that has to
be redrawn on the screen when moving to the next or previous entries
in the menu.


.TP
.B ascii_chars
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, Mutt will use plain ASCII characters when displaying thread
and attachment trees, instead of the default \fIACS\fP characters.


.TP
.B askbcc
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, Mutt will prompt you for blind\-carbon\-copy (Bcc) recipients
before editing an outgoing message.


.TP
.B askcc
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, Mutt will prompt you for carbon\-copy (Cc) recipients before
editing the body of an outgoing message.


.TP
.B assumed_charset
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable is a colon\-separated list of character encoding
schemes for messages without character encoding indication.
Header field values and message body content without character encoding
indication would be assumed that they are written in one of this list.
By default, all the header fields and message body without any charset
indication are assumed to be in \(lqus\-ascii\(rq.
.IP
For example, Japanese users might prefer this:

.IP
.EX
set assumed_charset=\(rqiso\-2022\-jp:euc\-jp:shift_jis:utf\-8\(rq

.EE
.IP
However, only the first content is valid for the message body.


.TP
.B attach_charset
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable is a colon\-separated list of character encoding
schemes for text file attachments. Mutt uses this setting to guess
which encoding files being attached are encoded in to convert them to
a proper character set given in $send_charset.
.IP
If \fIunset\fP, the value of $charset will be used instead.
For example, the following configuration would work for Japanese
text handling:

.IP
.EX
set attach_charset=\(rqiso\-2022\-jp:euc\-jp:shift_jis:utf\-8\(rq

.EE
.IP
Note: for Japanese users, \(lqiso\-2022\-*\(rq must be put at the head
of the value as shown above if included.


.TP
.B attach_format
.nf
Type: string
Default: \(lq%u%D%I %t%4n %T%.40d%> [%.7m/%.10M, %.6e%?C?, %C?, %s] \(rq
.fi
.IP
This variable describes the format of the \(lqattachment\(rq menu.  The
following \fBprintf(3)\fP\-style sequences are understood:
.RS
.PD 0
.TP
%C  
charset
.TP
%c  
requires charset conversion (\(lqn\(rq or \(lqc\(rq)
.TP
%D  
deleted flag
.TP
%d  
description (if none, falls back to %F)
.TP
%e  
MIME content\-transfer\-encoding
.TP
%F  
filename in content\-disposition header (if none, falls back to %f)
.TP
%f  
filename
.TP
%I  
disposition (\(lqI\(rq for inline, \(lqA\(rq for attachment)
.TP
%m  
major MIME type
.TP
%M  
MIME subtype
.TP
%n  
attachment number
.TP
%Q  
\(lqQ\(rq, if MIME part qualifies for attachment counting
.TP
%s  
size (see formatstrings-size)
.TP
%t  
tagged flag
.TP
%T  
graphic tree characters
.TP
%u  
unlink (=to delete) flag
.TP
%X  
number of qualifying MIME parts in this part and its children
(please see the \(lqattachments\(rq section for possible speed effects)
.TP
%>X 
right justify the rest of the string and pad with character \(lqX\(rq
.TP
%|X 
pad to the end of the line with character \(lqX\(rq
.TP
%*X 
soft\-fill with character \(lqX\(rq as pad
.RE
.PD 1
.IP
For an explanation of \(lqsoft\-fill\(rq, see the $index_format documentation.


.TP
.B attach_save_charset_convert
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
When saving received text\-type attachments, this quadoption
prompts to convert the character set if the encoding of the
attachment (or $assumed_charset if none is specified) differs
from charset.


.TP
.B attach_save_dir
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
The default directory to save attachments from the \(lqattachment\(rq menu.
If it doesn't exist, Mutt will prompt to create the directory before
saving.
.IP
If the path is invalid (e.g. not a directory, or cannot be
chdir'ed to), Mutt will fall back to using the current directory.


.TP
.B attach_sep
.nf
Type: string
Default: \(lq\\n\(rq
.fi
.IP
The separator to add between attachments when operating (saving,
printing, piping, etc) on a list of tagged attachments.


.TP
.B attach_split
.nf
Type: boolean
Default: yes
.fi
.IP
If this variable is \fIunset\fP, when operating (saving, printing, piping,
etc) on a list of tagged attachments, Mutt will concatenate the
attachments and will operate on them as a single attachment. The
$attach_sep separator is added after each attachment. When \fIset\fP,
Mutt will operate on the attachments one by one.


.TP
.B attribution
.nf
Type: string (localized)
Default: \(lqOn %d, %n wrote:\(rq
.fi
.IP
This is the string that will precede a message which has been included
in a reply.  For a full listing of defined \fBprintf(3)\fP\-like sequences see
the section on $index_format.


.TP
.B attribution_locale
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
The locale used by \fBstrftime(3)\fP to format dates in the
attribution string.  Legal values are the strings your system
accepts for the locale environment variable \fB$LC_TIME\fP.
.IP
This variable is to allow the attribution date format to be
customized by recipient or folder using hooks.  By default, Mutt
will use your locale environment, so there is no need to set
this except to override that default.


.TP
.B auto_subscribe
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, Mutt assumes the presence of a List\-Post header
means the recipient is subscribed to the list.  Unless the mailing list
is in the \(lqunsubscribe\(rq or \(lqunlist\(rq lists, it will be added
to the \(lqsubscribe\(rq list.  Parsing and checking these things slows
header reading down, so this option is disabled by default.


.TP
.B auto_tag
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, functions in the \fIindex\fP menu which affect a message
will be applied to all tagged messages (if there are any).  When
unset, you must first use the \fB<tag\-prefix>\fP function (bound to \(lq;\(rq
by default) to make the next function apply to all tagged messages.


.TP
.B autocrypt
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, enables autocrypt, which provides
passive encryption protection with keys exchanged via headers.
See \(lqautocryptdoc\(rq for more details.
(Autocrypt only)


.TP
.B autocrypt_acct_format
.nf
Type: string
Default: \(lq%4n %\-30a %20p %10s\(rq
.fi
.IP
This variable describes the format of the \(lqautocrypt account\(rq menu.
The following \fBprintf(3)\fP\-style sequences are understood
.RS
.PD 0
.TP
%a  
email address
.TP
%k  
gpg keyid
.TP
%n  
current entry number
.TP
%p  
prefer\-encrypt flag
.TP
%s  
status flag (active/inactive)
.RE
.PD 1
.IP
(Autocrypt only)


.TP
.B autocrypt_dir
.nf
Type: path
Default: \(lq~/.mutt/autocrypt\(rq
.fi
.IP
This variable sets where autocrypt files are stored, including the GPG
keyring and sqlite database.  See \(lqautocryptdoc\(rq for more details.
(Autocrypt only)


.TP
.B autocrypt_reply
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, replying to an autocrypt email automatically
enables autocrypt in the reply.  You may want to unset this if you're using
the same key for autocrypt as normal web\-of\-trust, so that autocrypt
isn't forced on for all encrypted replies.
(Autocrypt only)


.TP
.B autoedit
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP along with $edit_headers, Mutt will skip the initial
send\-menu (prompting for subject and recipients) and allow you to
immediately begin editing the body of your
message.  The send\-menu may still be accessed once you have finished
editing the body of your message.
.IP
\fBNote:\fP when this option is \fIset\fP, you cannot use send\-hooks that depend
on the recipients when composing a new (non\-reply) message, as the initial
list of recipients is empty.
.IP
Also see $fast_reply.


.TP
.B background_edit
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, Mutt will run $editor in the background during
message composition.  A landing page will display, waiting for
the $editor to exit.  The landing page may be exited, allowing
perusal of the mailbox, or even for other messages to be
composed.  Backgrounded sessions may be returned to via the
\fB<background\-compose\-menu>\fP function.
.IP
For background editing to work properly, $editor must be set to
an editor that does not try to use the Mutt terminal: for example
a graphical editor, or a script launching (and waiting for) the
editor in another Gnu Screen window.
.IP
For more details, see \(lqbgedit\(rq (\(rqBackground Editing\(rq in the manual).


.TP
.B background_confirm_quit
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, if there are any background edit sessions, you
will be prompted to confirm exiting Mutt, in addition to the
$quit prompt.


.TP
.B background_format
.nf
Type: string
Default: \(lq%10S %7p %s\(rq
.fi
.IP
This variable describes the format of the \(lqbackground compose\(rq
menu.  The following \fBprintf(3)\fP\-style sequences are
understood:
.RS
.PD 0
.TP
%i 
parent message id (for replies and forwarded messages)
.TP
%n 
the running number on the menu
.TP
%p 
pid of the $editor process
.TP
%r 
comma separated list of \(lqTo:\(rq recipients
.TP
%R 
comma separated list of \(lqCc:\(rq recipients
.TP
%s 
subject of the message
.TP
%S 
status of the $editor process: running/finished
.RE
.PD 1

.TP
.B beep
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is \fIset\fP, mutt will beep when an error occurs.


.TP
.B beep_new
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is \fIset\fP, mutt will beep whenever it prints a message
notifying you of new mail.  This is independent of the setting of the
$beep variable.


.TP
.B bounce
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
Controls whether you will be asked to confirm bouncing messages.
If set to \fIyes\fP you don't get asked if you want to bounce a
message. Setting this variable to \fIno\fP is not generally useful,
and thus not recommended, because you are unable to bounce messages.


.TP
.B bounce_delivered
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is \fIset\fP, mutt will include Delivered\-To headers when
bouncing messages.  Postfix users may wish to \fIunset\fP this variable.


.TP
.B braille_friendly
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is \fIset\fP, mutt will place the cursor at the beginning
of the current line in menus, even when the $arrow_cursor variable
is \fIunset\fP, making it easier for blind persons using Braille displays to
follow these menus.  The option is \fIunset\fP by default because many
visual terminals don't permit making the cursor invisible.


.TP
.B browser_abbreviate_mailboxes
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is \fIset\fP, mutt will abbreviate mailbox
names in the browser mailbox list, using '~' and '='
shortcuts.
.IP
The default \fB\(rqalpha\(rq\fP setting of $sort_browser uses
locale\-based sorting (using \fBstrcoll(3)\fP), which ignores some
punctuation.  This can lead to some situations where the order
doesn't make intuitive sense.  In those cases, it may be
desirable to \fIunset\fP this variable.


.TP
.B browser_sticky_cursor
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is \fIset\fP, the browser will attempt to keep
the cursor on the same mailbox when performing various functions.
These include moving up a directory, toggling between mailboxes
and directory listing, creating/renaming a mailbox, toggling
subscribed mailboxes, and entering a new mask.


.TP
.B certificate_file
.nf
Type: path
Default: \(lq~/.mutt_certificates\(rq
.fi
.IP
This variable specifies the file where the certificates you trust
are saved. When an unknown certificate is encountered, you are asked
if you accept it or not. If you accept it, the certificate can also
be saved in this file and further connections are automatically
accepted.
.IP
You can also manually add CA certificates in this file. Any server
certificate that is signed with one of these CA certificates is
also automatically accepted.
.IP
Example:

.IP
.EX
set certificate_file=~/.mutt/certificates

.EE
.IP
(OpenSSL and GnuTLS only)


.TP
.B change_folder_next
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is \fIset\fP, the \fB<change\-folder>\fP function
mailbox suggestion will start at the next folder in your \(lqmailboxes\(rq
list, instead of starting at the first folder in the list.


.TP
.B charset
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Character set your terminal uses to display and enter textual data.
It is also the fallback for $send_charset.
.IP
Upon startup Mutt tries to derive this value from environment variables
such as \fB$LC_CTYPE\fP or \fB$LANG\fP.
.IP
\fBNote:\fP It should only be set in case Mutt isn't able to determine the
character set used correctly.


.TP
.B check_mbox_size
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is \fIset\fP, mutt will use file size attribute instead of
access time when checking for new mail in mbox and mmdf folders.
.IP
This variable is \fIunset\fP by default and should only be enabled when
new mail detection for these folder types is unreliable or doesn't work.
.IP
Note that enabling this variable should happen before any \(lqmailboxes\(rq
directives occur in configuration files regarding mbox or mmdf folders
because mutt needs to determine the initial new mail status of such a
mailbox by performing a fast mailbox scan when it is defined.
Afterwards the new mail status is tracked by file size changes.


.TP
.B check_new
.nf
Type: boolean
Default: yes
.fi
.IP
\fBNote:\fP this option only affects \fImaildir\fP and \fIMH\fP style
mailboxes.
.IP
When \fIset\fP, Mutt will check for new mail delivered while the
mailbox is open.  Especially with MH mailboxes, this operation can
take quite some time since it involves scanning the directory and
checking each file to see if it has already been looked at.  If
this variable is \fIunset\fP, no check for new mail is performed
while the mailbox is open.


.TP
.B collapse_unread
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIunset\fP, Mutt will not collapse a thread if it contains any
unread messages.


.TP
.B compose_confirm_detach_first
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will prompt for confirmation when trying to
use \fB<detach\-file>\fP on the first entry in the compose menu.
This is to help prevent irreversible loss of the typed message by
accidentally hitting 'D' in the menu.
.IP
Note: Mutt only prompts for the first entry.  It doesn't keep
track of which message is the typed message if the entries are
reordered, or if the first entry was already deleted.


.TP
.B compose_format
.nf
Type: string (localized)
Default: \(lq\-\- Mutt: Compose  [Approx. msg size: %l   Atts: %a]%>\-\(rq
.fi
.IP
Controls the format of the status line displayed in the \(lqcompose\(rq
menu.  This string is similar to $status_format, but has its own
set of \fBprintf(3)\fP\-like sequences:
.RS
.PD 0
.TP
%a 
total number of attachments
.TP
%h 
local hostname
.TP
%l 
approximate size (in bytes) of the current message (see formatstrings-size)
.TP
%v 
Mutt version string
.RE
.PD 1
.IP
See the text describing the $status_format option for more
information on how to set $compose_format.


.TP
.B config_charset
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
When defined, Mutt will recode commands in rc files from this
encoding to the current character set as specified by $charset
and aliases written to $alias_file from the current character set.
.IP
Please note that if setting $charset it must be done before
setting $config_charset.
.IP
Recoding should be avoided as it may render unconvertable
characters as question marks which can lead to undesired
side effects (for example in regular expressions).


.TP
.B confirmappend
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will prompt for confirmation when appending messages to
an existing mailbox.


.TP
.B confirmcreate
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will prompt for confirmation when saving messages to a
mailbox which does not yet exist before creating it.


.TP
.B connect_timeout
.nf
Type: number
Default: 30
.fi
.IP
Causes Mutt to timeout a network connection (for IMAP, POP or SMTP) after this
many seconds if the connection is not able to be established.  A negative
value causes Mutt to wait indefinitely for the connection attempt to succeed.


.TP
.B content_type
.nf
Type: string
Default: \(lqtext/plain\(rq
.fi
.IP
Sets the default Content\-Type for the body of newly composed messages.


.TP
.B copy
.nf
Type: quadoption
Default: yes
.fi
.IP
This variable controls whether or not copies of your outgoing messages
will be saved for later references.  Also see $record,
$save_name, $force_name and \(lqfcc-hook\(rq.


.TP
.B copy_decode_weed
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether Mutt will weed headers when invoking the
\fB<decode\-copy>\fP or \fB<decode\-save>\fP functions.


.TP
.B count_alternatives
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, Mutt will recurse inside multipart/alternatives while
performing attachment searching and counting (see attachments).
.IP
Traditionally, multipart/alternative parts have simply represented
different encodings of the main content of the email.  Unfortunately,
some mail clients have started to place email attachments inside
one of alternatives.  Setting this will allow Mutt to find
and count matching attachments hidden there, and include them
in the index via %X or through ~X pattern matching.


.TP
.B cursor_overlay
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, Mutt will overlay the indicator, tree,
sidebar_highlight, and sidebar_indicator colors onto the currently
selected line.  This will allow \fBdefault\fP colors in those
to be overridden, and for attributes to be merged between
the layers.


.TP
.B crypt_autoencrypt
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable will cause Mutt to always attempt to PGP
encrypt outgoing messages.  This is probably only useful in
connection to the \(lqsend-hook\(rq command.  It can be overridden
by use of the pgp menu, when encryption is not required or
signing is requested as well.  If $smime_is_default is \fIset\fP,
then OpenSSL is used instead to create S/MIME messages and
settings can be overridden by use of the smime menu instead.
(Crypto only)


.TP
.B crypt_autopgp
.nf
Type: boolean
Default: yes
.fi
.IP
This variable controls whether or not mutt may automatically enable
PGP encryption/signing for messages.  See also $crypt_autoencrypt,
$crypt_replyencrypt,
$crypt_autosign, $crypt_replysign and $smime_is_default.


.TP
.B crypt_autosign
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable will cause Mutt to always attempt to
cryptographically sign outgoing messages.  This can be overridden
by use of the pgp menu, when signing is not required or
encryption is requested as well. If $smime_is_default is \fIset\fP,
then OpenSSL is used instead to create S/MIME messages and settings can
be overridden by use of the smime menu instead of the pgp menu.
(Crypto only)


.TP
.B crypt_autosmime
.nf
Type: boolean
Default: yes
.fi
.IP
This variable controls whether or not mutt may automatically enable
S/MIME encryption/signing for messages. See also $crypt_autoencrypt,
$crypt_replyencrypt,
$crypt_autosign, $crypt_replysign and $smime_is_default.


.TP
.B crypt_confirmhook
.nf
Type: boolean
Default: yes
.fi
.IP
If set, then you will be prompted for confirmation of keys when using
the \fIcrypt\-hook\fP command.  If unset, no such confirmation prompt will
be presented.  This is generally considered unsafe, especially where
typos are concerned.


.TP
.B crypt_opportunistic_encrypt
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable will cause Mutt to automatically enable and
disable encryption, based on whether all message recipient keys
can be located by Mutt.
.IP
When this option is enabled, Mutt will enable/disable encryption
each time the TO, CC, and BCC lists are edited.  If
$edit_headers is set, Mutt will also do so each time the message
is edited.
.IP
While this is set, encryption can't be manually enabled/disabled.
The pgp or smime menus provide a selection to temporarily disable
this option for the current message.
.IP
If $crypt_autoencrypt or $crypt_replyencrypt enable encryption for
a message, this option will be disabled for that message.  It can
be manually re\-enabled in the pgp or smime menus.
(Crypto only)


.TP
.B crypt_opportunistic_encrypt_strong_keys
.nf
Type: boolean
Default: no
.fi
.IP
When set, this modifies the behavior of $crypt_opportunistic_encrypt
to only search for \(rqstrong keys\(rq, that is, keys with full validity
according to the web\-of\-trust algorithm.  A key with marginal or no
validity will not enable opportunistic encryption.
.IP
For S/MIME, the behavior depends on the backend.  Classic S/MIME will
filter for certificates with the 't' (trusted) flag in the .index file.
The GPGME backend will use the same filters as with OpenPGP, and depends
on GPGME's logic for assigning the GPGME_VALIDITY_FULL and
GPGME_VALIDITY_ULTIMATE validity flag.


.TP
.B crypt_protected_headers_read
.nf
Type: boolean
Default: yes
.fi
.IP
When set, Mutt will display protected headers in the pager,
and will update the index and header cache with revised headers.
Protected headers are stored inside the encrypted or signed part of an
an email, to prevent disclosure or tampering.
For more information see https://github.com/autocrypt/protected\-headers.
Currently Mutt only supports the Subject header.
.IP
Encrypted messages using protected headers often substitute the exposed
Subject header with a dummy value (see $crypt_protected_headers_subject).
Mutt will update its concept of the correct subject \fBafter\fP the
message is opened, i.e. via the \fB<display\-message>\fP function.
If you reply to a message before opening it, Mutt will end up using
the dummy Subject header, so be sure to open such a message first.
(Crypto only)


.TP
.B crypt_protected_headers_save
.nf
Type: boolean
Default: no
.fi
.IP
When $crypt_protected_headers_read is set, and a message with a
protected Subject is opened, Mutt will save the updated Subject
into the header cache by default.  This allows searching/limiting
based on the protected Subject header if the mailbox is
re\-opened, without having to re\-open the message each time.
However, for mbox/mh mailbox types, or if header caching is not
set up, you would need to re\-open the message each time the
mailbox was reopened before you could see or search/limit on the
protected subject again.
.IP
When this variable is set, Mutt additionally saves the protected
Subject back \fBin the clear\-text message headers\fP.  This
provides better usability, but with the tradeoff of reduced
security.  The protected Subject header, which may have
previously been encrypted, is now stored in clear\-text in the
message headers.  Copying the message elsewhere, via Mutt or
external tools, could expose this previously encrypted data.
Please make sure you understand the consequences of this before
you enable this variable.
(Crypto only)


.TP
.B crypt_protected_headers_subject
.nf
Type: string
Default: \(lq...\(rq
.fi
.IP
When $crypt_protected_headers_write is set, and the message is marked
for encryption, this will be substituted into the Subject field in the
message headers.
To prevent a subject from being substituted, unset this variable, or set it
to the empty string.
(Crypto only)


.TP
.B crypt_protected_headers_write
.nf
Type: boolean
Default: no
.fi
.IP
When set, Mutt will generate protected headers for signed and
encrypted emails.
Protected headers are stored inside the encrypted or signed part of an
an email, to prevent disclosure or tampering.
For more information see https://github.com/autocrypt/protected\-headers.
Currently Mutt only supports the Subject header.
(Crypto only)


.TP
.B crypt_replyencrypt
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, automatically PGP or OpenSSL encrypt replies to messages which are
encrypted.
(Crypto only)


.TP
.B crypt_replysign
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, automatically PGP or OpenSSL sign replies to messages which are
signed.
.IP
\fBNote:\fP this does not work on messages that are encrypted
\fIand\fP signed!
(Crypto only)


.TP
.B crypt_replysignencrypted
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, automatically PGP or OpenSSL sign replies to messages
which are encrypted. This makes sense in combination with
$crypt_replyencrypt, because it allows you to sign all
messages which are automatically encrypted.  This works around
the problem noted in $crypt_replysign, that mutt is not able
to find out whether an encrypted message is also signed.
(Crypto only)


.TP
.B crypt_timestamp
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, mutt will include a time stamp in the lines surrounding
PGP or S/MIME output, so spoofing such lines is more difficult.
If you are using colors to mark these lines, and rely on these,
you may \fIunset\fP this setting.
(Crypto only)


.TP
.B crypt_use_gpgme
.nf
Type: boolean
Default: no
.fi
.IP
This variable controls the use of the GPGME\-enabled crypto backends.
If it is \fIset\fP and Mutt was built with gpgme support, the gpgme code for
S/MIME and PGP will be used instead of the classic code.  Note that
you need to set this option in .muttrc; it won't have any effect when
used interactively.
.IP
Note that the GPGME backend does not support creating old\-style inline
(traditional) PGP encrypted or signed messages (see $pgp_autoinline).


.TP
.B crypt_use_pka
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether mutt uses PKA
(see http://www.g10code.de/docs/pka\-intro.de.pdf) during signature
verification (only supported by the GPGME backend).


.TP
.B crypt_verify_sig
.nf
Type: quadoption
Default: yes
.fi
.IP
If \fI\(lqyes\(rq\fP, always attempt to verify PGP or S/MIME signatures.
If \fI\(lqask\-*\(rq\fP, ask whether or not to verify the signature.
If \fI\(lqno\(rq\fP, never attempt to verify cryptographic signatures.
(Crypto only)


.TP
.B date_format
.nf
Type: string
Default: \(lq!%a, %b %d, %Y at %I:%M:%S%p %Z\(rq
.fi
.IP
This variable controls the format of the date printed by the \(lq%d\(rq
sequence in $index_format.  This is passed to the \fBstrftime(3)\fP
function to process the date, see the man page for the proper syntax.
.IP
Unless the first character in the string is a bang (\(lq!\(rq), the month
and week day names are expanded according to the locale.
If the first character in the string is a
bang, the bang is discarded, and the month and week day names in the
rest of the string are expanded in the \fIC\fP locale (that is in US
English).


.TP
.B default_hook
.nf
Type: string
Default: \(lq~f %s !~P | (~P ~C %s)\(rq
.fi
.IP
This variable controls how \(lqmessage-hook\(rq, \(lqreply-hook\(rq, \(lqsend-hook\(rq,
\(lqsend2-hook\(rq, \(lqsave-hook\(rq, and \(lqfcc-hook\(rq will
be interpreted if they are specified with only a simple regexp,
instead of a matching pattern.  The hooks are expanded when they are
declared, so a hook will be interpreted according to the value of this
variable at the time the hook is declared.
.IP
The default value matches
if the message is either from a user matching the regular expression
given, or if it is from you (if the from address matches
\(lqalternates\(rq) and is to or cc'ed to a user matching the given
regular expression.


.TP
.B delete
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
Controls whether or not messages are really deleted when closing or
synchronizing a mailbox.  If set to \fIyes\fP, messages marked for
deleting will automatically be purged without prompting.  If set to
\fIno\fP, messages marked for deletion will be kept in the mailbox.
.IP
This option is ignored for maildir\-style mailboxes when $maildir_trash
is set.


.TP
.B delete_untag
.nf
Type: boolean
Default: yes
.fi
.IP
If this option is \fIset\fP, mutt will untag messages when marking them
for deletion.  This applies when you either explicitly delete a message,
or when you save it to another folder.


.TP
.B digest_collapse
.nf
Type: boolean
Default: yes
.fi
.IP
If this option is \fIset\fP, mutt's received\-attachments menu will not show the subparts of
individual messages in a multipart/digest.  To see these subparts, press \(lqv\(rq on that menu.


.TP
.B display_filter
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
When set, specifies a command used to filter messages.  When a message
is viewed it is passed as standard input to $display_filter, and the
filtered message is read from the standard output.


.TP
.B dotlock_program
.nf
Type: path
Default: \(lq/usr/local/bin/mutt_dotlock\(rq
.fi
.IP
Contains the path of the \fBmutt_dotlock(1)\fP binary to be used by
mutt.


.TP
.B dsn_notify
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable sets the request for when notification is returned.  The
string consists of a comma separated list (no spaces!) of one or more
of the following: \fInever\fP, to never request notification,
\fIfailure\fP, to request notification on transmission failure,
\fIdelay\fP, to be notified of message delays, \fIsuccess\fP, to be
notified of successful transmission.
.IP
Example:

.IP
.EX
set dsn_notify=\(rqfailure,delay\(rq

.EE
.IP
\fBNote:\fP when using $sendmail for delivery, you should not enable
this unless you are either using Sendmail 8.8.x or greater or a MTA
providing a \fBsendmail(1)\fP\-compatible interface supporting the \fB\-N\fP option
for DSN. For SMTP delivery, DSN support is auto\-detected so that it
depends on the server whether DSN will be used or not.


.TP
.B dsn_return
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable controls how much of your message is returned in DSN
messages.  It may be set to either \fIhdrs\fP to return just the
message header, or \fIfull\fP to return the full message.
.IP
Example:

.IP
.EX
set dsn_return=hdrs

.EE
.IP
\fBNote:\fP when using $sendmail for delivery, you should not enable
this unless you are either using Sendmail 8.8.x or greater or a MTA
providing a \fBsendmail(1)\fP\-compatible interface supporting the \fB\-R\fP option
for DSN. For SMTP delivery, DSN support is auto\-detected so that it
depends on the server whether DSN will be used or not.


.TP
.B duplicate_threads
.nf
Type: boolean
Default: yes
.fi
.IP
This variable controls whether mutt, when $sort is set to \fIthreads\fP, threads
messages with the same Message\-Id together.  If it is \fIset\fP, it will indicate
that it thinks they are duplicates of each other with an equals sign
in the thread tree.


.TP
.B edit_headers
.nf
Type: boolean
Default: no
.fi
.IP
This option allows you to edit the header of your outgoing messages
along with the body of your message.
.IP
Although the compose menu may have localized header labels, the
labels passed to your editor will be standard RFC 2822 headers,
(e.g. To:, Cc:, Subject:).  Headers added in your editor must
also be RFC 2822 headers, or one of the pseudo headers listed in
\(lqedit-header\(rq.  Mutt will not understand localized header
labels, just as it would not when parsing an actual email.
.IP
\fBNote\fP that changes made to the References: and Date: headers are
ignored for interoperability reasons.


.TP
.B editor
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable specifies which editor is used by mutt.
It defaults to the value of the \fB$VISUAL\fP, or \fB$EDITOR\fP, environment
variable, or to the string \(lqvi\(rq if neither of those are set.
.IP
The \fB$editor\fP string may contain a \fI%s\fP escape, which will be replaced by the name
of the file to be edited.  If the \fI%s\fP escape does not appear in \fB$editor\fP, a
space and the name to be edited are appended.
.IP
The resulting string is then executed by running

.IP
.EX
sh \-c 'string'

.EE
.IP
where \fIstring\fP is the expansion of \fB$editor\fP described above.


.TP
.B encode_from
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will quoted\-printable encode messages when
they contain the string \(lqFrom \(rq (note the trailing space) in the beginning of a line.
This is useful to avoid the tampering certain mail delivery and transport
agents tend to do with messages (in order to prevent tools from
misinterpreting the line as a mbox message separator).


.TP
.B entropy_file
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
The file which includes random data that is used to initialize SSL
library functions. (OpenSSL only)


.TP
.B envelope_from_address
.nf
Type: e-mail address
Default: \(lq\(rq
.fi
.IP
Manually sets the \fIenvelope\fP sender for outgoing messages.
This value is ignored if $use_envelope_from is \fIunset\fP.


.TP
.B error_history
.nf
Type: number
Default: 30
.fi
.IP
This variable controls the size (in number of strings remembered)
of the error messages displayed by mutt.  These can be shown with
the \fB<error\-history>\fP function.  The history is cleared each
time this variable is set.


.TP
.B escape
.nf
Type: string
Default: \(lq~\(rq
.fi
.IP
Escape character to use for functions in the built\-in editor.


.TP
.B fast_reply
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, the initial prompt for recipients and subject are skipped
when replying to messages, and the initial prompt for subject is
skipped when forwarding messages.
.IP
\fBNote:\fP this variable has no effect when the $autoedit
variable is \fIset\fP.


.TP
.B fcc_attach
.nf
Type: quadoption
Default: yes
.fi
.IP
This variable controls whether or not attachments on outgoing messages
are saved along with the main body of your message.
.IP
Note: $fcc_before_send forces the default (set) behavior of this option.


.TP
.B fcc_before_send
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is \fIset\fP, FCCs will occur before sending
the message.  Before sending, the message cannot be manipulated,
so it will be stored the exact same as sent:
$fcc_attach and $fcc_clear will be ignored (using their default
values).
.IP
When \fIunset\fP, the default, FCCs will occur after sending.
Variables $fcc_attach and $fcc_clear will be respected, allowing
it to be stored without attachments or encryption/signing if
desired.


.TP
.B fcc_clear
.nf
Type: boolean
Default: no
.fi
.IP
When this variable is \fIset\fP, FCCs will be stored unencrypted and
unsigned, even when the actual message is encrypted and/or
signed.
.IP
Note: $fcc_before_send forces the default (unset) behavior of this option.
(PGP only)
.IP
See also $pgp_self_encrypt, $smime_self_encrypt.


.TP
.B fcc_delimiter
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
When specified, this allows the ability to Fcc to more than one
mailbox.  The fcc value will be split by this delimiter and Mutt
will evaluate each part as a mailbox separately.
.IP
See $record, \(lqfcc-hook\(rq, and \(lqfcc-save-hook\(rq.


.TP
.B flag_safe
.nf
Type: boolean
Default: no
.fi
.IP
If set, flagged messages cannot be deleted.


.TP
.B folder
.nf
Type: path
Default: \(lq~/Mail\(rq
.fi
.IP
Specifies the default location of your mailboxes.  A \(lq+\(rq or \(lq=\(rq at the
beginning of a pathname will be expanded to the value of this
variable.  Note that if you change this variable (from the default)
value you need to make sure that the assignment occurs \fIbefore\fP
you use \(lq+\(rq or \(lq=\(rq for any other variables since expansion takes place
when handling the \(lqmailboxes\(rq command.


.TP
.B folder_format
.nf
Type: string
Default: \(lq%2C %t %N %F %2l %\-8.8u %\-8.8g %8s %d %f\(rq
.fi
.IP
This variable allows you to customize the file browser display to your
personal taste.  This string is similar to $index_format, but has
its own set of \fBprintf(3)\fP\-like sequences:
.RS
.PD 0
.TP
%C  
current file number
.TP
%d  
date/time folder was last modified
.TP
%D  
date/time folder was last modified using $date_format.
.TP
%f  
filename (\(lq/\(rq is appended to directory names,
\(lq@\(rq to symbolic links and \(lq*\(rq to executable
files)
.TP
%F  
file permissions
.TP
%g  
group name (or numeric gid, if missing)
.TP
%l  
number of hard links
.TP
%m  
number of messages in the mailbox *
.TP
%n  
number of unread messages in the mailbox *
.TP
%N  
N if mailbox has new mail, blank otherwise
.TP
%s  
size in bytes (see formatstrings-size)
.TP
%t  
\(lq*\(rq if the file is tagged, blank otherwise
.TP
%u  
owner name (or numeric uid, if missing)
.TP
%>X 
right justify the rest of the string and pad with character \(lqX\(rq
.TP
%|X 
pad to the end of the line with character \(lqX\(rq
.TP
%*X 
soft\-fill with character \(lqX\(rq as pad
.RE
.PD 1
.IP
For an explanation of \(lqsoft\-fill\(rq, see the $index_format documentation.
.IP
* = can be optionally printed if nonzero
.IP
%m, %n, and %N only work for monitored mailboxes.
%m requires $mail_check_stats to be set.
%n requires $mail_check_stats to be set (except for IMAP mailboxes).


.TP
.B followup_to
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether or not the \(lqMail\-Followup\-To:\(rq header field is
generated when sending mail.  When \fIset\fP, Mutt will generate this
field when you are replying to a known mailing list, specified with
the \(lqsubscribe\(rq or \(lqlists\(rq commands.
.IP
This field has two purposes.  First, preventing you from
receiving duplicate copies of replies to messages which you send
to mailing lists, and second, ensuring that you do get a reply
separately for any messages sent to known lists to which you are
not subscribed.
.IP
The header will contain only the list's address
for subscribed lists, and both the list address and your own
email address for unsubscribed lists.  Without this header, a
group reply to your message sent to a subscribed list will be
sent to both the list and your address, resulting in two copies
of the same email for you.


.TP
.B force_name
.nf
Type: boolean
Default: no
.fi
.IP
This variable is similar to $save_name, except that Mutt will
store a copy of your outgoing message by the username of the address
you are sending to even if that mailbox does not exist.
.IP
Also see the $record variable.


.TP
.B forward_attachments
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
When forwarding inline (i.e. $mime_forward \fIunset\fP or
answered with \(lqno\(rq and $forward_decode \fIset\fP), attachments
which cannot be decoded in a reasonable manner will be attached
to the newly composed message if this quadoption is \fIset\fP or
answered with \(lqyes\(rq.


.TP
.B forward_attribution_intro
.nf
Type: string (localized)
Default: \(lq\-\-\-\-\- Forwarded message from %f \-\-\-\-\-\(rq
.fi
.IP
This is the string that will precede a message which has been forwarded
in the main body of a message (when $mime_forward is unset).
For a full listing of defined \fBprintf(3)\fP\-like sequences see
the section on $index_format.  See also $attribution_locale.


.TP
.B forward_attribution_trailer
.nf
Type: string (localized)
Default: \(lq\-\-\-\-\- End forwarded message \-\-\-\-\-\(rq
.fi
.IP
This is the string that will follow a message which has been forwarded
in the main body of a message (when $mime_forward is unset).
For a full listing of defined \fBprintf(3)\fP\-like sequences see
the section on $index_format.  See also $attribution_locale.


.TP
.B forward_decode
.nf
Type: boolean
Default: yes
.fi
.IP
Controls the decoding of complex MIME messages into \fBtext/plain\fP when
forwarding a message.  The message header is also RFC2047 decoded.
This variable is only used, if $mime_forward is \fIunset\fP,
otherwise $mime_forward_decode is used instead.


.TP
.B forward_decrypt
.nf
Type: quadoption
Default: yes
.fi
.IP
This quadoption controls the handling of encrypted messages when
forwarding or attaching a message.  When set to or answered
\(lqyes\(rq, the outer layer of encryption is stripped off.
.IP
This variable is used if $mime_forward is \fIset\fP and
$mime_forward_decode is \fIunset\fP.  It is also used when
attaching a message via \fB<attach\-message>\fP in the compose
menu.  (PGP only)


.TP
.B forward_edit
.nf
Type: quadoption
Default: yes
.fi
.IP
This quadoption controls whether or not the user is automatically
placed in the editor when forwarding messages.  For those who always want
to forward with no modification, use a setting of \(lqno\(rq.


.TP
.B forward_format
.nf
Type: string
Default: \(lq[%a: %s]\(rq
.fi
.IP
This variable controls the default subject when forwarding a message.
It uses the same format sequences as the $index_format variable.


.TP
.B forward_quote
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, forwarded messages included in the main body of the
message (when $mime_forward is \fIunset\fP) will be quoted using
$indent_string.


.TP
.B from
.nf
Type: e-mail address
Default: \(lq\(rq
.fi
.IP
When \fIset\fP, this variable contains a default from address.  It
can be overridden using \(lqmy_hdr\(rq (including from a \(lqsend-hook\(rq) and
$reverse_name.  This variable is ignored if $use_from is \fIunset\fP.
.IP
This setting defaults to the contents of the environment variable \fB$EMAIL\fP.


.TP
.B gecos_mask
.nf
Type: regular expression
Default: \(lq^[^,]*\(rq
.fi
.IP
A regular expression used by mutt to parse the GECOS field of a password
entry when expanding the alias.  The default value
will return the string up to the first \(lq,\(rq encountered.
If the GECOS field contains a string like \(lqlastname, firstname\(rq then you
should set it to \(lq\fB.*\fP\(rq.
.IP
This can be useful if you see the following behavior: you address an e\-mail
to user ID \(lqstevef\(rq whose full name is \(lqSteve Franklin\(rq.  If mutt expands
\(lqstevef\(rq to \(lq\(rqFranklin\(rq stevef@foo.bar\(rq then you should set the $gecos_mask to
a regular expression that will match the whole name so mutt will expand
\(lqFranklin\(rq to \(lqFranklin, Steve\(rq.


.TP
.B hdrs
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIunset\fP, the header fields normally added by the \(lqmy_hdr\(rq
command are not created.  This variable \fImust\fP be unset before
composing a new message or replying in order to take effect.  If \fIset\fP,
the user defined header fields are added to every new message.


.TP
.B header
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, this variable causes Mutt to include the header
of the message you are replying to into the edit buffer.
The $weed setting applies.


.TP
.B header_cache
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable points to the header cache database.
If pointing to a directory Mutt will contain a header cache
database file per folder, if pointing to a file that file will
be a single global header cache. By default it is \fIunset\fP so no header
caching will be used.  If pointing to a directory, it must be
created in advance.
.IP
Header caching can greatly improve speed when opening POP, IMAP
MH or Maildir folders, see \(lqcaching\(rq for details.


.TP
.B header_cache_compress
.nf
Type: boolean
Default: yes
.fi
.IP
When mutt is compiled with qdbm, tokyocabinet, or kyotocabinet as header
cache backend, this option determines whether the database will be compressed.
Compression results in database files roughly being one fifth
of the usual diskspace, but the decompression can result in a
slower opening of cached folder(s) which in general is still
much faster than opening non header cached folders.


.TP
.B header_cache_pagesize
.nf
Type: number (long)
Default: 16384
.fi
.IP
When mutt is compiled with either gdbm or bdb4 as the header cache backend,
this option changes the database page size.  Too large or too small
values can waste space, memory, or CPU time. The default should be more
or less optimal for most use cases.


.TP
.B header_color_partial
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, color header regexps behave like color body regexps:
color is applied to the exact text matched by the regexp.  When
\fIunset\fP, color is applied to the entire header.
.IP
One use of this option might be to apply color to just the header labels.
.IP
See \(lqcolor\(rq for more details.


.TP
.B help
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, help lines describing the bindings for the major functions
provided by each menu are displayed on the first line of the screen.
.IP
\fBNote:\fP The binding will not be displayed correctly if the
function is bound to a sequence rather than a single keystroke.  Also,
the help line may not be updated if a binding is changed while Mutt is
running.  Since this variable is primarily aimed at new users, neither
of these should present a major problem.


.TP
.B hidden_host
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will skip the host name part of $hostname variable
when adding the domain part to addresses.  This variable does not
affect the generation of Message\-IDs, and it will not lead to the
cut\-off of first\-level domains.


.TP
.B hide_limited
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will not show the presence of messages that are hidden
by limiting, in the thread tree.


.TP
.B hide_missing
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will not show the presence of missing messages in the
thread tree.


.TP
.B hide_thread_subject
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will not show the subject of messages in the thread
tree that have the same subject as their parent or closest previously
displayed sibling.


.TP
.B hide_top_limited
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will not show the presence of messages that are hidden
by limiting, at the top of threads in the thread tree.  Note that when
$hide_limited is \fIset\fP, this option will have no effect.


.TP
.B hide_top_missing
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will not show the presence of missing messages at the
top of threads in the thread tree.  Note that when $hide_missing is
\fIset\fP, this option will have no effect.


.TP
.B history
.nf
Type: number
Default: 10
.fi
.IP
This variable controls the size (in number of strings remembered) of
the string history buffer per category. The buffer is cleared each time the
variable is set.


.TP
.B history_file
.nf
Type: path
Default: \(lq~/.mutthistory\(rq
.fi
.IP
The file in which Mutt will save its history.
.IP
Also see $save_history.


.TP
.B history_remove_dups
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, all of the string history will be scanned for duplicates
when a new entry is added.  Duplicate entries in the $history_file will
also be removed when it is periodically compacted.


.TP
.B honor_disposition
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, Mutt will not display attachments with a
disposition of \(lqattachment\(rq inline even if it could
render the part to plain text. These MIME parts can only
be viewed from the attachment menu.
.IP
If \fIunset\fP, Mutt will render all MIME parts it can
properly transform to plain text.


.TP
.B honor_followup_to
.nf
Type: quadoption
Default: yes
.fi
.IP
This variable controls whether or not a Mail\-Followup\-To header is
honored when group\-replying to a message.


.TP
.B hostname
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Specifies the fully\-qualified hostname of the system mutt is running on
containing the host's name and the DNS domain it belongs to. It is used
as the domain part (after \(lq@\(rq) for local email addresses as well as
Message\-Id headers.
.IP
Its value is determined at startup as follows: the node's
hostname is first determined by the \fBuname(3)\fP function.  The
domain is then looked up using the \fBgethostname(2)\fP and
\fBgetaddrinfo(3)\fP functions.  If those calls are unable to
determine the domain, the full value returned by uname is used.
Optionally, Mutt can be compiled with a fixed domain name in
which case a detected one is not used.
.IP
Starting in Mutt 2.0, the operations described in the previous
paragraph are performed after the muttrc is processed, instead of
beforehand.  This way, if the DNS operations are creating delays
at startup, you can avoid those by manually setting the value in
your muttrc.
.IP
Also see $use_domain and $hidden_host.


.TP
.B idn_decode
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will show you international domain names decoded.
Note: You can use IDNs for addresses even if this is \fIunset\fP.
This variable only affects decoding. (IDN only)


.TP
.B idn_encode
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will encode international domain names using
IDN.  Unset this if your SMTP server can handle newer (RFC 6531)
UTF\-8 encoded domains. (IDN only)


.TP
.B ignore_linear_white_space
.nf
Type: boolean
Default: no
.fi
.IP
This option replaces linear\-white\-space between encoded\-word
and text to a single space to prevent the display of MIME\-encoded
\(lqSubject:\(rq field from being divided into multiple lines.


.TP
.B ignore_list_reply_to
.nf
Type: boolean
Default: no
.fi
.IP
Affects the behavior of the \fB<reply>\fP function when replying to
messages from mailing lists (as defined by the \(lqsubscribe\(rq or
\(lqlists\(rq commands).  When \fIset\fP, if the \(lqReply\-To:\(rq field is
set to the same value as the \(lqTo:\(rq field, Mutt assumes that the
\(lqReply\-To:\(rq field was set by the mailing list to automate responses
to the list, and will ignore this field.  To direct a response to the
mailing list when this option is \fIset\fP, use the \fB<list-reply>\fP
function; \fB<group\-reply>\fP will reply to both the sender and the
list.


.TP
.B imap_authenticators
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is a colon\-delimited list of authentication methods mutt may
attempt to use to log in to an IMAP server, in the order mutt should
try them.  Authentication methods are either \(lqlogin\(rq or the right
side of an IMAP \(lqAUTH=xxx\(rq capability string, e.g. \(lqdigest\-md5\(rq, \(lqgssapi\(rq
or \(lqcram\-md5\(rq. This option is case\-insensitive. If it's
\fIunset\fP (the default) mutt will try all available methods,
in order from most\-secure to least\-secure.
.IP
Example:

.IP
.EX
set imap_authenticators=\(rqgssapi:cram\-md5:login\(rq

.EE
.IP
\fBNote:\fP Mutt will only fall back to other authentication methods if
the previous methods are unavailable. If a method is available but
authentication fails, mutt will not connect to the IMAP server.


.TP
.B imap_check_subscribed
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will fetch the set of subscribed folders from
your server on connection, and add them to the set of mailboxes
it polls for new mail just as if you had issued individual \(lqmailboxes\(rq
commands.


.TP
.B imap_condstore
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will use the CONDSTORE extension (RFC 7162)
if advertised by the server.  Mutt's current implementation is basic,
used only for initial message fetching and flag updates.
.IP
For some IMAP servers, enabling this will slightly speed up
downloading initial messages.  Unfortunately, Gmail is not one
those, and displays worse performance when enabled.  Your
mileage may vary.


.TP
.B imap_deflate
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will use the COMPRESS=DEFLATE extension (RFC
4978) if advertised by the server.
.IP
In general a good compression efficiency can be achieved, which
speeds up reading large mailboxes also on fairly good connections.


.TP
.B imap_delim_chars
.nf
Type: string
Default: \(lq/.\(rq
.fi
.IP
This contains the list of characters which you would like to treat
as folder separators for displaying IMAP paths. In particular it
helps in using the \(lq=\(rq shortcut for your \fIfolder\fP variable.


.TP
.B imap_fetch_chunk_size
.nf
Type: number (long)
Default: 0
.fi
.IP
When set to a value greater than 0, new headers will be
downloaded in groups of this many headers per request.  If you
have a very large mailbox, this might prevent a timeout and
disconnect when opening the mailbox, by sending a FETCH per set
of this many headers, instead of a single FETCH for all new
headers.


.TP
.B imap_headers
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Mutt requests these header fields in addition to the default headers
(\(lqDate:\(rq, \(lqFrom:\(rq, \(lqSender:\(rq, \(lqSubject:\(rq, \(lqTo:\(rq, \(lqCc:\(rq, \(lqMessage\-Id:\(rq,
\(lqReferences:\(rq, \(lqContent\-Type:\(rq, \(lqContent\-Description:\(rq, \(lqIn\-Reply\-To:\(rq,
\(lqReply\-To:\(rq, \(lqLines:\(rq, \(lqList\-Post:\(rq, \(lqX\-Label:\(rq) from IMAP
servers before displaying the index menu. You may want to add more
headers for spam detection.
.IP
\fBNote:\fP This is a space separated list, items should be uppercase
and not contain the colon, e.g. \(lqX\-BOGOSITY X\-SPAM\-STATUS\(rq for the
\(lqX\-Bogosity:\(rq and \(lqX\-Spam\-Status:\(rq header fields.


.TP
.B imap_idle
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will attempt to use the IMAP IDLE extension
to check for new mail in the current mailbox. Some servers
(dovecot was the inspiration for this option) react badly
to mutt's implementation. If your connection seems to freeze
up periodically, try unsetting this.


.TP
.B imap_keepalive
.nf
Type: number
Default: 300
.fi
.IP
This variable specifies the maximum amount of time in seconds that mutt
will wait before polling open IMAP connections, to prevent the server
from closing them before mutt has finished with them. The default is
well within the RFC\-specified minimum amount of time (30 minutes) before
a server is allowed to do this, but in practice the RFC does get
violated every now and then. Reduce this number if you find yourself
getting disconnected from your IMAP server due to inactivity.


.TP
.B imap_list_subscribed
.nf
Type: boolean
Default: no
.fi
.IP
This variable configures whether IMAP folder browsing will look for
only subscribed folders or all folders.  This can be toggled in the
IMAP browser with the \fB<toggle\-subscribed>\fP function.


.TP
.B imap_login
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Your login name on the IMAP server.
.IP
This variable defaults to the value of $imap_user.


.TP
.B imap_oauth_refresh_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
The command to run to generate an OAUTH refresh token for
authorizing your connection to your IMAP server.  This command will be
run on every connection attempt that uses the OAUTHBEARER authentication
mechanism.  See \(lqoauth\(rq for details.


.TP
.B imap_pass
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Specifies the password for your IMAP account.  If \fIunset\fP, Mutt will
prompt you for your password when you invoke the \fB<imap\-fetch\-mail>\fP function
or try to open an IMAP folder.
.IP
\fBWarning\fP: you should only use this option when you are on a
fairly secure machine, because the superuser can read your muttrc even
if you are the only one who can read the file.


.TP
.B imap_passive
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will not open new IMAP connections to check for new
mail.  Mutt will only check for new mail over existing IMAP
connections.  This is useful if you don't want to be prompted for
user/password pairs on mutt invocation, or if opening the connection
is slow.


.TP
.B imap_peek
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will avoid implicitly marking your mail as read whenever
you fetch a message from the server. This is generally a good thing,
but can make closing an IMAP folder somewhat slower. This option
exists to appease speed freaks.


.TP
.B imap_pipeline_depth
.nf
Type: number
Default: 15
.fi
.IP
Controls the number of IMAP commands that may be queued up before they
are sent to the server. A deeper pipeline reduces the amount of time
mutt must wait for the server, and can make IMAP servers feel much
more responsive. But not all servers correctly handle pipelined commands,
so if you have problems you might want to try setting this variable to 0.
.IP
\fBNote:\fP Changes to this variable have no effect on open connections.


.TP
.B imap_poll_timeout
.nf
Type: number
Default: 15
.fi
.IP
This variable specifies the maximum amount of time in seconds
that mutt will wait for a response when polling IMAP connections
for new mail, before timing out and closing the connection.  Set
to 0 to disable timing out.


.TP
.B imap_qresync
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will use the QRESYNC extension (RFC 7162)
if advertised by the server.  Mutt's current implementation is basic,
used only for initial message fetching and flag updates.
.IP
Note: this feature is currently experimental.  If you experience
strange behavior, such as duplicate or missing messages please
file a bug report to let us know.


.TP
.B imap_servernoise
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will display warning messages from the IMAP
server as error messages. Since these messages are often
harmless, or generated due to configuration problems on the
server which are out of the users' hands, you may wish to suppress
them at some point.


.TP
.B imap_user
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
The name of the user whose mail you intend to access on the IMAP
server.
.IP
This variable defaults to your user name on the local machine.


.TP
.B implicit_autoview
.nf
Type: boolean
Default: no
.fi
.IP
If set to \(lqyes\(rq, mutt will look for a mailcap entry with the
\(lq\fBcopiousoutput\fP\(rq flag set for \fIevery\fP MIME attachment it doesn't have
an internal viewer defined for.  If such an entry is found, mutt will
use the viewer defined in that entry to convert the body part to text
form.


.TP
.B include
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
Controls whether or not a copy of the message(s) you are replying to
is included in your reply.


.TP
.B include_encrypted
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether or not Mutt includes separately encrypted attachment
contents when replying.
.IP
This variable was added to prevent accidental exposure of encrypted
contents when replying to an attacker.  If a previously encrypted message
were attached by the attacker, they could trick an unwary recipient into
decrypting and including the message in their reply.


.TP
.B include_onlyfirst
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether or not Mutt includes only the first attachment
of the message you are replying.


.TP
.B indent_string
.nf
Type: string
Default: \(lq> \(rq
.fi
.IP
Specifies the string to prepend to each line of text quoted in a
message to which you are replying.  You are strongly encouraged not to
change this value, as it tends to agitate the more fanatical netizens.
.IP
The value of this option is ignored if $text_flowed is set, because
the quoting mechanism is strictly defined for format=flowed.
.IP
This option is a format string, please see the description of
$index_format for supported \fBprintf(3)\fP\-style sequences.


.TP
.B index_format
.nf
Type: string
Default: \(lq%4C %Z %{%b %d} %\-15.15L (%?l?%4l&%4c?) %s\(rq
.fi
.IP
This variable allows you to customize the message index display to
your personal taste.
.IP
\(lqFormat strings\(rq are similar to the strings used in the C
function \fBprintf(3)\fP to format output (see the man page for more details).
For an explanation of the %? construct, see the $status_format description.
The following sequences are defined in Mutt:
.RS
.PD 0
.TP
%a 
address of the author
.TP
%A 
reply\-to address (if present; otherwise: address of author)
.TP
%b 
filename of the original message folder (think mailbox)
.TP
%B 
the list to which the letter was sent, or else the folder name (%b).
.TP
%c 
number of characters (bytes) in the message (see formatstrings-size)
.TP
%C 
current message number
.TP
%d 
date and time of the message in the format specified by
$date_format converted to sender's time zone
.TP
%D 
date and time of the message in the format specified by
$date_format converted to the local time zone
.TP
%e 
current message number in thread
.TP
%E 
number of messages in current thread
.TP
%f 
sender (address + real name), either From: or Return\-Path:
.TP
%F 
author name, or recipient name if the message is from you
.TP
%H 
spam attribute(s) of this message
.TP
%i 
message\-id of the current message
.TP
%l 
number of lines in the unprocessed message (may not work with
maildir, mh, and IMAP folders)
.TP
%L 
If an address in the \(lqTo:\(rq or \(lqCc:\(rq header field matches an address
defined by the users \(lqsubscribe\(rq command, this displays
\(rqTo <list\-name>\(rq, otherwise the same as %F.
.TP
%m 
total number of message in the mailbox
.TP
%M 
number of hidden messages if the thread is collapsed.
.TP
%N 
message score
.TP
%n 
author's real name (or address if missing)
.TP
%O 
original save folder where mutt would formerly have
stashed the message: list name or recipient name
if not sent to a list
.TP
%P 
progress indicator for the built\-in pager (how much of the file has been displayed)
.TP
%r 
comma separated list of \(lqTo:\(rq recipients
.TP
%R 
comma separated list of \(lqCc:\(rq recipients
.TP
%s 
subject of the message
.TP
%S 
single character status of the message (\(lqN\(rq/\(lqO\(rq/\(lqD\(rq/\(lqd\(rq/\(lq!\(rq/\(lqr\(rq/\(lq*\(rq)
.TP
%t 
\(lqTo:\(rq field (recipients)
.TP
%T 
the appropriate character from the $to_chars string
.TP
%u 
user (login) name of the author
.TP
%v 
first name of the author, or the recipient if the message is from you
.TP
%X 
number of attachments
(please see the \(lqattachments\(rq section for possible speed effects)
.TP
%y 
\(lqX\-Label:\(rq field, if present
.TP
%Y 
\(lqX\-Label:\(rq field, if present, and \fI(1)\fP not at part of a thread tree,
\fI(2)\fP at the top of a thread, or \fI(3)\fP \(lqX\-Label:\(rq is different from
preceding message's \(lqX\-Label:\(rq.
.TP
%Z 
a three character set of message status flags.
the first character is new/read/replied flags (\(lqn\(rq/\(lqo\(rq/\(lqr\(rq/\(lqO\(rq/\(lqN\(rq).
the second is deleted or encryption flags (\(lqD\(rq/\(lqd\(rq/\(lqS\(rq/\(lqP\(rq/\(lqs\(rq/\(lqK\(rq).
the third is either tagged/flagged (\(lq*\(rq/\(lq!\(rq), or one of the characters
listed in $to_chars.
.TP
%@name@ 
insert and evaluate format\-string from the matching
\(lqindex-format-hook\(rq command
.TP
%{fmt} 
the date and time of the message is converted to sender's
time zone, and \(lqfmt\(rq is expanded by the library function
\fBstrftime(3)\fP; a leading bang disables locales
.TP
%[fmt] 
the date and time of the message is converted to the local
time zone, and \(lqfmt\(rq is expanded by the library function
\fBstrftime(3)\fP; a leading bang disables locales
.TP
%(fmt) 
the local date and time when the message was received.
\(lqfmt\(rq is expanded by the library function \fBstrftime(3)\fP;
a leading bang disables locales
.TP
%<fmt> 
the current local time. \(lqfmt\(rq is expanded by the library
function \fBstrftime(3)\fP; a leading bang disables locales.
.TP
%>X    
right justify the rest of the string and pad with character \(lqX\(rq
.TP
%|X    
pad to the end of the line with character \(lqX\(rq
.TP
%*X    
soft\-fill with character \(lqX\(rq as pad
.RE
.PD 1
.IP
Note that for mbox/mmdf, \(lq%l\(rq applies to the unprocessed message, and
for maildir/mh, the value comes from the \(lqLines:\(rq header field when
present (the meaning is normally the same). Thus the value depends on
the encodings used in the different parts of the message and has little
meaning in practice.
.IP
\(lqSoft\-fill\(rq deserves some explanation: Normal right\-justification
will print everything to the left of the \(lq%>\(rq, displaying padding and
whatever lies to the right only if there's room. By contrast,
soft\-fill gives priority to the right\-hand side, guaranteeing space
to display it and showing padding only if there's still room. If
necessary, soft\-fill will eat text leftwards to make room for
rightward text.
.IP
Note that these expandos are supported in
\(lqsave-hook\(rq, \(lqfcc-hook\(rq, \(lqfcc-save-hook\(rq, and
\(lqindex-format-hook\(rq.
.IP
They are also supported in the configuration variables $attribution,
$forward_attribution_intro, $forward_attribution_trailer,
$forward_format, $indent_string, $message_format, $pager_format,
and $post_indent_string.


.TP
.B ispell
.nf
Type: path
Default: \(lq/usr/bin/ispell\(rq
.fi
.IP
How to invoke ispell (GNU's spell\-checking software).


.TP
.B keep_flagged
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, read messages marked as flagged will not be moved
from your spool mailbox to your $mbox mailbox, or as a result of
a \(lqmbox-hook\(rq command.


.TP
.B local_date_header
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, the date in the Date header of emails that you send will be in
your local timezone. If unset a UTC date will be used instead to avoid
leaking information about your current location.


.TP
.B mail_check
.nf
Type: number
Default: 5
.fi
.IP
This variable configures how often (in seconds) mutt should look for
new mail. Also see the $timeout variable.


.TP
.B mail_check_recent
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will only notify you about new mail that has been received
since the last time you opened the mailbox.  When \fIunset\fP, Mutt will notify you
if any new mail exists in the mailbox, regardless of whether you have visited it
recently.


.TP
.B mail_check_stats
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will periodically calculate message
statistics of a mailbox while polling for new mail.  It will
check for unread, flagged, and total message counts.
(Note: IMAP mailboxes only support unread and total counts).
.IP
Because this operation is more performance intensive, it defaults
to \fIunset\fP, and has a separate option,
$mail_check_stats_interval, to control how often to update these
counts.
.IP
Message statistics can also be explicitly calculated by invoking the
\fB<check\-stats>\fP
function.


.TP
.B mail_check_stats_interval
.nf
Type: number
Default: 60
.fi
.IP
When $mail_check_stats is \fIset\fP, this variable configures
how often (in seconds) mutt will update message counts.


.TP
.B mailcap_path
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable specifies which files to consult when attempting to
display MIME bodies not directly supported by Mutt.  The default value
is generated during startup: see the \(lqmailcap\(rq section of the manual.


.TP
.B mailcap_sanitize
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, mutt will restrict possible characters in mailcap % expandos
to a well\-defined set of safe characters.  This is the safe setting,
but we are not sure it doesn't break some more advanced MIME stuff.
.IP
\fBDON'T CHANGE THIS SETTING UNLESS YOU ARE REALLY SURE WHAT YOU ARE
DOING!\fP


.TP
.B maildir_header_cache_verify
.nf
Type: boolean
Default: yes
.fi
.IP
Check for Maildir unaware programs other than mutt having modified maildir
files when the header cache is in use.  This incurs one \fBstat(2)\fP per
message every time the folder is opened (which can be very slow for NFS
folders).


.TP
.B maildir_trash
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, messages marked as deleted will be saved with the maildir
trashed flag instead of unlinked.  \fBNote:\fP this only applies
to maildir\-style mailboxes.  Setting it will have no effect on other
mailbox types.


.TP
.B maildir_check_cur
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, mutt will poll both the new and cur directories of
a maildir folder for new messages.  This might be useful if other
programs interacting with the folder (e.g. dovecot) are moving new
messages to the cur directory.  Note that setting this option may
slow down polling for new messages in large folders, since mutt has
to scan all cur messages.


.TP
.B mark_macro_prefix
.nf
Type: string
Default: \(lq'\(rq
.fi
.IP
Prefix for macros created using mark\-message.  A new macro
automatically generated with \fI<mark\-message>a\fP will be composed
from this prefix and the letter \fIa\fP.


.TP
.B mark_old
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether or not mutt marks \fInew\fP \fBunread\fP
messages as \fIold\fP if you exit a mailbox without reading them.
With this option \fIset\fP, the next time you start mutt, the messages
will show up with an \(lqO\(rq next to them in the index menu,
indicating that they are old.


.TP
.B markers
.nf
Type: boolean
Default: yes
.fi
.IP
Controls the display of wrapped lines in the internal pager. If set, a
\(lq+\(rq marker is displayed at the beginning of wrapped lines.
.IP
Also see the $smart_wrap variable.


.TP
.B mask
.nf
Type: regular expression
Default: \(lq!^\\.[^.]\(rq
.fi
.IP
A regular expression used in the file browser, optionally preceded by
the \fInot\fP operator \(lq!\(rq.  Only files whose names match this mask
will be shown. The match is always case\-sensitive.


.TP
.B mbox
.nf
Type: path
Default: \(lq~/mbox\(rq
.fi
.IP
This specifies the folder into which read mail in your $spoolfile
folder will be appended.
.IP
Also see the $move variable.


.TP
.B mbox_type
.nf
Type: folder magic
Default: mbox
.fi
.IP
The default mailbox type used when creating new folders. May be any of
\(lqmbox\(rq, \(lqMMDF\(rq, \(lqMH\(rq and \(lqMaildir\(rq. This is overridden by the
\fB\-m\fP command\-line option.


.TP
.B menu_context
.nf
Type: number
Default: 0
.fi
.IP
This variable controls the number of lines of context that are given
when scrolling through menus. (Similar to $pager_context.)


.TP
.B menu_move_off
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIunset\fP, the bottom entry of menus will never scroll up past
the bottom of the screen, unless there are less entries than lines.
When \fIset\fP, the bottom entry may move off the bottom.


.TP
.B menu_scroll
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, menus will be scrolled up or down one line when you
attempt to move across a screen boundary.  If \fIunset\fP, the screen
is cleared and the next or previous page of the menu is displayed
(useful for slow links to avoid many redraws).


.TP
.B message_cache_clean
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, mutt will clean out obsolete entries from the message cache when
the mailbox is synchronized. You probably only want to set it
every once in a while, since it can be a little slow
(especially for large folders).


.TP
.B message_cachedir
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Set this to a directory and mutt will cache copies of messages from
your IMAP and POP servers here. You are free to remove entries at any
time.
.IP
When setting this variable to a directory, mutt needs to fetch every
remote message only once and can perform regular expression searches
as fast as for local folders.
.IP
Also see the $message_cache_clean variable.


.TP
.B message_format
.nf
Type: string
Default: \(lq%s\(rq
.fi
.IP
This is the string displayed in the \(lqattachment\(rq menu for
attachments of type \fBmessage/rfc822\fP.  For a full listing of defined
\fBprintf(3)\fP\-like sequences see the section on $index_format.


.TP
.B message_id_format
.nf
Type: string
Default: \(lq<%z@%f>\(rq
.fi
.IP
This variable describes the format of the Message\-ID generated
when sending messages.  Mutt 2.0 introduced a more compact
format, but this variable allows the ability to choose your own
format.  The value may end in \(lq|\(rq to invoke an external filter.
See formatstrings-filters.
.IP
Please note that the Message\-ID value follows a strict syntax,
and you are responsible for ensuring correctness if you change
this from the default.  In particular, the value must follow the
syntax in RFC 5322: \(lq\fB\(rq<\(rq id\-left \(rq@\(rq id\-right \(rq>\(rq\fP\(rq.  No
spaces are allowed, and \fBid\-left\fP should follow the
dot\-atom\-text syntax in the RFC.  The \fBid\-right\fP should
generally be left at %f.
.IP
The old Message\-ID format can be used by setting this to:
\(lq\fB<%Y%02m%02d%02H%02M%02S.G%c%p@%f>\fP\(rq
.IP
The following \fBprintf(3)\fP\-style sequences are understood:
.RS
.PD 0
.TP
%c 
step counter looping from \(lqA\(rq to \(lqZ\(rq
.TP
%d 
current day of the month (GMT)
.TP
%f 
$hostname
.TP
%H 
current hour using a 24\-hour clock (GMT)
.TP
%m 
current month number (GMT)
.TP
%M 
current minute of the hour (GMT)
.TP
%p 
pid of the running mutt process
.TP
%r 
3 bytes of pseudorandom data encoded in Base64
.TP
%S 
current second of the minute (GMT)
.TP
%x 
1 byte of pseudorandom data hex encoded (example: '1b')
.TP
%Y 
current year using 4 digits (GMT)
.TP
%z 
4 byte timestamp + 8 bytes of pseudorandom data encoded in Base64
.RE
.PD 1

.TP
.B meta_key
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, forces Mutt to interpret keystrokes with the high bit (bit 8)
set as if the user had pressed the Esc key and whatever key remains
after having the high bit removed.  For example, if the key pressed
has an ASCII value of \fB0xf8\fP, then this is treated as if the user had
pressed Esc then \(lqx\(rq.  This is because the result of removing the
high bit from \fB0xf8\fP is \fB0x78\fP, which is the ASCII character
\(lqx\(rq.


.TP
.B metoo
.nf
Type: boolean
Default: no
.fi
.IP
If \fIunset\fP, Mutt will remove your address (see the \(lqalternates\(rq
command) from the list of recipients when replying to a message.


.TP
.B mh_purge
.nf
Type: boolean
Default: no
.fi
.IP
When \fIunset\fP, mutt will mimic mh's behavior and rename deleted messages
to \fI,<old file name>\fP in mh folders instead of really deleting
them. This leaves the message on disk but makes programs reading the folder
ignore it. If the variable is \fIset\fP, the message files will simply be
deleted.
.IP
This option is similar to $maildir_trash for Maildir folders.


.TP
.B mh_seq_flagged
.nf
Type: string
Default: \(lqflagged\(rq
.fi
.IP
The name of the MH sequence used for flagged messages.


.TP
.B mh_seq_replied
.nf
Type: string
Default: \(lqreplied\(rq
.fi
.IP
The name of the MH sequence used to tag replied messages.


.TP
.B mh_seq_unseen
.nf
Type: string
Default: \(lqunseen\(rq
.fi
.IP
The name of the MH sequence used for unseen messages.


.TP
.B mime_forward
.nf
Type: quadoption
Default: no
.fi
.IP
When \fIset\fP, the message you are forwarding will be attached as a
separate \fBmessage/rfc822\fP MIME part instead of included in the main body of the
message.  This is useful for forwarding MIME messages so the receiver
can properly view the message as it was delivered to you. If you like
to switch between MIME and not MIME from mail to mail, set this
variable to \(lqask\-no\(rq or \(lqask\-yes\(rq.
.IP
Also see $forward_decode and $mime_forward_decode.


.TP
.B mime_forward_decode
.nf
Type: boolean
Default: no
.fi
.IP
Controls the decoding of complex MIME messages into \fBtext/plain\fP when
forwarding a message while $mime_forward is \fIset\fP. Otherwise
$forward_decode is used instead.


.TP
.B mime_forward_rest
.nf
Type: quadoption
Default: yes
.fi
.IP
When forwarding multiple attachments of a MIME message from the attachment
menu, attachments which cannot be decoded in a reasonable manner will
be attached to the newly composed message if this option is \fIset\fP.


.TP
.B mime_type_query_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This specifies a command to run, to determine the mime type of a
new attachment when composing a message.  Unless
$mime_type_query_first is set, this will only be run if the
attachment's extension is not found in the mime.types file.
.IP
The string may contain a \(lq%s\(rq, which will be substituted with the
attachment filename.  Mutt will add quotes around the string substituted
for \(lq%s\(rq automatically according to shell quoting rules, so you should
avoid adding your own.  If no \(lq%s\(rq is found in the string, Mutt will
append the attachment filename to the end of the string.
.IP
The command should output a single line containing the
attachment's mime type.
.IP
Suggested values are \(lqxdg\-mime query filetype\(rq or
\(lqfile \-bi\(rq.


.TP
.B mime_type_query_first
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, the $mime_type_query_command will be run before the
mime.types lookup.


.TP
.B mix_entry_format
.nf
Type: string
Default: \(lq%4n %c %\-16s %a\(rq
.fi
.IP
This variable describes the format of a remailer line on the mixmaster
chain selection screen.  The following \fBprintf(3)\fP\-like sequences are
supported:
.RS
.PD 0
.TP
%n 
The running number on the menu.
.TP
%c 
Remailer capabilities.
.TP
%s 
The remailer's short name.
.TP
%a 
The remailer's e\-mail address.
.RE
.PD 1
.IP
(Mixmaster only)


.TP
.B mixmaster
.nf
Type: path
Default: \(lqmixmaster\(rq
.fi
.IP
This variable contains the path to the Mixmaster binary on your
system.  It is used with various sets of parameters to gather the
list of known remailers, and to finally send a message through the
mixmaster chain. (Mixmaster only)


.TP
.B move
.nf
Type: quadoption
Default: no
.fi
.IP
Controls whether or not Mutt will move read messages
from your spool mailbox to your $mbox mailbox, or as a result of
a \(lqmbox-hook\(rq command.


.TP
.B muttlisp_inline_eval
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, Mutt will evaluate bare parenthesis arguments to commands
as MuttLisp expressions.


.TP
.B narrow_tree
.nf
Type: boolean
Default: no
.fi
.IP
This variable, when \fIset\fP, makes the thread tree narrower, allowing
deeper threads to fit on the screen.


.TP
.B net_inc
.nf
Type: number
Default: 10
.fi
.IP
Operations that expect to transfer a large amount of data over the
network will update their progress every $net_inc kilobytes.
If set to 0, no progress messages will be displayed.
.IP
See also $read_inc, $write_inc and $net_inc.


.TP
.B new_mail_command
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
If \fIset\fP, Mutt will call this command after a new message is received.
See the $status_format documentation for the values that can be formatted
into this command.


.TP
.B pager
.nf
Type: path
Default: \(lqbuiltin\(rq
.fi
.IP
This variable specifies which pager you would like to use to view
messages. The value \(lqbuiltin\(rq means to use the built\-in pager, otherwise this
variable should specify the pathname of the external pager you would
like to use.
.IP
The string may contain a \(lq%s\(rq, which will be substituted with
the generated message filename.  Mutt will add quotes around the
string substituted for \(lq%s\(rq automatically according to shell
quoting rules, so you should avoid adding your own.  If no \(lq%s\(rq
is found in the string, Mutt will append the message filename to
the end of the string.
.IP
Using an external pager may have some disadvantages: Additional
keystrokes are necessary because you can't call mutt functions
directly from the pager, and screen resizes cause lines longer than
the screen width to be badly formatted in the help menu.
.IP
When using an external pager, also see $prompt_after which defaults
\fIset\fP.


.TP
.B pager_context
.nf
Type: number
Default: 0
.fi
.IP
This variable controls the number of lines of context that are given
when displaying the next or previous page in the internal pager.  By
default, Mutt will display the line after the last one on the screen
at the top of the next page (0 lines of context).
.IP
This variable also specifies the amount of context given for search
results. If positive, this many lines will be given before a match,
if 0, the match will be top\-aligned.


.TP
.B pager_format
.nf
Type: string
Default: \(lq\-%Z\- %C/%m: %\-20.20n   %s%*  \-\- (%P)\(rq
.fi
.IP
This variable controls the format of the one\-line message \(lqstatus\(rq
displayed before each message in either the internal or an external
pager.  The valid sequences are listed in the $index_format
section.


.TP
.B pager_index_lines
.nf
Type: number
Default: 0
.fi
.IP
Determines the number of lines of a mini\-index which is shown when in
the pager.  The current message, unless near the top or bottom of the
folder, will be roughly one third of the way down this mini\-index,
giving the reader the context of a few messages before and after the
message.  This is useful, for example, to determine how many messages
remain to be read in the current thread.  One of the lines is reserved
for the status bar from the index, so a setting of 6
will only show 5 lines of the actual index.  A value of 0 results in
no index being shown.  If the number of messages in the current folder
is less than $pager_index_lines, then the index will only use as
many lines as it needs.


.TP
.B pager_skip_quoted_context
.nf
Type: number
Default: 0
.fi
.IP
Determines the number of lines of context to show before the
unquoted text when using \fB<skip-quoted>\fP. When set to a
positive number at most that many lines of the previous quote are
displayed. If the previous quote is shorter the whole quote is
displayed.


.TP
.B pager_stop
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, the internal\-pager will \fBnot\fP move to the next message
when you are at the end of a message and invoke the \fB<next\-page>\fP
function.


.TP
.B pattern_format
.nf
Type: string
Default: \(lq%2n %\-15e  %d\(rq
.fi
.IP
This variable describes the format of the \(lqpattern completion\(rq menu. The
following \fBprintf(3)\fP\-style sequences are understood:
.RS
.PD 0
.TP
%d  
pattern description
.TP
%e  
pattern expression
.TP
%n  
index number
.RE
.PD 1
.IP


.TP
.B pgp_auto_decode
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, mutt will automatically attempt to decrypt traditional PGP
messages whenever the user performs an operation which ordinarily would
result in the contents of the message being operated on.  For example,
if the user displays a pgp\-traditional message which has not been manually
checked with the \fB<check-traditional-pgp>\fP function, mutt will automatically
check the message for traditional pgp.


.TP
.B pgp_autoinline
.nf
Type: boolean
Default: no
.fi
.IP
This option controls whether Mutt generates old\-style inline
(traditional) PGP encrypted or signed messages under certain
circumstances.  This can be overridden by use of the pgp menu,
when inline is not required.  The GPGME backend does not support
this option.
.IP
Note that Mutt might automatically use PGP/MIME for messages
which consist of more than a single MIME part.  Mutt can be
configured to ask before sending PGP/MIME messages when inline
(traditional) would not work.
.IP
Also see the $pgp_mime_auto variable.
.IP
Also note that using the old\-style PGP message format is \fBstrongly\fP
\fBdeprecated\fP.
(PGP only)


.TP
.B pgp_check_exit
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, mutt will check the exit code of the PGP subprocess when
signing or encrypting.  A non\-zero exit code means that the
subprocess failed.
(PGP only)


.TP
.B pgp_check_gpg_decrypt_status_fd
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, mutt will check the status file descriptor output
of $pgp_decrypt_command and $pgp_decode_command for GnuPG status codes
indicating successful decryption.  This will check for the presence of
DECRYPTION_OKAY, absence of DECRYPTION_FAILED, and that all
PLAINTEXT occurs between the BEGIN_DECRYPTION and END_DECRYPTION
status codes.
.IP
If \fIunset\fP, mutt will instead match the status fd output
against $pgp_decryption_okay.
(PGP only)


.TP
.B pgp_clearsign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This format is used to create an old\-style \(lqclearsigned\(rq PGP
message.  Note that the use of this format is \fBstrongly\fP
\fBdeprecated\fP.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_decode_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This format strings specifies a command which is used to decode
application/pgp attachments.
.IP
The PGP command formats have their own set of \fBprintf(3)\fP\-like sequences:
.RS
.PD 0
.TP
%p 
Expands to PGPPASSFD=0 when a pass phrase is needed, to an empty
string otherwise. Note: This may be used with a %? construct.
.TP
%f 
Expands to the name of a file containing a message.
.TP
%s 
Expands to the name of a file containing the signature part
           of a \fBmultipart/signed\fP attachment when verifying it.
.TP
%a 
The value of $pgp_sign_as if set, otherwise the value
of $pgp_default_key.
.TP
%r 
One or more key IDs (or fingerprints if available).
.RE
.PD 1
.IP
For examples on how to configure these formats for the various versions
of PGP which are floating around, see the pgp and gpg sample configuration files in
the \fBsamples/\fP subdirectory which has been installed on your system
alongside the documentation.
(PGP only)


.TP
.B pgp_decrypt_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to decrypt a PGP encrypted message.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_decryption_okay
.nf
Type: regular expression
Default: \(lq\(rq
.fi
.IP
If you assign text to this variable, then an encrypted PGP
message is only considered successfully decrypted if the output
from $pgp_decrypt_command contains the text.  This is used to
protect against a spoofed encrypted message, with multipart/encrypted
headers but containing a block that is not actually encrypted.
(e.g. simply signed and ascii armored text).
.IP
Note that if $pgp_check_gpg_decrypt_status_fd is set, this variable
is ignored.
(PGP only)


.TP
.B pgp_default_key
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is the default key\-pair to use for PGP operations.  It will be
used for encryption (see $postpone_encrypt and $pgp_self_encrypt).
.IP
It will also be used for signing unless $pgp_sign_as is set.
.IP
The (now deprecated) \fIpgp_self_encrypt_as\fP is an alias for this
variable, and should no longer be used.
(PGP only)


.TP
.B pgp_encrypt_only_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to encrypt a body part without signing it.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_encrypt_sign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to both sign and encrypt a body part.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_entry_format
.nf
Type: string
Default: \(lq%4n %t%f %4l/0x%k %\-4a %2c %u\(rq
.fi
.IP
This variable allows you to customize the PGP key selection menu to
your personal taste. This string is similar to $index_format, but
has its own set of \fBprintf(3)\fP\-like sequences:
.RS
.PD 0
.TP
%n     
number
.TP
%k     
key id
.TP
%u     
user id
.TP
%a     
algorithm
.TP
%l     
key length
.TP
%f     
flags
.TP
%c     
capabilities
.TP
%t     
trust/validity of the key\-uid association
.TP
%[<s>] 
date of the key where <s> is an \fBstrftime(3)\fP expression
.RE
.PD 1
.IP
(PGP only)


.TP
.B pgp_export_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to export a public key from the user's
key ring.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_getkeys_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is invoked whenever Mutt needs to fetch the public key associated with
an email address.  Of the sequences supported by $pgp_decode_command, %r is
the only \fBprintf(3)\fP\-like sequence used with this format.  Note that
in this case, %r expands to the email address, not the public key ID (the key ID is
unknown, which is why Mutt is invoking this command).
(PGP only)


.TP
.B pgp_good_sign
.nf
Type: regular expression
Default: \(lq\(rq
.fi
.IP
If you assign a text to this variable, then a PGP signature is only
considered verified if the output from $pgp_verify_command contains
the text. Use this variable if the exit code from the command is 0
even for bad signatures.
(PGP only)


.TP
.B pgp_ignore_subkeys
.nf
Type: boolean
Default: yes
.fi
.IP
Setting this variable will cause Mutt to ignore OpenPGP subkeys. Instead,
the principal key will inherit the subkeys' capabilities.  \fIUnset\fP this
if you want to play interesting key selection games.
(PGP only)


.TP
.B pgp_import_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to import a key from a message into
the user's public key ring.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_list_pubring_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to list the public key ring's contents.  The
output format must be analogous to the one used by

.IP
.EX
gpg \-\-list\-keys \-\-with\-colons \-\-with\-fingerprint

.EE
.IP
This format is also generated by the \fBmutt_pgpring\fP utility which comes
with mutt.
.IP
Note: gpg's \fBfixed\-list\-mode\fP option should not be used.  It
produces a different date format which may result in mutt showing
incorrect key generation dates.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
Note that in this case, %r expands to the search string, which is a list of
one or more quoted values such as email address, name, or keyid.
(PGP only)


.TP
.B pgp_list_secring_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to list the secret key ring's contents.  The
output format must be analogous to the one used by:

.IP
.EX
gpg \-\-list\-keys \-\-with\-colons \-\-with\-fingerprint

.EE
.IP
This format is also generated by the \fBmutt_pgpring\fP utility which comes
with mutt.
.IP
Note: gpg's \fBfixed\-list\-mode\fP option should not be used.  It
produces a different date format which may result in mutt showing
incorrect key generation dates.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
Note that in this case, %r expands to the search string, which is a list of
one or more quoted values such as email address, name, or keyid.
(PGP only)


.TP
.B pgp_long_ids
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, use 64 bit PGP key IDs, if \fIunset\fP use the normal 32 bit key IDs.
NOTE: Internally, Mutt has transitioned to using fingerprints (or long key IDs
as a fallback).  This option now only controls the display of key IDs
in the key selection menu and a few other places.
(PGP only)


.TP
.B pgp_mime_auto
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
This option controls whether Mutt will prompt you for
automatically sending a (signed/encrypted) message using
PGP/MIME when inline (traditional) fails (for any reason).
.IP
Also note that using the old\-style PGP message format is \fBstrongly\fP
\fBdeprecated\fP.
(PGP only)


.TP
.B pgp_replyinline
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable will cause Mutt to always attempt to
create an inline (traditional) message when replying to a
message which is PGP encrypted/signed inline.  This can be
overridden by use of the pgp menu, when inline is not
required.  This option does not automatically detect if the
(replied\-to) message is inline; instead it relies on Mutt
internals for previously checked/flagged messages.
.IP
Note that Mutt might automatically use PGP/MIME for messages
which consist of more than a single MIME part.  Mutt can be
configured to ask before sending PGP/MIME messages when inline
(traditional) would not work.
.IP
Also see the $pgp_mime_auto variable.
.IP
Also note that using the old\-style PGP message format is \fBstrongly\fP
\fBdeprecated\fP.
(PGP only)


.TP
.B pgp_retainable_sigs
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, signed and encrypted messages will consist of nested
\fBmultipart/signed\fP and \fBmultipart/encrypted\fP body parts.
.IP
This is useful for applications like encrypted and signed mailing
lists, where the outer layer (\fBmultipart/encrypted\fP) can be easily
removed, while the inner \fBmultipart/signed\fP part is retained.
(PGP only)


.TP
.B pgp_self_encrypt
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, PGP encrypted messages will also be encrypted
using the key in $pgp_default_key.
(PGP only)


.TP
.B pgp_show_unusable
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, mutt will display non\-usable keys on the PGP key selection
menu.  This includes keys which have been revoked, have expired, or
have been marked as \(lqdisabled\(rq by the user.
(PGP only)


.TP
.B pgp_sign_as
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
If you have a different key pair to use for signing, you should
set this to the signing key.  Most people will only need to set
$pgp_default_key.  It is recommended that you use the keyid form
to specify your key (e.g. \fB0x00112233\fP).
(PGP only)


.TP
.B pgp_sign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to create the detached PGP signature for a
\fBmultipart/signed\fP PGP/MIME body part.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_sort_keys
.nf
Type: sort order
Default: address
.fi
.IP
Specifies how the entries in the pgp menu are sorted. The
following are legal values:
.RS
.PD 0
.TP
address 
sort alphabetically by user id
.TP
keyid   
sort alphabetically by key id
.TP
date    
sort by key creation date
.TP
trust   
sort by the trust of the key
.RE
.PD 1
.IP
If you prefer reverse order of the above values, prefix it with
\(lqreverse\-\(rq.
(PGP only)


.TP
.B pgp_strict_enc
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, Mutt will automatically encode PGP/MIME signed messages as
quoted\-printable.  Please note that unsetting this variable may
lead to problems with non\-verifyable PGP signatures, so only change
this if you know what you are doing.
(PGP only)


.TP
.B pgp_timeout
.nf
Type: number (long)
Default: 300
.fi
.IP
The number of seconds after which a cached passphrase will expire if
not used.
(PGP only)


.TP
.B pgp_use_gpg_agent
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, mutt expects a \fBgpg\-agent(1)\fP process will handle
private key passphrase prompts.  If \fIunset\fP, mutt will prompt
for the passphrase and pass it via stdin to the pgp command.
.IP
Note that as of version 2.1, GnuPG automatically spawns an agent
and requires the agent be used for passphrase management.  Since
that version is increasingly prevalent, this variable now
defaults \fIset\fP.
.IP
Mutt works with a GUI or curses pinentry program.  A TTY pinentry
should not be used.
.IP
If you are using an older version of GnuPG without an agent running,
or another encryption program without an agent, you will need to
\fIunset\fP this variable.
(PGP only)


.TP
.B pgp_verify_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify PGP signatures.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pgp_verify_key_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify key information from the key selection
menu.
.IP
This is a format string, see the $pgp_decode_command command for
possible \fBprintf(3)\fP\-like sequences.
(PGP only)


.TP
.B pipe_decode
.nf
Type: boolean
Default: no
.fi
.IP
Used in connection with the \fB<pipe\-message>\fP function.  When \fIunset\fP,
Mutt will pipe the messages without any preprocessing. When \fIset\fP, Mutt
will attempt to decode the messages first.
.IP
Also see $pipe_decode_weed, which controls whether headers will
be weeded when this is \fIset\fP.


.TP
.B pipe_decode_weed
.nf
Type: boolean
Default: yes
.fi
.IP
For \fB<pipe\-message>\fP, when $pipe_decode is set, this further
controls whether Mutt will weed headers.


.TP
.B pipe_sep
.nf
Type: string
Default: \(lq\\n\(rq
.fi
.IP
The separator to add between messages when piping a list of tagged
messages to an external Unix command.


.TP
.B pipe_split
.nf
Type: boolean
Default: no
.fi
.IP
Used in connection with the \fB<pipe\-message>\fP function following
\fB<tag\-prefix>\fP.  If this variable is \fIunset\fP, when piping a list of
tagged messages Mutt will concatenate the messages and will pipe them
all concatenated.  When \fIset\fP, Mutt will pipe the messages one by one.
In both cases the messages are piped in the current sorted order,
and the $pipe_sep separator is added after each message.


.TP
.B pop_auth_try_all
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, Mutt will try all available authentication methods.
When \fIunset\fP, Mutt will only fall back to other authentication
methods if the previous methods are unavailable. If a method is
available but authentication fails, Mutt will not connect to the POP server.


.TP
.B pop_authenticators
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is a colon\-delimited list of authentication methods mutt may
attempt to use to log in to an POP server, in the order mutt should
try them.  Authentication methods are either \(lquser\(rq, \(lqapop\(rq or any
SASL mechanism, e.g. \(lqdigest\-md5\(rq, \(lqgssapi\(rq or \(lqcram\-md5\(rq.
This option is case\-insensitive. If this option is \fIunset\fP
(the default) mutt will try all available methods, in order from
most\-secure to least\-secure.
.IP
Example:

.IP
.EX
set pop_authenticators=\(rqdigest\-md5:apop:user\(rq

.EE


.TP
.B pop_checkinterval
.nf
Type: number
Default: 60
.fi
.IP
This variable configures how often (in seconds) mutt should look for
new mail in the currently selected mailbox if it is a POP mailbox.


.TP
.B pop_delete
.nf
Type: quadoption
Default: ask\-no
.fi
.IP
If \fIset\fP, Mutt will delete successfully downloaded messages from the POP
server when using the \fB<fetch-mail>\fP function.  When \fIunset\fP, Mutt will
download messages but also leave them on the POP server.


.TP
.B pop_host
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
The name of your POP server for the \fB<fetch-mail>\fP function.  You
can also specify an alternative port, username and password, i.e.:

.IP
.EX
[pop[s]://][username[:password]@]popserver[:port]

.EE
.IP
where \(lq[...]\(rq denotes an optional part.


.TP
.B pop_last
.nf
Type: boolean
Default: no
.fi
.IP
If this variable is \fIset\fP, mutt will try to use the \(lq\fBLAST\fP\(rq POP command
for retrieving only unread messages from the POP server when using
the \fB<fetch-mail>\fP function.


.TP
.B pop_oauth_refresh_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
The command to run to generate an OAUTH refresh token for
authorizing your connection to your POP server.  This command will be
run on every connection attempt that uses the OAUTHBEARER authentication
mechanism.  See \(lqoauth\(rq for details.


.TP
.B pop_pass
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Specifies the password for your POP account.  If \fIunset\fP, Mutt will
prompt you for your password when you open a POP mailbox.
.IP
\fBWarning\fP: you should only use this option when you are on a
fairly secure machine, because the superuser can read your muttrc
even if you are the only one who can read the file.


.TP
.B pop_reconnect
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
Controls whether or not Mutt will try to reconnect to the POP server if
the connection is lost.


.TP
.B pop_user
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Your login name on the POP server.
.IP
This variable defaults to your user name on the local machine.


.TP
.B post_indent_string
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Similar to the $attribution variable, Mutt will append this
string after the inclusion of a message which is being replied to.
For a full listing of defined \fBprintf(3)\fP\-like sequences see
the section on $index_format.


.TP
.B postpone
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
Controls whether or not messages are saved in the $postponed
mailbox when you elect not to send immediately.
.IP
Also see the $recall variable.


.TP
.B postponed
.nf
Type: path
Default: \(lq~/postponed\(rq
.fi
.IP
Mutt allows you to indefinitely \(lqpostpone sending a message\(rq which
you are editing.  When you choose to postpone a message, Mutt saves it
in the mailbox specified by this variable.
.IP
Also see the $postpone variable.


.TP
.B postpone_encrypt
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, postponed messages that are marked for encryption will be
self\-encrypted.  Mutt will first try to encrypt using the value specified
in $pgp_default_key or $smime_default_key.  If those are not
set, it will try the deprecated $postpone_encrypt_as.
(Crypto only)


.TP
.B postpone_encrypt_as
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is a deprecated fall\-back variable for $postpone_encrypt.
Please use $pgp_default_key or $smime_default_key.
(Crypto only)


.TP
.B preconnect
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
If \fIset\fP, a shell command to be executed if mutt fails to establish
a connection to the server. This is useful for setting up secure
connections, e.g. with \fBssh(1)\fP. If the command returns a  nonzero
status, mutt gives up opening the server. Example:

.IP
.EX
set preconnect=\(rqssh \-f \-q \-L 1234:mailhost.net:143 mailhost.net \\
sleep 20 < /dev/null > /dev/null\(rq

.EE
.IP
Mailbox \(lqfoo\(rq on \(lqmailhost.net\(rq can now be reached
as \(lq{localhost:1234}foo\(rq.
.IP
Note: For this example to work, you must be able to log in to the
remote machine without having to enter a password.


.TP
.B print
.nf
Type: quadoption
Default: ask\-no
.fi
.IP
Controls whether or not Mutt really prints messages.
This is set to \(lqask\-no\(rq by default, because some people
accidentally hit \(lqp\(rq often.


.TP
.B print_command
.nf
Type: path
Default: \(lqlpr\(rq
.fi
.IP
This specifies the command pipe that should be used to print messages.


.TP
.B print_decode
.nf
Type: boolean
Default: yes
.fi
.IP
Used in connection with the \fB<print\-message>\fP function.  If this
option is \fIset\fP, the message is decoded before it is passed to the
external command specified by $print_command.  If this option
is \fIunset\fP, no processing will be applied to the message when
printing it.  The latter setting may be useful if you are using
some advanced printer filter which is able to properly format
e\-mail messages for printing.
.IP
Also see $print_decode_weed, which controls whether headers will
be weeded when this is \fIset\fP.


.TP
.B print_decode_weed
.nf
Type: boolean
Default: yes
.fi
.IP
For \fB<print\-message>\fP, when $print_decode is set, this
further controls whether Mutt will weed headers.


.TP
.B print_split
.nf
Type: boolean
Default: no
.fi
.IP
Used in connection with the \fB<print\-message>\fP function.  If this option
is \fIset\fP, the command specified by $print_command is executed once for
each message which is to be printed.  If this option is \fIunset\fP,
the command specified by $print_command is executed only once, and
all the messages are concatenated, with a form feed as the message
separator.
.IP
Those who use the \fBenscript\fP(1) program's mail\-printing mode will
most likely want to \fIset\fP this option.


.TP
.B prompt_after
.nf
Type: boolean
Default: yes
.fi
.IP
If you use an \fIexternal\fP $pager, setting this variable will
cause Mutt to prompt you for a command when the pager exits rather
than returning to the index menu.  If \fIunset\fP, Mutt will return to the
index menu when the external pager exits.


.TP
.B query_command
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This specifies the command Mutt will use to make external address
queries.  The string may contain a \(lq%s\(rq, which will be substituted
with the query string the user types.  Mutt will add quotes around the
string substituted for \(lq%s\(rq automatically according to shell quoting
rules, so you should avoid adding your own.  If no \(lq%s\(rq is found in
the string, Mutt will append the user's query to the end of the string.
See \(lqquery\(rq for more information.


.TP
.B query_format
.nf
Type: string
Default: \(lq%4c %t %\-25.25a %\-25.25n %?e?(%e)?\(rq
.fi
.IP
This variable describes the format of the \(lqquery\(rq menu. The
following \fBprintf(3)\fP\-style sequences are understood:
.RS
.PD 0
.TP
%a  
destination address
.TP
%c  
current entry number
.TP
%e  
extra information *
.TP
%n  
destination name
.TP
%t  
\(lq*\(rq if current entry is tagged, a space otherwise
.TP
%>X 
right justify the rest of the string and pad with \(lqX\(rq
.TP
%|X 
pad to the end of the line with \(lqX\(rq
.TP
%*X 
soft\-fill with character \(lqX\(rq as pad
.RE
.PD 1
.IP
For an explanation of \(lqsoft\-fill\(rq, see the $index_format documentation.
.IP
* = can be optionally printed if nonzero, see the $status_format documentation.


.TP
.B quit
.nf
Type: quadoption
Default: yes
.fi
.IP
This variable controls whether \(lqquit\(rq and \(lqexit\(rq actually quit
from mutt.  If this option is \fIset\fP, they do quit, if it is \fIunset\fP, they
have no effect, and if it is set to \fIask\-yes\fP or \fIask\-no\fP, you are
prompted for confirmation when you try to quit.


.TP
.B quote_regexp
.nf
Type: regular expression
Default: \(lq^([ \\t]*[|>:}#])+\(rq
.fi
.IP
A regular expression used in the internal pager to determine quoted
sections of text in the body of a message. Quoted text may be filtered
out using the \fB<toggle\-quoted>\fP command, or colored according to the
\(lqcolor quoted\(rq family of directives.
.IP
Higher levels of quoting may be colored differently (\(lqcolor quoted1\(rq,
\(lqcolor quoted2\(rq, etc.). The quoting level is determined by removing
the last character from the matched text and recursively reapplying
the regular expression until it fails to produce a match.
.IP
Match detection may be overridden by the $smileys regular expression.


.TP
.B read_inc
.nf
Type: number
Default: 10
.fi
.IP
If set to a value greater than 0, Mutt will display which message it
is currently on when reading a mailbox or when performing search actions
such as search and limit. The message is printed after
this many messages have been read or searched (e.g., if set to 25, Mutt will
print a message when it is at message 25, and then again when it gets
to message 50).  This variable is meant to indicate progress when
reading or searching large mailboxes which may take some time.
When set to 0, only a single message will appear before the reading
the mailbox.
.IP
Also see the $write_inc, $net_inc and $time_inc variables and the
\(lqtuning\(rq section of the manual for performance considerations.


.TP
.B read_only
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, all folders are opened in read\-only mode.


.TP
.B realname
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This variable specifies what \(lqreal\(rq or \(lqpersonal\(rq name should be used
when sending messages.
.IP
By default, this is the GECOS field from \fB/etc/passwd\fP.  Note that this
variable will \fInot\fP be used when the user has set a real name
in the $from variable.


.TP
.B recall
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
Controls whether or not Mutt recalls postponed messages
when composing a new message.
.IP
Setting this variable to \fIyes\fP is not generally useful, and thus not
recommended.  Note that the \fB<recall\-message>\fP function can be used
to manually recall postponed messages.
.IP
Also see $postponed variable.


.TP
.B record
.nf
Type: path
Default: \(lq~/sent\(rq
.fi
.IP
This specifies the file into which your outgoing messages should be
appended.  (This is meant as the primary method for saving a copy of
your messages, but another way to do this is using the \(lqmy_hdr\(rq
command to create a \(lqBcc:\(rq field with your email address in it.)
.IP
The value of \fI$record\fP is overridden by the $force_name and
$save_name variables, and the \(lqfcc-hook\(rq command.  Also see $copy
and $write_bcc.
.IP
Multiple mailboxes may be specified if $fcc_delimiter is
set to a string delimiter.


.TP
.B reflow_space_quotes
.nf
Type: boolean
Default: yes
.fi
.IP
This option controls how quotes from format=flowed messages are displayed
in the pager and when replying (with $text_flowed \fIunset\fP).
When set, this option adds spaces after each level of quote marks, turning
\(rq>>>foo\(rq into \(rq> > > foo\(rq.
.IP
\fBNote:\fP If $reflow_text is \fIunset\fP, this option has no effect.
Also, this option does not affect replies when $text_flowed is \fIset\fP.


.TP
.B reflow_text
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will reformat paragraphs in text/plain
parts marked format=flowed.  If \fIunset\fP, Mutt will display paragraphs
unaltered from how they appear in the message body.  See RFC3676 for
details on the \fIformat=flowed\fP format.
.IP
Also see $reflow_wrap, and $wrap.


.TP
.B reflow_wrap
.nf
Type: number
Default: 78
.fi
.IP
This variable controls the maximum paragraph width when reformatting text/plain
parts when $reflow_text is \fIset\fP.  When the value is 0, paragraphs will
be wrapped at the terminal's right margin.  A positive value sets the
paragraph width relative to the left margin.  A negative value set the
paragraph width relative to the right margin.
.IP
Also see $wrap.


.TP
.B reply_regexp
.nf
Type: regular expression (localized)
Default: \(lq^(re)(\\[[0\-9]+\\])*:[ \\t]*\(rq
.fi
.IP
A regular expression used to recognize reply messages when
threading and replying. The default value corresponds to the
standard Latin \(rqRe:\(rq prefix.
.IP
This value may have been localized by the translator for your
locale, adding other prefixes that are common in the locale. You
can add your own prefixes by appending inside \fB\(rq^(re)\(rq\fP.  For
example: \fB\(rq^(re|se)\(rq\fP or \fB\(rq^(re|aw|se)\(rq\fP.
.IP
The second parenthesized expression matches zero or more
bracketed numbers following the prefix, such as \fB\(rqRe[1]: \(rq\fP.
The initial \fB\(rq\\\\[\(rq\fP means a literal left\-bracket character.
Note the backslash must be doubled when used inside a double
quoted string in the muttrc.  \fB\(rq[0\-9]+\(rq\fP means one or more
numbers.  \fB\(rq\\\\]\(rq\fP means a literal right\-bracket.  Finally the
whole parenthesized expression has a \fB\(rq*\(rq\fP suffix, meaning it
can occur zero or more times.
.IP
The last part matches a colon followed by an optional space or
tab.  Note \fB\(rq\\t\(rq\fP is converted to a literal tab inside a
double quoted string.  If you use a single quoted string, you
would have to type an actual tab character, and would need to
convert the double\-backslashes to single backslashes.
.IP
Note: the result of this regexp match against the subject is
stored in the header cache.  Mutt isn't smart enough to
invalidate a header cache entry based on changing $reply_regexp,
so if you aren't seeing correct values in the index, try
temporarily turning off the header cache.  If that fixes the
problem, then once the variable is set to your liking, remove
your stale header cache files and turn the header cache back on.


.TP
.B reply_self
.nf
Type: boolean
Default: no
.fi
.IP
If \fIunset\fP and you are replying to a message sent by you, Mutt will
assume that you want to reply to the recipients of that message rather
than to yourself.
.IP
Also see the \(lqalternates\(rq command.


.TP
.B reply_to
.nf
Type: quadoption
Default: ask\-yes
.fi
.IP
If \fIset\fP, when replying to a message, Mutt will use the address listed
in the Reply\-to: header as the recipient of the reply.  If \fIunset\fP,
it will use the address in the From: header field instead.  This
option is useful for reading a mailing list that sets the Reply\-To:
header field to the list address and you want to send a private
message to the author of a message.


.TP
.B resolve
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, the cursor will be automatically advanced to the next
(possibly undeleted) message whenever a command that modifies the
current message is executed.


.TP
.B resume_draft_files
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, draft files (specified by \fB\-H\fP on the command
line) are processed similarly to when resuming a postponed
message.  Recipients are not prompted for; send\-hooks are not
evaluated; no alias expansion takes place; user\-defined headers
and signatures are not added to the message.


.TP
.B resume_edited_draft_files
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, draft files previously edited (via \fB\-E \-H\fP on
the command line) will have $resume_draft_files automatically
set when they are used as a draft file again.
.IP
The first time a draft file is saved, mutt will add a header,
X\-Mutt\-Resume\-Draft to the saved file.  The next time the draft
file is read in, if mutt sees the header, it will set
$resume_draft_files.
.IP
This option is designed to prevent multiple signatures,
user\-defined headers, and other processing effects from being
made multiple times to the draft file.


.TP
.B reverse_alias
.nf
Type: boolean
Default: no
.fi
.IP
This variable controls whether or not Mutt will display the \(lqpersonal\(rq
name from your aliases in the index menu if it finds an alias that
matches the message's sender.  For example, if you have the following
alias:

.IP
.EX
alias juser abd30425@somewhere.net (Joe User)

.EE
.IP
and then you receive mail which contains the following header:

.IP
.EX
From: abd30425@somewhere.net

.EE
.IP
It would be displayed in the index menu as \(lqJoe User\(rq instead of
\(lqabd30425@somewhere.net.\(rq  This is useful when the person's e\-mail
address is not human friendly.


.TP
.B reverse_name
.nf
Type: boolean
Default: no
.fi
.IP
It may sometimes arrive that you receive mail to a certain machine,
move the messages to another machine, and reply to some the messages
from there.  If this variable is \fIset\fP, the default \fIFrom:\fP line of
the reply messages is built using the address where you received the
messages you are replying to \fBif\fP that address matches your
\(lqalternates\(rq.  If the variable is \fIunset\fP, or the address that would be
used doesn't match your \(lqalternates\(rq, the \fIFrom:\fP line will use
your address on the current machine.
.IP
Also see the \(lqalternates\(rq command and $reverse_realname.


.TP
.B reverse_realname
.nf
Type: boolean
Default: yes
.fi
.IP
This variable fine\-tunes the behavior of the $reverse_name feature.
.IP
When it is \fIunset\fP, Mutt will remove the real name part of a
matching address.  This allows the use of the email address
without having to also use what the sender put in the real name
field.
.IP
When it is \fIset\fP, Mutt will use the matching address as\-is.
.IP
In either case, a missing real name will be filled in afterwards
using the value of $realname.


.TP
.B rfc2047_parameters
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is \fIset\fP, Mutt will decode RFC2047\-encoded MIME
parameters. You want to set this variable when mutt suggests you
to save attachments to files named like:

.IP
.EX
=?iso\-8859\-1?Q?file=5F=E4=5F991116=2Ezip?=

.EE
.IP
When this variable is \fIset\fP interactively, the change won't be
active until you change folders.
.IP
Note that this use of RFC2047's encoding is explicitly
prohibited by the standard, but nevertheless encountered in the
wild.
.IP
Also note that setting this parameter will \fInot\fP have the effect
that mutt \fIgenerates\fP this kind of encoding.  Instead, mutt will
unconditionally use the encoding specified in RFC2231.


.TP
.B save_address
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, mutt will take the sender's full address when choosing a
default folder for saving a mail. If $save_name or $force_name
is \fIset\fP too, the selection of the Fcc folder will be changed as well.


.TP
.B save_empty
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIunset\fP, mailboxes which contain no saved messages will be removed
when closed (the exception is $spoolfile which is never removed).
If \fIset\fP, mailboxes are never removed.
.IP
\fBNote:\fP This only applies to mbox and MMDF folders, Mutt does not
delete MH and Maildir directories.


.TP
.B save_history
.nf
Type: number
Default: 0
.fi
.IP
This variable controls the size of the history (per category) saved in the
$history_file file.


.TP
.B save_name
.nf
Type: boolean
Default: no
.fi
.IP
This variable controls how copies of outgoing messages are saved.
When \fIset\fP, a check is made to see if a mailbox specified by the
recipient address exists (this is done by searching for a mailbox in
the $folder directory with the \fIusername\fP part of the
recipient address).  If the mailbox exists, the outgoing message will
be saved to that mailbox, otherwise the message is saved to the
$record mailbox.
.IP
Also see the $force_name variable.


.TP
.B score
.nf
Type: boolean
Default: yes
.fi
.IP
When this variable is \fIunset\fP, scoring is turned off.  This can
be useful to selectively disable scoring for certain folders when the
$score_threshold_delete variable and related are used.


.TP
.B score_threshold_delete
.nf
Type: number
Default: \-1
.fi
.IP
Messages which have been assigned a score equal to or lower than the value
of this variable are automatically marked for deletion by mutt.  Since
mutt scores are always greater than or equal to zero, the default setting
of this variable will never mark a message for deletion.


.TP
.B score_threshold_flag
.nf
Type: number
Default: 9999
.fi
.IP
Messages which have been assigned a score greater than or equal to this
variable's value are automatically marked \(rqflagged\(rq.


.TP
.B score_threshold_read
.nf
Type: number
Default: \-1
.fi
.IP
Messages which have been assigned a score equal to or lower than the value
of this variable are automatically marked as read by mutt.  Since
mutt scores are always greater than or equal to zero, the default setting
of this variable will never mark a message read.


.TP
.B search_context
.nf
Type: number
Default: 0
.fi
.IP
For the pager, this variable specifies the number of lines shown
before search results. By default, search results will be top\-aligned.


.TP
.B send_charset
.nf
Type: string
Default: \(lqus\-ascii:iso\-8859\-1:utf\-8\(rq
.fi
.IP
A colon\-delimited list of character sets for outgoing messages. Mutt will use the
first character set into which the text can be converted exactly.
If your $charset is not \(lqiso\-8859\-1\(rq and recipients may not
understand \(lqUTF\-8\(rq, it is advisable to include in the list an
appropriate widely used standard character set (such as
\(lqiso\-8859\-2\(rq, \(lqkoi8\-r\(rq or \(lqiso\-2022\-jp\(rq) either instead of or after
\(lqiso\-8859\-1\(rq.
.IP
In case the text cannot be converted into one of these exactly,
mutt uses $charset as a fallback.


.TP
.B send_multipart_alternative
.nf
Type: quadoption
Default: no
.fi
.IP
If \fIset\fP, Mutt will generate a multipart/alternative
container and an alternative part using the filter script specified in
$send_multipart_alternative_filter.
See the section \(lqMIME Multipart/Alternative\(rq (alternative-order).
.IP
Note that enabling multipart/alternative is not compatible with inline
PGP encryption.  Mutt will prompt to use PGP/MIME in that case.


.TP
.B send_multipart_alternative_filter
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This specifies a filter script, which will convert the main
(composed) message of the email to an alternative format.  The
message will be piped to the filter's stdin.  The expected output
of the filter is the generated mime type, e.g. text/html,
followed by a blank line, and then the converted content.
See the section \(lqMIME Multipart/Alternative\(rq (alternative-order).


.TP
.B sendmail
.nf
Type: path
Default: \(lq/usr/sbin/sendmail \-oem \-oi\(rq
.fi
.IP
Specifies the program and arguments used to deliver mail sent by Mutt.
Mutt expects that the specified program interprets additional
arguments as recipient addresses.  Mutt appends all recipients after
adding a \fB\-\-\fP delimiter (if not already present).  Additional
flags, such as for $use_8bitmime, $use_envelope_from,
$dsn_notify, or $dsn_return will be added before the delimiter.
.IP
\fBNote:\fP This command is invoked differently from most other
commands in Mutt.  It is tokenized by space, and invoked directly
via \fBexecvp(3)\fP with an array of arguments \- so commands or
arguments with spaces in them are not supported.  The shell is
not used to run the command, so shell quoting is also not
supported.
.IP
\fBSee also:\fP $write_bcc.


.TP
.B sendmail_wait
.nf
Type: number
Default: 0
.fi
.IP
Specifies the number of seconds to wait for the $sendmail process
to finish before giving up and putting delivery in the background.
.IP
Mutt interprets the value of this variable as follows:
.RS
.PD 0
.TP
>0 
number of seconds to wait for sendmail to finish before continuing
.TP
0  
wait forever for sendmail to finish
.TP
<0 
always put sendmail in the background without waiting
.RE
.PD 1
.IP
Note that if you specify a value other than 0, the output of the child
process will be put in a temporary file.  If there is some error, you
will be informed as to where to find the output.


.TP
.B shell
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Command to use when spawning a subshell.  By default, the user's login
shell from \fB/etc/passwd\fP is used.


.TP
.B sidebar_delim_chars
.nf
Type: string
Default: \(lq/.\(rq
.fi
.IP
This contains the list of characters which you would like to treat
as folder separators for displaying paths in the sidebar.
.IP
Local mail is often arranged in directories: `dir1/dir2/mailbox'.

.IP
.EX
set sidebar_delim_chars='/'

.EE
.IP
IMAP mailboxes are often named: `folder1.folder2.mailbox'.

.IP
.EX
set sidebar_delim_chars='.'

.EE
.IP
\fBSee also:\fP $sidebar_short_path, $sidebar_folder_indent, $sidebar_indent_string.


.TP
.B sidebar_divider_char
.nf
Type: string
Default: \(lq|\(rq
.fi
.IP
This specifies the characters to be drawn between the sidebar (when
visible) and the other Mutt panels. ASCII and Unicode line\-drawing
characters are supported.


.TP
.B sidebar_folder_indent
.nf
Type: boolean
Default: no
.fi
.IP
Set this to indent mailboxes in the sidebar.
.IP
\fBSee also:\fP $sidebar_short_path, $sidebar_indent_string, $sidebar_delim_chars.


.TP
.B sidebar_format
.nf
Type: string
Default: \(lq%B%*  %n\(rq
.fi
.IP
This variable allows you to customize the sidebar display. This string is
similar to $index_format, but has its own set of \fBprintf(3)\fP\-like
sequences:
.RS
.PD 0
.TP
%B  
Name of the mailbox
.TP
%S  
* Size of mailbox (total number of messages)
.TP
%N  
* Number of unread messages in the mailbox
.TP
%n  
N if mailbox has new mail, blank otherwise
.TP
%F  
* Number of Flagged messages in the mailbox
.TP
%!  
\(lq!\(rq : one flagged message;
\(lq!!\(rq : two flagged messages;
\(lqn!\(rq : n flagged messages (for n > 2).
Otherwise prints nothing.
.TP
%d  
* @ Number of deleted messages
.TP
%L  
* @ Number of messages after limiting
.TP
%t  
* @ Number of tagged messages
.TP
%>X 
right justify the rest of the string and pad with \(lqX\(rq
.TP
%|X 
pad to the end of the line with \(lqX\(rq
.TP
%*X 
soft\-fill with character \(lqX\(rq as pad
.RE
.PD 1
.IP
* = Can be optionally printed if nonzero
@ = Only applicable to the current folder
.IP
In order to use %S, %N, %F, and %!, $mail_check_stats must
be \fIset\fP.  When thus set, a suggested value for this option is
\(rq%B%?F? [%F]?%* %?N?%N/?%S\(rq.


.TP
.B sidebar_indent_string
.nf
Type: string
Default: \(lq  \(rq
.fi
.IP
This specifies the string that is used to indent mailboxes in the sidebar.
It defaults to two spaces.
.IP
\fBSee also:\fP $sidebar_short_path, $sidebar_folder_indent, $sidebar_delim_chars.


.TP
.B sidebar_new_mail_only
.nf
Type: boolean
Default: no
.fi
.IP
When set, the sidebar will only display mailboxes containing new, or
flagged, mail.
.IP
\fBSee also:\fP sidebar_whitelist.


.TP
.B sidebar_next_new_wrap
.nf
Type: boolean
Default: no
.fi
.IP
When set, the \fB<sidebar\-next\-new>\fP command will not stop and the end of
the list of mailboxes, but wrap around to the beginning. The
\fB<sidebar\-prev\-new>\fP command is similarly affected, wrapping around to
the end of the list.


.TP
.B sidebar_relative_shortpath_indent
.nf
Type: boolean
Default: no
.fi
.IP
When set, this option changes how $sidebar_short_path and
$sidebar_folder_indent perform shortening and indentation: both
will look at the previous sidebar entries and shorten/indent
relative to the most recent parent.
.IP
An example of this option set/unset for mailboxes listed in this
order, with $sidebar_short_path=yes,
$sidebar_folder_indent=yes, and $sidebar_indent_string=\(rq→\(rq:
.RS
.PD 0
.TP
\fBmailbox\fP  
\fBset\fP   
\fBunset\fP
.TP
\fB=a.b\fP     
\fB=a.b\fP  
\fB→b\fP
.TP
\fB=a.b.c.d\fP 
\fB→c.d\fP  
\fB→→→d\fP
.TP
\fB=a.b.e\fP   
\fB→e\fP    
\fB→→e\fP
.RE
.PD 1
.IP
The second line illustrates most clearly.  With this option set,
\fB=a.b.c.d\fP is shortened relative to \fB=a.b\fP, becoming
\fBc.d\fP; it is also indented one place relative to \fB=a.b\fP.
With this option unset \fB=a.b.c.d\fP is always shortened to the
last part of the mailbox, \fBd\fP and is indented three places,
with respect to $folder (represented by '=').
.IP
When set, the third line will also be indented and shortened
relative to the first line.


.TP
.B sidebar_short_path
.nf
Type: boolean
Default: no
.fi
.IP
By default the sidebar will show the mailbox's path, relative to the
$folder variable. Setting \fBsidebar_shortpath=yes\fP will shorten the
names relative to the previous name. Here's an example:
.RS
.PD 0
.TP
\fBshortpath=no\fP 
\fBshortpath=yes\fP 
\fBshortpath=yes, folderindent=yes, indentstr=\(rq..\(rq\fP
.TP
\fBfruit\fP        
\fBfruit\fP         
\fBfruit\fP
.TP
\fBfruit.apple\fP  
\fBapple\fP         
\fB..apple\fP
.TP
\fBfruit.banana\fP 
\fBbanana\fP        
\fB..banana\fP
.TP
\fBfruit.cherry\fP 
\fBcherry\fP        
\fB..cherry\fP
.RE
.PD 1
.IP
\fBSee also:\fP $sidebar_delim_chars, $sidebar_folder_indent, $sidebar_indent_string.


.TP
.B sidebar_sort_method
.nf
Type: sort order
Default: unsorted
.fi
.IP
Specifies how to sort mailbox entries in the sidebar.  By default, the
entries are sorted alphabetically.  Valid values:
.RS
.PD 0
.TP
\(hy alpha (alphabetically)
.TP
\(hy count (all message count)
.TP
\(hy flagged (flagged message count)
.TP
\(hy name (alphabetically)
.TP
\(hy new (unread message count)
.TP
\(hy path (alphabetically)
.TP
\(hy unread (unread message count)
.TP
\(hy unsorted
.RE
.PD 1
.IP
You may optionally use the \(lqreverse\-\(rq prefix to specify reverse sorting
order (example: \(lq\fBset sidebar_sort_method=reverse\-alpha\fP\(rq).


.TP
.B sidebar_use_mailbox_shortcuts
.nf
Type: boolean
Default: no
.fi
.IP
When set, sidebar mailboxes will be displayed with mailbox shortcut prefixes
\(rq=\(rq or \(rq~\(rq.
.IP
When unset, the sidebar will trim off a matching $folder prefix
but otherwise not use mailbox shortcuts.


.TP
.B sidebar_visible
.nf
Type: boolean
Default: no
.fi
.IP
This specifies whether or not to show sidebar. The sidebar shows a list of
all your mailboxes.
.IP
\fBSee also:\fP $sidebar_format, $sidebar_width


.TP
.B sidebar_width
.nf
Type: number
Default: 30
.fi
.IP
This controls the width of the sidebar.  It is measured in screen columns.
For example: sidebar_width=20 could display 20 ASCII characters, or 10
Chinese characters.


.TP
.B sig_dashes
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, a line containing \(lq\-\- \(rq (note the trailing space) will be inserted before your
$signature.  It is \fBstrongly\fP recommended that you not \fIunset\fP
this variable unless your signature contains just your name.  The
reason for this is because many software packages use \(lq\-\- \\n\(rq to
detect your signature.  For example, Mutt has the ability to highlight
the signature in a different color in the built\-in pager.


.TP
.B sig_on_top
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, the signature will be included before any quoted or forwarded
text.  It is \fBstrongly\fP recommended that you do not set this variable
unless you really know what you are doing, and are prepared to take
some heat from netiquette guardians.


.TP
.B signature
.nf
Type: path
Default: \(lq~/.signature\(rq
.fi
.IP
Specifies the filename of your signature, which is appended to all
outgoing messages.   If the filename ends with a pipe (\(lq|\(rq), it is
assumed that filename is a shell command and input should be read from
its standard output.


.TP
.B simple_search
.nf
Type: string
Default: \(lq~f %s | ~s %s\(rq
.fi
.IP
Specifies how Mutt should expand a simple search into a real search
pattern.  A simple search is one that does not contain any of the \(lq~\(rq pattern
modifiers.  See \(lqpatterns\(rq for more information on search patterns.
.IP
For example, if you simply type \(lqjoe\(rq at a search or limit prompt, Mutt
will automatically expand it to the value specified by this variable by
replacing \(lq%s\(rq with the supplied string.
For the default value, \(lqjoe\(rq would be expanded to: \(lq~f joe | ~s joe\(rq.


.TP
.B size_show_bytes
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, message sizes will display bytes for values less than
1 kilobyte.  See formatstrings-size.


.TP
.B size_show_fractions
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, message sizes will be displayed with a single decimal value
for sizes from 0 to 10 kilobytes and 1 to 10 megabytes.
See formatstrings-size.


.TP
.B size_show_mb
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP, message sizes will display megabytes for values greater than
or equal to 1 megabyte.  See formatstrings-size.


.TP
.B size_units_on_left
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, message sizes units will be displayed to the left of the number.
See formatstrings-size.


.TP
.B sleep_time
.nf
Type: number
Default: 1
.fi
.IP
Specifies time, in seconds, to pause while displaying certain informational
messages, while moving from folder to folder and after expunging
messages from the current folder.  The default is to pause one second, so
a value of zero for this option suppresses the pause.


.TP
.B smart_wrap
.nf
Type: boolean
Default: yes
.fi
.IP
Controls the display of lines longer than the screen width in the
internal pager. If \fIset\fP, long lines are wrapped at a word boundary.  If
\fIunset\fP, lines are simply wrapped at the screen edge. Also see the
$markers variable.


.TP
.B smileys
.nf
Type: regular expression
Default: \(lq(>From )|(:[\-^]?[][)(><}{|/DP])\(rq
.fi
.IP
The \fIpager\fP uses this variable to catch some common false
positives of $quote_regexp, most notably smileys and not consider
a line quoted text if it also matches $smileys. This mostly
happens at the beginning of a line.


.TP
.B smime_ask_cert_label
.nf
Type: boolean
Default: yes
.fi
.IP
This flag controls whether you want to be asked to enter a label
for a certificate about to be added to the database or not. It is
\fIset\fP by default.
(S/MIME only)


.TP
.B smime_ca_location
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable contains the name of either a directory, or a file which
contains trusted certificates for use with OpenSSL.
(S/MIME only)


.TP
.B smime_certificates
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Since for S/MIME there is no pubring/secring as with PGP, mutt has to handle
storage and retrieval of keys by itself. This is very basic right
now, and keys and certificates are stored in two different
directories, both named as the hash\-value retrieved from
OpenSSL. There is an index file which contains mailbox\-address
keyid pairs, and which can be manually edited. This option points to
the location of the certificates.
(S/MIME only)


.TP
.B smime_decrypt_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This format string specifies a command which is used to decrypt
\fBapplication/x\-pkcs7\-mime\fP attachments.
.IP
The OpenSSL command formats have their own set of \fBprintf(3)\fP\-like sequences
similar to PGP's:
.RS
.PD 0
.TP
%f 
Expands to the name of a file containing a message.
.TP
%s 
Expands to the name of a file containing the signature part
           of a \fBmultipart/signed\fP attachment when verifying it.
.TP
%k 
The key\-pair specified with $smime_default_key
.TP
%c 
One or more certificate IDs.
.TP
%a 
The algorithm used for encryption.
.TP
%d 
The message digest algorithm specified with $smime_sign_digest_alg.
.TP
%C 
CA location:  Depending on whether $smime_ca_location
           points to a directory or file, this expands to
           \(lq\-CApath $smime_ca_location\(rq or \(lq\-CAfile $smime_ca_location\(rq.
.RE
.PD 1
.IP
For examples on how to configure these formats, see the \fBsmime.rc\fP in
the \fBsamples/\fP subdirectory which has been installed on your system
alongside the documentation.
(S/MIME only)


.TP
.B smime_decrypt_use_default_key
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP (default) this tells mutt to use the default key for decryption. Otherwise,
if managing multiple certificate\-key\-pairs, mutt will try to use the mailbox\-address
to determine the key to use. It will ask you to supply a key, if it can't find one.
(S/MIME only)


.TP
.B smime_default_key
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is the default key\-pair to use for S/MIME operations, and must be
set to the keyid (the hash\-value that OpenSSL generates) to work properly.
.IP
It will be used for encryption (see $postpone_encrypt and
$smime_self_encrypt). If GPGME is enabled, this is the key id displayed
by gpgsm.
.IP
It will be used for decryption unless $smime_decrypt_use_default_key
is \fIunset\fP.
.IP
It will also be used for signing unless $smime_sign_as is set.
.IP
The (now deprecated) \fIsmime_self_encrypt_as\fP is an alias for this
variable, and should no longer be used.
(S/MIME only)


.TP
.B smime_encrypt_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to create encrypted S/MIME messages.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_encrypt_with
.nf
Type: string
Default: \(lqaes256\(rq
.fi
.IP
This sets the algorithm that should be used for encryption.
Valid choices are \(lqaes128\(rq, \(lqaes192\(rq, \(lqaes256\(rq, \(lqdes\(rq, \(lqdes3\(rq, \(lqrc2\-40\(rq, \(lqrc2\-64\(rq, \(lqrc2\-128\(rq.
(S/MIME only)


.TP
.B smime_get_cert_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract X509 certificates from a PKCS7 structure.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_get_cert_email_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract the mail address(es) used for storing
X509 certificates, and for verification purposes (to check whether the
certificate was issued for the sender's mailbox).
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_get_signer_cert_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract only the signers X509 certificate from a S/MIME
signature, so that the certificate's owner may get compared to the
email's \(lqFrom:\(rq field.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_import_cert_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to import a certificate via smime_keys.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_is_default
.nf
Type: boolean
Default: no
.fi
.IP
The default behavior of mutt is to use PGP on all auto\-sign/encryption
operations. To override and to use OpenSSL instead this must be \fIset\fP.
However, this has no effect while replying, since mutt will automatically
select the same application that was used to sign/encrypt the original
message.  (Note that this variable can be overridden by unsetting $crypt_autosmime.)
(S/MIME only)


.TP
.B smime_keys
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Since for S/MIME there is no pubring/secring as with PGP, mutt has to handle
storage and retrieval of keys/certs by itself. This is very basic right now,
and stores keys and certificates in two different directories, both
named as the hash\-value retrieved from OpenSSL. There is an index file
which contains mailbox\-address keyid pair, and which can be manually
edited. This option points to the location of the private keys.
(S/MIME only)


.TP
.B smime_pk7out_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to extract PKCS7 structures of S/MIME signatures,
in order to extract the public X509 certificate(s).
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_self_encrypt
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, S/MIME encrypted messages will also be encrypted
using the certificate in $smime_default_key.
(S/MIME only)


.TP
.B smime_sign_as
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
If you have a separate key to use for signing, you should set this
to the signing key. Most people will only need to set $smime_default_key.
(S/MIME only)


.TP
.B smime_sign_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to created S/MIME signatures of type
\fBmultipart/signed\fP, which can be read by all mail clients.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.  NOTE: %c and %k will default
to $smime_sign_as if set, otherwise $smime_default_key.
(S/MIME only)


.TP
.B smime_sign_digest_alg
.nf
Type: string
Default: \(lqsha256\(rq
.fi
.IP
This sets the algorithm that should be used for the signature message digest.
Valid choices are \(lqmd5\(rq, \(lqsha1\(rq, \(lqsha224\(rq, \(lqsha256\(rq, \(lqsha384\(rq, \(lqsha512\(rq.
(S/MIME only)


.TP
.B smime_sign_opaque_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to created S/MIME signatures of type
\fBapplication/x\-pkcs7\-signature\fP, which can only be handled by mail
clients supporting the S/MIME extension.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_timeout
.nf
Type: number (long)
Default: 300
.fi
.IP
The number of seconds after which a cached passphrase will expire if
not used.
(S/MIME only)


.TP
.B smime_verify_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify S/MIME signatures of type \fBmultipart/signed\fP.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smime_verify_opaque_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This command is used to verify S/MIME signatures of type
\fBapplication/x\-pkcs7\-mime\fP.
.IP
This is a format string, see the $smime_decrypt_command command for
possible \fBprintf(3)\fP\-like sequences.
(S/MIME only)


.TP
.B smtp_authenticators
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
This is a colon\-delimited list of authentication methods mutt may
attempt to use to log in to an SMTP server, in the order mutt should
try them.  Authentication methods are any SASL mechanism, e.g.
\(lqdigest\-md5\(rq, \(lqgssapi\(rq or \(lqcram\-md5\(rq.
This option is case\-insensitive. If it is \(lqunset\(rq
(the default) mutt will try all available methods, in order from
most\-secure to least\-secure.
.IP
Example:

.IP
.EX
set smtp_authenticators=\(rqdigest\-md5:cram\-md5\(rq

.EE


.TP
.B smtp_oauth_refresh_command
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
The command to run to generate an OAUTH refresh token for
authorizing your connection to your SMTP server.  This command will be
run on every connection attempt that uses the OAUTHBEARER authentication
mechanism.  See \(lqoauth\(rq for details.


.TP
.B smtp_pass
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Specifies the password for your SMTP account.  If \fIunset\fP, Mutt will
prompt you for your password when you first send mail via SMTP.
See $smtp_url to configure mutt to send mail via SMTP.
.IP
\fBWarning\fP: you should only use this option when you are on a
fairly secure machine, because the superuser can read your muttrc even
if you are the only one who can read the file.


.TP
.B smtp_url
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Defines the SMTP smarthost where sent messages should relayed for
delivery. This should take the form of an SMTP URL, e.g.:

.IP
.EX
smtp[s]://[user[:pass]@]host[:port]

.EE
.IP
where \(lq[...]\(rq denotes an optional part.
Setting this variable overrides the value of the $sendmail
variable.
.IP
Also see $write_bcc.


.TP
.B sort
.nf
Type: sort order
Default: date
.fi
.IP
Specifies how to sort messages in the \(lqindex\(rq menu.  Valid values
are:
.RS
.PD 0
.TP
\(hy date or date\-sent
.TP
\(hy date\-received
.TP
\(hy from
.TP
\(hy mailbox\-order (unsorted)
.TP
\(hy score
.TP
\(hy size
.TP
\(hy spam
.TP
\(hy subject
.TP
\(hy threads
.TP
\(hy to
.RE
.PD 1
.IP
You may optionally use the \(lqreverse\-\(rq prefix to specify reverse sorting
order (example: \(lq\fBset sort=reverse\-date\-sent\fP\(rq).
.IP
For values except \(lqthreads\(rq, this provides the primary sort
method.  When two message sort values are equal, $sort_aux will
be used for a secondary sort.
.IP
When set to \(lqthreads\(rq, Mutt threads messages in the index. It
uses the variable $sort_thread_groups to sort between threads
(at the top/root level), and $sort_aux to sort sub\-threads and
children.


.TP
.B sort_alias
.nf
Type: sort order
Default: alias
.fi
.IP
Specifies how the entries in the \(lqalias\(rq menu are sorted.  The
following are legal values:
.RS
.PD 0
.TP
\(hy address (sort alphabetically by email address)
.TP
\(hy alias (sort alphabetically by alias name)
.TP
\(hy unsorted (leave in order specified in .muttrc)
.RE
.PD 1

.TP
.B sort_aux
.nf
Type: sort order
Default: date
.fi
.IP
For non\-threaded mode, this provides a secondary sort for
messages in the \(lqindex\(rq menu, used when the $sort value is
equal for two messages.
.IP
When sorting by threads, this variable controls how the branches
of the thread trees are sorted.  This can be set to any value
that $sort can, except \(lqthreads\(rq (in that case, mutt will just
use \(lqdate\-sent\(rq).  You can also specify the \(lqlast\-\(rq prefix in
addition to the \(lqreverse\-\(rq prefix, but \(lqlast\-\(rq must come
after \(lqreverse\-\(rq.  The \(lqlast\-\(rq prefix causes messages to be
sorted against its siblings by which has the last descendant,
using the rest of $sort_aux as an ordering.  For instance,

.IP
.EX
set sort_aux=last\-date\-received

.EE
.IP
would mean that if a new message is received in a sub\-thread,
that sub\-thread becomes the last one displayed.
.IP
Note: For reversed\-threads $sort
order, $sort_aux is reversed again (which is not the right thing to do,
but kept to not break any existing configuration setting).


.TP
.B sort_browser
.nf
Type: sort order
Default: alpha
.fi
.IP
Specifies how to sort entries in the file browser.  By default, the
entries are sorted alphabetically.  Valid values:
.RS
.PD 0
.TP
\(hy alpha (alphabetically)
.TP
\(hy count
.TP
\(hy date
.TP
\(hy size
.TP
\(hy unread
.TP
\(hy unsorted
.RE
.PD 1
.IP
You may optionally use the \(lqreverse\-\(rq prefix to specify reverse sorting
order (example: \(lq\fBset sort_browser=reverse\-date\fP\(rq).


.TP
.B sort_browser_mailboxes
.nf
Type: sort order
Default: unsorted
.fi
.IP
Specifies how to sort entries in the mailbox browser.  By default, the
entries are unsorted, displayed in the same order as listed
in the \(lqmailboxes\(rq command.  Valid values:
.RS
.PD 0
.TP
\(hy alpha (alphabetically)
.TP
\(hy count
.TP
\(hy date
.TP
\(hy size
.TP
\(hy unread
.TP
\(hy unsorted
.RE
.PD 1
.IP
You may optionally use the \(lqreverse\-\(rq prefix to specify reverse sorting
order (example: \(lq\fBset sort_browser_mailboxes=reverse\-alpha\fP\(rq).


.TP
.B sort_re
.nf
Type: boolean
Default: yes
.fi
.IP
This variable is only useful when sorting by threads with
$strict_threads \fIunset\fP.  In that case, it changes the heuristic
mutt uses to thread messages by subject.  With $sort_re \fIset\fP, mutt will
only attach a message as the child of another message by subject if
the subject of the child message starts with a substring matching the
setting of $reply_regexp.  With $sort_re \fIunset\fP, mutt will attach
the message whether or not this is the case, as long as the
non\-$reply_regexp parts of both messages are identical.


.TP
.B sort_thread_groups
.nf
Type: sort order
Default: aux
.fi
.IP
When sorting by threads, this variable controls how threads are
sorted in relation to other threads (at the top/root level).
This can be set to any value that $sort can, except \(lqthreads\(rq.
You can also specify the \(lqlast\-\(rq prefix in addition to the
\(lqreverse\-\(rq prefix, but \(lqlast\-\(rq must come after \(lqreverse\-\(rq.
The \(lqlast\-\(rq prefix causes messages to be sorted against its
siblings by which has the last descendant, using the rest of
$sort_thread_groups as an ordering.
.IP
For backward compatibility, the default value is \(lqaux\(rq, which
means to use $sort_aux for top\-level thread sorting too.  The
value \(lqaux\(rq does not respect \(lqlast\-\(rq or \(lqreverse\-\(rq
prefixes, it simply delegates sorting directly to $sort_aux.
.IP
Note: For reversed\-threads $sort order, $sort_thread_groups is
reversed again (which is not the right thing to do, but kept to
not break any existing configuration setting).


.TP
.B spam_separator
.nf
Type: string
Default: \(lq,\(rq
.fi
.IP
This variable controls what happens when multiple spam headers
are matched: if \fIunset\fP, each successive header will overwrite any
previous matches value for the spam label. If \fIset\fP, each successive
match will append to the previous, using this variable's value as a
separator.


.TP
.B spoolfile
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
If your spool mailbox is in a non\-default place where Mutt cannot find
it, you can specify its location with this variable.  Mutt will
initially set this variable to the value of the environment
variable \fB$MAIL\fP or \fB$MAILDIR\fP if either is defined.


.TP
.B ssl_ca_certificates_file
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable specifies a file containing trusted CA certificates.
Any server certificate that is signed with one of these CA
certificates is also automatically accepted. (GnuTLS only)
.IP
Example:

.IP
.EX
set ssl_ca_certificates_file=/etc/ssl/certs/ca\-certificates.crt

.EE


.TP
.B ssl_client_cert
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
The file containing a client certificate and its associated private
key.


.TP
.B ssl_force_tls
.nf
Type: boolean
Default: yes
.fi
.IP
If this variable is \fIset\fP, Mutt will require that all connections
to remote servers be encrypted. Furthermore it will attempt to
negotiate TLS even if the server does not advertise the capability,
since it would otherwise have to abort the connection anyway. This
option supersedes $ssl_starttls.


.TP
.B ssl_min_dh_prime_bits
.nf
Type: number
Default: 0
.fi
.IP
This variable specifies the minimum acceptable prime size (in bits)
for use in any Diffie\-Hellman key exchange. A value of 0 will use
the default from the GNUTLS library. (GnuTLS only)


.TP
.B ssl_starttls
.nf
Type: quadoption
Default: yes
.fi
.IP
If \fIset\fP (the default), mutt will attempt to use \fBSTARTTLS\fP on servers
advertising the capability. When \fIunset\fP, mutt will not attempt to
use \fBSTARTTLS\fP regardless of the server's capabilities.
.IP
\fBNote\fP that \fBSTARTTLS\fP is subject to many kinds of
attacks, including the ability of a machine\-in\-the\-middle to
suppress the advertising of support.  Setting $ssl_force_tls is
recommended if you rely on \fBSTARTTLS\fP.


.TP
.B ssl_use_sslv2
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP , Mutt will use SSLv2 when communicating with servers that
request it. \fBN.B. As of 2011, SSLv2 is considered insecure, and using
is inadvisable. See https://tools.ietf.org/html/rfc6176 .\fP
(OpenSSL only)


.TP
.B ssl_use_sslv3
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP , Mutt will use SSLv3 when communicating with servers that
request it. \fBN.B. As of 2015, SSLv3 is considered insecure, and using
it is inadvisable. See https://tools.ietf.org/html/rfc7525 .\fP


.TP
.B ssl_use_tlsv1
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP , Mutt will use TLSv1.0 when communicating with servers that
request it. \fBN.B. As of 2015, TLSv1.0 is considered insecure, and using
it is inadvisable. See https://tools.ietf.org/html/rfc7525 .\fP


.TP
.B ssl_use_tlsv1_1
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP , Mutt will use TLSv1.1 when communicating with servers that
request it. \fBN.B. As of 2015, TLSv1.1 is considered insecure, and using
it is inadvisable. See https://tools.ietf.org/html/rfc7525 .\fP


.TP
.B ssl_use_tlsv1_2
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP , Mutt will use TLSv1.2 when communicating with servers that
request it.


.TP
.B ssl_use_tlsv1_3
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP , Mutt will use TLSv1.3 when communicating with servers that
request it.


.TP
.B ssl_usesystemcerts
.nf
Type: boolean
Default: yes
.fi
.IP
If set to \fIyes\fP, mutt will use CA certificates in the
system\-wide certificate store when checking if a server certificate
is signed by a trusted CA. (OpenSSL only)


.TP
.B ssl_verify_dates
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP (the default), mutt will not automatically accept a server
certificate that is either not yet valid or already expired. You should
only unset this for particular known hosts, using the
\fB<account-hook>\fP function.


.TP
.B ssl_verify_host
.nf
Type: boolean
Default: yes
.fi
.IP
If \fIset\fP (the default), mutt will not automatically accept a server
certificate whose host name does not match the host used in your folder
URL. You should only unset this for particular known hosts, using
the \fB<account-hook>\fP function.


.TP
.B ssl_verify_host_override
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Defines an alternate host name to verify the server certificate against.
This should not be set unless you are sure what you are doing, but it
might be useful for connection to a .onion host without a properly
configured host name in the certificate.  See $ssl_verify_host.


.TP
.B ssl_verify_partial_chains
.nf
Type: boolean
Default: no
.fi
.IP
This option should not be changed from the default unless you understand
what you are doing.
.IP
Setting this variable to \fIyes\fP will permit verifying partial
certification chains, i. e. a certificate chain where not the root,
but an intermediate certificate CA, or the host certificate, are
marked trusted (in $certificate_file), without marking the root
signing CA as trusted.
.IP
(OpenSSL 1.0.2b and newer only).


.TP
.B ssl_ciphers
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Contains a colon\-separated list of ciphers to use when using SSL.
For OpenSSL, see ciphers(1) for the syntax of the string.
.IP
For GnuTLS, this option will be used in place of \(rqNORMAL\(rq at the
start of the priority string.  See gnutls_priority_init(3) for the
syntax and more details. (Note: GnuTLS version 2.1.7 or higher is
required.)


.TP
.B status_chars
.nf
Type: string
Default: \(lq\-*%A\(rq
.fi
.IP
Controls the characters used by the \(lq%r\(rq indicator in
$status_format. The first character is used when the mailbox is
unchanged. The second is used when the mailbox has been changed, and
it needs to be resynchronized. The third is used if the mailbox is in
read\-only mode, or if the mailbox will not be written when exiting
that mailbox (You can toggle whether to write changes to a mailbox
with the \fB<toggle\-write>\fP operation, bound by default to \(lq%\(rq). The fourth
is used to indicate that the current folder has been opened in attach\-
message mode (Certain operations like composing a new mail, replying,
forwarding, etc. are not permitted in this mode).


.TP
.B status_format
.nf
Type: string (localized)
Default: \(lq\-%r\-Mutt: %f [Msgs:%?M?%M/?%m%?n? New:%n?%?o? Old:%o?%?d? Del:%d?%?F? Flag:%F?%?t? Tag:%t?%?p? Post:%p?%?b? Inc:%b?%?B? Back:%B?%?l? %l?]\-\-\-(%s/%?T?%T/?%S)\-%>\-(%P)\-\-\-\(rq
.fi
.IP
Controls the format of the status line displayed in the \(lqindex\(rq
menu.  This string is similar to $index_format, but has its own
set of \fBprintf(3)\fP\-like sequences:
.RS
.PD 0
.TP
%b  
number of mailboxes with new mail *
.TP
%B  
number of backgrounded editing sessions *
.TP
%d  
number of deleted messages *
.TP
%f  
the full pathname of the current mailbox
.TP
%F  
number of flagged messages *
.TP
%h  
local hostname
.TP
%l  
size (in bytes) of the current mailbox (see formatstrings-size) *
.TP
%L  
size (in bytes) of the messages shown
(i.e., which match the current limit) (see formatstrings-size) *
.TP
%m  
the number of messages in the mailbox *
.TP
%M  
the number of messages shown (i.e., which match the current limit) *
.TP
%n  
number of new messages in the mailbox *
.TP
%o  
number of old unread messages *
.TP
%p  
number of postponed messages *
.TP
%P  
percentage of the way through the index
.TP
%r  
modified/read\-only/won't\-write/attach\-message indicator,
according to $status_chars
.TP
%R  
number of read messages *
.TP
%s  
current sorting mode ($sort)
.TP
%S  
current aux sorting method ($sort_aux)
.TP
%t  
number of tagged messages *
.TP
%T  
current thread group sorting method ($sort_thread_groups) *
.TP
%u  
number of unread messages *
.TP
%v  
Mutt version string
.TP
%V  
currently active limit pattern, if any *
.TP
%>X 
right justify the rest of the string and pad with \(lqX\(rq
.TP
%|X 
pad to the end of the line with \(lqX\(rq
.TP
%*X 
soft\-fill with character \(lqX\(rq as pad
.RE
.PD 1
.IP
For an explanation of \(lqsoft\-fill\(rq, see the $index_format documentation.
.IP
* = can be optionally printed if nonzero
.IP
Some of the above sequences can be used to optionally print a string
if their value is nonzero.  For example, you may only want to see the
number of flagged messages if such messages exist, since zero is not
particularly meaningful.  To optionally print a string based upon one
of the above sequences, the following construct is used:
.IP
\fB%?<sequence_char>?<optional_string>?\fP
.IP
where \fIsequence_char\fP is a character from the table above, and
\fIoptional_string\fP is the string you would like printed if
\fIsequence_char\fP is nonzero.  \fIoptional_string\fP \fBmay\fP contain
other sequences as well as normal text, but you may \fBnot\fP nest
optional strings.
.IP
Here is an example illustrating how to optionally print the number of
new messages in a mailbox:
.IP
\fB%?n?%n new messages.?\fP
.IP
You can also switch between two strings using the following construct:
.IP
\fB%?<sequence_char>?<if_string>&<else_string>?\fP
.IP
If the value of \fIsequence_char\fP is non\-zero, \fIif_string\fP will
be expanded, otherwise \fIelse_string\fP will be expanded.
.IP
You can force the result of any \fBprintf(3)\fP\-like sequence to be lowercase
by prefixing the sequence character with an underscore (\(lq_\(rq) sign.
For example, if you want to display the local hostname in lowercase,
you would use: \(lq\fB%_h\fP\(rq.
.IP
If you prefix the sequence character with a colon (\(lq:\(rq) character, mutt
will replace any dots in the expansion by underscores. This might be helpful
with IMAP folders that don't like dots in folder names.


.TP
.B status_on_top
.nf
Type: boolean
Default: no
.fi
.IP
Setting this variable causes the \(lqstatus bar\(rq to be displayed on
the first line of the screen rather than near the bottom. If $help
is \fIset\fP, too it'll be placed at the bottom.


.TP
.B strict_threads
.nf
Type: boolean
Default: no
.fi
.IP
If \fIset\fP, threading will only make use of the \(lqIn\-Reply\-To\(rq and
\(lqReferences:\(rq fields when you $sort by message threads.  By
default, messages with the same subject are grouped together in
\(lqpseudo threads.\(rq. This may not always be desirable, such as in a
personal mailbox where you might have several unrelated messages with
the subjects like \(lqhi\(rq which will get grouped together. See also
$sort_re for a less drastic way of controlling this
behavior.


.TP
.B suspend
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIunset\fP, mutt won't stop when the user presses the terminal's
\fIsusp\fP key, usually \(lq^Z\(rq. This is useful if you run mutt
inside an xterm using a command like \(lq\fBxterm \-e mutt\fP\(rq.


.TP
.B text_flowed
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will generate \(lqformat=flowed\(rq bodies with a content type
of \(lq\fBtext/plain; format=flowed\fP\(rq.
This format is easier to handle for some mailing software, and generally
just looks like ordinary text.  To actually make use of this format's
features, you'll need support in your editor.
.IP
The option only controls newly composed messages.  Postponed messages,
resent messages, and draft messages (via \-H on the command line) will
use the content\-type of the source message.
.IP
Note that $indent_string is ignored when this option is \fIset\fP.


.TP
.B thorough_search
.nf
Type: boolean
Default: yes
.fi
.IP
Affects the \fB~b\fP, \fB~B\fP, and \fB~h\fP search operations described in
section \(lqpatterns\(rq.  If \fIset\fP, the headers and body/attachments of
messages to be searched are decoded before searching. If \fIunset\fP,
messages are searched as they appear in the folder.
.IP
Users searching attachments or for non\-ASCII characters should \fIset\fP
this value because decoding also includes MIME parsing/decoding and possible
character set conversions. Otherwise mutt will attempt to match against the
raw message received (for example quoted\-printable encoded or with encoded
headers) which may lead to incorrect search results.


.TP
.B thread_received
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt uses the date received rather than the date sent
to thread messages by subject.


.TP
.B tilde
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, the internal\-pager will pad blank lines to the bottom of the
screen with a tilde (\(lq~\(rq).


.TP
.B time_inc
.nf
Type: number
Default: 0
.fi
.IP
Along with $read_inc, $write_inc, and $net_inc, this
variable controls the frequency with which progress updates are
displayed. It suppresses updates less than $time_inc milliseconds
apart. This can improve throughput on systems with slow terminals,
or when running mutt on a remote system.
.IP
Also see the \(lqtuning\(rq section of the manual for performance considerations.


.TP
.B timeout
.nf
Type: number
Default: 600
.fi
.IP
When Mutt is waiting for user input either idling in menus or
in an interactive prompt, Mutt would block until input is
present. Depending on the context, this would prevent certain
operations from working, like checking for new mail or keeping
an IMAP connection alive.
.IP
This variable controls how many seconds Mutt will at most wait
until it aborts waiting for input, performs these operations and
continues to wait for input.
.IP
A value of zero or less will cause Mutt to never time out.


.TP
.B tmpdir
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
This variable allows you to specify where Mutt will place its
temporary files needed for displaying and composing messages.  If
this variable is not set, the environment variable \fB$TMPDIR\fP is
used.  If \fB$TMPDIR\fP is not set then \(lq\fB/tmp\fP\(rq is used.


.TP
.B to_chars
.nf
Type: string
Default: \(lq +TCFL\(rq
.fi
.IP
Controls the character used to indicate mail addressed to you.  The
first character is the one used when the mail is \fInot\fP addressed to your
address.  The second is used when you are the only
recipient of the message.  The third is when your address
appears in the \(lqTo:\(rq header field, but you are not the only recipient of
the message.  The fourth character is used when your
address is specified in the \(lqCc:\(rq header field, but you are not the only
recipient.  The fifth character is used to indicate mail that was sent
by \fIyou\fP.  The sixth character is used to indicate when a mail
was sent to a mailing\-list you subscribe to.


.TP
.B trash
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
If set, this variable specifies the path of the trash folder where the
mails marked for deletion will be moved, instead of being irremediably
purged.
.IP
NOTE: When you delete a message in the trash folder, it is really
deleted, so that you have a way to clean the trash.


.TP
.B ts_icon_format
.nf
Type: string (localized)
Default: \(lqM%?n?AIL&ail?\(rq
.fi
.IP
Controls the format of the icon title, as long as \(lq$ts_enabled\(rq is set.
This string is identical in formatting to the one used by
\(lq$status_format\(rq.


.TP
.B ts_enabled
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether mutt tries to set the terminal status line and icon name.
Most terminal emulators emulate the status line in the window title.


.TP
.B ts_status_format
.nf
Type: string (localized)
Default: \(lqMutt with %?m?%m messages&no messages?%?n? [%n NEW]?\(rq
.fi
.IP
Controls the format of the terminal status line (or window title),
provided that \(lq$ts_enabled\(rq has been set. This string is identical in
formatting to the one used by \(lq$status_format\(rq.


.TP
.B tunnel
.nf
Type: string
Default: \(lq\(rq
.fi
.IP
Setting this variable will cause mutt to open a pipe to a command
instead of a raw socket. You may be able to use this to set up
preauthenticated connections to your IMAP/POP3/SMTP server. Example:

.IP
.EX
set tunnel=\(rqssh \-q mailhost.net /usr/local/libexec/imapd\(rq

.EE
.IP
Note: For this example to work you must be able to log in to the remote
machine without having to enter a password.
.IP
When set, Mutt uses the tunnel for all remote connections.
Please see \(lqaccount-hook\(rq in the manual for how to use different
tunnel commands per connection.


.TP
.B tunnel_is_secure
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will assume the $tunnel connection does not need
STARTTLS to be enabled.  It will also allow IMAP PREAUTH server
responses inside a tunnel to proceed.  This is appropriate if $tunnel
uses ssh or directly invokes the server locally.
.IP
When \fIunset\fP, Mutt will negotiate STARTTLS according to the
ssl_starttls and ssl_force_tls variables.  If ssl_force_tls is
set, Mutt will abort connecting if an IMAP server responds with PREAUTH.
This setting is appropriate if $tunnel does not provide security and
could be tampered with by attackers.


.TP
.B uncollapse_jump
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, Mutt will jump to the next unread message, if any,
when the current thread is \fIun\fPcollapsed.


.TP
.B uncollapse_new
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will automatically uncollapse any collapsed
thread that receives a newly delivered message.  When
\fIunset\fP, collapsed threads will remain collapsed. The
presence of the newly delivered message will still affect index
sorting, though.


.TP
.B use_8bitmime
.nf
Type: boolean
Default: no
.fi
.IP
\fBWarning:\fP do not set this variable unless you are using a version
of sendmail which supports the \fB\-B8BITMIME\fP flag (such as sendmail
8.8.x) or you may not be able to send mail.
.IP
When \fIset\fP, Mutt will invoke $sendmail with the \fB\-B8BITMIME\fP
flag when sending 8\-bit messages to enable ESMTP negotiation.


.TP
.B use_domain
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will qualify all local addresses (ones without the
\(lq@host\(rq portion) with the value of $hostname.  If \fIunset\fP, no
addresses will be qualified.


.TP
.B use_envelope_from
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will set the \fIenvelope\fP sender of the message.
If $envelope_from_address is \fIset\fP, it will be used as the sender
address. If \fIunset\fP, mutt will attempt to derive the sender from the
\(lqFrom:\(rq header.
.IP
Note that this information is passed to sendmail command using the
\fB\-f\fP command line switch. Therefore setting this option is not useful
if the $sendmail variable already contains \fB\-f\fP or if the
executable pointed to by $sendmail doesn't support the \fB\-f\fP switch.


.TP
.B use_from
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will generate the \(lqFrom:\(rq header field when
sending messages.  If \fIunset\fP, no \(lqFrom:\(rq header field will be
generated unless the user explicitly sets one using the \(lqmy_hdr\(rq
command.


.TP
.B use_ipv6
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, Mutt will look for IPv6 addresses of hosts it tries to
contact.  If this option is \fIunset\fP, Mutt will restrict itself to IPv4 addresses.
Normally, the default should work.


.TP
.B user_agent
.nf
Type: boolean
Default: no
.fi
.IP
When \fIset\fP, mutt will add a \(lqUser\-Agent:\(rq header to outgoing
messages, indicating which version of mutt was used for composing
them.


.TP
.B visual
.nf
Type: path
Default: \(lq\(rq
.fi
.IP
Specifies the visual editor to invoke when the \(lq\fB~v\fP\(rq command is
given in the built\-in editor.


.TP
.B wait_key
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether Mutt will ask you to press a key after an external command
has been invoked by these functions: \fB<shell\-escape>\fP,
\fB<pipe\-message>\fP, \fB<pipe\-entry>\fP, \fB<print\-message>\fP,
and \fB<print\-entry>\fP commands.
.IP
It is also used when viewing attachments with \(lqauto_view\(rq, provided
that the corresponding mailcap entry has a \fIneedsterminal\fP flag,
and the external program is interactive.
.IP
When \fIset\fP, Mutt will always ask for a key. When \fIunset\fP, Mutt will wait
for a key only if the external command returned a non\-zero status.


.TP
.B weed
.nf
Type: boolean
Default: yes
.fi
.IP
When \fIset\fP, mutt will weed headers when displaying, forwarding,
or replying to messages.
.IP
Also see $copy_decode_weed, $pipe_decode_weed, $print_decode_weed.


.TP
.B wrap
.nf
Type: number
Default: 0
.fi
.IP
When set to a positive value, mutt will wrap text at $wrap characters.
When set to a negative value, mutt will wrap text so that there are $wrap
characters of empty space on the right side of the terminal. Setting it
to zero makes mutt wrap at the terminal width.
.IP
Also see $reflow_wrap.


.TP
.B wrap_headers
.nf
Type: number
Default: 78
.fi
.IP
This option specifies the number of characters to use for wrapping
an outgoing message's headers. Allowed values are between 78 and 998
inclusive.
.IP
\fBNote:\fP This option usually shouldn't be changed. RFC5233
recommends a line length of 78 (the default), so \fBplease only change
this setting when you know what you're doing\fP.


.TP
.B wrap_search
.nf
Type: boolean
Default: yes
.fi
.IP
Controls whether searches wrap around the end.
.IP
When \fIset\fP, searches will wrap around the first (or last) item. When
\fIunset\fP, incremental searches will not wrap.


.TP
.B wrapmargin
.nf
Type: number
Default: 0
.fi
.IP
(DEPRECATED) Equivalent to setting $wrap with a negative value.


.TP
.B write_bcc
.nf
Type: boolean
Default: no
.fi
.IP
Controls whether mutt writes out the \(lqBcc:\(rq header when
preparing messages to be sent.  Some MTAs, such as Exim and
Courier, do not strip the \(lqBcc:\(rq header; so it is advisable to
leave this unset unless you have a particular need for the header
to be in the sent message.
.IP
If mutt is set to deliver directly via SMTP (see $smtp_url),
this option does nothing: mutt will never write out the \(lqBcc:\(rq
header in this case.
.IP
Note this option only affects the sending of messages.  Fcc'ed
copies of a message will always contain the \(lqBcc:\(rq header if
one exists.


.TP
.B write_inc
.nf
Type: number
Default: 10
.fi
.IP
When writing a mailbox, a message will be printed every
$write_inc messages to indicate progress.  If set to 0, only a
single message will be displayed before writing a mailbox.
.IP
Also see the $read_inc, $net_inc and $time_inc variables and the
\(lqtuning\(rq section of the manual for performance considerations.


.\" -*-nroff-*-
.SH SEE ALSO
.PP
.BR iconv (1),
.BR iconv (3),
.BR mailcap (5),
.BR maildir (5),
.BR mbox (5),
.BR mutt (1),
.BR printf (3),
.BR regex (7),
.BR strftime (3)
.PP
The Mutt Manual
.PP
The Mutt home page: http://www.mutt.org/
.SH AUTHOR
.PP
Michael Elkins, and others.  Use <mutt-dev@mutt.org> to contact
the developers.
