# (c) Copyright 2014, 2019-2021. CodeWeavers, Inc.

import checkgtk
import cxutils
import cxdiag
import cxfixes

def check_all_bases(extras=checkgtk.CHECK_SIGNALS):
    # Check for generic errors
    cxfixes.clear_errors()
    diag = cxdiag.get(None, cxdiag.CHECK_NOBIT | cxdiag.CHECK_DBUS | cxdiag.CHECK_OPENSSL | cxdiag.CHECK_PERLFILECOPY | cxdiag.CHECK_GZIP)

    # Then add the GTK ones
    gtk_status = checkgtk.ensure_present_gtk(extras)
    if gtk_status == checkgtk.MISSING_PYGI:
        cxfixes.add_error('pygi', level='required')
    elif gtk_status == checkgtk.MISSING_VTE:
        cxfixes.add_error('python-vte-2.91', level='required')
    elif gtk_status in (checkgtk.MISSING_GIR, checkgtk.BROKEN):
        cxfixes.add_error('gir-data', level='required')

    if cxfixes.get_error_count() == 1 and \
       (cxfixes.has_error('dbus') or cxfixes.has_error('python3-dbus')):
        # D-Bus is optional so ignore it for now
        cxfixes.clear_errors()
    else:
        for errid, title in cxutils.iteritems(diag.warnings):
            cxfixes.add_error(errid, title, 'recommended')
        cxfixes.add_masked_errors()

    return gtk_status

def fix_all_bases(extras=checkgtk.CHECK_SIGNALS, report=True):
    gtk_status = check_all_bases(extras)

    cxfixes.fix_errors()
    if report:
        # Refresh the error list so we don't report errors that have been fixed
        # as a side effect of others. For instance installing libgcc_s is
        # likely to fix MissingLibPthread.
        gtk_status = check_all_bases(extras)
        cxfixes.report_errors()
    elif gtk_status != checkgtk.OK:
        # The issues may not have all been fixed but if GTK+ is ok we can
        # at least bring up the GUI.
        gtk_status = checkgtk.ensure_present_gtk(extras)

    if gtk_status == checkgtk.NO_DISPLAY:
        import cxlog
        cxlog.err("Verify $DISPLAY: it is not set, invalid or you are not allowed to access it")

    if gtk_status != checkgtk.OK:
        # Only signal a failure if we won't be able to bring up the GUI
        return False
    return True
