/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.topografix.gpx._1._0.Gpx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.fibs.geotag.track.TrackWriter;

public class GpxWriter
implements TrackWriter {
    @Override
    public void write(Gpx gpx, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.write(gpx, fileOutputStream);
        fileOutputStream.close();
    }

    @Override
    public void write(Gpx gpx, OutputStream outputStream) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)Gpx.class.getPackage().getName());
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.schemaLocation", (Object)"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd");
        gpx.setCreator("Geotag http://geotag.sourceforge.net");
        try {
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            XMLGregorianCalendar now = datatypeFactory.newXMLGregorianCalendar(new GregorianCalendar());
            gpx.setTime(now);
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        marshaller.marshal((Object)gpx, outputStream);
        outputStream.close();
    }
}

