/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.fibs.geotag.image.ImageFile;
import org.fibs.geotag.image.ImageFileFactory;
import org.fibs.geotag.tasks.InterruptibleTask;

public class PreviewLoaderTask
extends InterruptibleTask<Void, BufferedImage> {
    private File file;
    private BufferedImage bufferedImage;
    private long delay;
    private static List<PreviewLoaderTask> runningTasks = new ArrayList<PreviewLoaderTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewLoaderTask(File file, long delay) {
        this.file = file;
        this.delay = delay;
        List<PreviewLoaderTask> list = runningTasks;
        synchronized (list) {
            for (PreviewLoaderTask task : runningTasks) {
                task.interruptRequest();
            }
            runningTasks.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        try {
            ImageFile imageFile;
            Thread.sleep(this.delay);
            if (!this.interruptRequested() && (imageFile = ImageFileFactory.createImageFile(this.file)) != null) {
                this.bufferedImage = imageFile.read();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List<PreviewLoaderTask> list = runningTasks;
        synchronized (list) {
            runningTasks.remove(this);
        }
        return null;
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }
}

