import QtQuick 2.1
import QtQuick.Controls 1.4
import QtQuick.Layouts 1.0
import Shotcut.Controls 1.0 as Shotcut
Shotcut.KeyframableFilter {
    width: 350
    height: 125
    keyframableParameters: ["yaw", "pitch", "roll"]
    startValues: [0.5, 0.5, 0.5]
    middleValues: [0.0, 0.0, 0.0]
    endValues: [0.5, 0.5, 0.5]
    property var allParameters: [
        {
            name: "yaw",
            type: "simple",
            def: 0
        },
        {
            name: "pitch",
            type: "simple",
            def: 0
        },
        {
            name: "roll",
            type: "simple",
            def: 0
        },
        {
            name: "interpolation",
            type: "combobox",
            def: 1
        },
        {
            name: "grid",
            type: "checkbox",
            def: false
        }
        ]
    function isKeyframeButtonChecked(control){
        return filter.animateIn <= 0 && filter.animateOut <= 0 && filter.keyframeCount(control) > 0;
    }
    
    function setSimpleControl(parameter, controlSlider, controlKeyframeButton) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
        controlKeyframeButton.checked = isKeyframeButtonChecked(parameter);
    }
    
    function setSimpleControlStatic(parameter, controlSlider) {
        controlSlider.value = filter.getDouble(parameter, getPosition());
    }
    
    function setSimpleComboBox(parameter, controlComboBox) {
        controlComboBox.currentIndex = filter.get(parameter);
    }
    
    function setSimpleCheckBox(parameter, controlCheckBox) {
        controlCheckBox.checked = filter.get(parameter) == "1";
    }
    
    function setSimpleTextField(parameter, controlTextField) {
        controlTextField.text = filter.get(parameter);
    }
    
    function setSimpleNumTextField(parameter, controlTextField) {
        controlTextField.text = filter.getDouble(parameter).toFixed(4);
    }
    
    function getFrameRate() {
        return producer.getDouble("meta.media.frame_rate_num", getPosition()) / producer.getDouble("meta.media.frame_rate_den", getPosition());
    }
    
    function getClipOffset() {
        return filter.in;
    }
    function getKeyframesButton(param) {
        return this["prop_" + param.name + "KeyframesButton"];
    }
    
    function getControl(param) {
        if (param.control != null && param.control !== undefined) {
            return this["prop_" + param.control];
        } else if (param.type == "simple" || param.type == "static") {
            return this["prop_" + param.name + "Slider"];
        } else if (param.type == "checkbox") {
            return this["prop_" + param.name + "CheckBox"];
        } else if (param.type == "combobox") {
            return this["prop_" + param.name + "ComboBox"];
        } else if (param.type == "textfield" || param.type == "numtextfield") {
            return this["prop_" + param.name + "TextField"];
        } else {
            return null;
        }
    }
    
    function enableControls(enabled) {
        for (var i = 0; i < allParameters.length; ++i) {
            var control = getControl(allParameters[i]);
            control.enabled = enabled;
        }
    }
    
    function defaultBeforePresetLoaded() {
        for (var i in preset.parameters) {
            filter.resetProperty(preset.parameters[i]);
        }
        resetSimpleKeyframes();
    }
    
    function defaultPresetSelected() {
        initializeSimpleKeyframes();
        setControls();
    }
    
    function setControlsForAllParameters() {
        console.log("START");
        console.log(allParameters.length);
        for (var i = 0; i < allParameters.length; ++i) {
            console.log(i);
            var param = allParameters[i];
            var control = getControl(param);
            console.log(param.name);
            console.log(param.type);
            console.log(control);
            if (param.type == "simple") {
                setSimpleControl(param.name, control, getKeyframesButton(param));
            } else if (param.type == "static") {
                setSimpleControlStatic(param.name, control);
            } else if (param.type == "combobox") {
                setSimpleComboBox(param.name, control);
            } else if (param.type == "checkbox") {
                setSimpleCheckBox(param.name, control);
            } else if (param.type == "textfield") {
                setSimpleTextField(param.name, control);
            } else if (param.type == "numtextfield") {
                setSimpleNumTextField(param.name, control);
            }
        }
    }
    function setControls() {
        blockUpdate = true;
        setControlsForAllParameters();
        blockUpdate = false;
        enableControls(isSimpleKeyframesActive());
    }
    
    function defaultOnCompleted() {
        if (filter.isNew) {
            for (var i = 0; i < allParameters.length; ++i) {
                var param = allParameters[i];
                console.log(param.name);
                if (param.def != null) {
                    var control = getControl(param);
                    filter.set(param.name, param.def);
                }
            }
            filter.savePreset(preset.parameters);
        }
        setControls();
    }
    
    function updateSimpleKeyframes() {
        setControlsForAllParameters();
    }
    
    Component.onCompleted: {
        defaultOnCompleted()
    }
    function updateProperty_yaw () {
        if (!blockUpdate) {
            updateFilter("yaw", yawSlider.value, yawKeyframesButton, getPosition());
        }
    }
    property alias prop_yawSlider : yawSlider;
    property alias prop_yawKeyframesButton : yawKeyframesButton;
    
    function updateProperty_pitch () {
        if (!blockUpdate) {
            updateFilter("pitch", pitchSlider.value, pitchKeyframesButton, getPosition());
        }
    }
    property alias prop_pitchSlider : pitchSlider;
    property alias prop_pitchKeyframesButton : pitchKeyframesButton;
    
    function updateProperty_roll () {
        if (!blockUpdate) {
            updateFilter("roll", rollSlider.value, rollKeyframesButton, getPosition());
        }
    }
    property alias prop_rollSlider : rollSlider;
    property alias prop_rollKeyframesButton : rollKeyframesButton;
    
    function updateProperty_interpolation () {
        if (!blockUpdate) {
            filter.set("interpolation", interpolationComboBox.currentIndex);
        }
    }
    property alias prop_interpolationComboBox : interpolationComboBox;
    
    function updateProperty_grid () {
        if (!blockUpdate) {
            filter.set("grid", gridCheckBox.checked);
        }
    }
    property alias prop_gridCheckBox : gridCheckBox;
    
    GridLayout {
        columns: 4
        anchors.fill: parent
        anchors.margins: 8
        Label {
            text: qsTr('Preset')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.Preset {
            id: preset
            parameters: ["yaw", "pitch", "roll", "interpolation"]
            Layout.columnSpan: 3
            onBeforePresetLoaded: {
                defaultBeforePresetLoaded()
            }
            onPresetSelected: {
                defaultPresetSelected()
            }
        }
        Label {
            text: qsTr('Interpolation')
            Layout.alignment: Qt.AlignRight
        }
        ComboBox {
            currentIndex: 0
            model: ["Nearest-neighbor", "Bilinear"]
            id: interpolationComboBox
            Layout.columnSpan: 2
            onCurrentIndexChanged: updateProperty_interpolation()
        }
        Shotcut.UndoButton {
            id: interpolationUndo
            onClicked: interpolationComboBox.currentIndex = 1
        }
        Label {
            text: qsTr('Yaw')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: yawSlider
            minimumValue: -360
            maximumValue: 360
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_yaw()
        }
        Shotcut.KeyframesButton {
            id: yawKeyframesButton;
            checked: isKeyframeButtonChecked("yaw");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "yaw", yawSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: yawUndo
            onClicked: yawSlider.value = 0
        }
        Label {
            text: qsTr('Pitch')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: pitchSlider
            minimumValue: -180
            maximumValue: 180
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_pitch()
        }
        Shotcut.KeyframesButton {
            id: pitchKeyframesButton;
            checked: isKeyframeButtonChecked("pitch");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "pitch", pitchSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: pitchUndo
            onClicked: pitchSlider.value = 0
        }
        Label {
            text: qsTr('Roll')
            Layout.alignment: Qt.AlignRight
        }
        Shotcut.SliderSpinner {
            id: rollSlider
            minimumValue: -180
            maximumValue: 180
            spinnerWidth: 120;
            suffix: ' deg';
            decimals: 3;
            stepSize: 1;
            onValueChanged: updateProperty_roll()
        }
        Shotcut.KeyframesButton {
            id: rollKeyframesButton;
            checked: isKeyframeButtonChecked("roll");
            onToggled: {
                enableControls(true);
                toggleKeyframes(checked, "roll", rollSlider.value);
            }
        }
        Shotcut.UndoButton {
            id: rollUndo
            onClicked: rollSlider.value = 0
        }
        Label {
            text: qsTr('Grid')
            Layout.alignment: Qt.AlignRight
        }
        CheckBox {
            text: qsTr('Show')
            checked: false
            partiallyCheckedEnabled: false
            id: gridCheckBox
            Layout.columnSpan: 3
            onCheckedChanged: updateProperty_grid()
        }
    }
    Connections {
        target: filter
        onInChanged: updateSimpleKeyframes();
        onOutChanged: updateSimpleKeyframes();
        onAnimateInChanged: updateSimpleKeyframes();
        onAnimateOutChanged: updateSimpleKeyframes();
        onChanged: setControls();
    }
    
    Connections {
        target: producer;
        onPositionChanged: setControls();
    }
    
}
