
#ifndef MESSAGECOMPOSER_EXPORT_H
#define MESSAGECOMPOSER_EXPORT_H

#ifdef MESSAGECOMPOSER_STATIC_DEFINE
#  define MESSAGECOMPOSER_EXPORT
#  define MESSAGECOMPOSER_NO_EXPORT
#else
#  ifndef MESSAGECOMPOSER_EXPORT
#    ifdef KPim6MessageComposer_EXPORTS
        /* We are building this library */
#      define MESSAGECOMPOSER_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define MESSAGECOMPOSER_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef MESSAGECOMPOSER_NO_EXPORT
#    define MESSAGECOMPOSER_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef MESSAGECOMPOSER_DECL_DEPRECATED
#  define MESSAGECOMPOSER_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef MESSAGECOMPOSER_DECL_DEPRECATED_EXPORT
#  define MESSAGECOMPOSER_DECL_DEPRECATED_EXPORT MESSAGECOMPOSER_EXPORT MESSAGECOMPOSER_DECL_DEPRECATED
#endif

#ifndef MESSAGECOMPOSER_DECL_DEPRECATED_NO_EXPORT
#  define MESSAGECOMPOSER_DECL_DEPRECATED_NO_EXPORT MESSAGECOMPOSER_NO_EXPORT MESSAGECOMPOSER_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef MESSAGECOMPOSER_NO_DEPRECATED
#    define MESSAGECOMPOSER_NO_DEPRECATED
#  endif
#endif
#include <messagecomposer_version.h>

#define MESSAGECOMPOSER_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(MESSAGECOMPOSER_NO_DEPRECATED)
#  undef MESSAGECOMPOSER_DEPRECATED
#  define MESSAGECOMPOSER_DEPRECATED_EXPORT MESSAGECOMPOSER_EXPORT
#  define MESSAGECOMPOSER_DEPRECATED_NO_EXPORT MESSAGECOMPOSER_NO_EXPORT
#elif defined(MESSAGECOMPOSER_NO_DEPRECATED_WARNINGS)
#  define MESSAGECOMPOSER_DEPRECATED
#  define MESSAGECOMPOSER_DEPRECATED_EXPORT MESSAGECOMPOSER_EXPORT
#  define MESSAGECOMPOSER_DEPRECATED_NO_EXPORT MESSAGECOMPOSER_NO_EXPORT
#else
#  define MESSAGECOMPOSER_DEPRECATED MESSAGECOMPOSER_DECL_DEPRECATED
#  define MESSAGECOMPOSER_DEPRECATED_EXPORT MESSAGECOMPOSER_DECL_DEPRECATED_EXPORT
#  define MESSAGECOMPOSER_DEPRECATED_NO_EXPORT MESSAGECOMPOSER_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define MESSAGECOMPOSER_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define MESSAGECOMPOSER_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef MESSAGECOMPOSER_NO_DEPRECATED
#  define MESSAGECOMPOSER_DISABLE_DEPRECATED_BEFORE_AND_AT MESSAGECOMPOSER_VERSION
#endif
#ifdef MESSAGECOMPOSER_NO_DEPRECATED_WARNINGS
#  define MESSAGECOMPOSER_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef MESSAGECOMPOSER_DEPRECATED_WARNINGS_SINCE
#  ifdef MESSAGECOMPOSER_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define MESSAGECOMPOSER_DEPRECATED_WARNINGS_SINCE MESSAGECOMPOSER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define MESSAGECOMPOSER_DEPRECATED_WARNINGS_SINCE MESSAGECOMPOSER_VERSION
#  endif
#endif

#ifndef MESSAGECOMPOSER_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define MESSAGECOMPOSER_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef MESSAGECOMPOSER_DEPRECATED
#  define MESSAGECOMPOSER_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > MESSAGECOMPOSER_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define MESSAGECOMPOSER_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* MESSAGECOMPOSER_EXPORT_H */
