/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JpegSegmentData
implements Serializable {
    static final long serialVersionUID = 7110175216435025451L;
    private final HashMap _segmentDataMap = new HashMap(10);

    public void addSegment(byte by, byte[] byArray) {
        List list = this.getOrCreateSegmentList(by);
        list.add(byArray);
    }

    public byte[] getSegment(byte by) {
        return this.getSegment(by, 0);
    }

    public byte[] getSegment(byte by, int n) {
        List list = this.getSegmentList(by);
        if (list == null || list.size() <= n) {
            return null;
        }
        return (byte[])list.get(n);
    }

    public int getSegmentCount(byte by) {
        List list = this.getSegmentList(by);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public void removeSegmentOccurrence(byte by, int n) {
        List list = (List)this._segmentDataMap.get(new Byte(by));
        list.remove(n);
    }

    public void removeSegment(byte by) {
        this._segmentDataMap.remove(new Byte(by));
    }

    private List getSegmentList(byte by) {
        return (List)this._segmentDataMap.get(new Byte(by));
    }

    private List getOrCreateSegmentList(byte by) {
        List list;
        Byte by2 = new Byte(by);
        if (this._segmentDataMap.containsKey(by2)) {
            list = (List)this._segmentDataMap.get(by2);
        } else {
            list = new ArrayList();
            this._segmentDataMap.put(by2, list);
        }
        return list;
    }

    public boolean containsSegment(byte by) {
        return this._segmentDataMap.containsKey(new Byte(by));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ToFile(File file, JpegSegmentData jpegSegmentData) throws IOException {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            objectOutputStream.writeObject(jpegSegmentData);
        }
        finally {
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JpegSegmentData FromFile(File file) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            JpegSegmentData jpegSegmentData = (JpegSegmentData)objectInputStream.readObject();
            return jpegSegmentData;
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
    }
}

