;;; Disarchive
;;; Copyright © 2020 Timothy Sample <samplet@ngyro.com>
;;;
;;; This file is part of Disarchive.
;;;
;;; Disarchive is free software: you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation, either version 3 of the License, or
;;; (at your option) any later version.
;;;
;;; Disarchive is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with Disarchive.  If not, see <http://www.gnu.org/licenses/>.

(define-module (disarchive config)
  #:export (%tar
            %gzip
            %xz
            %zgz
            %disarchive-directory-cache))

;;; Commentary:
;;;
;;; This module provides system-specific values.
;;;
;;; Code:

(define DISARCHIVE_O_NOFOLLOW 131072)

;; Older versions of Guile do not have O_NOFOLLOW, but newer ones do.
;; Hence, we check for O_NOFOLLOW and use the Guile version if we can.
(unless (and=> (module-variable (resolve-interface '(guile)) 'O_NOFOLLOW)
               variable-bound?)
  (export (DISARCHIVE_O_NOFOLLOW . O_NOFOLLOW)))

(define %tar "/gnu/store/99c25918hl9pihix8hparmc96q6zrpwy-tar-1.34/bin/tar")

(define %gzip "/gnu/store/l0yga4lrwwf74rz7fb0dadglg27ajpsx-gzip-1.10/bin/gzip")

(define %xz "/gnu/store/fk24dx8qz1b5smnc4ljfw25xn7yjps0q-xz-5.2.5/bin/xz")

(define (%zgz)
  (or (getenv "DISARCHIVE_ZGZ")
      "/gnu/store/hzzm750va0xxrgdinar4kzym7dpd94f7-disarchive-0.4.0/libexec/disarchive-zgz"))

(define %disarchive-directory-cache (make-parameter #f))
