/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool.keytool;

import gnu.crypto.tool.keytool.Command;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

class Delete
extends Command {
    public void run() throws Exception {
        String alias;
        FileInputStream in;
        KeyStore store = null;
        KeyStore store2 = null;
        CertificateFactory cert = null;
        if (this.provider != null) {
            store = KeyStore.getInstance(this.storeType, this.provider);
            cert = CertificateFactory.getInstance(this.certType, this.provider);
            if (this.secretStore != null) {
                store2 = KeyStore.getInstance(this.storeType, this.provider);
            }
        } else {
            store = KeyStore.getInstance(this.storeType);
            cert = CertificateFactory.getInstance(this.certType);
            if (this.secretStore != null) {
                store2 = KeyStore.getInstance(this.storeType, this.provider);
            }
        }
        NameCallback aliasIn = new NameCallback("alias: ", this.alias);
        PasswordCallback pass = new PasswordCallback("keystore password: ", false);
        PasswordCallback pass2 = new PasswordCallback("secret keystore password: ", false);
        Callback[] cb = null;
        cb = store2 != null ? (this.alias.equals("mykey") ? new Callback[]{aliasIn, pass, pass2} : new Callback[]{pass, pass2}) : (this.alias.equals("mykey") ? new Callback[]{aliasIn, pass} : new Callback[]{pass});
        this.handler.handle(cb);
        if (this.storeFile.equals("-")) {
            if (this.verbose > 0) {
                this.println("Loading keystore from standard input");
            }
            store.load(System.in, pass.getPassword());
        } else {
            if (this.verbose > 0) {
                this.println("Loading keystore from " + this.storeFile);
            }
            in = new FileInputStream(this.storeFile);
            store.load(in, pass.getPassword());
            in.close();
        }
        if (store2 != null) {
            if (this.secretStore.equals("-")) {
                if (this.verbose > 0) {
                    this.println("Loading secret keystore from standard input");
                }
                store2.load(System.in, pass2.getPassword());
            } else {
                if (this.verbose > 0) {
                    this.println("Loading secret keystore from " + this.storeFile);
                }
                in = new FileInputStream(this.storeFile);
                store.load(in, pass.getPassword());
                in.close();
            }
        }
        if ((alias = this.alias).equals("mykey")) {
            alias = aliasIn.getName();
        }
        if (!store.containsAlias(alias)) {
            throw new Exception("no such alias: " + alias);
        }
        store.deleteEntry(alias);
        OutputStream out = null;
        if (this.outFile != null) {
            out = this.outFile.equals("-") ? System.out : new FileOutputStream(this.outFile);
        } else {
            OutputStream outputStream = out = this.storeFile.equals("-") ? System.out : new FileOutputStream(this.storeFile);
        }
        if (this.verbose > 0) {
            this.println("Writing keystore to " + (out == System.out ? "standard output" : (this.outFile == null ? this.storeFile : this.outFile)));
        }
        store.store(out, pass.getPassword());
        if (out != System.out) {
            out.flush();
            out.close();
        }
        if (store2 != null) {
            if (!store2.containsAlias(alias)) {
                throw new Exception("no such alias: " + alias);
            }
            store2.deleteEntry(alias);
        }
        if (store2 != null) {
            out = null;
            if (this.outFile != null) {
                out = this.outFile.equals("-") ? System.out : new FileOutputStream(this.outFile);
            } else {
                OutputStream outputStream = out = this.storeFile.equals("-") ? System.out : new FileOutputStream(this.storeFile);
            }
            if (this.verbose > 0) {
                this.println("Writing secret keystore to " + (out == System.out ? "standard output" : (this.outFile == null ? this.storeFile : this.outFile)));
            }
            store2.store(out, pass.getPassword());
            if (out != System.out) {
                out.flush();
                out.close();
            }
        }
    }

    public String toString() {
        return "delete";
    }

    Delete(Command previous) {
        super(previous);
    }
}

