/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki;

import gnu.crypto.der.BitString;
import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.OID;
import gnu.crypto.pki.X500Name;
import gnu.crypto.pki.X509CertificateImpl;
import gnu.crypto.pki.ext.Extension;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;

public final class X509CertificateBuilder
extends X509CertificateImpl {
    private static final long ONE_YEAR = 31536000000L;

    public final byte[] getEncoded() throws CertificateEncodingException {
        if (this.encoded == null) {
            throw new CertificateEncodingException("not encoded");
        }
        return (byte[])this.encoded.clone();
    }

    public final Date getNotBefore() {
        if (this.notBefore == null) {
            throw new IllegalStateException("notBefore not set");
        }
        return (Date)this.notBefore.clone();
    }

    public final Date getNotAfter() {
        if (this.notAfter == null) {
            throw new IllegalStateException("notAfter not set");
        }
        return (Date)this.notAfter.clone();
    }

    public final byte[] getSignature() {
        if (this.signature != null) {
            throw new IllegalStateException("certificate has not been signed");
        }
        return (byte[])this.signature.clone();
    }

    public final byte[] getTBSCertificate() throws CertificateEncodingException {
        if (this.tbsCertBytes == null) {
            throw new CertificateEncodingException("not encoded");
        }
        return (byte[])this.tbsCertBytes.clone();
    }

    public final void setVersion(int version) {
        if (version <= 0 || version > 3) {
            throw new IllegalArgumentException("invalid version: " + version);
        }
        this.version = version;
        this.encoded = null;
    }

    public final void setSerialNumber(BigInteger serialNo) {
        if (serialNo.signum() < 0 || serialNo.equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("serial numbers must be positive");
        }
        this.serialNo = serialNo;
        this.encoded = null;
    }

    public final void setIssuer(X500Name issuer) {
        this.issuer = issuer;
        this.encoded = null;
    }

    public final void setIssuer(X500Principal issuer) throws IOException {
        this.issuer = new X500Name(issuer.getEncoded());
        this.encoded = null;
    }

    public final void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
        this.encoded = null;
    }

    public final void setNotAfter(Date notAfter) {
        this.notAfter = notAfter;
        this.encoded = null;
    }

    public final void setSubject(X500Name subject) {
        this.subject = subject;
        this.encoded = null;
    }

    public final void setSubject(X500Principal subject) throws IOException {
        this.subject = new X500Name(subject.getEncoded());
        this.encoded = null;
    }

    public final void setPublicKey(PublicKey subjectKey) {
        this.subjectKey = subjectKey;
        this.encoded = null;
    }

    public final void setIssuerUniqueId(BitString issuerUniqueId) {
        this.issuerUniqueId = issuerUniqueId;
        this.encoded = null;
    }

    public final void setSubjectUniqueId(BitString subjectUniqueId) {
        this.subjectUniqueId = subjectUniqueId;
        this.encoded = null;
    }

    public final void addExtension(Extension extension) {
        this.extensions.put(extension.getOid(), extension);
        this.encoded = null;
    }

    public final void setSigAlg(String sigAlg) {
        this.sigAlgId = sigAlg.equals("DSAwithSHA1") || sigAlg.equals("DSS") ? ID_DSA_WITH_SHA1 : (sigAlg.equals("MD2withRSA") ? ID_RSA_WITH_MD2 : (sigAlg.equals("MD5withRSA") ? ID_RSA_WITH_MD5 : (sigAlg.equals("SHA1withRSA") ? ID_RSA_WITH_SHA1 : new OID(sigAlg))));
    }

    public final void setSigParams(byte[] sigAlgVal) {
        this.sigAlgVal = sigAlgVal == null ? null : (byte[])sigAlgVal.clone();
        this.encoded = null;
    }

    public final void sign(PrivateKey key, String sigAlg, String provider) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        this.setSigAlg(sigAlg);
        Signature sig = Signature.getInstance(sigAlg, provider);
        sig.initSign(key);
        try {
            this.encoded = this.sign(sig);
        }
        catch (IOException ioe) {
            CertificateEncodingException cee = new CertificateEncodingException();
            cee.initCause(ioe);
            throw cee;
        }
    }

    public final void sign(PrivateKey key, String sigAlg) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        this.setSigAlg(sigAlg);
        Signature sig = Signature.getInstance(sigAlg);
        sig.initSign(key);
        try {
            this.encoded = this.sign(sig);
        }
        catch (IOException ioe) {
            CertificateEncodingException cee = new CertificateEncodingException();
            cee.initCause(ioe);
            throw cee;
        }
    }

    private final byte[] sign(Signature sig) throws CertificateException, IOException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        ArrayList<DERValue> cert = new ArrayList<DERValue>(3);
        ArrayList<DERValue> tbsCert = new ArrayList<DERValue>(9);
        if (this.version != 1) {
            tbsCert.add(new DERValue(96, BigInteger.valueOf(this.version - 1)));
        }
        if (this.serialNo == null) {
            throw new CertificateException("no serial number");
        }
        tbsCert.add(new DERValue(2, this.serialNo));
        ArrayList<DERValue> algId = new ArrayList<DERValue>(2);
        algId.add(new DERValue(6, this.sigAlgId));
        if (this.sigAlgVal != null) {
            algId.add(DERReader.read(this.sigAlgVal));
        } else {
            algId.add(new DERValue(5, null));
        }
        DERValue algIdVal = new DERValue(48, algId);
        tbsCert.add(algIdVal);
        if (this.issuer == null) {
            throw new CertificateException("no issuer");
        }
        tbsCert.add(DERReader.read(this.issuer.getDer()));
        if (this.notBefore == null) {
            this.notBefore = new Date();
        }
        if (this.notAfter == null) {
            this.notAfter = new Date(this.notBefore.getTime() + 31536000000L);
        }
        ArrayList<DERValue> validity = new ArrayList<DERValue>(2);
        validity.add(new DERValue(24, this.notBefore));
        validity.add(new DERValue(24, this.notAfter));
        tbsCert.add(new DERValue(48, validity));
        if (this.subject == null) {
            throw new CertificateException("no subject");
        }
        tbsCert.add(DERReader.read(this.subject.getDer()));
        if (this.subjectKey == null) {
            throw new CertificateException("no public key");
        }
        if (!"X.509".equals(this.subjectKey.getFormat())) {
            KeyFactory factory = KeyFactory.getInstance(this.subjectKey.getAlgorithm());
            PublicKey key2 = (PublicKey)factory.translateKey(this.subjectKey);
            tbsCert.add(DERReader.read(key2.getEncoded()));
        } else {
            tbsCert.add(DERReader.read(this.subjectKey.getEncoded()));
        }
        if (this.issuerUniqueId != null) {
            if (this.version < 2) {
                throw new CertificateException("issuerUniqueId is only valid for version 2 or 3");
            }
            tbsCert.add(new DERValue(65, this.issuerUniqueId));
        }
        if (this.subjectUniqueId != null) {
            if (this.version < 2) {
                throw new CertificateException("subjectUniqueId is only valid for version 2 or 3");
            }
            tbsCert.add(new DERValue(66, this.subjectUniqueId));
        }
        if (this.extensions.size() > 0 && this.version < 3) {
            throw new CertificateException("extensions are only valid for version 3");
        }
        if (this.extensions.size() > 0) {
            ArrayList<DERValue> exts = new ArrayList<DERValue>(this.extensions.size());
            Iterator it = this.extensions.values().iterator();
            while (it.hasNext()) {
                Extension e = (Extension)it.next();
                exts.add(e.getDerValue());
            }
            tbsCert.add(new DERValue(67, exts));
        }
        DERValue tbsCertVal = new DERValue(48, tbsCert);
        this.tbsCertBytes = tbsCertVal.getEncoded();
        sig.update(this.tbsCertBytes);
        this.signature = sig.sign();
        cert.add(tbsCertVal);
        cert.add(algIdVal);
        cert.add(new DERValue(4, this.signature));
        return new DERValue(48, cert).getEncoded();
    }

    public X509CertificateBuilder() {
        this.version = 3;
    }
}

