/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Cardinality;

public final class CardinalityCheckingIterator
implements SequenceIterator {
    private SequenceIterator base;
    private int requiredCardinality;
    private RoleLocator role;
    private SourceLocator locator;
    private Item first = null;
    private Item second = null;
    private Item current = null;
    private int position = 0;

    public CardinalityCheckingIterator(SequenceIterator base, int requiredCardinality, RoleLocator role, SourceLocator locator) throws XPathException {
        this.base = base;
        this.requiredCardinality = requiredCardinality;
        this.role = role;
        this.locator = locator;
        this.first = base.next();
        if (this.first == null) {
            if (!Cardinality.allowsZero(requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + role.getMessage(), role.getErrorCode());
            }
        } else {
            if (requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + role.getMessage() + " is an empty sequence", role.getErrorCode());
            }
            this.second = base.next();
            if (this.second != null && !Cardinality.allowsMany(requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + role.getMessage() + CardinalityChecker.depictSequenceStart(base.getAnother(), 2), role.getErrorCode());
            }
        }
    }

    public Item next() throws XPathException {
        if (this.position < 2) {
            if (this.position == 0) {
                this.current = this.first;
                this.position = this.first == null ? -1 : 1;
                return this.current;
            }
            if (this.position == 1) {
                this.current = this.second;
                this.position = this.second == null ? -1 : 2;
                return this.current;
            }
            return null;
        }
        this.current = this.base.next();
        this.position = this.current == null ? -1 : ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return new CardinalityCheckingIterator(this.base.getAnother(), this.requiredCardinality, this.role, this.locator);
    }

    public int getProperties() {
        return 0;
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, this.locator);
        e.setIsTypeError(true);
        e.setErrorCode(errorCode);
        throw e;
    }
}

