/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PositionVariable;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TreatExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.sort.IntArraySet;
import net.sf.saxon.expr.sort.IntSet;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.CurrentGroupingKey;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionParser {
    protected Tokenizer t;
    protected StaticContext env;
    protected Stack<Binding> rangeVariables = new Stack();
    protected Container defaultContainer;
    protected NameChecker nameChecker;
    protected boolean allowXPath30Syntax = false;
    protected boolean scanOnly = false;
    protected boolean compileWithTracing = false;
    protected int language = 0;
    public static final int XPATH = 0;
    public static final int XSLT_PATTERN = 1;
    public static final int SEQUENCE_TYPE = 2;
    public static final int XQUERY = 3;
    protected DecimalValue languageVersion = DecimalValue.TWO;

    public void setCompileWithTracing(boolean trueOrFalse) {
        this.compileWithTracing = trueOrFalse;
    }

    public boolean isCompileWithTracing() {
        return this.compileWithTracing;
    }

    public Tokenizer getTokenizer() {
        return this.t;
    }

    public StaticContext getStaticContext() {
        return this.env;
    }

    public void setDefaultContainer(Container container) {
        this.defaultContainer = container;
    }

    public Container getDefaultContainer() {
        return this.defaultContainer;
    }

    public NameChecker getNameChecker() {
        return this.nameChecker;
    }

    public void nextToken() throws XPathException {
        block3: {
            try {
                this.t.next();
                if (this.t.currentToken != 201 && this.t.currentToken != 34 || !this.t.currentTokenValue.startsWith("{")) break block3;
                if (this.allowXPath30Syntax) {
                    this.t.currentTokenValue = this.normalizeEQName(this.t.currentTokenValue);
                    break block3;
                }
                throw new XPathException("The expanded QName syntax \"uri\":local is not allowed in this version of XPath/XQuery");
            }
            catch (XPathException err) {
                this.grumble(err.getMessage());
            }
        }
    }

    public void expect(int token) throws XPathException {
        if (this.t.currentToken != token) {
            this.grumble("expected \"" + Token.tokens[token] + "\", found " + this.currentTokenDisplay());
        }
    }

    public void grumble(String message) throws XPathException {
        this.grumble(message, this.language == 1 ? "XTSE0340" : "XPST0003");
    }

    public void grumble(String message, String errorCode) throws XPathException {
        this.grumble(message, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", errorCode), -1);
    }

    public void grumble(String message, String errorCode, int offset) throws XPathException {
        this.grumble(message, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", errorCode), offset);
    }

    protected void grumble(String message, StructuredQName errorCode, int offset) throws XPathException {
        int column;
        int line;
        if (errorCode == null) {
            errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XPST0003");
        }
        String s = this.t.recentText(-1);
        if (offset == -1) {
            line = this.t.getLineNumber();
            column = this.t.getColumnNumber();
        } else {
            line = this.t.getLineNumber(offset);
            column = this.t.getColumnNumber(offset);
        }
        String lineInfo = line == 1 ? "" : "on line " + line + ' ';
        String columnInfo = "at char " + column + ' ';
        String prefix = this.getLanguage() + " syntax error " + columnInfo + lineInfo + (s.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(s) + ":\n    ";
        XPathException err = new XPathException(message);
        err.setAdditionalLocationText(prefix);
        err.setIsStaticError(true);
        err.setErrorCodeQName(errorCode);
        throw err;
    }

    protected void warning(String message) throws XPathException {
        String s = this.t.recentText(-1);
        int line = this.t.getLineNumber();
        String lineInfo = line == 1 ? "" : "on line " + line + ' ';
        String prefix = lineInfo + (message.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(s) + ":\n    ";
        this.env.issueWarning(prefix + message, null);
    }

    public void setLanguage(int language, DecimalValue version) {
        switch (language) {
            case 0: 
            case 1: 
            case 2: {
                if (DecimalValue.TWO_POINT_ONE.equals(version)) {
                    version = DecimalValue.THREE;
                }
                if (DecimalValue.TWO.equals(version) || DecimalValue.THREE.equals(version)) break;
                throw new IllegalArgumentException("Unsupported language version " + version);
            }
            case 3: {
                if (DecimalValue.ONE_POINT_ONE.equals(version)) {
                    version = DecimalValue.THREE;
                }
                if (DecimalValue.ONE.equals(version) || DecimalValue.THREE.equals(version)) break;
                throw new IllegalArgumentException("Unsupported language version " + version);
            }
            default: {
                throw new IllegalArgumentException("Unknown language " + language);
            }
        }
        this.language = language;
        this.languageVersion = version;
        this.allowXPath30Syntax = DecimalValue.THREE.equals(this.languageVersion);
    }

    protected String getLanguage() {
        switch (this.language) {
            case 0: {
                return "XPath";
            }
            case 1: {
                return "XSLT Pattern";
            }
            case 2: {
                return "SequenceType";
            }
            case 3: {
                return "XQuery";
            }
        }
        return "XPath";
    }

    protected String currentTokenDisplay() {
        if (this.t.currentToken == 201) {
            return "name \"" + this.t.currentTokenValue + '\"';
        }
        if (this.t.currentToken == -1) {
            return "(unknown token)";
        }
        return '\"' + Token.tokens[this.t.currentToken] + '\"';
    }

    public Expression parse(String expression, int start, int terminator, int lineNumber, StaticContext env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.t = new Tokenizer();
        try {
            this.t.tokenize(expression, start, -1, lineNumber);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        Expression exp = this.parseExpression();
        if (this.t.currentToken != terminator) {
            if (this.t.currentToken == 0 && terminator == 215) {
                this.grumble("Missing curly brace after expression in attribute value template", "XTSE0350");
            } else {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
            }
        }
        return exp;
    }

    public SequenceType parseSequenceType(String input, StaticContext env) throws XPathException {
        this.env = env;
        this.nameChecker = env.getConfiguration().getNameChecker();
        this.language = 2;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(input, 0, -1, 1);
        }
        catch (XPathException err) {
            this.grumble(err.getMessage());
        }
        SequenceType req = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return req;
    }

    public Expression parseExpression() throws XPathException {
        Expression exp = this.parseExprSingle();
        ArrayList<Expression> list = null;
        while (this.t.currentToken == 7) {
            if (list == null) {
                list = new ArrayList<Expression>(10);
                list.add(exp);
            }
            this.nextToken();
            Expression next = this.parseExprSingle();
            this.setLocation(next);
            list.add(next);
        }
        if (list != null) {
            exp = Block.makeBlock(list);
            this.setLocation(exp);
        }
        return exp;
    }

    public Expression parseExprSingle() throws XPathException {
        switch (this.t.currentToken) {
            case 211: 
            case 216: {
                return this.parseForExpression();
            }
            case 31: 
            case 32: {
                return this.parseQuantifiedExpression();
            }
            case 36: {
                return this.parseIfExpression();
            }
            case 66: {
                return this.parseSwitchExpression();
            }
            case 65: {
                return this.parseTypeswitchExpression();
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return this.parseValidateExpression();
            }
            case 218: {
                return this.parseExtensionExpression();
            }
            case 60: {
                if (!this.t.currentTokenValue.equals("try")) break;
                return this.parseTryCatchExpression();
            }
        }
        return this.parseOrExpression();
    }

    protected Expression parseTypeswitchExpression() throws XPathException {
        this.grumble("typeswitch is not allowed in XPath");
        return null;
    }

    protected Expression parseSwitchExpression() throws XPathException {
        this.grumble("switch expression requires XQuery 1.1");
        return null;
    }

    protected Expression parseValidateExpression() throws XPathException {
        this.grumble("validate{} expressions are not allowed in XPath");
        return null;
    }

    protected Expression parseExtensionExpression() throws XPathException {
        this.grumble("extension expressions (#...#) are not allowed in XPath");
        return null;
    }

    protected Expression parseTryCatchExpression() throws XPathException {
        this.grumble("try/catch expressions are not allowed in XPath");
        return null;
    }

    private Expression parseOrExpression() throws XPathException {
        Expression exp = this.parseAndExpression();
        while (this.t.currentToken == 9) {
            this.nextToken();
            exp = new BooleanExpression(exp, 9, this.parseAndExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseAndExpression() throws XPathException {
        Expression exp = this.parseComparisonExpression();
        while (this.t.currentToken == 10) {
            this.nextToken();
            exp = new BooleanExpression(exp, 10, this.parseComparisonExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseForExpression() throws XPathException {
        if (this.t.currentToken == 216 && !this.allowXPath30Syntax) {
            this.grumble("'let' is not permitted in XPath 2.0");
        }
        return this.parseMappingExpression();
    }

    private Expression parseQuantifiedExpression() throws XPathException {
        return this.parseMappingExpression();
    }

    private Expression parseMappingExpression() throws XPathException {
        int i;
        int offset = this.t.currentTokenStartOffset;
        int operator = this.t.currentToken;
        ArrayList<ForClause> clauseList = new ArrayList<ForClause>(3);
        do {
            Assignation v;
            ForClause clause = new ForClause();
            clause.offset = offset;
            clause.requiredType = operator == 216 ? SequenceType.ANY_SEQUENCE : SequenceType.SINGLE_ITEM;
            clauseList.add(clause);
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String var = this.t.currentTokenValue;
            if (operator == 211) {
                v = new ForExpression();
                v.setRequiredType(SequenceType.SINGLE_ITEM);
            } else if (operator == 216) {
                v = new LetExpression();
                v.setRequiredType(SequenceType.ANY_SEQUENCE);
            } else {
                v = new QuantifiedExpression();
                v.setRequiredType(SequenceType.SINGLE_ITEM);
                ((QuantifiedExpression)v).setOperator(operator);
            }
            v.setVariableQName(this.makeStructuredQName(var, false));
            clause.rangeVariable = v;
            this.nextToken();
            if (this.t.currentToken == 71 && this.language == 3) {
                SequenceType type;
                this.nextToken();
                clause.requiredType = type = this.parseSequenceType();
                if (type.getCardinality() != 16384) {
                    this.warning("Occurrence indicator on singleton range variable has no effect");
                    type = SequenceType.makeSequenceType(type.getPrimaryType(), 16384);
                }
                v.setRequiredType(type);
            }
            clause.positionVariable = null;
            this.expect(operator == 216 ? 58 : 30);
            this.nextToken();
            clause.sequence = this.parseExprSingle();
            this.declareRangeVariable(clause.rangeVariable);
        } while (this.t.currentToken == 7);
        if (operator == 211 || operator == 216) {
            this.expect(25);
        } else {
            this.expect(33);
        }
        this.nextToken();
        Expression action = this.parseExprSingle();
        TypeHierarchy th = this.env.getConfiguration().getTypeHierarchy();
        for (i = clauseList.size() - 1; i >= 0; --i) {
            ForClause fc = (ForClause)clauseList.get(i);
            Assignation exp = fc.rangeVariable;
            this.setLocation(exp, offset);
            exp.setSequence(fc.sequence);
            if (fc.requiredType == SequenceType.SINGLE_ITEM) {
                SequenceType type = SequenceType.makeSequenceType(fc.sequence.getItemType(th), 16384);
                fc.rangeVariable.setRequiredType(type);
            } else {
                fc.rangeVariable.setRequiredType(fc.requiredType);
            }
            exp.setAction(action);
            action = exp;
        }
        for (i = clauseList.size() - 1; i >= 0; --i) {
            FLWORClause clause = (FLWORClause)clauseList.get(i);
            for (int n = 0; n < clause.numberOfRangeVariables(); ++n) {
                this.undeclareRangeVariable();
            }
        }
        return action;
    }

    private Expression parseIfExpression() throws XPathException {
        int ifoffset = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression condition = this.parseExpression();
        this.expect(204);
        this.nextToken();
        int thenoffset = this.t.currentTokenStartOffset;
        this.expect(26);
        this.nextToken();
        Expression thenExp = this.makeTracer(thenoffset, this.parseExprSingle(), 2016, null);
        int elseoffset = this.t.currentTokenStartOffset;
        this.expect(27);
        this.nextToken();
        Expression elseExp = this.makeTracer(elseoffset, this.parseExprSingle(), 2017, null);
        Expression ifExp = Choose.makeConditional(condition, thenExp, elseExp);
        this.setLocation(ifExp, ifoffset);
        return this.makeTracer(ifoffset, ifExp, 2015, null);
    }

    private Expression parseInstanceOfExpression() throws XPathException {
        Expression exp = this.parseTreatExpression();
        if (this.t.currentToken == 45) {
            this.nextToken();
            exp = new InstanceOfExpression(exp, this.parseSequenceType());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseTreatExpression() throws XPathException {
        Expression exp = this.parseCastableExpression();
        if (this.t.currentToken == 47) {
            this.nextToken();
            SequenceType target = this.parseSequenceType();
            exp = TreatExpression.make(exp, target);
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseCastableExpression() throws XPathException {
        Expression exp = this.parseCastExpression();
        if (this.t.currentToken == 57) {
            boolean allowEmpty;
            this.nextToken();
            this.expect(201);
            AtomicType at = this.getAtomicType(this.t.currentTokenValue);
            if (at.getFingerprint() == 632) {
                this.grumble("No value is castable to xs:anyAtomicType", "XPST0080");
            }
            if (at.getFingerprint() == 531) {
                this.grumble("No value is castable to xs:NOTATION", "XPST0080");
            }
            this.nextToken();
            boolean bl = allowEmpty = this.t.currentToken == 213;
            if (allowEmpty) {
                this.nextToken();
            }
            if (at.isNamespaceSensitive()) {
                if (exp instanceof StringLiteral) {
                    try {
                        String source = ((StringLiteral)exp).getStringValue();
                        this.makeNameCode(source, false);
                        exp = new Literal(BooleanValue.TRUE);
                    }
                    catch (Exception e) {
                        exp = new Literal(BooleanValue.FALSE);
                    }
                } else {
                    exp = new CastableExpression(exp, at, allowEmpty);
                }
            } else {
                exp = new CastableExpression(exp, at, allowEmpty);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseCastExpression() throws XPathException {
        Expression exp = this.parseUnaryExpression();
        if (this.t.currentToken == 46) {
            boolean allowEmpty;
            this.nextToken();
            this.expect(201);
            AtomicType at = this.getAtomicType(this.t.currentTokenValue);
            if (at.getFingerprint() == 632) {
                this.grumble("Cannot cast to xs:anyAtomicType", "XPST0080");
            }
            if (at.getFingerprint() == 531) {
                this.grumble("Cannot cast to xs:NOTATION", "XPST0080");
            }
            this.nextToken();
            boolean bl = allowEmpty = this.t.currentToken == 213;
            if (allowEmpty) {
                this.nextToken();
            }
            if (at.isNamespaceSensitive() && exp instanceof StringLiteral) {
                try {
                    String source = ((StringLiteral)exp).getStringValue();
                    return new Literal(CastExpression.castStringToQName(source, at, this.env));
                }
                catch (XPathException e) {
                    this.grumble(e.getMessage(), e.getErrorCodeQName(), -1);
                }
            } else {
                exp = new CastExpression(exp, at, allowEmpty);
                this.setLocation(exp);
                exp = ExpressionVisitor.make(this.env, exp.getExecutable()).simplify(exp);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AtomicType getAtomicType(String qname) throws XPathException {
        block24: {
            String local;
            String uri;
            if (this.scanOnly) {
                return BuiltInAtomicType.STRING;
            }
            if (qname.startsWith("{")) {
                StructuredQName sq = StructuredQName.fromClarkName(qname);
                uri = sq.getNamespaceURI();
                local = sq.getLocalName();
            } else {
                try {
                    String[] parts = this.nameChecker.getQNameParts(qname);
                    if (parts[0].length() == 0) {
                        uri = this.env.getDefaultElementNamespace();
                    } else {
                        try {
                            uri = this.env.getURIForPrefix(parts[0]);
                        }
                        catch (XPathException err) {
                            this.grumble(err.getMessage(), err.getErrorCodeQName(), -1);
                            uri = "";
                        }
                    }
                    local = parts[1];
                }
                catch (QNameException err) {
                    this.grumble(err.getMessage());
                    return null;
                }
            }
            boolean builtInNamespace = uri.equals("http://www.w3.org/2001/XMLSchema");
            if (builtInNamespace) {
                ItemType t = Type.getBuiltInItemType(uri, local);
                if (t == null) {
                    this.grumble("Unknown atomic type " + qname, "XPST0051");
                }
                if (t instanceof BuiltInAtomicType) {
                    if (this.env.isAllowedBuiltInType((BuiltInAtomicType)t)) return (AtomicType)t;
                    this.grumble("The type " + qname + " is not recognized by a Basic XSLT Processor. ", "XPST0080");
                    return (AtomicType)t;
                }
                this.grumble("The type " + qname + " is not atomic", "XPST0051");
            } else {
                if (uri.equals("http://saxon.sf.net/java-type")) {
                    try {
                        String className = local.replace('-', '$');
                        Class theClass = this.env.getConfiguration().getClass(className, false, null);
                        return new ExternalObjectType(theClass, this.env.getConfiguration());
                    }
                    catch (XPathException err) {
                        this.grumble("Unknown Java class " + local, "XPST0051");
                        return null;
                    }
                }
                if (uri.equals("http://saxon.sf.net/clitype")) {
                    return (AtomicType)Configuration.getPlatform().getExternalObjectType(this.env.getConfiguration(), uri, local);
                }
                if (this.env.isImportedSchema(uri)) {
                    SchemaType st;
                    int fp = this.env.getNamePool().getFingerprint(uri, local);
                    if (fp == -1) {
                        this.grumble("Unknown type " + qname, "XPST0051");
                    }
                    if ((st = this.env.getConfiguration().getSchemaType(fp)) == null) {
                        this.grumble("Unknown atomic type " + qname, "XPST0051");
                        break block24;
                    } else {
                        if (st.isAtomicType()) {
                            return (AtomicType)st;
                        }
                        if (st.isComplexType()) {
                            this.grumble("Type (" + qname + ") is a complex type", "XPST0051");
                            return null;
                        }
                        this.grumble("Type (" + qname + ") is a list or union type", "XPST0051");
                        return null;
                    }
                }
                if (uri.length() == 0) {
                    this.grumble("There is no imported schema for the null namespace", "XPST0051");
                    return null;
                }
                this.grumble("There is no imported schema for namespace " + uri, "XPST0051");
                return null;
            }
        }
        this.grumble("Unknown atomic type " + qname, "XPST0051");
        return null;
    }

    private Expression parseComparisonExpression() throws XPathException {
        Expression exp = this.parseRangeExpression();
        switch (this.t.currentToken) {
            case 20: 
            case 37: 
            case 38: {
                int op = this.t.currentToken;
                this.nextToken();
                exp = new IdentityComparison(exp, op, this.parseRangeExpression());
                this.setLocation(exp);
                return exp;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                int op = this.t.currentToken;
                this.nextToken();
                exp = new GeneralComparison(exp, op, this.parseRangeExpression());
                this.setLocation(exp);
                return exp;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int op = this.t.currentToken;
                this.nextToken();
                exp = new ValueComparison(exp, op, this.parseRangeExpression());
                this.setLocation(exp);
                return exp;
            }
        }
        return exp;
    }

    private Expression parseRangeExpression() throws XPathException {
        Expression exp = this.parseAdditiveExpression();
        if (this.t.currentToken == 29) {
            this.nextToken();
            exp = new RangeExpression(exp, 29, this.parseAdditiveExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    public SequenceType parseSequenceType() throws XPathException {
        int occurrenceFlag;
        ItemType primaryType = this.parseItemType();
        if (primaryType instanceof EmptySequenceTest) {
            return SequenceType.makeSequenceType(primaryType, 8192);
        }
        switch (this.t.currentToken) {
            case 17: 
            case 207: {
                occurrenceFlag = 57344;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 15: {
                occurrenceFlag = 49152;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 213: {
                occurrenceFlag = 24576;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            default: {
                occurrenceFlag = 16384;
            }
        }
        return SequenceType.makeSequenceType(primaryType, occurrenceFlag);
    }

    protected ItemType parseItemType() throws XPathException {
        ItemType primaryType;
        if (this.t.currentToken == 5) {
            primaryType = this.parseParenthesizedItemType();
        } else if (this.t.currentToken == 201) {
            primaryType = this.getAtomicType(this.t.currentTokenValue);
            this.nextToken();
        } else if (this.t.currentToken == 69) {
            if (this.t.currentTokenValue.equals("item")) {
                this.nextToken();
                this.expect(204);
                this.nextToken();
                primaryType = AnyItemType.getInstance();
            } else if (this.t.currentTokenValue.equals("function")) {
                primaryType = this.parseFunctionItemType();
            } else if (this.t.currentTokenValue.equals("empty-sequence")) {
                this.nextToken();
                this.expect(204);
                this.nextToken();
                primaryType = EmptySequenceTest.getInstance();
            } else {
                primaryType = this.parseKindTest();
            }
        } else {
            this.grumble("Expected type name in SequenceType, found " + Token.tokens[this.t.currentToken]);
            return null;
        }
        return primaryType;
    }

    protected ItemType parseFunctionItemType() throws XPathException {
        this.grumble("The item type function() is available only when XQuery 1.1 is enabled");
        return null;
    }

    protected ItemType parseParenthesizedItemType() throws XPathException {
        this.grumble("A parenthesized item type is allowed only when XQuery 1.1 is enabled");
        return null;
    }

    private Expression parseAdditiveExpression() throws XPathException {
        Expression exp = this.parseMultiplicativeExpression();
        while (this.t.currentToken == 15 || this.t.currentToken == 16) {
            int op = this.t.currentToken;
            this.nextToken();
            exp = new ArithmeticExpression(exp, op, this.parseMultiplicativeExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseMultiplicativeExpression() throws XPathException {
        Expression exp = this.parseUnionExpression();
        while (this.t.currentToken == 17 || this.t.currentToken == 18 || this.t.currentToken == 56 || this.t.currentToken == 19) {
            int op = this.t.currentToken;
            this.nextToken();
            exp = new ArithmeticExpression(exp, op, this.parseUnionExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseUnaryExpression() throws XPathException {
        Expression exp;
        switch (this.t.currentToken) {
            case 16: {
                this.nextToken();
                exp = new ArithmeticExpression(new Literal(Int64Value.ZERO), 299, this.parseUnaryExpression());
                break;
            }
            case 15: {
                this.nextToken();
                exp = new ArithmeticExpression(new Literal(Int64Value.ZERO), 15, this.parseUnaryExpression());
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                exp = this.parseValidateExpression();
                break;
            }
            case 218: {
                exp = this.parseExtensionExpression();
                break;
            }
            default: {
                exp = this.parsePathExpression();
            }
        }
        this.setLocation(exp);
        return exp;
    }

    protected Expression parseUnionExpression() throws XPathException {
        Expression exp = this.parseIntersectExpression();
        while (this.t.currentToken == 1) {
            this.nextToken();
            exp = new VennExpression(exp, 1, this.parseIntersectExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    private Expression parseIntersectExpression() throws XPathException {
        Expression exp = this.parseInstanceOfExpression();
        while (this.t.currentToken == 23 || this.t.currentToken == 24) {
            int op = this.t.currentToken;
            this.nextToken();
            exp = new VennExpression(exp, op, this.parseInstanceOfExpression());
            this.setLocation(exp);
        }
        return exp;
    }

    protected boolean atStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 3: 
            case 5: 
            case 21: 
            case 34: 
            case 35: 
            case 41: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 218: {
                return true;
            }
            case 60: {
                return this.t.currentTokenValue.equals("ordered") || this.t.currentTokenValue.equals("unordered");
            }
        }
        return false;
    }

    protected boolean disallowedAtStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 45: 
            case 46: 
            case 47: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    protected Expression parsePathExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 2: {
                this.nextToken();
                RootExpression start = new RootExpression();
                this.setLocation(start);
                if (this.disallowedAtStartOfRelativePath()) {
                    this.grumble("Operator '" + Token.tokens[this.t.currentToken] + "' is not allowed after '/'");
                }
                if (this.atStartOfRelativePath()) {
                    Expression path = this.parseRemainingPath(start);
                    this.setLocation(path);
                    return path;
                }
                return start;
            }
            case 8: {
                this.nextToken();
                RootExpression start2 = new RootExpression();
                this.setLocation(start2);
                AxisExpression axisExp = new AxisExpression(5, null);
                this.setLocation(axisExp);
                Expression exp = this.parseRemainingPath(new SlashExpression(start2, axisExp));
                this.setLocation(exp);
                return exp;
            }
        }
        return this.parseRelativePath();
    }

    protected Expression parseRelativePath() throws XPathException {
        Expression exp = this.parseStepExpression(this.language == 1);
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            int op = this.t.currentToken;
            this.nextToken();
            Expression next = this.parseStepExpression(false);
            if (op == 2) {
                exp = new SlashExpression(exp, next);
            } else {
                AxisExpression ae = new AxisExpression(5, null);
                this.setLocation(ae);
                SlashExpression se = new SlashExpression(ae, next);
                this.setLocation(se);
                exp = new SlashExpression(exp, se);
            }
            this.setLocation(exp);
        }
        return exp;
    }

    protected Expression parseRemainingPath(Expression start) throws XPathException {
        Expression exp = start;
        int op = 2;
        while (true) {
            Expression next = this.parseStepExpression(false);
            if (op == 2) {
                exp = new SlashExpression(exp, next);
            } else {
                AxisExpression descOrSelf = new AxisExpression(5, null);
                this.setLocation(descOrSelf);
                SlashExpression step = new SlashExpression(descOrSelf, next);
                this.setLocation(step);
                exp = new SlashExpression(exp, step);
            }
            this.setLocation(exp);
            op = this.t.currentToken;
            if (op != 2 && op != 8) break;
            this.nextToken();
        }
        return exp;
    }

    protected Expression parseStepExpression(boolean firstInPattern) throws XPathException {
        boolean reverse;
        Expression step = this.parseBasicStep(firstInPattern);
        boolean bl = reverse = step instanceof AxisExpression && !Axis.isForwards[((AxisExpression)step).getAxis()];
        while (true) {
            if (this.t.currentToken == 4) {
                this.nextToken();
                Expression predicate = this.parsePredicate();
                this.expect(203);
                this.nextToken();
                step = new FilterExpression(step, predicate);
                this.setLocation(step);
                continue;
            }
            if (this.t.currentToken != 5) break;
            step = this.parseDynamicFunctionCall(step);
            this.setLocation(step);
        }
        if (reverse) {
            return SystemFunction.makeSystemFunction("reverse", new Expression[]{step});
        }
        return step;
    }

    protected Expression parsePredicate() throws XPathException {
        return this.parseExpression();
    }

    protected Expression parseBasicStep(boolean firstInPattern) throws XPathException {
        switch (this.t.currentToken) {
            case 21: {
                return this.parseVariableReference();
            }
            case 5: {
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.nextToken();
                    return new Literal(EmptySequence.getInstance());
                }
                Expression seq = this.parseExpression();
                this.expect(204);
                this.nextToken();
                return seq;
            }
            case 202: {
                return this.parseStringLiteral();
            }
            case 209: {
                return this.parseNumericLiteral();
            }
            case 34: {
                return this.parseFunctionCall();
            }
            case 205: {
                this.nextToken();
                ContextItemExpression cie = new ContextItemExpression();
                this.setLocation(cie);
                return cie;
            }
            case 206: {
                this.nextToken();
                ParentNodeExpression pne = new ParentNodeExpression();
                this.setLocation(pne);
                return pne;
            }
            case 69: {
                if (this.t.currentTokenValue.equals("function")) {
                    return this.parseInlineFunction();
                }
            }
            case 70: 
            case 201: 
            case 207: 
            case 208: {
                int defaultAxis = 3;
                if (this.t.currentToken == 69 && (this.t.currentTokenValue.equals("attribute") || this.t.currentTokenValue.equals("schema-attribute"))) {
                    defaultAxis = 2;
                } else if (firstInPattern && this.t.currentToken == 69 && this.t.currentTokenValue.equals("document-node")) {
                    defaultAxis = 12;
                }
                NodeTest test = this.parseNodeTest((short)1);
                if (test instanceof AnyNodeTest) {
                    test = defaultAxis == 3 ? AnyChildNodeTest.getInstance() : NodeKindTest.ATTRIBUTE;
                }
                AxisExpression ae = new AxisExpression((byte)defaultAxis, test);
                this.setLocation(ae);
                return ae;
            }
            case 3: {
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression ae2 = new AxisExpression(2, this.parseNodeTest((short)2));
                        this.setLocation(ae2);
                        return ae2;
                    }
                }
                this.grumble("@ must be followed by a NodeTest");
                break;
            }
            case 35: {
                byte axis;
                try {
                    axis = Axis.getAxisNumber(this.t.currentTokenValue);
                }
                catch (XPathException err) {
                    this.grumble(err.getMessage());
                    axis = 3;
                }
                if (axis == 8 && this.language == 3) {
                    this.grumble("The namespace axis is not available in XQuery");
                }
                short principalNodeType = Axis.principalNodeType[axis];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression ax = new AxisExpression(axis, this.parseNodeTest(principalNodeType));
                        this.setLocation(ax);
                        return ax;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 217: {
                return this.parseConstructor();
            }
            case 41: {
                return this.parseLiteralFunctionItem();
            }
            default: {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
            }
        }
        return null;
    }

    protected Expression parseNumericLiteral() throws XPathException {
        NumericValue number = NumericValue.parseNumber(this.t.currentTokenValue);
        if (number.isNaN()) {
            this.grumble("Invalid numeric literal " + Err.wrap(this.t.currentTokenValue, 4));
        }
        this.nextToken();
        Literal lit = new Literal(number);
        this.setLocation(lit);
        return lit;
    }

    protected Expression parseStringLiteral() throws XPathException {
        Literal literal = this.makeStringLiteral(this.t.currentTokenValue);
        this.nextToken();
        return literal;
    }

    protected Expression parseVariableReference() throws XPathException {
        Expression ref;
        this.nextToken();
        this.expect(201);
        String var = this.t.currentTokenValue;
        this.nextToken();
        if (this.scanOnly) {
            return new ContextItemExpression();
        }
        StructuredQName vtest = this.makeStructuredQName(var, false);
        Binding b = this.findRangeVariable(vtest);
        if (b != null) {
            ref = new LocalVariableReference(b);
        } else {
            try {
                ref = this.env.bindVariable(vtest);
            }
            catch (XPathException err) {
                if ("XPST0008".equals(err.getErrorCodeLocalPart())) {
                    this.grumble("Variable $" + var + " has not been declared", "XPST0008");
                    return null;
                }
                throw err;
            }
        }
        this.setLocation(ref);
        return ref;
    }

    protected Literal makeStringLiteral(String currentTokenValue) throws XPathException {
        StringLiteral literal = new StringLiteral(currentTokenValue);
        this.setLocation(literal);
        return literal;
    }

    protected Expression parseConstructor() throws XPathException {
        this.grumble("Node constructor expressions are allowed only in XQuery, not in XPath");
        return null;
    }

    protected Expression parseDynamicFunctionCall(Expression functionItem) throws XPathException {
        this.grumble("Unexpected '(' after primary expression. (Dynamic function calls are allowed only in XQuery 1.1)");
        return null;
    }

    protected NodeTest parseNodeTest(short nodeType) throws XPathException {
        int tok = this.t.currentToken;
        String tokv = this.t.currentTokenValue;
        switch (tok) {
            case 201: {
                this.nextToken();
                return this.makeNameTest(nodeType, tokv, nodeType == 1);
            }
            case 208: {
                this.nextToken();
                return this.makeNamespaceTest(nodeType, tokv);
            }
            case 70: {
                this.nextToken();
                tokv = this.t.currentTokenValue;
                this.expect(201);
                this.nextToken();
                return this.makeLocalNameTest(nodeType, tokv);
            }
            case 207: {
                this.nextToken();
                return NodeKindTest.makeNodeKindTest(nodeType);
            }
            case 69: {
                return this.parseKindTest();
            }
        }
        this.grumble("Unrecognized node test");
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private NodeTest parseKindTest() throws XPathException {
        typeName = this.t.currentTokenValue;
        schemaDeclaration = typeName.startsWith("schema-");
        primaryType = this.getSystemType(typeName);
        nameCode = -1;
        empty = false;
        this.nextToken();
        if (this.t.currentToken == 204) {
            if (schemaDeclaration) {
                this.grumble("schema-element() and schema-attribute() require a name to be supplied");
                return null;
            }
            empty = true;
            this.nextToken();
        }
        switch (primaryType) {
            case 88: {
                this.grumble("item() is not allowed in a path expression");
                return null;
            }
            case 0: {
                if (empty) {
                    return AnyNodeTest.getInstance();
                }
                this.grumble("No arguments are allowed in node()");
                return null;
            }
            case 3: {
                if (empty) {
                    return NodeKindTest.TEXT;
                }
                this.grumble("No arguments are allowed in text()");
                return null;
            }
            case 8: {
                if (empty) {
                    return NodeKindTest.COMMENT;
                }
                this.grumble("No arguments are allowed in comment()");
                return null;
            }
            case 13: {
                if (empty) {
                    if (!this.isNamespaceTestAllowed()) {
                        this.grumble("namespace-node() test is not allowed in XPath 2.0/XQuery 1.0");
                    }
                    return NodeKindTest.NAMESPACE;
                }
                this.grumble("No arguments are allowed in namespace-node()");
                return null;
            }
            case 9: {
                if (empty) {
                    return NodeKindTest.DOCUMENT;
                }
                try {
                    innerType = this.getSystemType(this.t.currentTokenValue);
                }
                catch (XPathException err) {
                    innerType = 88;
                }
                if (innerType != 1) {
                    this.grumble("Argument to document-node() must be an element type descriptor");
                    return null;
                }
                inner = this.parseKindTest();
                this.expect(204);
                this.nextToken();
                return new DocumentNodeTest(inner);
            }
            case 7: {
                if (empty) {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                if (this.t.currentToken != 202) ** GOTO lbl64
                piName = Whitespace.trim(this.t.currentTokenValue);
                if (!this.nameChecker.isValidNCName(piName)) {
                    this.grumble("Processing instruction name must be a valid NCName", "XPTY0004");
                } else {
                    nameCode = this.env.getNamePool().allocate("", "", piName);
                }
                ** GOTO lbl76
lbl64:
                // 1 sources

                if (this.t.currentToken != 201) ** GOTO lbl75
                try {
                    parts = this.nameChecker.getQNameParts(this.t.currentTokenValue);
                    if (parts[0].length() != 0) ** GOTO lbl70
                    nameCode = this.makeNameCode(parts[1], false);
                    ** GOTO lbl76
lbl70:
                    // 1 sources

                    this.grumble("Processing instruction name must not contain a colon");
                }
                catch (QNameException e) {
                    this.grumble("Invalid processing instruction name. " + e.getMessage());
                }
                ** GOTO lbl76
lbl75:
                // 1 sources

                this.grumble("Processing instruction name must be a QName or a string literal");
lbl76:
                // 6 sources

                this.nextToken();
                this.expect(204);
                this.nextToken();
                return new NameTest(7, nameCode, this.env.getNamePool());
            }
            case 1: 
            case 2: {
                nodeName = "";
                if (empty) {
                    return NodeKindTest.makeNodeKindTest(primaryType);
                }
                if (this.t.currentToken == 207 || this.t.currentToken == 17) {
                    if (schemaDeclaration) {
                        this.grumble("schema-element() and schema-attribute() must specify an actual name, not '*'");
                        return null;
                    }
                    nameCode = -1;
                } else if (this.t.currentToken == 201) {
                    nodeName = this.t.currentTokenValue;
                    nameCode = this.makeNameCode(this.t.currentTokenValue, primaryType == 1);
                } else {
                    this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after '(' in SequenceType");
                }
                suri = null;
                if (nameCode != -1) {
                    suri = this.env.getNamePool().getURI(nameCode);
                }
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.nextToken();
                    if (nameCode == -1) {
                        return NodeKindTest.makeNodeKindTest(primaryType);
                    }
                    if (primaryType == 2) {
                        if (schemaDeclaration) {
                            attributeDecl = this.env.getConfiguration().getAttributeDeclaration(nameCode & 1048575);
                            if (!this.env.isImportedSchema(suri)) {
                                this.grumble("No schema has been imported for namespace '" + suri + '\'', "XPST0008");
                            }
                            if (attributeDecl == null) {
                                this.grumble("There is no declaration for attribute @" + nodeName + " in an imported schema", "XPST0008");
                                return null;
                            }
                            return attributeDecl.makeSchemaNodeTest();
                        }
                        nameTest = new NameTest(2, nameCode, this.env.getNamePool());
                        return nameTest;
                    }
                    if (schemaDeclaration) {
                        if (!this.env.isImportedSchema(suri)) {
                            this.grumble("No schema has been imported for namespace '" + suri + '\'', "XPST0008");
                        }
                        if ((elementDecl = this.env.getConfiguration().getElementDeclaration(nameCode & 1048575)) == null) {
                            this.grumble("There is no declaration for element <" + nodeName + "> in an imported schema", "XPST0008");
                            return null;
                        }
                        return elementDecl.makeSchemaNodeTest();
                    }
                    nameTest = new NameTest(1, nameCode, this.env.getNamePool());
                    return nameTest;
                }
                if (this.t.currentToken == 7) {
                    if (schemaDeclaration) {
                        this.grumble("schema-element() and schema-attribute() must have one argument only");
                        return null;
                    }
                    this.nextToken();
                    if (this.t.currentToken == 207) {
                        this.grumble("'*' is no longer permitted as the second argument of element() and attribute()");
                        return null;
                    }
                    if (this.t.currentToken == 201) {
                        contentType = this.makeNameCode(this.t.currentTokenValue, true) & 1048575;
                        uri = this.env.getNamePool().getURI(contentType);
                        lname = this.env.getNamePool().getLocalName(contentType);
                        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
                            schemaType = this.env.getConfiguration().getSchemaType(contentType);
                        } else {
                            if (!this.env.isImportedSchema(uri)) {
                                this.grumble("No schema has been imported for namespace '" + uri + '\'', "XPST0008");
                            }
                            schemaType = this.env.getConfiguration().getSchemaType(contentType);
                        }
                        if (schemaType == null) {
                            this.grumble("Unknown type name " + lname, "XPST0008");
                            return null;
                        }
                        if (primaryType == 2 && schemaType.isComplexType()) {
                            this.warning("An attribute cannot have a complex type");
                        }
                        typeTest = new ContentTypeTest(primaryType, schemaType, this.env.getConfiguration());
                        if (nameCode == -1) {
                            result /* !! */  = typeTest;
                            if (primaryType == 2) {
                                this.nextToken();
                            } else {
                                this.nextToken();
                                if (this.t.currentToken == 213) {
                                    typeTest.setNillable(true);
                                    this.nextToken();
                                }
                            }
                        } else if (primaryType == 2) {
                            nameTest = new NameTest(2, nameCode, this.env.getNamePool());
                            result /* !! */  = new CombinedNodeTest(nameTest, 23, typeTest);
                            this.nextToken();
                        } else {
                            nameTest = new NameTest(1, nameCode, this.env.getNamePool());
                            result /* !! */  = new CombinedNodeTest(nameTest, 23, typeTest);
                            this.nextToken();
                            if (this.t.currentToken == 213) {
                                typeTest.setNillable(true);
                                this.nextToken();
                            }
                        }
                    } else {
                        this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after ',' in SequenceType");
                        return null;
                    }
                    this.expect(204);
                    this.nextToken();
                    return result /* !! */ ;
                }
                this.grumble("Expected ')' or ',' in SequenceType");
                return null;
            }
        }
        this.grumble("Unknown node kind");
        return null;
    }

    protected boolean isNamespaceTestAllowed() {
        return this.allowXPath30Syntax;
    }

    private int getSystemType(String name) throws XPathException {
        if ("item".equals(name)) {
            return 88;
        }
        if ("document-node".equals(name)) {
            return 9;
        }
        if ("element".equals(name)) {
            return 1;
        }
        if ("schema-element".equals(name)) {
            return 1;
        }
        if ("attribute".equals(name)) {
            return 2;
        }
        if ("schema-attribute".equals(name)) {
            return 2;
        }
        if ("text".equals(name)) {
            return 3;
        }
        if ("comment".equals(name)) {
            return 8;
        }
        if ("processing-instruction".equals(name)) {
            return 7;
        }
        if ("namespace-node".equals(name)) {
            return 13;
        }
        if ("node".equals(name)) {
            return 0;
        }
        this.grumble("Unknown type " + name);
        return -1;
    }

    protected Expression parseFunctionCall() throws XPathException {
        Expression fcall;
        String fname = this.t.currentTokenValue;
        int offset = this.t.currentTokenStartOffset;
        ArrayList<Expression> args = new ArrayList<Expression>(10);
        StructuredQName functionName = this.resolveFunctionName(fname);
        IntArraySet placeMarkers = null;
        this.nextToken();
        if (this.t.currentToken != 204) {
            while (true) {
                Expression arg;
                if ((arg = this.parseFunctionArgument()) == null) {
                    if (placeMarkers == null) {
                        placeMarkers = new IntArraySet();
                    }
                    placeMarkers.add(args.size());
                    arg = new Literal(EmptySequence.getInstance());
                }
                args.add(arg);
                if (this.t.currentToken != 7) break;
                this.nextToken();
            }
            this.expect(204);
        }
        this.nextToken();
        if (this.scanOnly) {
            return new StringLiteral(StringValue.EMPTY_STRING);
        }
        Expression[] arguments = new Expression[args.size()];
        args.toArray(arguments);
        if (placeMarkers != null) {
            return this.makeCurriedFunction(functionName, arguments, placeMarkers);
        }
        try {
            fcall = this.env.getFunctionLibrary().bind(functionName, arguments, this.env, this.defaultContainer);
        }
        catch (XPathException err) {
            if (err.getErrorCodeQName() == null) {
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
            }
            this.grumble(err.getMessage(), err.getErrorCodeQName(), offset);
            return null;
        }
        if (fcall == null) {
            String msg = "Cannot find a matching " + arguments.length + "-argument function named " + functionName.getClarkName() + "()";
            if (this.env.getConfiguration().isAllowExternalFunctions()) {
                SequenceType[] sig = this.env.getFunctionLibrary().getFunctionSignature(functionName, -1);
                if (sig != null) {
                    msg = msg + ". The namespace URI and local name are recognized, but the number of arguments is wrong";
                } else {
                    String actualURI = functionName.getNamespaceURI();
                    String similarNamespace = NamespaceConstant.findSimilarNamespace(actualURI);
                    if (similarNamespace != null) {
                        msg = similarNamespace.equals(actualURI) ? (similarNamespace.equals("http://saxon.sf.net/") && this.env.getConfiguration().getEditionCode().equals("HE") ? msg + ". Saxon extension functions are not available under Saxon-HE" : (similarNamespace.equals("http://saxon.sf.net/") && !this.env.getConfiguration().isLicensedFeature(64) ? msg + ". Saxon extension functions require a Saxon-PE or Saxon-EE license" : msg + ". There is no Saxon extension function with the local name " + functionName.getLocalName())) : msg + ". Perhaps the intended namespace was '" + similarNamespace + "'";
                    } else if (actualURI.contains("java")) {
                        msg = this.env.getConfiguration().getEditionCode().equals("HE") ? msg + ". Note that direct calls to Java methods are not available under Saxon-HE" : msg + ". For diagnostics on calls to Java methods, use the -TJ command line option or set the Configuration property FeatureKeys.TRACE_EXTERNAL_FUNCTIONS";
                    } else if (actualURI.startsWith("clitype:")) {
                        msg = this.env.getConfiguration().getEditionCode().equals("HE") ? msg + ". Note that direct calls to external .NET methods are not available under Saxon-HE" : msg + ". For diagnostics on calls to .NET methods, use the -TJ command line optionor call processor.SetProperty(\"http://saxon.sf.net/feature/trace-external-functions\", \"true\")";
                    }
                }
            } else {
                msg = msg + ". External function calls have been disabled";
            }
            if (this.env.isInBackwardsCompatibleMode()) {
                XPathException err = new XPathException(msg, "XTDE1425");
                ErrorExpression exp = new ErrorExpression(err);
                this.setLocation(exp);
                return exp;
            }
            this.grumble(msg, "XPST0017", offset);
            return null;
        }
        if (fcall instanceof CastExpression && ((AtomicType)fcall.getItemType(this.env.getConfiguration().getTypeHierarchy())).isNamespaceSensitive() && arguments[0] instanceof StringLiteral) {
            try {
                AtomicValue av = CastExpression.castStringToQName(((StringLiteral)arguments[0]).getStringValue(), (AtomicType)fcall.getItemType(this.env.getConfiguration().getTypeHierarchy()), this.env);
                return new Literal(av);
            }
            catch (XPathException e) {
                this.grumble(e.getMessage(), e.getErrorCodeQName(), offset);
                return null;
            }
        }
        if (this.language == 1) {
            if (fcall instanceof RegexGroup) {
                return new Literal(EmptySequence.getInstance());
            }
            if (fcall instanceof CurrentGroup) {
                this.grumble("The current-group() function cannot be used in a pattern", "XTSE1060", offset);
                return null;
            }
            if (fcall instanceof CurrentGroupingKey) {
                this.grumble("The current-grouping-key() function cannot be used in a pattern", "XTSE1070", offset);
                return null;
            }
        }
        this.setLocation(fcall, offset);
        for (int a = 0; a < arguments.length; ++a) {
            fcall.adoptChildExpression(arguments[a]);
        }
        return this.makeTracer(offset, fcall, 2009, functionName);
    }

    protected StructuredQName resolveFunctionName(String fname) throws XPathException {
        ItemType t;
        String local;
        String uri;
        StructuredQName functionName;
        int offset = this.t.currentTokenStartOffset;
        if (fname.startsWith("{")) {
            if (!this.allowXPath30Syntax) {
                this.grumble("Expanded QName syntax requires XPath 3.0/XQuery 3.0");
            }
            functionName = StructuredQName.fromClarkName(fname);
            uri = functionName.getNamespaceURI();
            local = functionName.getLocalName();
        } else {
            String[] parts;
            try {
                parts = this.nameChecker.getQNameParts(fname);
            }
            catch (QNameException e) {
                this.grumble("Function name is not a valid QName: " + fname + "()", "XPST0003", offset);
                return null;
            }
            local = parts[1];
            if (parts[0].length() == 0) {
                uri = this.env.getDefaultFunctionNamespace();
            } else {
                try {
                    uri = this.env.getURIForPrefix(parts[0]);
                }
                catch (XPathException err) {
                    this.grumble(err.getMessage(), "XPST0081", offset);
                    return null;
                }
            }
            functionName = new StructuredQName(parts[0], uri, local);
        }
        if (uri.equals("http://www.w3.org/2001/XMLSchema") && (t = Type.getBuiltInItemType(uri, local)) instanceof BuiltInAtomicType && !this.env.isAllowedBuiltInType((BuiltInAtomicType)t)) {
            this.grumble("The type " + fname + " is not recognized by a Basic XSLT Processor. ", "XPST0080", offset);
            return null;
        }
        return functionName;
    }

    protected Expression parseFunctionArgument() throws XPathException {
        return this.parseExprSingle();
    }

    protected Expression parseLiteralFunctionItem() throws XPathException {
        this.grumble("Literal function items are allowed only in XPath 3.0 / XQuery 3.0");
        return null;
    }

    protected Expression parseInlineFunction() throws XPathException {
        this.grumble("Inline functions are allowed only in XQuery 1.1");
        return null;
    }

    protected Expression makeCurriedFunction(StructuredQName name, Expression[] args, IntSet placeMarkers) throws XPathException {
        this.grumble("Curried functions are allowed only in XPath/XQuery 3.0");
        return null;
    }

    public Stack<Binding> getRangeVariables() {
        return this.rangeVariables;
    }

    public void setRangeVariables(Stack<Binding> variables) {
        this.rangeVariables = variables;
    }

    public void declareRangeVariable(Binding declaration) throws XPathException {
        this.rangeVariables.push(declaration);
    }

    public void undeclareRangeVariable() {
        this.rangeVariables.pop();
    }

    protected Binding findRangeVariable(StructuredQName qName) {
        for (int v = this.rangeVariables.size() - 1; v >= 0; --v) {
            Binding b = (Binding)this.rangeVariables.elementAt(v);
            if (!b.getVariableQName().equals(qName)) continue;
            return b;
        }
        return null;
    }

    public void setRangeVariableStack(Stack<Binding> stack) {
        this.rangeVariables = stack;
    }

    public final int makeNameCode(String qname, boolean useDefault) throws XPathException {
        if (this.scanOnly) {
            return 386;
        }
        if (qname.startsWith("{")) {
            return this.env.getNamePool().allocateClarkName(qname);
        }
        try {
            String[] parts = this.nameChecker.getQNameParts(qname);
            String prefix = parts[0];
            if (prefix.length() == 0) {
                if (useDefault) {
                    String uri = this.env.getDefaultElementNamespace();
                    return this.env.getNamePool().allocate("", uri, qname);
                }
                return this.env.getNamePool().allocate("", "", qname);
            }
            try {
                String uri = this.env.getURIForPrefix(prefix);
                return this.env.getNamePool().allocate(prefix, uri, parts[1]);
            }
            catch (XPathException err) {
                this.grumble(err.getMessage(), err.getErrorCodeQName(), -1);
                return -1;
            }
        }
        catch (QNameException e) {
            this.grumble(e.getMessage());
            return -1;
        }
    }

    public final int makeNameCodeSilently(String qname, boolean useDefault) throws XPathException, QNameException {
        if (this.scanOnly) {
            return 386;
        }
        String[] parts = this.nameChecker.getQNameParts(qname);
        String prefix = parts[0];
        if (prefix.length() == 0) {
            if (useDefault) {
                String uri = this.env.getDefaultElementNamespace();
                return this.env.getNamePool().allocate("", uri, qname);
            }
            return this.env.getNamePool().allocate("", "", qname);
        }
        String uri = this.env.getURIForPrefix(prefix);
        return this.env.getNamePool().allocate(prefix, uri, parts[1]);
    }

    public final StructuredQName makeStructuredQName(String qname, boolean useDefault) throws XPathException {
        if (this.scanOnly) {
            return null;
        }
        if (qname.startsWith("{")) {
            return StructuredQName.fromClarkName(qname);
        }
        try {
            String[] parts = this.nameChecker.getQNameParts(qname);
            String prefix = parts[0];
            if (prefix.length() == 0) {
                if (useDefault) {
                    String uri = this.env.getDefaultElementNamespace();
                    return new StructuredQName("", uri, qname);
                }
                return new StructuredQName("", "", qname);
            }
            try {
                String uri = this.env.getURIForPrefix(prefix);
                return new StructuredQName(prefix, uri, parts[1]);
            }
            catch (XPathException err) {
                this.grumble(err.getMessage(), err.getErrorCodeQName(), -1);
                return null;
            }
        }
        catch (QNameException e) {
            this.grumble(e.getMessage());
            return null;
        }
    }

    public NameTest makeNameTest(short nodeType, String qname, boolean useDefault) throws XPathException {
        int nameCode = this.makeNameCode(qname, useDefault);
        return new NameTest(nodeType, nameCode, this.env.getNamePool());
    }

    public NamespaceTest makeNamespaceTest(short nodeType, String prefix) throws XPathException {
        String uri;
        if (this.scanOnly) {
            return new NamespaceTest(this.env.getNamePool(), nodeType, "http://saxon.sf.net/");
        }
        if (prefix.charAt(0) == '{') {
            int closeBrace = prefix.indexOf(125);
            uri = prefix.substring(1, closeBrace);
        } else {
            try {
                uri = this.env.getURIForPrefix(prefix);
            }
            catch (XPathException e) {
                this.grumble(e.getMessage(), "XPST0081");
                return null;
            }
        }
        return new NamespaceTest(this.env.getNamePool(), nodeType, uri);
    }

    public LocalNameTest makeLocalNameTest(short nodeType, String localName) throws XPathException {
        if (!this.nameChecker.isValidNCName(localName)) {
            this.grumble("Local name [" + localName + "] contains invalid characters");
        }
        return new LocalNameTest(this.env.getNamePool(), nodeType, localName);
    }

    protected void setLocation(Expression exp) {
        this.setLocation(exp, this.t.currentTokenStartOffset);
    }

    public void setLocation(Expression exp, int offset) {
        int line = this.t.getLineNumber(offset);
        if (exp.getLocationId() == -1) {
            int loc = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), line);
            exp.setLocationId(loc);
        }
        if (exp.getContainer() == null) {
            exp.setContainer(this.defaultContainer);
        }
    }

    public Expression makeTracer(int startOffset, Expression exp, int construct, StructuredQName qName) {
        if (this.isCompileWithTracing()) {
            TraceExpression trace = new TraceExpression(exp);
            long lc = this.t.getLineAndColumn(startOffset);
            trace.setLineNumber((int)(lc >> 32));
            trace.setColumnNumber((int)(lc & Integer.MAX_VALUE));
            trace.setSystemId(this.env.getSystemId());
            trace.setNamespaceResolver(this.env.getNamespaceResolver());
            trace.setConstructType(construct);
            trace.setObjectName(qName);
            return trace;
        }
        return exp;
    }

    protected boolean isKeyword(String s) {
        return this.t.currentToken == 201 && this.t.currentTokenValue.equals(s);
    }

    protected String normalizeEQName(String s) throws XPathException {
        if (!Whitespace.containsWhitespace(s)) {
            return s;
        }
        StructuredQName sq = StructuredQName.fromClarkName(s);
        CharSequence uri = Whitespace.collapseWhitespace(sq.getNamespaceURI());
        return "{" + uri + "}" + sq.getLocalName();
    }

    public void setScanOnly(boolean scanOnly) {
        this.scanOnly = scanOnly;
    }

    protected static class TemporaryContainer
    implements Container,
    LocationProvider,
    Serializable {
        private LocationMap map;
        private int locationId;
        private Executable executable;

        public TemporaryContainer(LocationMap map, int locationId) {
            this.map = map;
            this.locationId = locationId;
        }

        public int getContainerGranularity() {
            return 0;
        }

        public void setExecutable(Executable exec) {
            this.executable = exec;
        }

        public Executable getExecutable() {
            return this.executable;
        }

        public LocationProvider getLocationProvider() {
            return this.map;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return this.map.getSystemId(this.locationId);
        }

        public int getLineNumber() {
            return this.map.getLineNumber(this.locationId);
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId(long locationId) {
            return this.getSystemId();
        }

        public int getLineNumber(long locationId) {
            return this.getLineNumber();
        }

        public int getColumnNumber(long locationId) {
            return this.getColumnNumber();
        }

        public int getHostLanguage() {
            return 54;
        }
    }

    public static class ForClause
    implements FLWORClause {
        public Assignation rangeVariable;
        public PositionVariable positionVariable;
        public Expression sequence;
        public SequenceType requiredType;
        public int offset;
        public boolean isOuterFor;

        public int numberOfRangeVariables() {
            return this.positionVariable == null ? 1 : 2;
        }
    }

    public static interface FLWORClause {
        public int numberOfRangeVariables();
    }
}

