/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.sort.QuickSort;
import com.icl.saxon.sort.Sortable;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class NodeSetExtent
extends NodeSetValue
implements Sortable,
NodeList {
    private NodeInfo[] value;
    private int length;
    private boolean sorted;
    private boolean reverseSorted;
    private NodeOrderComparer comparer;

    public NodeSetExtent(NodeOrderComparer nodeOrderComparer) {
        this.comparer = nodeOrderComparer;
        this.value = new NodeInfo[0];
        this.length = 0;
        this.sorted = true;
        this.reverseSorted = true;
    }

    public NodeSetExtent(NodeInfo[] nodeInfoArray, NodeOrderComparer nodeOrderComparer) {
        this.value = nodeInfoArray;
        this.length = nodeInfoArray.length;
        this.sorted = this.length < 2;
        this.reverseSorted = this.length < 2;
        this.comparer = nodeOrderComparer;
    }

    public NodeSetExtent(Vector vector, NodeOrderComparer nodeOrderComparer) {
        this.value = new NodeInfo[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.value[n] = (NodeInfo)vector.elementAt(n);
            ++n;
        }
        this.length = vector.size();
        this.sorted = this.length < 2;
        this.reverseSorted = this.length < 2;
        this.comparer = nodeOrderComparer;
    }

    public NodeSetExtent(NodeEnumeration nodeEnumeration, NodeOrderComparer nodeOrderComparer) throws XPathException {
        this.comparer = nodeOrderComparer;
        int n = 20;
        this.value = new NodeInfo[n];
        int n2 = 0;
        while (nodeEnumeration.hasMoreElements()) {
            if (n2 >= n) {
                NodeInfo[] nodeInfoArray = new NodeInfo[n *= 2];
                System.arraycopy(this.value, 0, nodeInfoArray, 0, n2);
                this.value = nodeInfoArray;
            }
            this.value[n2++] = nodeEnumeration.nextElement();
        }
        this.sorted = nodeEnumeration.isSorted() || n2 < 2;
        this.reverseSorted = nodeEnumeration.isReverseSorted() || n2 < 2;
        this.length = n2;
    }

    public void append(NodeInfo nodeInfo) {
        this.reverseSorted = false;
        if (this.value.length < this.length + 1) {
            NodeInfo[] nodeInfoArray = new NodeInfo[this.length == 0 ? 10 : this.length * 2];
            System.arraycopy(this.value, 0, nodeInfoArray, 0, this.length);
            this.value = nodeInfoArray;
        }
        if (this.length > 0 && this.value[this.length - 1].isSameNodeInfo(nodeInfo)) {
            return;
        }
        this.value[this.length++] = nodeInfo;
    }

    public Expression simplify() {
        if (this.length == 0) {
            return new EmptyNodeSet();
        }
        if (this.length == 1) {
            return new SingletonNodeSet(this.value[0]);
        }
        return this;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public String asString() {
        return this.length > 0 ? this.getFirst().getStringValue() : "";
    }

    public boolean asBoolean() throws XPathException {
        return this.length > 0;
    }

    public int getCount() {
        this.sort();
        return this.length;
    }

    public NodeSetValue sort() {
        if (this.length < 2) {
            this.sorted = true;
        }
        if (this.sorted) {
            return this;
        }
        if (this.reverseSorted) {
            NodeInfo[] nodeInfoArray = new NodeInfo[this.length];
            int n = 0;
            while (n < this.length) {
                nodeInfoArray[n] = this.value[this.length - n - 1];
                ++n;
            }
            this.value = nodeInfoArray;
            this.sorted = true;
            this.reverseSorted = false;
        } else {
            QuickSort.sort(this, 0, this.length - 1);
            int n = 1;
            int n2 = 1;
            while (n2 < this.length) {
                if (!this.value[n2].isSameNodeInfo(this.value[n2 - 1])) {
                    this.value[n++] = this.value[n2];
                }
                ++n2;
            }
            this.length = n;
            this.sorted = true;
            this.reverseSorted = false;
        }
        return this;
    }

    public NodeInfo getFirst() {
        if (this.length == 0) {
            return null;
        }
        if (this.sorted) {
            return this.value[0];
        }
        NodeInfo nodeInfo = this.value[0];
        int n = 1;
        while (n < this.length) {
            if (this.comparer.compare(this.value[n], nodeInfo) < 0) {
                nodeInfo = this.value[n];
            }
            ++n;
        }
        return nodeInfo;
    }

    public NodeInfo selectFirst(Context context) {
        return this.getFirst();
    }

    public NodeEnumeration enumerate() {
        return new NodeSetValueEnumeration();
    }

    public int getLength() {
        return this.getCount();
    }

    public Node item(int n) {
        this.sort();
        if (this.length > n && this.value[n] instanceof Node) {
            return (Node)((Object)this.value[n]);
        }
        return null;
    }

    public int compare(int n, int n2) {
        return this.comparer.compare(this.value[n], this.value[n2]);
    }

    public void swap(int n, int n2) {
        NodeInfo nodeInfo = this.value[n];
        this.value[n] = this.value[n2];
        this.value[n2] = nodeInfo;
    }

    private class NodeSetValueEnumeration
    implements AxisEnumeration,
    LastPositionFinder {
        int index = 0;

        public boolean hasMoreElements() {
            return this.index < NodeSetExtent.this.length;
        }

        public NodeInfo nextElement() {
            return NodeSetExtent.this.value[this.index++];
        }

        public boolean isSorted() {
            return NodeSetExtent.this.sorted;
        }

        public boolean isReverseSorted() {
            return NodeSetExtent.this.reverseSorted;
        }

        public boolean isPeer() {
            return false;
        }

        public int getLastPosition() {
            return NodeSetExtent.this.length;
        }
    }
}

