/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.S9apiUtils;
import java.net.URI;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Logger;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;

public class ReadableInline
implements ReadablePipe {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private boolean readSeqOk = false;
    private int pos = 0;
    private Step reader = null;

    public ReadableInline(XProcRuntime runtime, Vector<XdmValue> nodes, HashSet<String> excludeNS) {
        this.runtime = runtime;
        this.documents = new DocumentSequence(runtime);
        XdmDestination dest = new XdmDestination();
        XdmNode p_inline = null;
        if (nodes.size() > 0) {
            p_inline = ((XdmNode)nodes.get(this.pos)).getParent();
        }
        XdmNode node = null;
        for (int pos = 0; pos < nodes.size() && node == null; ++pos) {
            if (((XdmNode)nodes.get(pos)).getNodeKind() != XdmNodeKind.ELEMENT) continue;
            node = (XdmNode)nodes.get(pos);
        }
        if (node == null) {
            throw XProcException.dynamicError(1, p_inline, "Invalid inline content");
        }
        URI baseURI = null;
        baseURI = node.getAttributeValue(XProcConstants.xml_base) == null ? node.getBaseURI() : node.getParent().getBaseURI();
        try {
            S9apiUtils.writeXdmValue(runtime, nodes, (Destination)dest, baseURI);
            XdmNode doc = dest.getXdmNode();
            doc = S9apiUtils.removeNamespaces(runtime, doc, excludeNS, true);
            runtime.finest(null, null, "Instantiate a ReadableInline");
            this.documents.add(doc);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }

    @Override
    public void canReadSequence(boolean sequence) {
        this.readSeqOk = sequence;
    }

    @Override
    public boolean readSequence() {
        return this.readSeqOk;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public boolean moreDocuments() {
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        XdmNode doc = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.runtime.finest(null, this.reader.getNode(), this.reader.getName() + " read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this);
        }
        return doc;
    }

    public String toString() {
        return "readableinline " + this.documents;
    }
}

