/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

public class Delete
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _recursive = new QName("recursive");
    private WritablePipe result = null;

    public Delete(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean recursive = this.getOption(_recursive, false);
        RuntimeValue href = this.getOption(_href);
        URI uri = href.getBaseURI().resolve(href.getString());
        if (!"file".equals(uri.getScheme())) {
            throw new XProcException(this.step.getNode(), "Only file: scheme URIs are supported by the delete step.");
        }
        File file = new File(uri.getPath());
        if (!file.exists()) {
            throw new XProcException(this.step.getNode(), "Cannot delete: file does not exist: " + file.getAbsolutePath());
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        tree.addText(file.toURI().toASCIIString());
        this.performDelete(file, recursive);
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    private void performDelete(File file, boolean recursive) {
        if (recursive && file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.performDelete(f, recursive);
            }
        }
        if (!file.delete()) {
            throw new XProcException(this.step.getNode(), "Delete failed for: " + file.getAbsolutePath());
        }
    }
}

