﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

// Source files represent a source generated JsonSerializerContext as produced by the .NET 7 SDK.
// Used to validate correctness of contexts generated by previous SDKs against the current System.Text.Json runtime components.
// Unless absolutely necessary DO NOT MODIFY any of these files -- it would invalidate the purpose of the regression tests.

// <auto-generated/>

#nullable enable annotations
#nullable disable warnings

// Suppress warnings about [Obsolete] member usage in generated code.
#pragma warning disable CS0618

namespace System.Text.Json.Tests.SourceGenRegressionTests.Net70
{
    public partial class Net70GeneratedContext
    {
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>>? _DictionaryStringHighLowTemps;
        /// <summary>
        /// Defines the source generated JSON serialization contract metadata for a given type.
        /// </summary>
        public global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>> DictionaryStringHighLowTemps
        {
            get => _DictionaryStringHighLowTemps ??= Create_DictionaryStringHighLowTemps(Options, makeReadOnly: true);
        }
        
        private global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>> Create_DictionaryStringHighLowTemps(global::System.Text.Json.JsonSerializerOptions options, bool makeReadOnly)
        {
            global::System.Text.Json.Serialization.Metadata.JsonTypeInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>>? jsonTypeInfo = null;
            global::System.Text.Json.Serialization.JsonConverter? customConverter;
            if (options.Converters.Count > 0 && (customConverter = GetRuntimeProvidedCustomConverter(options, typeof(global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>))) != null)
            {
                jsonTypeInfo = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateValueInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>>(options, customConverter);
            }
            else
            {
                global::System.Text.Json.Serialization.Metadata.JsonCollectionInfoValues<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>> info = new global::System.Text.Json.Serialization.Metadata.JsonCollectionInfoValues<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>>()
                {
                    ObjectCreator = () => new global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>(),
                    NumberHandling = default,
                    SerializeHandler = DictionaryStringHighLowTempsSerializeHandler
                };
        
                jsonTypeInfo = global::System.Text.Json.Serialization.Metadata.JsonMetadataServices.CreateDictionaryInfo<global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>, global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>(options, info);
        
            }
        
            if (makeReadOnly)
            {
                jsonTypeInfo.MakeReadOnly();
            }
        
            return jsonTypeInfo;
        }
        
        
        // Intentionally not a static method because we create a delegate to it. Invoking delegates to instance
        // methods is almost as fast as virtual calls. Static methods need to go through a shuffle thunk.
        private void DictionaryStringHighLowTempsSerializeHandler(global::System.Text.Json.Utf8JsonWriter writer, global::System.Collections.Generic.Dictionary<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps>? value)
        {
            if (value == null)
            {
                writer.WriteNullValue();
                return;
            }
        
            writer.WriteStartObject();
        
            foreach (global::System.Collections.Generic.KeyValuePair<global::System.String, global::System.Text.Json.Tests.SourceGenRegressionTests.Net70.HighLowTemps> pair in value)
            {
                writer.WritePropertyName(pair.Key);
                HighLowTempsSerializeHandler(writer, pair.Value!);
            }
        
            writer.WriteEndObject();
        }
    }
}
