import { getRect } from 'css-box-model';
import getMaxWindowScroll from './get-max-window-scroll';
import getWindowScroll from './get-window-scroll';
export default (() => {
  const scroll = getWindowScroll();
  const maxScroll = getMaxWindowScroll();
  const top = scroll.y;
  const left = scroll.x;

  // window.innerHeight: includes scrollbars (not what we want)
  // document.clientHeight gives us the correct value when using the html5 doctype
  const doc = document.documentElement;
  // Using these values as they do not consider scrollbars
  // padding box, without scrollbar
  const width = doc.clientWidth;
  const height = doc.clientHeight;

  // Computed
  const right = left + width;
  const bottom = top + height;
  const container = getRect({
    top,
    left,
    right,
    bottom
  });
  const viewport = {
    container,
    scroll: {
      current: scroll,
      max: maxScroll
    }
  };
  return viewport;
});