#!/bin/bash

file=$1
project=$(echo "$2" | cut -d = -f 2)

if [[ "$file" = "" ]] ; then
    echo "Usage:  $0 <file with smatch messages> -p=<project>"
    exit 1
fi

outfile="${project}.no_return_funcs"
bin_dir=$(dirname $0)
add_file=$(echo ${bin_dir}/../smatch_data/${outfile}.add)
remove=$(echo ${bin_dir}/../smatch_data/${outfile}.remove)
tmp=$(mktemp /tmp/smatch.XXXX)
tmp2=$(mktemp /tmp/smatch.XXXX)

echo "// list of functions which don't return." > $outfile
echo '// generated by `gen_no_return_funcs.sh`' >> $outfile
cat $(echo ${bin_dir}/../smatch_data/no_return_funcs) >> $outfile
cat $add_file >> $outfile 2> /dev/null

grep no_return_funcs $file | cut -d ' ' -f 2 | cut -d '(' -f 1 > $tmp

cat $tmp | sort -u > $tmp2
mv $tmp2 $tmp
cat $tmp $remove $remove 2> /dev/null | sort | uniq -u >> $outfile
rm $tmp
echo "Done.  List saved as '$outfile'"
echo "Copy it to smatch_data/<project>.no_return_funcs"
