/* SPDX-License-Identifier: Unicode-DFS-2016 */
/*
 * Capitalization tables
 */

struct capitalization_table {
	u16 upper;
	u16 lower;
};

/*
 * Correspondence table for small and capital Unicode letters in the range of
 * 0x0000 - 0xffff based on http://www.unicode.org/Public/UCA/11.0.0/allkeys.txt
 */
#define UNICODE_CAPITALIZATION_TABLE { \
	{ 0x0531, /* ARMENIAN CAPITAL LETTER AYB */ \
	  0x0561, /* ARMENIAN SMALL LETTER AYB */ }, \
	{ 0x0532, /* ARMENIAN CAPITAL LETTER BEN */ \
	  0x0562, /* ARMENIAN SMALL LETTER BEN */ }, \
	{ 0x053E, /* ARMENIAN CAPITAL LETTER CA */ \
	  0x056E, /* ARMENIAN SMALL LETTER CA */ }, \
	{ 0x0549, /* ARMENIAN CAPITAL LETTER CHA */ \
	  0x0579, /* ARMENIAN SMALL LETTER CHA */ }, \
	{ 0x0543, /* ARMENIAN CAPITAL LETTER CHEH */ \
	  0x0573, /* ARMENIAN SMALL LETTER CHEH */ }, \
	{ 0x0551, /* ARMENIAN CAPITAL LETTER CO */ \
	  0x0581, /* ARMENIAN SMALL LETTER CO */ }, \
	{ 0x0534, /* ARMENIAN CAPITAL LETTER DA */ \
	  0x0564, /* ARMENIAN SMALL LETTER DA */ }, \
	{ 0x0535, /* ARMENIAN CAPITAL LETTER ECH */ \
	  0x0565, /* ARMENIAN SMALL LETTER ECH */ }, \
	{ 0x0537, /* ARMENIAN CAPITAL LETTER EH */ \
	  0x0567, /* ARMENIAN SMALL LETTER EH */ }, \
	{ 0x0538, /* ARMENIAN CAPITAL LETTER ET */ \
	  0x0568, /* ARMENIAN SMALL LETTER ET */ }, \
	{ 0x0556, /* ARMENIAN CAPITAL LETTER FEH */ \
	  0x0586, /* ARMENIAN SMALL LETTER FEH */ }, \
	{ 0x0542, /* ARMENIAN CAPITAL LETTER GHAD */ \
	  0x0572, /* ARMENIAN SMALL LETTER GHAD */ }, \
	{ 0x0533, /* ARMENIAN CAPITAL LETTER GIM */ \
	  0x0563, /* ARMENIAN SMALL LETTER GIM */ }, \
	{ 0x0540, /* ARMENIAN CAPITAL LETTER HO */ \
	  0x0570, /* ARMENIAN SMALL LETTER HO */ }, \
	{ 0x053B, /* ARMENIAN CAPITAL LETTER INI */ \
	  0x056B, /* ARMENIAN SMALL LETTER INI */ }, \
	{ 0x0541, /* ARMENIAN CAPITAL LETTER JA */ \
	  0x0571, /* ARMENIAN SMALL LETTER JA */ }, \
	{ 0x054B, /* ARMENIAN CAPITAL LETTER JHEH */ \
	  0x057B, /* ARMENIAN SMALL LETTER JHEH */ }, \
	{ 0x0554, /* ARMENIAN CAPITAL LETTER KEH */ \
	  0x0584, /* ARMENIAN SMALL LETTER KEH */ }, \
	{ 0x053F, /* ARMENIAN CAPITAL LETTER KEN */ \
	  0x056F, /* ARMENIAN SMALL LETTER KEN */ }, \
	{ 0x053C, /* ARMENIAN CAPITAL LETTER LIWN */ \
	  0x056C, /* ARMENIAN SMALL LETTER LIWN */ }, \
	{ 0x0544, /* ARMENIAN CAPITAL LETTER MEN */ \
	  0x0574, /* ARMENIAN SMALL LETTER MEN */ }, \
	{ 0x0546, /* ARMENIAN CAPITAL LETTER NOW */ \
	  0x0576, /* ARMENIAN SMALL LETTER NOW */ }, \
	{ 0x0555, /* ARMENIAN CAPITAL LETTER OH */ \
	  0x0585, /* ARMENIAN SMALL LETTER OH */ }, \
	{ 0x054A, /* ARMENIAN CAPITAL LETTER PEH */ \
	  0x057A, /* ARMENIAN SMALL LETTER PEH */ }, \
	{ 0x0553, /* ARMENIAN CAPITAL LETTER PIWR */ \
	  0x0583, /* ARMENIAN SMALL LETTER PIWR */ }, \
	{ 0x054C, /* ARMENIAN CAPITAL LETTER RA */ \
	  0x057C, /* ARMENIAN SMALL LETTER RA */ }, \
	{ 0x0550, /* ARMENIAN CAPITAL LETTER REH */ \
	  0x0580, /* ARMENIAN SMALL LETTER REH */ }, \
	{ 0x054D, /* ARMENIAN CAPITAL LETTER SEH */ \
	  0x057D, /* ARMENIAN SMALL LETTER SEH */ }, \
	{ 0x0547, /* ARMENIAN CAPITAL LETTER SHA */ \
	  0x0577, /* ARMENIAN SMALL LETTER SHA */ }, \
	{ 0x054F, /* ARMENIAN CAPITAL LETTER TIWN */ \
	  0x057F, /* ARMENIAN SMALL LETTER TIWN */ }, \
	{ 0x0539, /* ARMENIAN CAPITAL LETTER TO */ \
	  0x0569, /* ARMENIAN SMALL LETTER TO */ }, \
	{ 0x054E, /* ARMENIAN CAPITAL LETTER VEW */ \
	  0x057E, /* ARMENIAN SMALL LETTER VEW */ }, \
	{ 0x0548, /* ARMENIAN CAPITAL LETTER VO */ \
	  0x0578, /* ARMENIAN SMALL LETTER VO */ }, \
	{ 0x053D, /* ARMENIAN CAPITAL LETTER XEH */ \
	  0x056D, /* ARMENIAN SMALL LETTER XEH */ }, \
	{ 0x0545, /* ARMENIAN CAPITAL LETTER YI */ \
	  0x0575, /* ARMENIAN SMALL LETTER YI */ }, \
	{ 0x0552, /* ARMENIAN CAPITAL LETTER YIWN */ \
	  0x0582, /* ARMENIAN SMALL LETTER YIWN */ }, \
	{ 0x0536, /* ARMENIAN CAPITAL LETTER ZA */ \
	  0x0566, /* ARMENIAN SMALL LETTER ZA */ }, \
	{ 0x053A, /* ARMENIAN CAPITAL LETTER ZHE */ \
	  0x056A, /* ARMENIAN SMALL LETTER ZHE */ }, \
	{ 0x24B6, /* CIRCLED LATIN CAPITAL LETTER A */ \
	  0x24D0, /* CIRCLED LATIN SMALL LETTER A */ }, \
	{ 0x24B7, /* CIRCLED LATIN CAPITAL LETTER B */ \
	  0x24D1, /* CIRCLED LATIN SMALL LETTER B */ }, \
	{ 0x24B8, /* CIRCLED LATIN CAPITAL LETTER C */ \
	  0x24D2, /* CIRCLED LATIN SMALL LETTER C */ }, \
	{ 0x24B9, /* CIRCLED LATIN CAPITAL LETTER D */ \
	  0x24D3, /* CIRCLED LATIN SMALL LETTER D */ }, \
	{ 0x24BA, /* CIRCLED LATIN CAPITAL LETTER E */ \
	  0x24D4, /* CIRCLED LATIN SMALL LETTER E */ }, \
	{ 0x24BB, /* CIRCLED LATIN CAPITAL LETTER F */ \
	  0x24D5, /* CIRCLED LATIN SMALL LETTER F */ }, \
	{ 0x24BC, /* CIRCLED LATIN CAPITAL LETTER G */ \
	  0x24D6, /* CIRCLED LATIN SMALL LETTER G */ }, \
	{ 0x24BD, /* CIRCLED LATIN CAPITAL LETTER H */ \
	  0x24D7, /* CIRCLED LATIN SMALL LETTER H */ }, \
	{ 0x24BE, /* CIRCLED LATIN CAPITAL LETTER I */ \
	  0x24D8, /* CIRCLED LATIN SMALL LETTER I */ }, \
	{ 0x24BF, /* CIRCLED LATIN CAPITAL LETTER J */ \
	  0x24D9, /* CIRCLED LATIN SMALL LETTER J */ }, \
	{ 0x24C0, /* CIRCLED LATIN CAPITAL LETTER K */ \
	  0x24DA, /* CIRCLED LATIN SMALL LETTER K */ }, \
	{ 0x24C1, /* CIRCLED LATIN CAPITAL LETTER L */ \
	  0x24DB, /* CIRCLED LATIN SMALL LETTER L */ }, \
	{ 0x24C2, /* CIRCLED LATIN CAPITAL LETTER M */ \
	  0x24DC, /* CIRCLED LATIN SMALL LETTER M */ }, \
	{ 0x24C3, /* CIRCLED LATIN CAPITAL LETTER N */ \
	  0x24DD, /* CIRCLED LATIN SMALL LETTER N */ }, \
	{ 0x24C4, /* CIRCLED LATIN CAPITAL LETTER O */ \
	  0x24DE, /* CIRCLED LATIN SMALL LETTER O */ }, \
	{ 0x24C5, /* CIRCLED LATIN CAPITAL LETTER P */ \
	  0x24DF, /* CIRCLED LATIN SMALL LETTER P */ }, \
	{ 0x24C6, /* CIRCLED LATIN CAPITAL LETTER Q */ \
	  0x24E0, /* CIRCLED LATIN SMALL LETTER Q */ }, \
	{ 0x24C7, /* CIRCLED LATIN CAPITAL LETTER R */ \
	  0x24E1, /* CIRCLED LATIN SMALL LETTER R */ }, \
	{ 0x24C8, /* CIRCLED LATIN CAPITAL LETTER S */ \
	  0x24E2, /* CIRCLED LATIN SMALL LETTER S */ }, \
	{ 0x24C9, /* CIRCLED LATIN CAPITAL LETTER T */ \
	  0x24E3, /* CIRCLED LATIN SMALL LETTER T */ }, \
	{ 0x24CA, /* CIRCLED LATIN CAPITAL LETTER U */ \
	  0x24E4, /* CIRCLED LATIN SMALL LETTER U */ }, \
	{ 0x24CB, /* CIRCLED LATIN CAPITAL LETTER V */ \
	  0x24E5, /* CIRCLED LATIN SMALL LETTER V */ }, \
	{ 0x24CC, /* CIRCLED LATIN CAPITAL LETTER W */ \
	  0x24E6, /* CIRCLED LATIN SMALL LETTER W */ }, \
	{ 0x24CD, /* CIRCLED LATIN CAPITAL LETTER X */ \
	  0x24E7, /* CIRCLED LATIN SMALL LETTER X */ }, \
	{ 0x24CE, /* CIRCLED LATIN CAPITAL LETTER Y */ \
	  0x24E8, /* CIRCLED LATIN SMALL LETTER Y */ }, \
	{ 0x24CF, /* CIRCLED LATIN CAPITAL LETTER Z */ \
	  0x24E9, /* CIRCLED LATIN SMALL LETTER Z */ }, \
	{ 0x2CC8, /* COPTIC CAPITAL LETTER AKHMIMIC KHEI */ \
	  0x2CC9, /* COPTIC SMALL LETTER AKHMIMIC KHEI */ }, \
	{ 0x2C80, /* COPTIC CAPITAL LETTER ALFA */ \
	  0x2C81, /* COPTIC SMALL LETTER ALFA */ }, \
	{ 0x2CF2, /* COPTIC CAPITAL LETTER BOHAIRIC KHEI */ \
	  0x2CF3, /* COPTIC SMALL LETTER BOHAIRIC KHEI */ }, \
	{ 0x2CC2, /* COPTIC CAPITAL LETTER CROSSED SHEI */ \
	  0x2CC3, /* COPTIC SMALL LETTER CROSSED SHEI */ }, \
	{ 0x2CB6, /* COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE */ \
	  0x2CB7, /* COPTIC SMALL LETTER CRYPTOGRAMMIC EIE */ }, \
	{ 0x2CED, /* COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA */ \
	  0x2CEE, /* COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA */ }, \
	{ 0x2CBC, /* COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI */ \
	  0x2CBD, /* COPTIC SMALL LETTER CRYPTOGRAMMIC NI */ }, \
	{ 0x2CEB, /* COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI */ \
	  0x2CEC, /* COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI */ }, \
	{ 0x2C86, /* COPTIC CAPITAL LETTER DALDA */ \
	  0x2C87, /* COPTIC SMALL LETTER DALDA */ }, \
	{ 0x03EE, /* COPTIC CAPITAL LETTER DEI */ \
	  0x03EF, /* COPTIC SMALL LETTER DEI */ }, \
	{ 0x2CB2, /* COPTIC CAPITAL LETTER DIALECT-P ALEF */ \
	  0x2CB3, /* COPTIC SMALL LETTER DIALECT-P ALEF */ }, \
	{ 0x2CCA, /* COPTIC CAPITAL LETTER DIALECT-P HORI */ \
	  0x2CCB, /* COPTIC SMALL LETTER DIALECT-P HORI */ }, \
	{ 0x2CB8, /* COPTIC CAPITAL LETTER DIALECT-P KAPA */ \
	  0x2CB9, /* COPTIC SMALL LETTER DIALECT-P KAPA */ }, \
	{ 0x2CBA, /* COPTIC CAPITAL LETTER DIALECT-P NI */ \
	  0x2CBB, /* COPTIC SMALL LETTER DIALECT-P NI */ }, \
	{ 0x2C88, /* COPTIC CAPITAL LETTER EIE */ \
	  0x2C89, /* COPTIC SMALL LETTER EIE */ }, \
	{ 0x03E4, /* COPTIC CAPITAL LETTER FEI */ \
	  0x03E5, /* COPTIC SMALL LETTER FEI */ }, \
	{ 0x2CAA, /* COPTIC CAPITAL LETTER FI */ \
	  0x2CAB, /* COPTIC SMALL LETTER FI */ }, \
	{ 0x2C84, /* COPTIC CAPITAL LETTER GAMMA */ \
	  0x2C85, /* COPTIC SMALL LETTER GAMMA */ }, \
	{ 0x03EA, /* COPTIC CAPITAL LETTER GANGIA */ \
	  0x03EB, /* COPTIC SMALL LETTER GANGIA */ }, \
	{ 0x2C8E, /* COPTIC CAPITAL LETTER HATE */ \
	  0x2C8F, /* COPTIC SMALL LETTER HATE */ }, \
	{ 0x03E8, /* COPTIC CAPITAL LETTER HORI */ \
	  0x03E9, /* COPTIC SMALL LETTER HORI */ }, \
	{ 0x2C92, /* COPTIC CAPITAL LETTER IAUDA */ \
	  0x2C93, /* COPTIC SMALL LETTER IAUDA */ }, \
	{ 0x2C94, /* COPTIC CAPITAL LETTER KAPA */ \
	  0x2C95, /* COPTIC SMALL LETTER KAPA */ }, \
	{ 0x03E6, /* COPTIC CAPITAL LETTER KHEI */ \
	  0x03E7, /* COPTIC SMALL LETTER KHEI */ }, \
	{ 0x2CAC, /* COPTIC CAPITAL LETTER KHI */ \
	  0x2CAD, /* COPTIC SMALL LETTER KHI */ }, \
	{ 0x2C9C, /* COPTIC CAPITAL LETTER KSI */ \
	  0x2C9D, /* COPTIC SMALL LETTER KSI */ }, \
	{ 0x2C96, /* COPTIC CAPITAL LETTER LAULA */ \
	  0x2C97, /* COPTIC SMALL LETTER LAULA */ }, \
	{ 0x2CD0, /* COPTIC CAPITAL LETTER L-SHAPED HA */ \
	  0x2CD1, /* COPTIC SMALL LETTER L-SHAPED HA */ }, \
	{ 0x2C98, /* COPTIC CAPITAL LETTER MI */ \
	  0x2C99, /* COPTIC SMALL LETTER MI */ }, \
	{ 0x2C9A, /* COPTIC CAPITAL LETTER NI */ \
	  0x2C9B, /* COPTIC SMALL LETTER NI */ }, \
	{ 0x2C9E, /* COPTIC CAPITAL LETTER O */ \
	  0x2C9F, /* COPTIC SMALL LETTER O */ }, \
	{ 0x2CB4, /* COPTIC CAPITAL LETTER OLD COPTIC AIN */ \
	  0x2CB5, /* COPTIC SMALL LETTER OLD COPTIC AIN */ }, \
	{ 0x2CD8, /* COPTIC CAPITAL LETTER OLD COPTIC DJA */ \
	  0x2CD9, /* COPTIC SMALL LETTER OLD COPTIC DJA */ }, \
	{ 0x2CC6, /* COPTIC CAPITAL LETTER OLD COPTIC ESH */ \
	  0x2CC7, /* COPTIC SMALL LETTER OLD COPTIC ESH */ }, \
	{ 0x2CD6, /* COPTIC CAPITAL LETTER OLD COPTIC GANGIA */ \
	  0x2CD7, /* COPTIC SMALL LETTER OLD COPTIC GANGIA */ }, \
	{ 0x2CCE, /* COPTIC CAPITAL LETTER OLD COPTIC HA */ \
	  0x2CCF, /* COPTIC SMALL LETTER OLD COPTIC HA */ }, \
	{ 0x2CD4, /* COPTIC CAPITAL LETTER OLD COPTIC HAT */ \
	  0x2CD5, /* COPTIC SMALL LETTER OLD COPTIC HAT */ }, \
	{ 0x2CD2, /* COPTIC CAPITAL LETTER OLD COPTIC HEI */ \
	  0x2CD3, /* COPTIC SMALL LETTER OLD COPTIC HEI */ }, \
	{ 0x2CCC, /* COPTIC CAPITAL LETTER OLD COPTIC HORI */ \
	  0x2CCD, /* COPTIC SMALL LETTER OLD COPTIC HORI */ }, \
	{ 0x2CBE, /* COPTIC CAPITAL LETTER OLD COPTIC OOU */ \
	  0x2CBF, /* COPTIC SMALL LETTER OLD COPTIC OOU */ }, \
	{ 0x2CC4, /* COPTIC CAPITAL LETTER OLD COPTIC SHEI */ \
	  0x2CC5, /* COPTIC SMALL LETTER OLD COPTIC SHEI */ }, \
	{ 0x2CDA, /* COPTIC CAPITAL LETTER OLD COPTIC SHIMA */ \
	  0x2CDB, /* COPTIC SMALL LETTER OLD COPTIC SHIMA */ }, \
	{ 0x2CDE, /* COPTIC CAPITAL LETTER OLD NUBIAN NGI */ \
	  0x2CDF, /* COPTIC SMALL LETTER OLD NUBIAN NGI */ }, \
	{ 0x2CE0, /* COPTIC CAPITAL LETTER OLD NUBIAN NYI */ \
	  0x2CE1, /* COPTIC SMALL LETTER OLD NUBIAN NYI */ }, \
	{ 0x2CDC, /* COPTIC CAPITAL LETTER OLD NUBIAN SHIMA */ \
	  0x2CDD, /* COPTIC SMALL LETTER OLD NUBIAN SHIMA */ }, \
	{ 0x2CE2, /* COPTIC CAPITAL LETTER OLD NUBIAN WAU */ \
	  0x2CE3, /* COPTIC SMALL LETTER OLD NUBIAN WAU */ }, \
	{ 0x2CB0, /* COPTIC CAPITAL LETTER OOU */ \
	  0x2CB1, /* COPTIC SMALL LETTER OOU */ }, \
	{ 0x2CA0, /* COPTIC CAPITAL LETTER PI */ \
	  0x2CA1, /* COPTIC SMALL LETTER PI */ }, \
	{ 0x2CAE, /* COPTIC CAPITAL LETTER PSI */ \
	  0x2CAF, /* COPTIC SMALL LETTER PSI */ }, \
	{ 0x2CA2, /* COPTIC CAPITAL LETTER RO */ \
	  0x2CA3, /* COPTIC SMALL LETTER RO */ }, \
	{ 0x2CC0, /* COPTIC CAPITAL LETTER SAMPI */ \
	  0x2CC1, /* COPTIC SMALL LETTER SAMPI */ }, \
	{ 0x03E2, /* COPTIC CAPITAL LETTER SHEI */ \
	  0x03E3, /* COPTIC SMALL LETTER SHEI */ }, \
	{ 0x03EC, /* COPTIC CAPITAL LETTER SHIMA */ \
	  0x03ED, /* COPTIC SMALL LETTER SHIMA */ }, \
	{ 0x2CA4, /* COPTIC CAPITAL LETTER SIMA */ \
	  0x2CA5, /* COPTIC SMALL LETTER SIMA */ }, \
	{ 0x2C8A, /* COPTIC CAPITAL LETTER SOU */ \
	  0x2C8B, /* COPTIC SMALL LETTER SOU */ }, \
	{ 0x2CA6, /* COPTIC CAPITAL LETTER TAU */ \
	  0x2CA7, /* COPTIC SMALL LETTER TAU */ }, \
	{ 0x2C90, /* COPTIC CAPITAL LETTER THETHE */ \
	  0x2C91, /* COPTIC SMALL LETTER THETHE */ }, \
	{ 0x2CA8, /* COPTIC CAPITAL LETTER UA */ \
	  0x2CA9, /* COPTIC SMALL LETTER UA */ }, \
	{ 0x2C82, /* COPTIC CAPITAL LETTER VIDA */ \
	  0x2C83, /* COPTIC SMALL LETTER VIDA */ }, \
	{ 0x2C8C, /* COPTIC CAPITAL LETTER ZATA */ \
	  0x2C8D, /* COPTIC SMALL LETTER ZATA */ }, \
	{ 0x0410, /* CYRILLIC CAPITAL LETTER A */ \
	  0x0430, /* CYRILLIC SMALL LETTER A */ }, \
	{ 0x04D0, /* CYRILLIC CAPITAL LETTER A WITH BREVE */ \
	  0x04D1, /* CYRILLIC SMALL LETTER A WITH BREVE */ }, \
	{ 0x04D2, /* CYRILLIC CAPITAL LETTER A WITH DIAERESIS */ \
	  0x04D3, /* CYRILLIC SMALL LETTER A WITH DIAERESIS */ }, \
	{ 0x04BC, /* CYRILLIC CAPITAL LETTER ABKHASIAN CHE */ \
	  0x04BD, /* CYRILLIC SMALL LETTER ABKHASIAN CHE */ }, \
	{ 0x04BE, /* CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER */ \
	  0x04BF, /* CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER */ }, \
	{ 0x04E0, /* CYRILLIC CAPITAL LETTER ABKHASIAN DZE */ \
	  0x04E1, /* CYRILLIC SMALL LETTER ABKHASIAN DZE */ }, \
	{ 0x04A8, /* CYRILLIC CAPITAL LETTER ABKHASIAN HA */ \
	  0x04A9, /* CYRILLIC SMALL LETTER ABKHASIAN HA */ }, \
	{ 0x051E, /* CYRILLIC CAPITAL LETTER ALEUT KA */ \
	  0x051F, /* CYRILLIC SMALL LETTER ALEUT KA */ }, \
	{ 0x04E8, /* CYRILLIC CAPITAL LETTER BARRED O */ \
	  0x04E9, /* CYRILLIC SMALL LETTER BARRED O */ }, \
	{ 0x04EA, /* CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS */ \
	  0x04EB, /* CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS */ }, \
	{ 0x04A0, /* CYRILLIC CAPITAL LETTER BASHKIR KA */ \
	  0x04A1, /* CYRILLIC SMALL LETTER BASHKIR KA */ }, \
	{ 0x0411, /* CYRILLIC CAPITAL LETTER BE */ \
	  0x0431, /* CYRILLIC SMALL LETTER BE */ }, \
	{ 0x046A, /* CYRILLIC CAPITAL LETTER BIG YUS */ \
	  0x046B, /* CYRILLIC SMALL LETTER BIG YUS */ }, \
	{ 0xA66A, /* CYRILLIC CAPITAL LETTER BINOCULAR O */ \
	  0xA66B, /* CYRILLIC SMALL LETTER BINOCULAR O */ }, \
	{ 0xA65A, /* CYRILLIC CAPITAL LETTER BLENDED YUS */ \
	  0xA65B, /* CYRILLIC SMALL LETTER BLENDED YUS */ }, \
	{ 0xA64C, /* CYRILLIC CAPITAL LETTER BROAD OMEGA */ \
	  0xA64D, /* CYRILLIC SMALL LETTER BROAD OMEGA */ }, \
	{ 0x0406, /* CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I */ \
	  0x0456, /* CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I */ }, \
	{ 0xA686, /* CYRILLIC CAPITAL LETTER CCHE */ \
	  0xA687, /* CYRILLIC SMALL LETTER CCHE */ }, \
	{ 0x0427, /* CYRILLIC CAPITAL LETTER CHE */ \
	  0x0447, /* CYRILLIC SMALL LETTER CHE */ }, \
	{ 0x04B6, /* CYRILLIC CAPITAL LETTER CHE WITH DESCENDER */ \
	  0x04B7, /* CYRILLIC SMALL LETTER CHE WITH DESCENDER */ }, \
	{ 0x04F4, /* CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS */ \
	  0x04F5, /* CYRILLIC SMALL LETTER CHE WITH DIAERESIS */ }, \
	{ 0x04B8, /* CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE */ \
	  0x04B9, /* CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE */ }, \
	{ 0xA658, /* CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS */ \
	  0xA659, /* CYRILLIC SMALL LETTER CLOSED LITTLE YUS */ }, \
	{ 0xA69A, /* CYRILLIC CAPITAL LETTER CROSSED O */ \
	  0xA69B, /* CYRILLIC SMALL LETTER CROSSED O */ }, \
	{ 0x052C, /* CYRILLIC CAPITAL LETTER DCHE */ \
	  0x052D, /* CYRILLIC SMALL LETTER DCHE */ }, \
	{ 0x0414, /* CYRILLIC CAPITAL LETTER DE */ \
	  0x0434, /* CYRILLIC SMALL LETTER DE */ }, \
	{ 0x0402, /* CYRILLIC CAPITAL LETTER DJE */ \
	  0x0452, /* CYRILLIC SMALL LETTER DJE */ }, \
	{ 0xA648, /* CYRILLIC CAPITAL LETTER DJERV */ \
	  0xA649, /* CYRILLIC SMALL LETTER DJERV */ }, \
	{ 0xA66C, /* CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O */ \
	  0xA66D, /* CYRILLIC SMALL LETTER DOUBLE MONOCULAR O */ }, \
	{ 0xA698, /* CYRILLIC CAPITAL LETTER DOUBLE O */ \
	  0xA699, /* CYRILLIC SMALL LETTER DOUBLE O */ }, \
	{ 0xA680, /* CYRILLIC CAPITAL LETTER DWE */ \
	  0xA681, /* CYRILLIC SMALL LETTER DWE */ }, \
	{ 0x0405, /* CYRILLIC CAPITAL LETTER DZE */ \
	  0x0455, /* CYRILLIC SMALL LETTER DZE */ }, \
	{ 0xA642, /* CYRILLIC CAPITAL LETTER DZELO */ \
	  0xA643, /* CYRILLIC SMALL LETTER DZELO */ }, \
	{ 0x040F, /* CYRILLIC CAPITAL LETTER DZHE */ \
	  0x045F, /* CYRILLIC SMALL LETTER DZHE */ }, \
	{ 0xA682, /* CYRILLIC CAPITAL LETTER DZWE */ \
	  0xA683, /* CYRILLIC SMALL LETTER DZWE */ }, \
	{ 0xA688, /* CYRILLIC CAPITAL LETTER DZZE */ \
	  0xA689, /* CYRILLIC SMALL LETTER DZZE */ }, \
	{ 0x052A, /* CYRILLIC CAPITAL LETTER DZZHE */ \
	  0x052B, /* CYRILLIC SMALL LETTER DZZHE */ }, \
	{ 0x042D, /* CYRILLIC CAPITAL LETTER E */ \
	  0x044D, /* CYRILLIC SMALL LETTER E */ }, \
	{ 0x04EC, /* CYRILLIC CAPITAL LETTER E WITH DIAERESIS */ \
	  0x04ED, /* CYRILLIC SMALL LETTER E WITH DIAERESIS */ }, \
	{ 0x0424, /* CYRILLIC CAPITAL LETTER EF */ \
	  0x0444, /* CYRILLIC SMALL LETTER EF */ }, \
	{ 0x041B, /* CYRILLIC CAPITAL LETTER EL */ \
	  0x043B, /* CYRILLIC SMALL LETTER EL */ }, \
	{ 0x052E, /* CYRILLIC CAPITAL LETTER EL WITH DESCENDER */ \
	  0x052F, /* CYRILLIC SMALL LETTER EL WITH DESCENDER */ }, \
	{ 0x0512, /* CYRILLIC CAPITAL LETTER EL WITH HOOK */ \
	  0x0513, /* CYRILLIC SMALL LETTER EL WITH HOOK */ }, \
	{ 0x0520, /* CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK */ \
	  0x0521, /* CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK */ }, \
	{ 0x04C5, /* CYRILLIC CAPITAL LETTER EL WITH TAIL */ \
	  0x04C6, /* CYRILLIC SMALL LETTER EL WITH TAIL */ }, \
	{ 0x041C, /* CYRILLIC CAPITAL LETTER EM */ \
	  0x043C, /* CYRILLIC SMALL LETTER EM */ }, \
	{ 0x04CD, /* CYRILLIC CAPITAL LETTER EM WITH TAIL */ \
	  0x04CE, /* CYRILLIC SMALL LETTER EM WITH TAIL */ }, \
	{ 0x041D, /* CYRILLIC CAPITAL LETTER EN */ \
	  0x043D, /* CYRILLIC SMALL LETTER EN */ }, \
	{ 0x04A2, /* CYRILLIC CAPITAL LETTER EN WITH DESCENDER */ \
	  0x04A3, /* CYRILLIC SMALL LETTER EN WITH DESCENDER */ }, \
	{ 0x04C7, /* CYRILLIC CAPITAL LETTER EN WITH HOOK */ \
	  0x04C8, /* CYRILLIC SMALL LETTER EN WITH HOOK */ }, \
	{ 0x0528, /* CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK */ \
	  0x0529, /* CYRILLIC SMALL LETTER EN WITH LEFT HOOK */ }, \
	{ 0x0522, /* CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK */ \
	  0x0523, /* CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK */ }, \
	{ 0x04C9, /* CYRILLIC CAPITAL LETTER EN WITH TAIL */ \
	  0x04CA, /* CYRILLIC SMALL LETTER EN WITH TAIL */ }, \
	{ 0x0420, /* CYRILLIC CAPITAL LETTER ER */ \
	  0x0440, /* CYRILLIC SMALL LETTER ER */ }, \
	{ 0x048E, /* CYRILLIC CAPITAL LETTER ER WITH TICK */ \
	  0x048F, /* CYRILLIC SMALL LETTER ER WITH TICK */ }, \
	{ 0x0421, /* CYRILLIC CAPITAL LETTER ES */ \
	  0x0441, /* CYRILLIC SMALL LETTER ES */ }, \
	{ 0x04AA, /* CYRILLIC CAPITAL LETTER ES WITH DESCENDER */ \
	  0x04AB, /* CYRILLIC SMALL LETTER ES WITH DESCENDER */ }, \
	{ 0x0472, /* CYRILLIC CAPITAL LETTER FITA */ \
	  0x0473, /* CYRILLIC SMALL LETTER FITA */ }, \
	{ 0x0413, /* CYRILLIC CAPITAL LETTER GHE */ \
	  0x0433, /* CYRILLIC SMALL LETTER GHE */ }, \
	{ 0x04F6, /* CYRILLIC CAPITAL LETTER GHE WITH DESCENDER */ \
	  0x04F7, /* CYRILLIC SMALL LETTER GHE WITH DESCENDER */ }, \
	{ 0x0494, /* CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK */ \
	  0x0495, /* CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK */ }, \
	{ 0x0492, /* CYRILLIC CAPITAL LETTER GHE WITH STROKE */ \
	  0x0493, /* CYRILLIC SMALL LETTER GHE WITH STROKE */ }, \
	{ 0x04FA, /* CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK */ \
	  0x04FB, /* CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK */ }, \
	{ 0x0490, /* CYRILLIC CAPITAL LETTER GHE WITH UPTURN */ \
	  0x0491, /* CYRILLIC SMALL LETTER GHE WITH UPTURN */ }, \
	{ 0x0403, /* CYRILLIC CAPITAL LETTER GJE */ \
	  0x0453, /* CYRILLIC SMALL LETTER GJE */ }, \
	{ 0x0425, /* CYRILLIC CAPITAL LETTER HA */ \
	  0x0445, /* CYRILLIC SMALL LETTER HA */ }, \
	{ 0x04B2, /* CYRILLIC CAPITAL LETTER HA WITH DESCENDER */ \
	  0x04B3, /* CYRILLIC SMALL LETTER HA WITH DESCENDER */ }, \
	{ 0x04FC, /* CYRILLIC CAPITAL LETTER HA WITH HOOK */ \
	  0x04FD, /* CYRILLIC SMALL LETTER HA WITH HOOK */ }, \
	{ 0x04FE, /* CYRILLIC CAPITAL LETTER HA WITH STROKE */ \
	  0x04FF, /* CYRILLIC SMALL LETTER HA WITH STROKE */ }, \
	{ 0x042A, /* CYRILLIC CAPITAL LETTER HARD SIGN */ \
	  0x044A, /* CYRILLIC SMALL LETTER HARD SIGN */ }, \
	{ 0xA694, /* CYRILLIC CAPITAL LETTER HWE */ \
	  0xA695, /* CYRILLIC SMALL LETTER HWE */ }, \
	{ 0x0418, /* CYRILLIC CAPITAL LETTER I */ \
	  0x0438, /* CYRILLIC SMALL LETTER I */ }, \
	{ 0x04E4, /* CYRILLIC CAPITAL LETTER I WITH DIAERESIS */ \
	  0x04E5, /* CYRILLIC SMALL LETTER I WITH DIAERESIS */ }, \
	{ 0x040D, /* CYRILLIC CAPITAL LETTER I WITH GRAVE */ \
	  0x045D, /* CYRILLIC SMALL LETTER I WITH GRAVE */ }, \
	{ 0x04E2, /* CYRILLIC CAPITAL LETTER I WITH MACRON */ \
	  0x04E3, /* CYRILLIC SMALL LETTER I WITH MACRON */ }, \
	{ 0x0415, /* CYRILLIC CAPITAL LETTER IE */ \
	  0x0435, /* CYRILLIC SMALL LETTER IE */ }, \
	{ 0x04D6, /* CYRILLIC CAPITAL LETTER IE WITH BREVE */ \
	  0x04D7, /* CYRILLIC SMALL LETTER IE WITH BREVE */ }, \
	{ 0x0400, /* CYRILLIC CAPITAL LETTER IE WITH GRAVE */ \
	  0x0450, /* CYRILLIC SMALL LETTER IE WITH GRAVE */ }, \
	{ 0x0401, /* CYRILLIC CAPITAL LETTER IO */ \
	  0x0451, /* CYRILLIC SMALL LETTER IO */ }, \
	{ 0xA646, /* CYRILLIC CAPITAL LETTER IOTA */ \
	  0xA647, /* CYRILLIC SMALL LETTER IOTA */ }, \
	{ 0xA656, /* CYRILLIC CAPITAL LETTER IOTIFIED A */ \
	  0xA657, /* CYRILLIC SMALL LETTER IOTIFIED A */ }, \
	{ 0x046C, /* CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS */ \
	  0x046D, /* CYRILLIC SMALL LETTER IOTIFIED BIG YUS */ }, \
	{ 0xA65C, /* CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS */ \
	  0xA65D, /* CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS */ }, \
	{ 0x0464, /* CYRILLIC CAPITAL LETTER IOTIFIED E */ \
	  0x0465, /* CYRILLIC SMALL LETTER IOTIFIED E */ }, \
	{ 0x0468, /* CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS */ \
	  0x0469, /* CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS */ }, \
	{ 0xA652, /* CYRILLIC CAPITAL LETTER IOTIFIED YAT */ \
	  0xA653, /* CYRILLIC SMALL LETTER IOTIFIED YAT */ }, \
	{ 0x0474, /* CYRILLIC CAPITAL LETTER IZHITSA */ \
	  0x0475, /* CYRILLIC SMALL LETTER IZHITSA */ }, \
	{ 0x0476, /* CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */ \
	  0x0477, /* CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */ }, \
	{ 0x0408, /* CYRILLIC CAPITAL LETTER JE */ \
	  0x0458, /* CYRILLIC SMALL LETTER JE */ }, \
	{ 0x041A, /* CYRILLIC CAPITAL LETTER KA */ \
	  0x043A, /* CYRILLIC SMALL LETTER KA */ }, \
	{ 0x049A, /* CYRILLIC CAPITAL LETTER KA WITH DESCENDER */ \
	  0x049B, /* CYRILLIC SMALL LETTER KA WITH DESCENDER */ }, \
	{ 0x04C3, /* CYRILLIC CAPITAL LETTER KA WITH HOOK */ \
	  0x04C4, /* CYRILLIC SMALL LETTER KA WITH HOOK */ }, \
	{ 0x049E, /* CYRILLIC CAPITAL LETTER KA WITH STROKE */ \
	  0x049F, /* CYRILLIC SMALL LETTER KA WITH STROKE */ }, \
	{ 0x049C, /* CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE */ \
	  0x049D, /* CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE */ }, \
	{ 0x04CB, /* CYRILLIC CAPITAL LETTER KHAKASSIAN CHE */ \
	  0x04CC, /* CYRILLIC SMALL LETTER KHAKASSIAN CHE */ }, \
	{ 0x040C, /* CYRILLIC CAPITAL LETTER KJE */ \
	  0x045C, /* CYRILLIC SMALL LETTER KJE */ }, \
	{ 0x0500, /* CYRILLIC CAPITAL LETTER KOMI DE */ \
	  0x0501, /* CYRILLIC SMALL LETTER KOMI DE */ }, \
	{ 0x0502, /* CYRILLIC CAPITAL LETTER KOMI DJE */ \
	  0x0503, /* CYRILLIC SMALL LETTER KOMI DJE */ }, \
	{ 0x0506, /* CYRILLIC CAPITAL LETTER KOMI DZJE */ \
	  0x0507, /* CYRILLIC SMALL LETTER KOMI DZJE */ }, \
	{ 0x0508, /* CYRILLIC CAPITAL LETTER KOMI LJE */ \
	  0x0509, /* CYRILLIC SMALL LETTER KOMI LJE */ }, \
	{ 0x050A, /* CYRILLIC CAPITAL LETTER KOMI NJE */ \
	  0x050B, /* CYRILLIC SMALL LETTER KOMI NJE */ }, \
	{ 0x050C, /* CYRILLIC CAPITAL LETTER KOMI SJE */ \
	  0x050D, /* CYRILLIC SMALL LETTER KOMI SJE */ }, \
	{ 0x050E, /* CYRILLIC CAPITAL LETTER KOMI TJE */ \
	  0x050F, /* CYRILLIC SMALL LETTER KOMI TJE */ }, \
	{ 0x0504, /* CYRILLIC CAPITAL LETTER KOMI ZJE */ \
	  0x0505, /* CYRILLIC SMALL LETTER KOMI ZJE */ }, \
	{ 0x0480, /* CYRILLIC CAPITAL LETTER KOPPA */ \
	  0x0481, /* CYRILLIC SMALL LETTER KOPPA */ }, \
	{ 0x046E, /* CYRILLIC CAPITAL LETTER KSI */ \
	  0x046F, /* CYRILLIC SMALL LETTER KSI */ }, \
	{ 0x0514, /* CYRILLIC CAPITAL LETTER LHA */ \
	  0x0515, /* CYRILLIC SMALL LETTER LHA */ }, \
	{ 0x0466, /* CYRILLIC CAPITAL LETTER LITTLE YUS */ \
	  0x0467, /* CYRILLIC SMALL LETTER LITTLE YUS */ }, \
	{ 0x0409, /* CYRILLIC CAPITAL LETTER LJE */ \
	  0x0459, /* CYRILLIC SMALL LETTER LJE */ }, \
	{ 0xA668, /* CYRILLIC CAPITAL LETTER MONOCULAR O */ \
	  0xA669, /* CYRILLIC SMALL LETTER MONOCULAR O */ }, \
	{ 0xA64A, /* CYRILLIC CAPITAL LETTER MONOGRAPH UK */ \
	  0xA64B, /* CYRILLIC SMALL LETTER MONOGRAPH UK */ }, \
	{ 0xA64E, /* CYRILLIC CAPITAL LETTER NEUTRAL YER */ \
	  0xA64F, /* CYRILLIC SMALL LETTER NEUTRAL YER */ }, \
	{ 0x040A, /* CYRILLIC CAPITAL LETTER NJE */ \
	  0x045A, /* CYRILLIC SMALL LETTER NJE */ }, \
	{ 0x041E, /* CYRILLIC CAPITAL LETTER O */ \
	  0x043E, /* CYRILLIC SMALL LETTER O */ }, \
	{ 0x04E6, /* CYRILLIC CAPITAL LETTER O WITH DIAERESIS */ \
	  0x04E7, /* CYRILLIC SMALL LETTER O WITH DIAERESIS */ }, \
	{ 0x0460, /* CYRILLIC CAPITAL LETTER OMEGA */ \
	  0x0461, /* CYRILLIC SMALL LETTER OMEGA */ }, \
	{ 0x047C, /* CYRILLIC CAPITAL LETTER OMEGA WITH TITLO */ \
	  0x047D, /* CYRILLIC SMALL LETTER OMEGA WITH TITLO */ }, \
	{ 0x047E, /* CYRILLIC CAPITAL LETTER OT */ \
	  0x047F, /* CYRILLIC SMALL LETTER OT */ }, \
	{ 0x041F, /* CYRILLIC CAPITAL LETTER PE */ \
	  0x043F, /* CYRILLIC SMALL LETTER PE */ }, \
	{ 0x0524, /* CYRILLIC CAPITAL LETTER PE WITH DESCENDER */ \
	  0x0525, /* CYRILLIC SMALL LETTER PE WITH DESCENDER */ }, \
	{ 0x04A6, /* CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK */ \
	  0x04A7, /* CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK */ }, \
	{ 0x0470, /* CYRILLIC CAPITAL LETTER PSI */ \
	  0x0471, /* CYRILLIC SMALL LETTER PSI */ }, \
	{ 0x051A, /* CYRILLIC CAPITAL LETTER QA */ \
	  0x051B, /* CYRILLIC SMALL LETTER QA */ }, \
	{ 0xA644, /* CYRILLIC CAPITAL LETTER REVERSED DZE */ \
	  0xA645, /* CYRILLIC SMALL LETTER REVERSED DZE */ }, \
	{ 0xA660, /* CYRILLIC CAPITAL LETTER REVERSED TSE */ \
	  0xA661, /* CYRILLIC SMALL LETTER REVERSED TSE */ }, \
	{ 0xA654, /* CYRILLIC CAPITAL LETTER REVERSED YU */ \
	  0xA655, /* CYRILLIC SMALL LETTER REVERSED YU */ }, \
	{ 0x0510, /* CYRILLIC CAPITAL LETTER REVERSED ZE */ \
	  0x0511, /* CYRILLIC SMALL LETTER REVERSED ZE */ }, \
	{ 0x0516, /* CYRILLIC CAPITAL LETTER RHA */ \
	  0x0517, /* CYRILLIC SMALL LETTER RHA */ }, \
	{ 0x047A, /* CYRILLIC CAPITAL LETTER ROUND OMEGA */ \
	  0x047B, /* CYRILLIC SMALL LETTER ROUND OMEGA */ }, \
	{ 0x04D8, /* CYRILLIC CAPITAL LETTER SCHWA */ \
	  0x04D9, /* CYRILLIC SMALL LETTER SCHWA */ }, \
	{ 0x04DA, /* CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS */ \
	  0x04DB, /* CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS */ }, \
	{ 0x048C, /* CYRILLIC CAPITAL LETTER SEMISOFT SIGN */ \
	  0x048D, /* CYRILLIC SMALL LETTER SEMISOFT SIGN */ }, \
	{ 0x0428, /* CYRILLIC CAPITAL LETTER SHA */ \
	  0x0448, /* CYRILLIC SMALL LETTER SHA */ }, \
	{ 0x0429, /* CYRILLIC CAPITAL LETTER SHCHA */ \
	  0x0449, /* CYRILLIC SMALL LETTER SHCHA */ }, \
	{ 0x04BA, /* CYRILLIC CAPITAL LETTER SHHA */ \
	  0x04BB, /* CYRILLIC SMALL LETTER SHHA */ }, \
	{ 0x0526, /* CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER */ \
	  0x0527, /* CYRILLIC SMALL LETTER SHHA WITH DESCENDER */ }, \
	{ 0x048A, /* CYRILLIC CAPITAL LETTER SHORT I WITH TAIL */ \
	  0x048B, /* CYRILLIC SMALL LETTER SHORT I WITH TAIL */ }, \
	{ 0x040E, /* CYRILLIC CAPITAL LETTER SHORT U */ \
	  0x045E, /* CYRILLIC SMALL LETTER SHORT U */ }, \
	{ 0xA696, /* CYRILLIC CAPITAL LETTER SHWE */ \
	  0xA697, /* CYRILLIC SMALL LETTER SHWE */ }, \
	{ 0xA662, /* CYRILLIC CAPITAL LETTER SOFT DE */ \
	  0xA663, /* CYRILLIC SMALL LETTER SOFT DE */ }, \
	{ 0xA664, /* CYRILLIC CAPITAL LETTER SOFT EL */ \
	  0xA665, /* CYRILLIC SMALL LETTER SOFT EL */ }, \
	{ 0xA666, /* CYRILLIC CAPITAL LETTER SOFT EM */ \
	  0xA667, /* CYRILLIC SMALL LETTER SOFT EM */ }, \
	{ 0x042C, /* CYRILLIC CAPITAL LETTER SOFT SIGN */ \
	  0x044C, /* CYRILLIC SMALL LETTER SOFT SIGN */ }, \
	{ 0x04AE, /* CYRILLIC CAPITAL LETTER STRAIGHT U */ \
	  0x04AF, /* CYRILLIC SMALL LETTER STRAIGHT U */ }, \
	{ 0x04B0, /* CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE */ \
	  0x04B1, /* CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE */ }, \
	{ 0xA692, /* CYRILLIC CAPITAL LETTER TCHE */ \
	  0xA693, /* CYRILLIC SMALL LETTER TCHE */ }, \
	{ 0x0422, /* CYRILLIC CAPITAL LETTER TE */ \
	  0x0442, /* CYRILLIC SMALL LETTER TE */ }, \
	{ 0x04AC, /* CYRILLIC CAPITAL LETTER TE WITH DESCENDER */ \
	  0x04AD, /* CYRILLIC SMALL LETTER TE WITH DESCENDER */ }, \
	{ 0xA68A, /* CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK */ \
	  0xA68B, /* CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK */ }, \
	{ 0x0426, /* CYRILLIC CAPITAL LETTER TSE */ \
	  0x0446, /* CYRILLIC SMALL LETTER TSE */ }, \
	{ 0x040B, /* CYRILLIC CAPITAL LETTER TSHE */ \
	  0x045B, /* CYRILLIC SMALL LETTER TSHE */ }, \
	{ 0xA690, /* CYRILLIC CAPITAL LETTER TSSE */ \
	  0xA691, /* CYRILLIC SMALL LETTER TSSE */ }, \
	{ 0xA68E, /* CYRILLIC CAPITAL LETTER TSWE */ \
	  0xA68F, /* CYRILLIC SMALL LETTER TSWE */ }, \
	{ 0xA68C, /* CYRILLIC CAPITAL LETTER TWE */ \
	  0xA68D, /* CYRILLIC SMALL LETTER TWE */ }, \
	{ 0x0423, /* CYRILLIC CAPITAL LETTER U */ \
	  0x0443, /* CYRILLIC SMALL LETTER U */ }, \
	{ 0x04F0, /* CYRILLIC CAPITAL LETTER U WITH DIAERESIS */ \
	  0x04F1, /* CYRILLIC SMALL LETTER U WITH DIAERESIS */ }, \
	{ 0x04F2, /* CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE */ \
	  0x04F3, /* CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE */ }, \
	{ 0x04EE, /* CYRILLIC CAPITAL LETTER U WITH MACRON */ \
	  0x04EF, /* CYRILLIC SMALL LETTER U WITH MACRON */ }, \
	{ 0x0478, /* CYRILLIC CAPITAL LETTER UK */ \
	  0x0479, /* CYRILLIC SMALL LETTER UK */ }, \
	{ 0x0404, /* CYRILLIC CAPITAL LETTER UKRAINIAN IE */ \
	  0x0454, /* CYRILLIC SMALL LETTER UKRAINIAN IE */ }, \
	{ 0x0412, /* CYRILLIC CAPITAL LETTER VE */ \
	  0x0432, /* CYRILLIC SMALL LETTER VE */ }, \
	{ 0x051C, /* CYRILLIC CAPITAL LETTER WE */ \
	  0x051D, /* CYRILLIC SMALL LETTER WE */ }, \
	{ 0x042F, /* CYRILLIC CAPITAL LETTER YA */ \
	  0x044F, /* CYRILLIC SMALL LETTER YA */ }, \
	{ 0x0518, /* CYRILLIC CAPITAL LETTER YAE */ \
	  0x0519, /* CYRILLIC SMALL LETTER YAE */ }, \
	{ 0x0462, /* CYRILLIC CAPITAL LETTER YAT */ \
	  0x0463, /* CYRILLIC SMALL LETTER YAT */ }, \
	{ 0x042B, /* CYRILLIC CAPITAL LETTER YERU */ \
	  0x044B, /* CYRILLIC SMALL LETTER YERU */ }, \
	{ 0xA650, /* CYRILLIC CAPITAL LETTER YERU WITH BACK YER */ \
	  0xA651, /* CYRILLIC SMALL LETTER YERU WITH BACK YER */ }, \
	{ 0x04F8, /* CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS */ \
	  0x04F9, /* CYRILLIC SMALL LETTER YERU WITH DIAERESIS */ }, \
	{ 0x0407, /* CYRILLIC CAPITAL LETTER YI */ \
	  0x0457, /* CYRILLIC SMALL LETTER YI */ }, \
	{ 0xA65E, /* CYRILLIC CAPITAL LETTER YN */ \
	  0xA65F, /* CYRILLIC SMALL LETTER YN */ }, \
	{ 0x042E, /* CYRILLIC CAPITAL LETTER YU */ \
	  0x044E, /* CYRILLIC SMALL LETTER YU */ }, \
	{ 0x0417, /* CYRILLIC CAPITAL LETTER ZE */ \
	  0x0437, /* CYRILLIC SMALL LETTER ZE */ }, \
	{ 0x0498, /* CYRILLIC CAPITAL LETTER ZE WITH DESCENDER */ \
	  0x0499, /* CYRILLIC SMALL LETTER ZE WITH DESCENDER */ }, \
	{ 0x04DE, /* CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS */ \
	  0x04DF, /* CYRILLIC SMALL LETTER ZE WITH DIAERESIS */ }, \
	{ 0xA640, /* CYRILLIC CAPITAL LETTER ZEMLYA */ \
	  0xA641, /* CYRILLIC SMALL LETTER ZEMLYA */ }, \
	{ 0x0416, /* CYRILLIC CAPITAL LETTER ZHE */ \
	  0x0436, /* CYRILLIC SMALL LETTER ZHE */ }, \
	{ 0x04C1, /* CYRILLIC CAPITAL LETTER ZHE WITH BREVE */ \
	  0x04C2, /* CYRILLIC SMALL LETTER ZHE WITH BREVE */ }, \
	{ 0x0496, /* CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER */ \
	  0x0497, /* CYRILLIC SMALL LETTER ZHE WITH DESCENDER */ }, \
	{ 0x04DC, /* CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS */ \
	  0x04DD, /* CYRILLIC SMALL LETTER ZHE WITH DIAERESIS */ }, \
	{ 0xA684, /* CYRILLIC CAPITAL LETTER ZHWE */ \
	  0xA685, /* CYRILLIC SMALL LETTER ZHWE */ }, \
	{ 0xFF21, /* FULLWIDTH LATIN CAPITAL LETTER A */ \
	  0xFF41, /* FULLWIDTH LATIN SMALL LETTER A */ }, \
	{ 0xFF22, /* FULLWIDTH LATIN CAPITAL LETTER B */ \
	  0xFF42, /* FULLWIDTH LATIN SMALL LETTER B */ }, \
	{ 0xFF23, /* FULLWIDTH LATIN CAPITAL LETTER C */ \
	  0xFF43, /* FULLWIDTH LATIN SMALL LETTER C */ }, \
	{ 0xFF24, /* FULLWIDTH LATIN CAPITAL LETTER D */ \
	  0xFF44, /* FULLWIDTH LATIN SMALL LETTER D */ }, \
	{ 0xFF25, /* FULLWIDTH LATIN CAPITAL LETTER E */ \
	  0xFF45, /* FULLWIDTH LATIN SMALL LETTER E */ }, \
	{ 0xFF26, /* FULLWIDTH LATIN CAPITAL LETTER F */ \
	  0xFF46, /* FULLWIDTH LATIN SMALL LETTER F */ }, \
	{ 0xFF27, /* FULLWIDTH LATIN CAPITAL LETTER G */ \
	  0xFF47, /* FULLWIDTH LATIN SMALL LETTER G */ }, \
	{ 0xFF28, /* FULLWIDTH LATIN CAPITAL LETTER H */ \
	  0xFF48, /* FULLWIDTH LATIN SMALL LETTER H */ }, \
	{ 0xFF29, /* FULLWIDTH LATIN CAPITAL LETTER I */ \
	  0xFF49, /* FULLWIDTH LATIN SMALL LETTER I */ }, \
	{ 0xFF2A, /* FULLWIDTH LATIN CAPITAL LETTER J */ \
	  0xFF4A, /* FULLWIDTH LATIN SMALL LETTER J */ }, \
	{ 0xFF2B, /* FULLWIDTH LATIN CAPITAL LETTER K */ \
	  0xFF4B, /* FULLWIDTH LATIN SMALL LETTER K */ }, \
	{ 0xFF2C, /* FULLWIDTH LATIN CAPITAL LETTER L */ \
	  0xFF4C, /* FULLWIDTH LATIN SMALL LETTER L */ }, \
	{ 0xFF2D, /* FULLWIDTH LATIN CAPITAL LETTER M */ \
	  0xFF4D, /* FULLWIDTH LATIN SMALL LETTER M */ }, \
	{ 0xFF2E, /* FULLWIDTH LATIN CAPITAL LETTER N */ \
	  0xFF4E, /* FULLWIDTH LATIN SMALL LETTER N */ }, \
	{ 0xFF2F, /* FULLWIDTH LATIN CAPITAL LETTER O */ \
	  0xFF4F, /* FULLWIDTH LATIN SMALL LETTER O */ }, \
	{ 0xFF30, /* FULLWIDTH LATIN CAPITAL LETTER P */ \
	  0xFF50, /* FULLWIDTH LATIN SMALL LETTER P */ }, \
	{ 0xFF31, /* FULLWIDTH LATIN CAPITAL LETTER Q */ \
	  0xFF51, /* FULLWIDTH LATIN SMALL LETTER Q */ }, \
	{ 0xFF32, /* FULLWIDTH LATIN CAPITAL LETTER R */ \
	  0xFF52, /* FULLWIDTH LATIN SMALL LETTER R */ }, \
	{ 0xFF33, /* FULLWIDTH LATIN CAPITAL LETTER S */ \
	  0xFF53, /* FULLWIDTH LATIN SMALL LETTER S */ }, \
	{ 0xFF34, /* FULLWIDTH LATIN CAPITAL LETTER T */ \
	  0xFF54, /* FULLWIDTH LATIN SMALL LETTER T */ }, \
	{ 0xFF35, /* FULLWIDTH LATIN CAPITAL LETTER U */ \
	  0xFF55, /* FULLWIDTH LATIN SMALL LETTER U */ }, \
	{ 0xFF36, /* FULLWIDTH LATIN CAPITAL LETTER V */ \
	  0xFF56, /* FULLWIDTH LATIN SMALL LETTER V */ }, \
	{ 0xFF37, /* FULLWIDTH LATIN CAPITAL LETTER W */ \
	  0xFF57, /* FULLWIDTH LATIN SMALL LETTER W */ }, \
	{ 0xFF38, /* FULLWIDTH LATIN CAPITAL LETTER X */ \
	  0xFF58, /* FULLWIDTH LATIN SMALL LETTER X */ }, \
	{ 0xFF39, /* FULLWIDTH LATIN CAPITAL LETTER Y */ \
	  0xFF59, /* FULLWIDTH LATIN SMALL LETTER Y */ }, \
	{ 0xFF3A, /* FULLWIDTH LATIN CAPITAL LETTER Z */ \
	  0xFF5A, /* FULLWIDTH LATIN SMALL LETTER Z */ }, \
	{ 0x10CD, /* GEORGIAN CAPITAL LETTER AEN */ \
	  0x2D2D, /* GEORGIAN SMALL LETTER AEN */ }, \
	{ 0x10A0, /* GEORGIAN CAPITAL LETTER AN */ \
	  0x2D00, /* GEORGIAN SMALL LETTER AN */ }, \
	{ 0x10A1, /* GEORGIAN CAPITAL LETTER BAN */ \
	  0x2D01, /* GEORGIAN SMALL LETTER BAN */ }, \
	{ 0x10BA, /* GEORGIAN CAPITAL LETTER CAN */ \
	  0x2D1A, /* GEORGIAN SMALL LETTER CAN */ }, \
	{ 0x10BD, /* GEORGIAN CAPITAL LETTER CHAR */ \
	  0x2D1D, /* GEORGIAN SMALL LETTER CHAR */ }, \
	{ 0x10B9, /* GEORGIAN CAPITAL LETTER CHIN */ \
	  0x2D19, /* GEORGIAN SMALL LETTER CHIN */ }, \
	{ 0x10BC, /* GEORGIAN CAPITAL LETTER CIL */ \
	  0x2D1C, /* GEORGIAN SMALL LETTER CIL */ }, \
	{ 0x10A3, /* GEORGIAN CAPITAL LETTER DON */ \
	  0x2D03, /* GEORGIAN SMALL LETTER DON */ }, \
	{ 0x10A4, /* GEORGIAN CAPITAL LETTER EN */ \
	  0x2D04, /* GEORGIAN SMALL LETTER EN */ }, \
	{ 0x10A2, /* GEORGIAN CAPITAL LETTER GAN */ \
	  0x2D02, /* GEORGIAN SMALL LETTER GAN */ }, \
	{ 0x10B6, /* GEORGIAN CAPITAL LETTER GHAN */ \
	  0x2D16, /* GEORGIAN SMALL LETTER GHAN */ }, \
	{ 0x10C0, /* GEORGIAN CAPITAL LETTER HAE */ \
	  0x2D20, /* GEORGIAN SMALL LETTER HAE */ }, \
	{ 0x10C4, /* GEORGIAN CAPITAL LETTER HAR */ \
	  0x2D24, /* GEORGIAN SMALL LETTER HAR */ }, \
	{ 0x10C1, /* GEORGIAN CAPITAL LETTER HE */ \
	  0x2D21, /* GEORGIAN SMALL LETTER HE */ }, \
	{ 0x10C2, /* GEORGIAN CAPITAL LETTER HIE */ \
	  0x2D22, /* GEORGIAN SMALL LETTER HIE */ }, \
	{ 0x10C5, /* GEORGIAN CAPITAL LETTER HOE */ \
	  0x2D25, /* GEORGIAN SMALL LETTER HOE */ }, \
	{ 0x10A8, /* GEORGIAN CAPITAL LETTER IN */ \
	  0x2D08, /* GEORGIAN SMALL LETTER IN */ }, \
	{ 0x10BF, /* GEORGIAN CAPITAL LETTER JHAN */ \
	  0x2D1F, /* GEORGIAN SMALL LETTER JHAN */ }, \
	{ 0x10BB, /* GEORGIAN CAPITAL LETTER JIL */ \
	  0x2D1B, /* GEORGIAN SMALL LETTER JIL */ }, \
	{ 0x10A9, /* GEORGIAN CAPITAL LETTER KAN */ \
	  0x2D09, /* GEORGIAN SMALL LETTER KAN */ }, \
	{ 0x10B5, /* GEORGIAN CAPITAL LETTER KHAR */ \
	  0x2D15, /* GEORGIAN SMALL LETTER KHAR */ }, \
	{ 0x10AA, /* GEORGIAN CAPITAL LETTER LAS */ \
	  0x2D0A, /* GEORGIAN SMALL LETTER LAS */ }, \
	{ 0x10AB, /* GEORGIAN CAPITAL LETTER MAN */ \
	  0x2D0B, /* GEORGIAN SMALL LETTER MAN */ }, \
	{ 0x10AC, /* GEORGIAN CAPITAL LETTER NAR */ \
	  0x2D0C, /* GEORGIAN SMALL LETTER NAR */ }, \
	{ 0x10AD, /* GEORGIAN CAPITAL LETTER ON */ \
	  0x2D0D, /* GEORGIAN SMALL LETTER ON */ }, \
	{ 0x10AE, /* GEORGIAN CAPITAL LETTER PAR */ \
	  0x2D0E, /* GEORGIAN SMALL LETTER PAR */ }, \
	{ 0x10B4, /* GEORGIAN CAPITAL LETTER PHAR */ \
	  0x2D14, /* GEORGIAN SMALL LETTER PHAR */ }, \
	{ 0x10B7, /* GEORGIAN CAPITAL LETTER QAR */ \
	  0x2D17, /* GEORGIAN SMALL LETTER QAR */ }, \
	{ 0x10B0, /* GEORGIAN CAPITAL LETTER RAE */ \
	  0x2D10, /* GEORGIAN SMALL LETTER RAE */ }, \
	{ 0x10B1, /* GEORGIAN CAPITAL LETTER SAN */ \
	  0x2D11, /* GEORGIAN SMALL LETTER SAN */ }, \
	{ 0x10B8, /* GEORGIAN CAPITAL LETTER SHIN */ \
	  0x2D18, /* GEORGIAN SMALL LETTER SHIN */ }, \
	{ 0x10A7, /* GEORGIAN CAPITAL LETTER TAN */ \
	  0x2D07, /* GEORGIAN SMALL LETTER TAN */ }, \
	{ 0x10B2, /* GEORGIAN CAPITAL LETTER TAR */ \
	  0x2D12, /* GEORGIAN SMALL LETTER TAR */ }, \
	{ 0x10B3, /* GEORGIAN CAPITAL LETTER UN */ \
	  0x2D13, /* GEORGIAN SMALL LETTER UN */ }, \
	{ 0x10A5, /* GEORGIAN CAPITAL LETTER VIN */ \
	  0x2D05, /* GEORGIAN SMALL LETTER VIN */ }, \
	{ 0x10C3, /* GEORGIAN CAPITAL LETTER WE */ \
	  0x2D23, /* GEORGIAN SMALL LETTER WE */ }, \
	{ 0x10BE, /* GEORGIAN CAPITAL LETTER XAN */ \
	  0x2D1E, /* GEORGIAN SMALL LETTER XAN */ }, \
	{ 0x10C7, /* GEORGIAN CAPITAL LETTER YN */ \
	  0x2D27, /* GEORGIAN SMALL LETTER YN */ }, \
	{ 0x10A6, /* GEORGIAN CAPITAL LETTER ZEN */ \
	  0x2D06, /* GEORGIAN SMALL LETTER ZEN */ }, \
	{ 0x10AF, /* GEORGIAN CAPITAL LETTER ZHAR */ \
	  0x2D0F, /* GEORGIAN SMALL LETTER ZHAR */ }, \
	{ 0x2C00, /* GLAGOLITIC CAPITAL LETTER AZU */ \
	  0x2C30, /* GLAGOLITIC SMALL LETTER AZU */ }, \
	{ 0x2C28, /* GLAGOLITIC CAPITAL LETTER BIG YUS */ \
	  0x2C58, /* GLAGOLITIC SMALL LETTER BIG YUS */ }, \
	{ 0x2C01, /* GLAGOLITIC CAPITAL LETTER BUKY */ \
	  0x2C31, /* GLAGOLITIC SMALL LETTER BUKY */ }, \
	{ 0x2C1D, /* GLAGOLITIC CAPITAL LETTER CHRIVI */ \
	  0x2C4D, /* GLAGOLITIC SMALL LETTER CHRIVI */ }, \
	{ 0x2C0C, /* GLAGOLITIC CAPITAL LETTER DJERVI */ \
	  0x2C3C, /* GLAGOLITIC SMALL LETTER DJERVI */ }, \
	{ 0x2C04, /* GLAGOLITIC CAPITAL LETTER DOBRO */ \
	  0x2C34, /* GLAGOLITIC SMALL LETTER DOBRO */ }, \
	{ 0x2C07, /* GLAGOLITIC CAPITAL LETTER DZELO */ \
	  0x2C37, /* GLAGOLITIC SMALL LETTER DZELO */ }, \
	{ 0x2C2A, /* GLAGOLITIC CAPITAL LETTER FITA */ \
	  0x2C5A, /* GLAGOLITIC SMALL LETTER FITA */ }, \
	{ 0x2C17, /* GLAGOLITIC CAPITAL LETTER FRITU */ \
	  0x2C47, /* GLAGOLITIC SMALL LETTER FRITU */ }, \
	{ 0x2C03, /* GLAGOLITIC CAPITAL LETTER GLAGOLI */ \
	  0x2C33, /* GLAGOLITIC SMALL LETTER GLAGOLI */ }, \
	{ 0x2C18, /* GLAGOLITIC CAPITAL LETTER HERU */ \
	  0x2C48, /* GLAGOLITIC SMALL LETTER HERU */ }, \
	{ 0x2C0B, /* GLAGOLITIC CAPITAL LETTER I */ \
	  0x2C3B, /* GLAGOLITIC SMALL LETTER I */ }, \
	{ 0x2C0A, /* GLAGOLITIC CAPITAL LETTER INITIAL IZHE */ \
	  0x2C3A, /* GLAGOLITIC SMALL LETTER INITIAL IZHE */ }, \
	{ 0x2C29, /* GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS */ \
	  0x2C59, /* GLAGOLITIC SMALL LETTER IOTATED BIG YUS */ }, \
	{ 0x2C27, /* GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS */ \
	  0x2C57, /* GLAGOLITIC SMALL LETTER IOTATED SMALL YUS */ }, \
	{ 0x2C09, /* GLAGOLITIC CAPITAL LETTER IZHE */ \
	  0x2C39, /* GLAGOLITIC SMALL LETTER IZHE */ }, \
	{ 0x2C2B, /* GLAGOLITIC CAPITAL LETTER IZHITSA */ \
	  0x2C5B, /* GLAGOLITIC SMALL LETTER IZHITSA */ }, \
	{ 0x2C0D, /* GLAGOLITIC CAPITAL LETTER KAKO */ \
	  0x2C3D, /* GLAGOLITIC SMALL LETTER KAKO */ }, \
	{ 0x2C2E, /* GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE */ \
	  0x2C5E, /* GLAGOLITIC SMALL LETTER LATINATE MYSLITE */ }, \
	{ 0x2C0E, /* GLAGOLITIC CAPITAL LETTER LJUDIJE */ \
	  0x2C3E, /* GLAGOLITIC SMALL LETTER LJUDIJE */ }, \
	{ 0x2C0F, /* GLAGOLITIC CAPITAL LETTER MYSLITE */ \
	  0x2C3F, /* GLAGOLITIC SMALL LETTER MYSLITE */ }, \
	{ 0x2C10, /* GLAGOLITIC CAPITAL LETTER NASHI */ \
	  0x2C40, /* GLAGOLITIC SMALL LETTER NASHI */ }, \
	{ 0x2C11, /* GLAGOLITIC CAPITAL LETTER ONU */ \
	  0x2C41, /* GLAGOLITIC SMALL LETTER ONU */ }, \
	{ 0x2C19, /* GLAGOLITIC CAPITAL LETTER OTU */ \
	  0x2C49, /* GLAGOLITIC SMALL LETTER OTU */ }, \
	{ 0x2C1A, /* GLAGOLITIC CAPITAL LETTER PE */ \
	  0x2C4A, /* GLAGOLITIC SMALL LETTER PE */ }, \
	{ 0x2C12, /* GLAGOLITIC CAPITAL LETTER POKOJI */ \
	  0x2C42, /* GLAGOLITIC SMALL LETTER POKOJI */ }, \
	{ 0x2C13, /* GLAGOLITIC CAPITAL LETTER RITSI */ \
	  0x2C43, /* GLAGOLITIC SMALL LETTER RITSI */ }, \
	{ 0x2C1E, /* GLAGOLITIC CAPITAL LETTER SHA */ \
	  0x2C4E, /* GLAGOLITIC SMALL LETTER SHA */ }, \
	{ 0x2C1B, /* GLAGOLITIC CAPITAL LETTER SHTA */ \
	  0x2C4B, /* GLAGOLITIC SMALL LETTER SHTA */ }, \
	{ 0x2C2C, /* GLAGOLITIC CAPITAL LETTER SHTAPIC */ \
	  0x2C5C, /* GLAGOLITIC SMALL LETTER SHTAPIC */ }, \
	{ 0x2C14, /* GLAGOLITIC CAPITAL LETTER SLOVO */ \
	  0x2C44, /* GLAGOLITIC SMALL LETTER SLOVO */ }, \
	{ 0x2C24, /* GLAGOLITIC CAPITAL LETTER SMALL YUS */ \
	  0x2C54, /* GLAGOLITIC SMALL LETTER SMALL YUS */ }, \
	{ 0x2C25, /* GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL */ \
	  0x2C55, /* GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL */ }, \
	{ 0x2C22, /* GLAGOLITIC CAPITAL LETTER SPIDERY HA */ \
	  0x2C52, /* GLAGOLITIC SMALL LETTER SPIDERY HA */ }, \
	{ 0x2C2D, /* GLAGOLITIC CAPITAL LETTER TROKUTASTI A */ \
	  0x2C5D, /* GLAGOLITIC SMALL LETTER TROKUTASTI A */ }, \
	{ 0x2C1C, /* GLAGOLITIC CAPITAL LETTER TSI */ \
	  0x2C4C, /* GLAGOLITIC SMALL LETTER TSI */ }, \
	{ 0x2C15, /* GLAGOLITIC CAPITAL LETTER TVRIDO */ \
	  0x2C45, /* GLAGOLITIC SMALL LETTER TVRIDO */ }, \
	{ 0x2C16, /* GLAGOLITIC CAPITAL LETTER UKU */ \
	  0x2C46, /* GLAGOLITIC SMALL LETTER UKU */ }, \
	{ 0x2C02, /* GLAGOLITIC CAPITAL LETTER VEDE */ \
	  0x2C32, /* GLAGOLITIC SMALL LETTER VEDE */ }, \
	{ 0x2C21, /* GLAGOLITIC CAPITAL LETTER YATI */ \
	  0x2C51, /* GLAGOLITIC SMALL LETTER YATI */ }, \
	{ 0x2C20, /* GLAGOLITIC CAPITAL LETTER YERI */ \
	  0x2C50, /* GLAGOLITIC SMALL LETTER YERI */ }, \
	{ 0x2C1F, /* GLAGOLITIC CAPITAL LETTER YERU */ \
	  0x2C4F, /* GLAGOLITIC SMALL LETTER YERU */ }, \
	{ 0x2C05, /* GLAGOLITIC CAPITAL LETTER YESTU */ \
	  0x2C35, /* GLAGOLITIC SMALL LETTER YESTU */ }, \
	{ 0x2C26, /* GLAGOLITIC CAPITAL LETTER YO */ \
	  0x2C56, /* GLAGOLITIC SMALL LETTER YO */ }, \
	{ 0x2C23, /* GLAGOLITIC CAPITAL LETTER YU */ \
	  0x2C53, /* GLAGOLITIC SMALL LETTER YU */ }, \
	{ 0x2C08, /* GLAGOLITIC CAPITAL LETTER ZEMLJA */ \
	  0x2C38, /* GLAGOLITIC SMALL LETTER ZEMLJA */ }, \
	{ 0x2C06, /* GLAGOLITIC CAPITAL LETTER ZHIVETE */ \
	  0x2C36, /* GLAGOLITIC SMALL LETTER ZHIVETE */ }, \
	{ 0x0391, /* GREEK CAPITAL LETTER ALPHA */ \
	  0x03B1, /* GREEK SMALL LETTER ALPHA */ }, \
	{ 0x1F09, /* GREEK CAPITAL LETTER ALPHA WITH DASIA */ \
	  0x1F01, /* GREEK SMALL LETTER ALPHA WITH DASIA */ }, \
	{ 0x1F0D, /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA */ \
	  0x1F05, /* GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA */ }, \
	{ 0x1F0F, /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI */ \
	  0x1F07, /* GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI */ }, \
	{ 0x1F0B, /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA */ \
	  0x1F03, /* GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA */ }, \
	{ 0x1FB9, /* GREEK CAPITAL LETTER ALPHA WITH MACRON */ \
	  0x1FB1, /* GREEK SMALL LETTER ALPHA WITH MACRON */ }, \
	{ 0x1FBB, /* GREEK CAPITAL LETTER ALPHA WITH OXIA */ \
	  0x1F71, /* GREEK SMALL LETTER ALPHA WITH OXIA */ }, \
	{ 0x1F08, /* GREEK CAPITAL LETTER ALPHA WITH PSILI */ \
	  0x1F00, /* GREEK SMALL LETTER ALPHA WITH PSILI */ }, \
	{ 0x1F0C, /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA */ \
	  0x1F04, /* GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA */ }, \
	{ 0x1F0E, /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI */ \
	  0x1F06, /* GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI */ }, \
	{ 0x1F0A, /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA */ \
	  0x1F02, /* GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA */ }, \
	{ 0x0386, /* GREEK CAPITAL LETTER ALPHA WITH TONOS */ \
	  0x03AC, /* GREEK SMALL LETTER ALPHA WITH TONOS */ }, \
	{ 0x1FBA, /* GREEK CAPITAL LETTER ALPHA WITH VARIA */ \
	  0x1F70, /* GREEK SMALL LETTER ALPHA WITH VARIA */ }, \
	{ 0x1FB8, /* GREEK CAPITAL LETTER ALPHA WITH VRACHY */ \
	  0x1FB0, /* GREEK SMALL LETTER ALPHA WITH VRACHY */ }, \
	{ 0x0372, /* GREEK CAPITAL LETTER ARCHAIC SAMPI */ \
	  0x0373, /* GREEK SMALL LETTER ARCHAIC SAMPI */ }, \
	{ 0x0392, /* GREEK CAPITAL LETTER BETA */ \
	  0x03B2, /* GREEK SMALL LETTER BETA */ }, \
	{ 0x03A7, /* GREEK CAPITAL LETTER CHI */ \
	  0x03C7, /* GREEK SMALL LETTER CHI */ }, \
	{ 0x0394, /* GREEK CAPITAL LETTER DELTA */ \
	  0x03B4, /* GREEK SMALL LETTER DELTA */ }, \
	{ 0x0395, /* GREEK CAPITAL LETTER EPSILON */ \
	  0x03B5, /* GREEK SMALL LETTER EPSILON */ }, \
	{ 0x1F19, /* GREEK CAPITAL LETTER EPSILON WITH DASIA */ \
	  0x1F11, /* GREEK SMALL LETTER EPSILON WITH DASIA */ }, \
	{ 0x1F1D, /* GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA */ \
	  0x1F15, /* GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA */ }, \
	{ 0x1F1B, /* GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA */ \
	  0x1F13, /* GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA */ }, \
	{ 0x1FC9, /* GREEK CAPITAL LETTER EPSILON WITH OXIA */ \
	  0x1F73, /* GREEK SMALL LETTER EPSILON WITH OXIA */ }, \
	{ 0x1F18, /* GREEK CAPITAL LETTER EPSILON WITH PSILI */ \
	  0x1F10, /* GREEK SMALL LETTER EPSILON WITH PSILI */ }, \
	{ 0x1F1C, /* GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA */ \
	  0x1F14, /* GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA */ }, \
	{ 0x1F1A, /* GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA */ \
	  0x1F12, /* GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA */ }, \
	{ 0x0388, /* GREEK CAPITAL LETTER EPSILON WITH TONOS */ \
	  0x03AD, /* GREEK SMALL LETTER EPSILON WITH TONOS */ }, \
	{ 0x1FC8, /* GREEK CAPITAL LETTER EPSILON WITH VARIA */ \
	  0x1F72, /* GREEK SMALL LETTER EPSILON WITH VARIA */ }, \
	{ 0x0397, /* GREEK CAPITAL LETTER ETA */ \
	  0x03B7, /* GREEK SMALL LETTER ETA */ }, \
	{ 0x1F29, /* GREEK CAPITAL LETTER ETA WITH DASIA */ \
	  0x1F21, /* GREEK SMALL LETTER ETA WITH DASIA */ }, \
	{ 0x1F2D, /* GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA */ \
	  0x1F25, /* GREEK SMALL LETTER ETA WITH DASIA AND OXIA */ }, \
	{ 0x1F2F, /* GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI */ \
	  0x1F27, /* GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI */ }, \
	{ 0x1F2B, /* GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA */ \
	  0x1F23, /* GREEK SMALL LETTER ETA WITH DASIA AND VARIA */ }, \
	{ 0x1FCB, /* GREEK CAPITAL LETTER ETA WITH OXIA */ \
	  0x1F75, /* GREEK SMALL LETTER ETA WITH OXIA */ }, \
	{ 0x1F28, /* GREEK CAPITAL LETTER ETA WITH PSILI */ \
	  0x1F20, /* GREEK SMALL LETTER ETA WITH PSILI */ }, \
	{ 0x1F2C, /* GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA */ \
	  0x1F24, /* GREEK SMALL LETTER ETA WITH PSILI AND OXIA */ }, \
	{ 0x1F2E, /* GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI */ \
	  0x1F26, /* GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI */ }, \
	{ 0x1F2A, /* GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA */ \
	  0x1F22, /* GREEK SMALL LETTER ETA WITH PSILI AND VARIA */ }, \
	{ 0x0389, /* GREEK CAPITAL LETTER ETA WITH TONOS */ \
	  0x03AE, /* GREEK SMALL LETTER ETA WITH TONOS */ }, \
	{ 0x1FCA, /* GREEK CAPITAL LETTER ETA WITH VARIA */ \
	  0x1F74, /* GREEK SMALL LETTER ETA WITH VARIA */ }, \
	{ 0x0393, /* GREEK CAPITAL LETTER GAMMA */ \
	  0x03B3, /* GREEK SMALL LETTER GAMMA */ }, \
	{ 0x0370, /* GREEK CAPITAL LETTER HETA */ \
	  0x0371, /* GREEK SMALL LETTER HETA */ }, \
	{ 0x0399, /* GREEK CAPITAL LETTER IOTA */ \
	  0x03B9, /* GREEK SMALL LETTER IOTA */ }, \
	{ 0x1F39, /* GREEK CAPITAL LETTER IOTA WITH DASIA */ \
	  0x1F31, /* GREEK SMALL LETTER IOTA WITH DASIA */ }, \
	{ 0x1F3D, /* GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA */ \
	  0x1F35, /* GREEK SMALL LETTER IOTA WITH DASIA AND OXIA */ }, \
	{ 0x1F3F, /* GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI */ \
	  0x1F37, /* GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI */ }, \
	{ 0x1F3B, /* GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA */ \
	  0x1F33, /* GREEK SMALL LETTER IOTA WITH DASIA AND VARIA */ }, \
	{ 0x03AA, /* GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */ \
	  0x03CA, /* GREEK SMALL LETTER IOTA WITH DIALYTIKA */ }, \
	{ 0x1FD9, /* GREEK CAPITAL LETTER IOTA WITH MACRON */ \
	  0x1FD1, /* GREEK SMALL LETTER IOTA WITH MACRON */ }, \
	{ 0x1FDB, /* GREEK CAPITAL LETTER IOTA WITH OXIA */ \
	  0x1F77, /* GREEK SMALL LETTER IOTA WITH OXIA */ }, \
	{ 0x1F38, /* GREEK CAPITAL LETTER IOTA WITH PSILI */ \
	  0x1F30, /* GREEK SMALL LETTER IOTA WITH PSILI */ }, \
	{ 0x1F3C, /* GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA */ \
	  0x1F34, /* GREEK SMALL LETTER IOTA WITH PSILI AND OXIA */ }, \
	{ 0x1F3E, /* GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI */ \
	  0x1F36, /* GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI */ }, \
	{ 0x1F3A, /* GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA */ \
	  0x1F32, /* GREEK SMALL LETTER IOTA WITH PSILI AND VARIA */ }, \
	{ 0x038A, /* GREEK CAPITAL LETTER IOTA WITH TONOS */ \
	  0x03AF, /* GREEK SMALL LETTER IOTA WITH TONOS */ }, \
	{ 0x1FDA, /* GREEK CAPITAL LETTER IOTA WITH VARIA */ \
	  0x1F76, /* GREEK SMALL LETTER IOTA WITH VARIA */ }, \
	{ 0x1FD8, /* GREEK CAPITAL LETTER IOTA WITH VRACHY */ \
	  0x1FD0, /* GREEK SMALL LETTER IOTA WITH VRACHY */ }, \
	{ 0x039A, /* GREEK CAPITAL LETTER KAPPA */ \
	  0x03BA, /* GREEK SMALL LETTER KAPPA */ }, \
	{ 0x039B, /* GREEK CAPITAL LETTER LAMDA */ \
	  0x03BB, /* GREEK SMALL LETTER LAMDA */ }, \
	{ 0x039C, /* GREEK CAPITAL LETTER MU */ \
	  0x03BC, /* GREEK SMALL LETTER MU */ }, \
	{ 0x039D, /* GREEK CAPITAL LETTER NU */ \
	  0x03BD, /* GREEK SMALL LETTER NU */ }, \
	{ 0x03A9, /* GREEK CAPITAL LETTER OMEGA */ \
	  0x03C9, /* GREEK SMALL LETTER OMEGA */ }, \
	{ 0x1F69, /* GREEK CAPITAL LETTER OMEGA WITH DASIA */ \
	  0x1F61, /* GREEK SMALL LETTER OMEGA WITH DASIA */ }, \
	{ 0x1F6D, /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA */ \
	  0x1F65, /* GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA */ }, \
	{ 0x1F6F, /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI */ \
	  0x1F67, /* GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI */ }, \
	{ 0x1F6B, /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA */ \
	  0x1F63, /* GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA */ }, \
	{ 0x1FFB, /* GREEK CAPITAL LETTER OMEGA WITH OXIA */ \
	  0x1F7D, /* GREEK SMALL LETTER OMEGA WITH OXIA */ }, \
	{ 0x1F68, /* GREEK CAPITAL LETTER OMEGA WITH PSILI */ \
	  0x1F60, /* GREEK SMALL LETTER OMEGA WITH PSILI */ }, \
	{ 0x1F6C, /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA */ \
	  0x1F64, /* GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA */ }, \
	{ 0x1F6E, /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI */ \
	  0x1F66, /* GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI */ }, \
	{ 0x1F6A, /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA */ \
	  0x1F62, /* GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA */ }, \
	{ 0x038F, /* GREEK CAPITAL LETTER OMEGA WITH TONOS */ \
	  0x03CE, /* GREEK SMALL LETTER OMEGA WITH TONOS */ }, \
	{ 0x1FFA, /* GREEK CAPITAL LETTER OMEGA WITH VARIA */ \
	  0x1F7C, /* GREEK SMALL LETTER OMEGA WITH VARIA */ }, \
	{ 0x039F, /* GREEK CAPITAL LETTER OMICRON */ \
	  0x03BF, /* GREEK SMALL LETTER OMICRON */ }, \
	{ 0x1F49, /* GREEK CAPITAL LETTER OMICRON WITH DASIA */ \
	  0x1F41, /* GREEK SMALL LETTER OMICRON WITH DASIA */ }, \
	{ 0x1F4D, /* GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA */ \
	  0x1F45, /* GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA */ }, \
	{ 0x1F4B, /* GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA */ \
	  0x1F43, /* GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA */ }, \
	{ 0x1FF9, /* GREEK CAPITAL LETTER OMICRON WITH OXIA */ \
	  0x1F79, /* GREEK SMALL LETTER OMICRON WITH OXIA */ }, \
	{ 0x1F48, /* GREEK CAPITAL LETTER OMICRON WITH PSILI */ \
	  0x1F40, /* GREEK SMALL LETTER OMICRON WITH PSILI */ }, \
	{ 0x1F4C, /* GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA */ \
	  0x1F44, /* GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA */ }, \
	{ 0x1F4A, /* GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA */ \
	  0x1F42, /* GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA */ }, \
	{ 0x038C, /* GREEK CAPITAL LETTER OMICRON WITH TONOS */ \
	  0x03CC, /* GREEK SMALL LETTER OMICRON WITH TONOS */ }, \
	{ 0x1FF8, /* GREEK CAPITAL LETTER OMICRON WITH VARIA */ \
	  0x1F78, /* GREEK SMALL LETTER OMICRON WITH VARIA */ }, \
	{ 0x0376, /* GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA */ \
	  0x0377, /* GREEK SMALL LETTER PAMPHYLIAN DIGAMMA */ }, \
	{ 0x03A6, /* GREEK CAPITAL LETTER PHI */ \
	  0x03C6, /* GREEK SMALL LETTER PHI */ }, \
	{ 0x03A0, /* GREEK CAPITAL LETTER PI */ \
	  0x03C0, /* GREEK SMALL LETTER PI */ }, \
	{ 0x03A8, /* GREEK CAPITAL LETTER PSI */ \
	  0x03C8, /* GREEK SMALL LETTER PSI */ }, \
	{ 0x03A1, /* GREEK CAPITAL LETTER RHO */ \
	  0x03C1, /* GREEK SMALL LETTER RHO */ }, \
	{ 0x1FEC, /* GREEK CAPITAL LETTER RHO WITH DASIA */ \
	  0x1FE5, /* GREEK SMALL LETTER RHO WITH DASIA */ }, \
	{ 0x03FA, /* GREEK CAPITAL LETTER SAN */ \
	  0x03FB, /* GREEK SMALL LETTER SAN */ }, \
	{ 0x03F7, /* GREEK CAPITAL LETTER SHO */ \
	  0x03F8, /* GREEK SMALL LETTER SHO */ }, \
	{ 0x03A3, /* GREEK CAPITAL LETTER SIGMA */ \
	  0x03C3, /* GREEK SMALL LETTER SIGMA */ }, \
	{ 0x03A4, /* GREEK CAPITAL LETTER TAU */ \
	  0x03C4, /* GREEK SMALL LETTER TAU */ }, \
	{ 0x0398, /* GREEK CAPITAL LETTER THETA */ \
	  0x03B8, /* GREEK SMALL LETTER THETA */ }, \
	{ 0x03A5, /* GREEK CAPITAL LETTER UPSILON */ \
	  0x03C5, /* GREEK SMALL LETTER UPSILON */ }, \
	{ 0x1F59, /* GREEK CAPITAL LETTER UPSILON WITH DASIA */ \
	  0x1F51, /* GREEK SMALL LETTER UPSILON WITH DASIA */ }, \
	{ 0x1F5D, /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA */ \
	  0x1F55, /* GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA */ }, \
	{ 0x1F5F, /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI */ \
	  0x1F57, /* GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI */ }, \
	{ 0x1F5B, /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA */ \
	  0x1F53, /* GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA */ }, \
	{ 0x03AB, /* GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */ \
	  0x03CB, /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA */ }, \
	{ 0x1FE9, /* GREEK CAPITAL LETTER UPSILON WITH MACRON */ \
	  0x1FE1, /* GREEK SMALL LETTER UPSILON WITH MACRON */ }, \
	{ 0x1FEB, /* GREEK CAPITAL LETTER UPSILON WITH OXIA */ \
	  0x1F7B, /* GREEK SMALL LETTER UPSILON WITH OXIA */ }, \
	{ 0x038E, /* GREEK CAPITAL LETTER UPSILON WITH TONOS */ \
	  0x03CD, /* GREEK SMALL LETTER UPSILON WITH TONOS */ }, \
	{ 0x1FEA, /* GREEK CAPITAL LETTER UPSILON WITH VARIA */ \
	  0x1F7A, /* GREEK SMALL LETTER UPSILON WITH VARIA */ }, \
	{ 0x1FE8, /* GREEK CAPITAL LETTER UPSILON WITH VRACHY */ \
	  0x1FE0, /* GREEK SMALL LETTER UPSILON WITH VRACHY */ }, \
	{ 0x039E, /* GREEK CAPITAL LETTER XI */ \
	  0x03BE, /* GREEK SMALL LETTER XI */ }, \
	{ 0x0396, /* GREEK CAPITAL LETTER ZETA */ \
	  0x03B6, /* GREEK SMALL LETTER ZETA */ }, \
	{ 0x0041, /* LATIN CAPITAL LETTER A */ \
	  0x0061, /* LATIN SMALL LETTER A */ }, \
	{ 0x00C1, /* LATIN CAPITAL LETTER A WITH ACUTE */ \
	  0x00E1, /* LATIN SMALL LETTER A WITH ACUTE */ }, \
	{ 0x0102, /* LATIN CAPITAL LETTER A WITH BREVE */ \
	  0x0103, /* LATIN SMALL LETTER A WITH BREVE */ }, \
	{ 0x1EAE, /* LATIN CAPITAL LETTER A WITH BREVE AND ACUTE */ \
	  0x1EAF, /* LATIN SMALL LETTER A WITH BREVE AND ACUTE */ }, \
	{ 0x1EB6, /* LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW */ \
	  0x1EB7, /* LATIN SMALL LETTER A WITH BREVE AND DOT BELOW */ }, \
	{ 0x1EB0, /* LATIN CAPITAL LETTER A WITH BREVE AND GRAVE */ \
	  0x1EB1, /* LATIN SMALL LETTER A WITH BREVE AND GRAVE */ }, \
	{ 0x1EB2, /* LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE */ \
	  0x1EB3, /* LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE */ }, \
	{ 0x1EB4, /* LATIN CAPITAL LETTER A WITH BREVE AND TILDE */ \
	  0x1EB5, /* LATIN SMALL LETTER A WITH BREVE AND TILDE */ }, \
	{ 0x01CD, /* LATIN CAPITAL LETTER A WITH CARON */ \
	  0x01CE, /* LATIN SMALL LETTER A WITH CARON */ }, \
	{ 0x00C2, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */ \
	  0x00E2, /* LATIN SMALL LETTER A WITH CIRCUMFLEX */ }, \
	{ 0x1EA4, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE */ \
	  0x1EA5, /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE */ }, \
	{ 0x1EAC, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW */ \
	  0x1EAD, /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW */ }, \
	{ 0x1EA6, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE */ \
	  0x1EA7, /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE */ }, \
	{ 0x1EA8, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */ \
	  0x1EA9, /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */ }, \
	{ 0x1EAA, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE */ \
	  0x1EAB, /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE */ }, \
	{ 0x00C4, /* LATIN CAPITAL LETTER A WITH DIAERESIS */ \
	  0x00E4, /* LATIN SMALL LETTER A WITH DIAERESIS */ }, \
	{ 0x01DE, /* LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON */ \
	  0x01DF, /* LATIN SMALL LETTER A WITH DIAERESIS AND MACRON */ }, \
	{ 0x0226, /* LATIN CAPITAL LETTER A WITH DOT ABOVE */ \
	  0x0227, /* LATIN SMALL LETTER A WITH DOT ABOVE */ }, \
	{ 0x01E0, /* LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON */ \
	  0x01E1, /* LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON */ }, \
	{ 0x1EA0, /* LATIN CAPITAL LETTER A WITH DOT BELOW */ \
	  0x1EA1, /* LATIN SMALL LETTER A WITH DOT BELOW */ }, \
	{ 0x0200, /* LATIN CAPITAL LETTER A WITH DOUBLE GRAVE */ \
	  0x0201, /* LATIN SMALL LETTER A WITH DOUBLE GRAVE */ }, \
	{ 0x00C0, /* LATIN CAPITAL LETTER A WITH GRAVE */ \
	  0x00E0, /* LATIN SMALL LETTER A WITH GRAVE */ }, \
	{ 0x1EA2, /* LATIN CAPITAL LETTER A WITH HOOK ABOVE */ \
	  0x1EA3, /* LATIN SMALL LETTER A WITH HOOK ABOVE */ }, \
	{ 0x0202, /* LATIN CAPITAL LETTER A WITH INVERTED BREVE */ \
	  0x0203, /* LATIN SMALL LETTER A WITH INVERTED BREVE */ }, \
	{ 0x0100, /* LATIN CAPITAL LETTER A WITH MACRON */ \
	  0x0101, /* LATIN SMALL LETTER A WITH MACRON */ }, \
	{ 0x0104, /* LATIN CAPITAL LETTER A WITH OGONEK */ \
	  0x0105, /* LATIN SMALL LETTER A WITH OGONEK */ }, \
	{ 0x00C5, /* LATIN CAPITAL LETTER A WITH RING ABOVE */ \
	  0x00E5, /* LATIN SMALL LETTER A WITH RING ABOVE */ }, \
	{ 0x01FA, /* LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE */ \
	  0x01FB, /* LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE */ }, \
	{ 0x1E00, /* LATIN CAPITAL LETTER A WITH RING BELOW */ \
	  0x1E01, /* LATIN SMALL LETTER A WITH RING BELOW */ }, \
	{ 0x023A, /* LATIN CAPITAL LETTER A WITH STROKE */ \
	  0x2C65, /* LATIN SMALL LETTER A WITH STROKE */ }, \
	{ 0x00C3, /* LATIN CAPITAL LETTER A WITH TILDE */ \
	  0x00E3, /* LATIN SMALL LETTER A WITH TILDE */ }, \
	{ 0xA732, /* LATIN CAPITAL LETTER AA */ \
	  0xA733, /* LATIN SMALL LETTER AA */ }, \
	{ 0x00C6, /* LATIN CAPITAL LETTER AE */ \
	  0x00E6, /* LATIN SMALL LETTER AE */ }, \
	{ 0x01FC, /* LATIN CAPITAL LETTER AE WITH ACUTE */ \
	  0x01FD, /* LATIN SMALL LETTER AE WITH ACUTE */ }, \
	{ 0x01E2, /* LATIN CAPITAL LETTER AE WITH MACRON */ \
	  0x01E3, /* LATIN SMALL LETTER AE WITH MACRON */ }, \
	{ 0x2C6D, /* LATIN CAPITAL LETTER ALPHA */ \
	  0x0251, /* LATIN SMALL LETTER ALPHA */ }, \
	{ 0xA734, /* LATIN CAPITAL LETTER AO */ \
	  0xA735, /* LATIN SMALL LETTER AO */ }, \
	{ 0xA736, /* LATIN CAPITAL LETTER AU */ \
	  0xA737, /* LATIN SMALL LETTER AU */ }, \
	{ 0xA738, /* LATIN CAPITAL LETTER AV */ \
	  0xA739, /* LATIN SMALL LETTER AV */ }, \
	{ 0xA73A, /* LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR */ \
	  0xA73B, /* LATIN SMALL LETTER AV WITH HORIZONTAL BAR */ }, \
	{ 0xA73C, /* LATIN CAPITAL LETTER AY */ \
	  0xA73D, /* LATIN SMALL LETTER AY */ }, \
	{ 0x0042, /* LATIN CAPITAL LETTER B */ \
	  0x0062, /* LATIN SMALL LETTER B */ }, \
	{ 0x1E02, /* LATIN CAPITAL LETTER B WITH DOT ABOVE */ \
	  0x1E03, /* LATIN SMALL LETTER B WITH DOT ABOVE */ }, \
	{ 0x1E04, /* LATIN CAPITAL LETTER B WITH DOT BELOW */ \
	  0x1E05, /* LATIN SMALL LETTER B WITH DOT BELOW */ }, \
	{ 0xA796, /* LATIN CAPITAL LETTER B WITH FLOURISH */ \
	  0xA797, /* LATIN SMALL LETTER B WITH FLOURISH */ }, \
	{ 0x0181, /* LATIN CAPITAL LETTER B WITH HOOK */ \
	  0x0253, /* LATIN SMALL LETTER B WITH HOOK */ }, \
	{ 0x1E06, /* LATIN CAPITAL LETTER B WITH LINE BELOW */ \
	  0x1E07, /* LATIN SMALL LETTER B WITH LINE BELOW */ }, \
	{ 0x0243, /* LATIN CAPITAL LETTER B WITH STROKE */ \
	  0x0180, /* LATIN SMALL LETTER B WITH STROKE */ }, \
	{ 0x0182, /* LATIN CAPITAL LETTER B WITH TOPBAR */ \
	  0x0183, /* LATIN SMALL LETTER B WITH TOPBAR */ }, \
	{ 0xA7B4, /* LATIN CAPITAL LETTER BETA */ \
	  0xA7B5, /* LATIN SMALL LETTER BETA */ }, \
	{ 0xA746, /* LATIN CAPITAL LETTER BROKEN L */ \
	  0xA747, /* LATIN SMALL LETTER BROKEN L */ }, \
	{ 0x0043, /* LATIN CAPITAL LETTER C */ \
	  0x0063, /* LATIN SMALL LETTER C */ }, \
	{ 0x0106, /* LATIN CAPITAL LETTER C WITH ACUTE */ \
	  0x0107, /* LATIN SMALL LETTER C WITH ACUTE */ }, \
	{ 0xA792, /* LATIN CAPITAL LETTER C WITH BAR */ \
	  0xA793, /* LATIN SMALL LETTER C WITH BAR */ }, \
	{ 0x010C, /* LATIN CAPITAL LETTER C WITH CARON */ \
	  0x010D, /* LATIN SMALL LETTER C WITH CARON */ }, \
	{ 0x00C7, /* LATIN CAPITAL LETTER C WITH CEDILLA */ \
	  0x00E7, /* LATIN SMALL LETTER C WITH CEDILLA */ }, \
	{ 0x1E08, /* LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE */ \
	  0x1E09, /* LATIN SMALL LETTER C WITH CEDILLA AND ACUTE */ }, \
	{ 0x0108, /* LATIN CAPITAL LETTER C WITH CIRCUMFLEX */ \
	  0x0109, /* LATIN SMALL LETTER C WITH CIRCUMFLEX */ }, \
	{ 0x010A, /* LATIN CAPITAL LETTER C WITH DOT ABOVE */ \
	  0x010B, /* LATIN SMALL LETTER C WITH DOT ABOVE */ }, \
	{ 0x0187, /* LATIN CAPITAL LETTER C WITH HOOK */ \
	  0x0188, /* LATIN SMALL LETTER C WITH HOOK */ }, \
	{ 0x023B, /* LATIN CAPITAL LETTER C WITH STROKE */ \
	  0x023C, /* LATIN SMALL LETTER C WITH STROKE */ }, \
	{ 0xA7B3, /* LATIN CAPITAL LETTER CHI */ \
	  0xAB53, /* LATIN SMALL LETTER CHI */ }, \
	{ 0xA76E, /* LATIN CAPITAL LETTER CON */ \
	  0xA76F, /* LATIN SMALL LETTER CON */ }, \
	{ 0xA72C, /* LATIN CAPITAL LETTER CUATRILLO */ \
	  0xA72D, /* LATIN SMALL LETTER CUATRILLO */ }, \
	{ 0xA72E, /* LATIN CAPITAL LETTER CUATRILLO WITH COMMA */ \
	  0xA72F, /* LATIN SMALL LETTER CUATRILLO WITH COMMA */ }, \
	{ 0x0044, /* LATIN CAPITAL LETTER D */ \
	  0x0064, /* LATIN SMALL LETTER D */ }, \
	{ 0x010E, /* LATIN CAPITAL LETTER D WITH CARON */ \
	  0x010F, /* LATIN SMALL LETTER D WITH CARON */ }, \
	{ 0x1E10, /* LATIN CAPITAL LETTER D WITH CEDILLA */ \
	  0x1E11, /* LATIN SMALL LETTER D WITH CEDILLA */ }, \
	{ 0x1E12, /* LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW */ \
	  0x1E13, /* LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW */ }, \
	{ 0x1E0A, /* LATIN CAPITAL LETTER D WITH DOT ABOVE */ \
	  0x1E0B, /* LATIN SMALL LETTER D WITH DOT ABOVE */ }, \
	{ 0x1E0C, /* LATIN CAPITAL LETTER D WITH DOT BELOW */ \
	  0x1E0D, /* LATIN SMALL LETTER D WITH DOT BELOW */ }, \
	{ 0x018A, /* LATIN CAPITAL LETTER D WITH HOOK */ \
	  0x0257, /* LATIN SMALL LETTER D WITH HOOK */ }, \
	{ 0x1E0E, /* LATIN CAPITAL LETTER D WITH LINE BELOW */ \
	  0x1E0F, /* LATIN SMALL LETTER D WITH LINE BELOW */ }, \
	{ 0x0110, /* LATIN CAPITAL LETTER D WITH STROKE */ \
	  0x0111, /* LATIN SMALL LETTER D WITH STROKE */ }, \
	{ 0x018B, /* LATIN CAPITAL LETTER D WITH TOPBAR */ \
	  0x018C, /* LATIN SMALL LETTER D WITH TOPBAR */ }, \
	{ 0x01F1, /* LATIN CAPITAL LETTER DZ */ \
	  0x01F3, /* LATIN SMALL LETTER DZ */ }, \
	{ 0x01C4, /* LATIN CAPITAL LETTER DZ WITH CARON */ \
	  0x01C6, /* LATIN SMALL LETTER DZ WITH CARON */ }, \
	{ 0x0045, /* LATIN CAPITAL LETTER E */ \
	  0x0065, /* LATIN SMALL LETTER E */ }, \
	{ 0x00C9, /* LATIN CAPITAL LETTER E WITH ACUTE */ \
	  0x00E9, /* LATIN SMALL LETTER E WITH ACUTE */ }, \
	{ 0x0114, /* LATIN CAPITAL LETTER E WITH BREVE */ \
	  0x0115, /* LATIN SMALL LETTER E WITH BREVE */ }, \
	{ 0x011A, /* LATIN CAPITAL LETTER E WITH CARON */ \
	  0x011B, /* LATIN SMALL LETTER E WITH CARON */ }, \
	{ 0x0228, /* LATIN CAPITAL LETTER E WITH CEDILLA */ \
	  0x0229, /* LATIN SMALL LETTER E WITH CEDILLA */ }, \
	{ 0x1E1C, /* LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE */ \
	  0x1E1D, /* LATIN SMALL LETTER E WITH CEDILLA AND BREVE */ }, \
	{ 0x00CA, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */ \
	  0x00EA, /* LATIN SMALL LETTER E WITH CIRCUMFLEX */ }, \
	{ 0x1EBE, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE */ \
	  0x1EBF, /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE */ }, \
	{ 0x1EC6, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW */ \
	  0x1EC7, /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW */ }, \
	{ 0x1EC0, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE */ \
	  0x1EC1, /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE */ }, \
	{ 0x1EC2, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */ \
	  0x1EC3, /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */ }, \
	{ 0x1EC4, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE */ \
	  0x1EC5, /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE */ }, \
	{ 0x1E18, /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW */ \
	  0x1E19, /* LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW */ }, \
	{ 0x00CB, /* LATIN CAPITAL LETTER E WITH DIAERESIS */ \
	  0x00EB, /* LATIN SMALL LETTER E WITH DIAERESIS */ }, \
	{ 0x0116, /* LATIN CAPITAL LETTER E WITH DOT ABOVE */ \
	  0x0117, /* LATIN SMALL LETTER E WITH DOT ABOVE */ }, \
	{ 0x1EB8, /* LATIN CAPITAL LETTER E WITH DOT BELOW */ \
	  0x1EB9, /* LATIN SMALL LETTER E WITH DOT BELOW */ }, \
	{ 0x0204, /* LATIN CAPITAL LETTER E WITH DOUBLE GRAVE */ \
	  0x0205, /* LATIN SMALL LETTER E WITH DOUBLE GRAVE */ }, \
	{ 0x00C8, /* LATIN CAPITAL LETTER E WITH GRAVE */ \
	  0x00E8, /* LATIN SMALL LETTER E WITH GRAVE */ }, \
	{ 0x1EBA, /* LATIN CAPITAL LETTER E WITH HOOK ABOVE */ \
	  0x1EBB, /* LATIN SMALL LETTER E WITH HOOK ABOVE */ }, \
	{ 0x0206, /* LATIN CAPITAL LETTER E WITH INVERTED BREVE */ \
	  0x0207, /* LATIN SMALL LETTER E WITH INVERTED BREVE */ }, \
	{ 0x0112, /* LATIN CAPITAL LETTER E WITH MACRON */ \
	  0x0113, /* LATIN SMALL LETTER E WITH MACRON */ }, \
	{ 0x1E16, /* LATIN CAPITAL LETTER E WITH MACRON AND ACUTE */ \
	  0x1E17, /* LATIN SMALL LETTER E WITH MACRON AND ACUTE */ }, \
	{ 0x1E14, /* LATIN CAPITAL LETTER E WITH MACRON AND GRAVE */ \
	  0x1E15, /* LATIN SMALL LETTER E WITH MACRON AND GRAVE */ }, \
	{ 0x0118, /* LATIN CAPITAL LETTER E WITH OGONEK */ \
	  0x0119, /* LATIN SMALL LETTER E WITH OGONEK */ }, \
	{ 0x0246, /* LATIN CAPITAL LETTER E WITH STROKE */ \
	  0x0247, /* LATIN SMALL LETTER E WITH STROKE */ }, \
	{ 0x1EBC, /* LATIN CAPITAL LETTER E WITH TILDE */ \
	  0x1EBD, /* LATIN SMALL LETTER E WITH TILDE */ }, \
	{ 0x1E1A, /* LATIN CAPITAL LETTER E WITH TILDE BELOW */ \
	  0x1E1B, /* LATIN SMALL LETTER E WITH TILDE BELOW */ }, \
	{ 0xA724, /* LATIN CAPITAL LETTER EGYPTOLOGICAL AIN */ \
	  0xA725, /* LATIN SMALL LETTER EGYPTOLOGICAL AIN */ }, \
	{ 0xA722, /* LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF */ \
	  0xA723, /* LATIN SMALL LETTER EGYPTOLOGICAL ALEF */ }, \
	{ 0x014A, /* LATIN CAPITAL LETTER ENG */ \
	  0x014B, /* LATIN SMALL LETTER ENG */ }, \
	{ 0x01A9, /* LATIN CAPITAL LETTER ESH */ \
	  0x0283, /* LATIN SMALL LETTER ESH */ }, \
	{ 0xA76A, /* LATIN CAPITAL LETTER ET */ \
	  0xA76B, /* LATIN SMALL LETTER ET */ }, \
	{ 0x00D0, /* LATIN CAPITAL LETTER ETH */ \
	  0x00F0, /* LATIN SMALL LETTER ETH */ }, \
	{ 0x01B7, /* LATIN CAPITAL LETTER EZH */ \
	  0x0292, /* LATIN SMALL LETTER EZH */ }, \
	{ 0x01B8, /* LATIN CAPITAL LETTER EZH REVERSED */ \
	  0x01B9, /* LATIN SMALL LETTER EZH REVERSED */ }, \
	{ 0x01EE, /* LATIN CAPITAL LETTER EZH WITH CARON */ \
	  0x01EF, /* LATIN SMALL LETTER EZH WITH CARON */ }, \
	{ 0x0046, /* LATIN CAPITAL LETTER F */ \
	  0x0066, /* LATIN SMALL LETTER F */ }, \
	{ 0x1E1E, /* LATIN CAPITAL LETTER F WITH DOT ABOVE */ \
	  0x1E1F, /* LATIN SMALL LETTER F WITH DOT ABOVE */ }, \
	{ 0x0191, /* LATIN CAPITAL LETTER F WITH HOOK */ \
	  0x0192, /* LATIN SMALL LETTER F WITH HOOK */ }, \
	{ 0xA798, /* LATIN CAPITAL LETTER F WITH STROKE */ \
	  0xA799, /* LATIN SMALL LETTER F WITH STROKE */ }, \
	{ 0x0047, /* LATIN CAPITAL LETTER G */ \
	  0x0067, /* LATIN SMALL LETTER G */ }, \
	{ 0x01F4, /* LATIN CAPITAL LETTER G WITH ACUTE */ \
	  0x01F5, /* LATIN SMALL LETTER G WITH ACUTE */ }, \
	{ 0x011E, /* LATIN CAPITAL LETTER G WITH BREVE */ \
	  0x011F, /* LATIN SMALL LETTER G WITH BREVE */ }, \
	{ 0x01E6, /* LATIN CAPITAL LETTER G WITH CARON */ \
	  0x01E7, /* LATIN SMALL LETTER G WITH CARON */ }, \
	{ 0x0122, /* LATIN CAPITAL LETTER G WITH CEDILLA */ \
	  0x0123, /* LATIN SMALL LETTER G WITH CEDILLA */ }, \
	{ 0x011C, /* LATIN CAPITAL LETTER G WITH CIRCUMFLEX */ \
	  0x011D, /* LATIN SMALL LETTER G WITH CIRCUMFLEX */ }, \
	{ 0x0120, /* LATIN CAPITAL LETTER G WITH DOT ABOVE */ \
	  0x0121, /* LATIN SMALL LETTER G WITH DOT ABOVE */ }, \
	{ 0x0193, /* LATIN CAPITAL LETTER G WITH HOOK */ \
	  0x0260, /* LATIN SMALL LETTER G WITH HOOK */ }, \
	{ 0x1E20, /* LATIN CAPITAL LETTER G WITH MACRON */ \
	  0x1E21, /* LATIN SMALL LETTER G WITH MACRON */ }, \
	{ 0xA7A0, /* LATIN CAPITAL LETTER G WITH OBLIQUE STROKE */ \
	  0xA7A1, /* LATIN SMALL LETTER G WITH OBLIQUE STROKE */ }, \
	{ 0x01E4, /* LATIN CAPITAL LETTER G WITH STROKE */ \
	  0x01E5, /* LATIN SMALL LETTER G WITH STROKE */ }, \
	{ 0x0194, /* LATIN CAPITAL LETTER GAMMA */ \
	  0x0263, /* LATIN SMALL LETTER GAMMA */ }, \
	{ 0x0241, /* LATIN CAPITAL LETTER GLOTTAL STOP */ \
	  0x0242, /* LATIN SMALL LETTER GLOTTAL STOP */ }, \
	{ 0x0048, /* LATIN CAPITAL LETTER H */ \
	  0x0068, /* LATIN SMALL LETTER H */ }, \
	{ 0x1E2A, /* LATIN CAPITAL LETTER H WITH BREVE BELOW */ \
	  0x1E2B, /* LATIN SMALL LETTER H WITH BREVE BELOW */ }, \
	{ 0x021E, /* LATIN CAPITAL LETTER H WITH CARON */ \
	  0x021F, /* LATIN SMALL LETTER H WITH CARON */ }, \
	{ 0x1E28, /* LATIN CAPITAL LETTER H WITH CEDILLA */ \
	  0x1E29, /* LATIN SMALL LETTER H WITH CEDILLA */ }, \
	{ 0x0124, /* LATIN CAPITAL LETTER H WITH CIRCUMFLEX */ \
	  0x0125, /* LATIN SMALL LETTER H WITH CIRCUMFLEX */ }, \
	{ 0x2C67, /* LATIN CAPITAL LETTER H WITH DESCENDER */ \
	  0x2C68, /* LATIN SMALL LETTER H WITH DESCENDER */ }, \
	{ 0x1E26, /* LATIN CAPITAL LETTER H WITH DIAERESIS */ \
	  0x1E27, /* LATIN SMALL LETTER H WITH DIAERESIS */ }, \
	{ 0x1E22, /* LATIN CAPITAL LETTER H WITH DOT ABOVE */ \
	  0x1E23, /* LATIN SMALL LETTER H WITH DOT ABOVE */ }, \
	{ 0x1E24, /* LATIN CAPITAL LETTER H WITH DOT BELOW */ \
	  0x1E25, /* LATIN SMALL LETTER H WITH DOT BELOW */ }, \
	{ 0xA7AA, /* LATIN CAPITAL LETTER H WITH HOOK */ \
	  0x0266, /* LATIN SMALL LETTER H WITH HOOK */ }, \
	{ 0x0126, /* LATIN CAPITAL LETTER H WITH STROKE */ \
	  0x0127, /* LATIN SMALL LETTER H WITH STROKE */ }, \
	{ 0x2C75, /* LATIN CAPITAL LETTER HALF H */ \
	  0x2C76, /* LATIN SMALL LETTER HALF H */ }, \
	{ 0xA726, /* LATIN CAPITAL LETTER HENG */ \
	  0xA727, /* LATIN SMALL LETTER HENG */ }, \
	{ 0x0049, /* LATIN CAPITAL LETTER I */ \
	  0x0069, /* LATIN SMALL LETTER I */ }, \
	{ 0x00CD, /* LATIN CAPITAL LETTER I WITH ACUTE */ \
	  0x00ED, /* LATIN SMALL LETTER I WITH ACUTE */ }, \
	{ 0x012C, /* LATIN CAPITAL LETTER I WITH BREVE */ \
	  0x012D, /* LATIN SMALL LETTER I WITH BREVE */ }, \
	{ 0x01CF, /* LATIN CAPITAL LETTER I WITH CARON */ \
	  0x01D0, /* LATIN SMALL LETTER I WITH CARON */ }, \
	{ 0x00CE, /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */ \
	  0x00EE, /* LATIN SMALL LETTER I WITH CIRCUMFLEX */ }, \
	{ 0x00CF, /* LATIN CAPITAL LETTER I WITH DIAERESIS */ \
	  0x00EF, /* LATIN SMALL LETTER I WITH DIAERESIS */ }, \
	{ 0x1E2E, /* LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE */ \
	  0x1E2F, /* LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE */ }, \
	{ 0x1ECA, /* LATIN CAPITAL LETTER I WITH DOT BELOW */ \
	  0x1ECB, /* LATIN SMALL LETTER I WITH DOT BELOW */ }, \
	{ 0x0208, /* LATIN CAPITAL LETTER I WITH DOUBLE GRAVE */ \
	  0x0209, /* LATIN SMALL LETTER I WITH DOUBLE GRAVE */ }, \
	{ 0x00CC, /* LATIN CAPITAL LETTER I WITH GRAVE */ \
	  0x00EC, /* LATIN SMALL LETTER I WITH GRAVE */ }, \
	{ 0x1EC8, /* LATIN CAPITAL LETTER I WITH HOOK ABOVE */ \
	  0x1EC9, /* LATIN SMALL LETTER I WITH HOOK ABOVE */ }, \
	{ 0x020A, /* LATIN CAPITAL LETTER I WITH INVERTED BREVE */ \
	  0x020B, /* LATIN SMALL LETTER I WITH INVERTED BREVE */ }, \
	{ 0x012A, /* LATIN CAPITAL LETTER I WITH MACRON */ \
	  0x012B, /* LATIN SMALL LETTER I WITH MACRON */ }, \
	{ 0x012E, /* LATIN CAPITAL LETTER I WITH OGONEK */ \
	  0x012F, /* LATIN SMALL LETTER I WITH OGONEK */ }, \
	{ 0x0197, /* LATIN CAPITAL LETTER I WITH STROKE */ \
	  0x0268, /* LATIN SMALL LETTER I WITH STROKE */ }, \
	{ 0x0128, /* LATIN CAPITAL LETTER I WITH TILDE */ \
	  0x0129, /* LATIN SMALL LETTER I WITH TILDE */ }, \
	{ 0x1E2C, /* LATIN CAPITAL LETTER I WITH TILDE BELOW */ \
	  0x1E2D, /* LATIN SMALL LETTER I WITH TILDE BELOW */ }, \
	{ 0xA779, /* LATIN CAPITAL LETTER INSULAR D */ \
	  0xA77A, /* LATIN SMALL LETTER INSULAR D */ }, \
	{ 0xA77B, /* LATIN CAPITAL LETTER INSULAR F */ \
	  0xA77C, /* LATIN SMALL LETTER INSULAR F */ }, \
	{ 0xA77D, /* LATIN CAPITAL LETTER INSULAR G */ \
	  0x1D79, /* LATIN SMALL LETTER INSULAR G */ }, \
	{ 0xA782, /* LATIN CAPITAL LETTER INSULAR R */ \
	  0xA783, /* LATIN SMALL LETTER INSULAR R */ }, \
	{ 0xA784, /* LATIN CAPITAL LETTER INSULAR S */ \
	  0xA785, /* LATIN SMALL LETTER INSULAR S */ }, \
	{ 0xA786, /* LATIN CAPITAL LETTER INSULAR T */ \
	  0xA787, /* LATIN SMALL LETTER INSULAR T */ }, \
	{ 0x0196, /* LATIN CAPITAL LETTER IOTA */ \
	  0x0269, /* LATIN SMALL LETTER IOTA */ }, \
	{ 0xA76C, /* LATIN CAPITAL LETTER IS */ \
	  0xA76D, /* LATIN SMALL LETTER IS */ }, \
	{ 0x004A, /* LATIN CAPITAL LETTER J */ \
	  0x006A, /* LATIN SMALL LETTER J */ }, \
	{ 0x0134, /* LATIN CAPITAL LETTER J WITH CIRCUMFLEX */ \
	  0x0135, /* LATIN SMALL LETTER J WITH CIRCUMFLEX */ }, \
	{ 0xA7B2, /* LATIN CAPITAL LETTER J WITH CROSSED-TAIL */ \
	  0x029D, /* LATIN SMALL LETTER J WITH CROSSED-TAIL */ }, \
	{ 0x0248, /* LATIN CAPITAL LETTER J WITH STROKE */ \
	  0x0249, /* LATIN SMALL LETTER J WITH STROKE */ }, \
	{ 0x004B, /* LATIN CAPITAL LETTER K */ \
	  0x006B, /* LATIN SMALL LETTER K */ }, \
	{ 0x1E30, /* LATIN CAPITAL LETTER K WITH ACUTE */ \
	  0x1E31, /* LATIN SMALL LETTER K WITH ACUTE */ }, \
	{ 0x01E8, /* LATIN CAPITAL LETTER K WITH CARON */ \
	  0x01E9, /* LATIN SMALL LETTER K WITH CARON */ }, \
	{ 0x0136, /* LATIN CAPITAL LETTER K WITH CEDILLA */ \
	  0x0137, /* LATIN SMALL LETTER K WITH CEDILLA */ }, \
	{ 0x2C69, /* LATIN CAPITAL LETTER K WITH DESCENDER */ \
	  0x2C6A, /* LATIN SMALL LETTER K WITH DESCENDER */ }, \
	{ 0xA742, /* LATIN CAPITAL LETTER K WITH DIAGONAL STROKE */ \
	  0xA743, /* LATIN SMALL LETTER K WITH DIAGONAL STROKE */ }, \
	{ 0x1E32, /* LATIN CAPITAL LETTER K WITH DOT BELOW */ \
	  0x1E33, /* LATIN SMALL LETTER K WITH DOT BELOW */ }, \
	{ 0x0198, /* LATIN CAPITAL LETTER K WITH HOOK */ \
	  0x0199, /* LATIN SMALL LETTER K WITH HOOK */ }, \
	{ 0x1E34, /* LATIN CAPITAL LETTER K WITH LINE BELOW */ \
	  0x1E35, /* LATIN SMALL LETTER K WITH LINE BELOW */ }, \
	{ 0xA7A2, /* LATIN CAPITAL LETTER K WITH OBLIQUE STROKE */ \
	  0xA7A3, /* LATIN SMALL LETTER K WITH OBLIQUE STROKE */ }, \
	{ 0xA740, /* LATIN CAPITAL LETTER K WITH STROKE */ \
	  0xA741, /* LATIN SMALL LETTER K WITH STROKE */ }, \
	{ 0xA744, /* LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE */ \
	  0xA745, /* LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE */ }, \
	{ 0x004C, /* LATIN CAPITAL LETTER L */ \
	  0x006C, /* LATIN SMALL LETTER L */ }, \
	{ 0x0139, /* LATIN CAPITAL LETTER L WITH ACUTE */ \
	  0x013A, /* LATIN SMALL LETTER L WITH ACUTE */ }, \
	{ 0x023D, /* LATIN CAPITAL LETTER L WITH BAR */ \
	  0x019A, /* LATIN SMALL LETTER L WITH BAR */ }, \
	{ 0xA7AD, /* LATIN CAPITAL LETTER L WITH BELT */ \
	  0x026C, /* LATIN SMALL LETTER L WITH BELT */ }, \
	{ 0x013D, /* LATIN CAPITAL LETTER L WITH CARON */ \
	  0x013E, /* LATIN SMALL LETTER L WITH CARON */ }, \
	{ 0x013B, /* LATIN CAPITAL LETTER L WITH CEDILLA */ \
	  0x013C, /* LATIN SMALL LETTER L WITH CEDILLA */ }, \
	{ 0x1E3C, /* LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW */ \
	  0x1E3D, /* LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW */ }, \
	{ 0x1E36, /* LATIN CAPITAL LETTER L WITH DOT BELOW */ \
	  0x1E37, /* LATIN SMALL LETTER L WITH DOT BELOW */ }, \
	{ 0x1E38, /* LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON */ \
	  0x1E39, /* LATIN SMALL LETTER L WITH DOT BELOW AND MACRON */ }, \
	{ 0x2C60, /* LATIN CAPITAL LETTER L WITH DOUBLE BAR */ \
	  0x2C61, /* LATIN SMALL LETTER L WITH DOUBLE BAR */ }, \
	{ 0xA748, /* LATIN CAPITAL LETTER L WITH HIGH STROKE */ \
	  0xA749, /* LATIN SMALL LETTER L WITH HIGH STROKE */ }, \
	{ 0x1E3A, /* LATIN CAPITAL LETTER L WITH LINE BELOW */ \
	  0x1E3B, /* LATIN SMALL LETTER L WITH LINE BELOW */ }, \
	{ 0x013F, /* LATIN CAPITAL LETTER L WITH MIDDLE DOT */ \
	  0x0140, /* LATIN SMALL LETTER L WITH MIDDLE DOT */ }, \
	{ 0x2C62, /* LATIN CAPITAL LETTER L WITH MIDDLE TILDE */ \
	  0x026B, /* LATIN SMALL LETTER L WITH MIDDLE TILDE */ }, \
	{ 0x0141, /* LATIN CAPITAL LETTER L WITH STROKE */ \
	  0x0142, /* LATIN SMALL LETTER L WITH STROKE */ }, \
	{ 0x01C7, /* LATIN CAPITAL LETTER LJ */ \
	  0x01C9, /* LATIN SMALL LETTER LJ */ }, \
	{ 0x004D, /* LATIN CAPITAL LETTER M */ \
	  0x006D, /* LATIN SMALL LETTER M */ }, \
	{ 0x1E3E, /* LATIN CAPITAL LETTER M WITH ACUTE */ \
	  0x1E3F, /* LATIN SMALL LETTER M WITH ACUTE */ }, \
	{ 0x1E40, /* LATIN CAPITAL LETTER M WITH DOT ABOVE */ \
	  0x1E41, /* LATIN SMALL LETTER M WITH DOT ABOVE */ }, \
	{ 0x1E42, /* LATIN CAPITAL LETTER M WITH DOT BELOW */ \
	  0x1E43, /* LATIN SMALL LETTER M WITH DOT BELOW */ }, \
	{ 0x2C6E, /* LATIN CAPITAL LETTER M WITH HOOK */ \
	  0x0271, /* LATIN SMALL LETTER M WITH HOOK */ }, \
	{ 0x1EFA, /* LATIN CAPITAL LETTER MIDDLE-WELSH LL */ \
	  0x1EFB, /* LATIN SMALL LETTER MIDDLE-WELSH LL */ }, \
	{ 0x1EFC, /* LATIN CAPITAL LETTER MIDDLE-WELSH V */ \
	  0x1EFD, /* LATIN SMALL LETTER MIDDLE-WELSH V */ }, \
	{ 0x004E, /* LATIN CAPITAL LETTER N */ \
	  0x006E, /* LATIN SMALL LETTER N */ }, \
	{ 0x0143, /* LATIN CAPITAL LETTER N WITH ACUTE */ \
	  0x0144, /* LATIN SMALL LETTER N WITH ACUTE */ }, \
	{ 0x0147, /* LATIN CAPITAL LETTER N WITH CARON */ \
	  0x0148, /* LATIN SMALL LETTER N WITH CARON */ }, \
	{ 0x0145, /* LATIN CAPITAL LETTER N WITH CEDILLA */ \
	  0x0146, /* LATIN SMALL LETTER N WITH CEDILLA */ }, \
	{ 0x1E4A, /* LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW */ \
	  0x1E4B, /* LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW */ }, \
	{ 0xA790, /* LATIN CAPITAL LETTER N WITH DESCENDER */ \
	  0xA791, /* LATIN SMALL LETTER N WITH DESCENDER */ }, \
	{ 0x1E44, /* LATIN CAPITAL LETTER N WITH DOT ABOVE */ \
	  0x1E45, /* LATIN SMALL LETTER N WITH DOT ABOVE */ }, \
	{ 0x1E46, /* LATIN CAPITAL LETTER N WITH DOT BELOW */ \
	  0x1E47, /* LATIN SMALL LETTER N WITH DOT BELOW */ }, \
	{ 0x01F8, /* LATIN CAPITAL LETTER N WITH GRAVE */ \
	  0x01F9, /* LATIN SMALL LETTER N WITH GRAVE */ }, \
	{ 0x019D, /* LATIN CAPITAL LETTER N WITH LEFT HOOK */ \
	  0x0272, /* LATIN SMALL LETTER N WITH LEFT HOOK */ }, \
	{ 0x1E48, /* LATIN CAPITAL LETTER N WITH LINE BELOW */ \
	  0x1E49, /* LATIN SMALL LETTER N WITH LINE BELOW */ }, \
	{ 0x0220, /* LATIN CAPITAL LETTER N WITH LONG RIGHT LEG */ \
	  0x019E, /* LATIN SMALL LETTER N WITH LONG RIGHT LEG */ }, \
	{ 0xA7A4, /* LATIN CAPITAL LETTER N WITH OBLIQUE STROKE */ \
	  0xA7A5, /* LATIN SMALL LETTER N WITH OBLIQUE STROKE */ }, \
	{ 0x00D1, /* LATIN CAPITAL LETTER N WITH TILDE */ \
	  0x00F1, /* LATIN SMALL LETTER N WITH TILDE */ }, \
	{ 0x01CA, /* LATIN CAPITAL LETTER NJ */ \
	  0x01CC, /* LATIN SMALL LETTER NJ */ }, \
	{ 0x004F, /* LATIN CAPITAL LETTER O */ \
	  0x006F, /* LATIN SMALL LETTER O */ }, \
	{ 0x00D3, /* LATIN CAPITAL LETTER O WITH ACUTE */ \
	  0x00F3, /* LATIN SMALL LETTER O WITH ACUTE */ }, \
	{ 0x014E, /* LATIN CAPITAL LETTER O WITH BREVE */ \
	  0x014F, /* LATIN SMALL LETTER O WITH BREVE */ }, \
	{ 0x01D1, /* LATIN CAPITAL LETTER O WITH CARON */ \
	  0x01D2, /* LATIN SMALL LETTER O WITH CARON */ }, \
	{ 0x00D4, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */ \
	  0x00F4, /* LATIN SMALL LETTER O WITH CIRCUMFLEX */ }, \
	{ 0x1ED0, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE */ \
	  0x1ED1, /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE */ }, \
	{ 0x1ED8, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW */ \
	  0x1ED9, /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW */ }, \
	{ 0x1ED2, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE */ \
	  0x1ED3, /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE */ }, \
	{ 0x1ED4, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */ \
	  0x1ED5, /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */ }, \
	{ 0x1ED6, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE */ \
	  0x1ED7, /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE */ }, \
	{ 0x00D6, /* LATIN CAPITAL LETTER O WITH DIAERESIS */ \
	  0x00F6, /* LATIN SMALL LETTER O WITH DIAERESIS */ }, \
	{ 0x022A, /* LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON */ \
	  0x022B, /* LATIN SMALL LETTER O WITH DIAERESIS AND MACRON */ }, \
	{ 0x022E, /* LATIN CAPITAL LETTER O WITH DOT ABOVE */ \
	  0x022F, /* LATIN SMALL LETTER O WITH DOT ABOVE */ }, \
	{ 0x0230, /* LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON */ \
	  0x0231, /* LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON */ }, \
	{ 0x1ECC, /* LATIN CAPITAL LETTER O WITH DOT BELOW */ \
	  0x1ECD, /* LATIN SMALL LETTER O WITH DOT BELOW */ }, \
	{ 0x0150, /* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */ \
	  0x0151, /* LATIN SMALL LETTER O WITH DOUBLE ACUTE */ }, \
	{ 0x020C, /* LATIN CAPITAL LETTER O WITH DOUBLE GRAVE */ \
	  0x020D, /* LATIN SMALL LETTER O WITH DOUBLE GRAVE */ }, \
	{ 0x00D2, /* LATIN CAPITAL LETTER O WITH GRAVE */ \
	  0x00F2, /* LATIN SMALL LETTER O WITH GRAVE */ }, \
	{ 0x1ECE, /* LATIN CAPITAL LETTER O WITH HOOK ABOVE */ \
	  0x1ECF, /* LATIN SMALL LETTER O WITH HOOK ABOVE */ }, \
	{ 0x01A0, /* LATIN CAPITAL LETTER O WITH HORN */ \
	  0x01A1, /* LATIN SMALL LETTER O WITH HORN */ }, \
	{ 0x1EDA, /* LATIN CAPITAL LETTER O WITH HORN AND ACUTE */ \
	  0x1EDB, /* LATIN SMALL LETTER O WITH HORN AND ACUTE */ }, \
	{ 0x1EE2, /* LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW */ \
	  0x1EE3, /* LATIN SMALL LETTER O WITH HORN AND DOT BELOW */ }, \
	{ 0x1EDC, /* LATIN CAPITAL LETTER O WITH HORN AND GRAVE */ \
	  0x1EDD, /* LATIN SMALL LETTER O WITH HORN AND GRAVE */ }, \
	{ 0x1EDE, /* LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE */ \
	  0x1EDF, /* LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE */ }, \
	{ 0x1EE0, /* LATIN CAPITAL LETTER O WITH HORN AND TILDE */ \
	  0x1EE1, /* LATIN SMALL LETTER O WITH HORN AND TILDE */ }, \
	{ 0x020E, /* LATIN CAPITAL LETTER O WITH INVERTED BREVE */ \
	  0x020F, /* LATIN SMALL LETTER O WITH INVERTED BREVE */ }, \
	{ 0xA74A, /* LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY */ \
	  0xA74B, /* LATIN SMALL LETTER O WITH LONG STROKE OVERLAY */ }, \
	{ 0xA74C, /* LATIN CAPITAL LETTER O WITH LOOP */ \
	  0xA74D, /* LATIN SMALL LETTER O WITH LOOP */ }, \
	{ 0x014C, /* LATIN CAPITAL LETTER O WITH MACRON */ \
	  0x014D, /* LATIN SMALL LETTER O WITH MACRON */ }, \
	{ 0x1E52, /* LATIN CAPITAL LETTER O WITH MACRON AND ACUTE */ \
	  0x1E53, /* LATIN SMALL LETTER O WITH MACRON AND ACUTE */ }, \
	{ 0x1E50, /* LATIN CAPITAL LETTER O WITH MACRON AND GRAVE */ \
	  0x1E51, /* LATIN SMALL LETTER O WITH MACRON AND GRAVE */ }, \
	{ 0x01EA, /* LATIN CAPITAL LETTER O WITH OGONEK */ \
	  0x01EB, /* LATIN SMALL LETTER O WITH OGONEK */ }, \
	{ 0x01EC, /* LATIN CAPITAL LETTER O WITH OGONEK AND MACRON */ \
	  0x01ED, /* LATIN SMALL LETTER O WITH OGONEK AND MACRON */ }, \
	{ 0x00D8, /* LATIN CAPITAL LETTER O WITH STROKE */ \
	  0x00F8, /* LATIN SMALL LETTER O WITH STROKE */ }, \
	{ 0x01FE, /* LATIN CAPITAL LETTER O WITH STROKE AND ACUTE */ \
	  0x01FF, /* LATIN SMALL LETTER O WITH STROKE AND ACUTE */ }, \
	{ 0x00D5, /* LATIN CAPITAL LETTER O WITH TILDE */ \
	  0x00F5, /* LATIN SMALL LETTER O WITH TILDE */ }, \
	{ 0x1E4C, /* LATIN CAPITAL LETTER O WITH TILDE AND ACUTE */ \
	  0x1E4D, /* LATIN SMALL LETTER O WITH TILDE AND ACUTE */ }, \
	{ 0x1E4E, /* LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS */ \
	  0x1E4F, /* LATIN SMALL LETTER O WITH TILDE AND DIAERESIS */ }, \
	{ 0x022C, /* LATIN CAPITAL LETTER O WITH TILDE AND MACRON */ \
	  0x022D, /* LATIN SMALL LETTER O WITH TILDE AND MACRON */ }, \
	{ 0x01A2, /* LATIN CAPITAL LETTER OI */ \
	  0x01A3, /* LATIN SMALL LETTER OI */ }, \
	{ 0xA7B6, /* LATIN CAPITAL LETTER OMEGA */ \
	  0xA7B7, /* LATIN SMALL LETTER OMEGA */ }, \
	{ 0xA74E, /* LATIN CAPITAL LETTER OO */ \
	  0xA74F, /* LATIN SMALL LETTER OO */ }, \
	{ 0x0190, /* LATIN CAPITAL LETTER OPEN E */ \
	  0x025B, /* LATIN SMALL LETTER OPEN E */ }, \
	{ 0x0186, /* LATIN CAPITAL LETTER OPEN O */ \
	  0x0254, /* LATIN SMALL LETTER OPEN O */ }, \
	{ 0x0222, /* LATIN CAPITAL LETTER OU */ \
	  0x0223, /* LATIN SMALL LETTER OU */ }, \
	{ 0x0050, /* LATIN CAPITAL LETTER P */ \
	  0x0070, /* LATIN SMALL LETTER P */ }, \
	{ 0x1E54, /* LATIN CAPITAL LETTER P WITH ACUTE */ \
	  0x1E55, /* LATIN SMALL LETTER P WITH ACUTE */ }, \
	{ 0x1E56, /* LATIN CAPITAL LETTER P WITH DOT ABOVE */ \
	  0x1E57, /* LATIN SMALL LETTER P WITH DOT ABOVE */ }, \
	{ 0xA752, /* LATIN CAPITAL LETTER P WITH FLOURISH */ \
	  0xA753, /* LATIN SMALL LETTER P WITH FLOURISH */ }, \
	{ 0x01A4, /* LATIN CAPITAL LETTER P WITH HOOK */ \
	  0x01A5, /* LATIN SMALL LETTER P WITH HOOK */ }, \
	{ 0xA754, /* LATIN CAPITAL LETTER P WITH SQUIRREL TAIL */ \
	  0xA755, /* LATIN SMALL LETTER P WITH SQUIRREL TAIL */ }, \
	{ 0x2C63, /* LATIN CAPITAL LETTER P WITH STROKE */ \
	  0x1D7D, /* LATIN SMALL LETTER P WITH STROKE */ }, \
	{ 0xA750, /* LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER */ \
	  0xA751, /* LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER */ }, \
	{ 0x0051, /* LATIN CAPITAL LETTER Q */ \
	  0x0071, /* LATIN SMALL LETTER Q */ }, \
	{ 0xA758, /* LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE */ \
	  0xA759, /* LATIN SMALL LETTER Q WITH DIAGONAL STROKE */ }, \
	{ 0xA756, /* LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER */ \
	  0xA757, /* LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER */ }, \
	{ 0x0052, /* LATIN CAPITAL LETTER R */ \
	  0x0072, /* LATIN SMALL LETTER R */ }, \
	{ 0xA75A, /* LATIN CAPITAL LETTER R ROTUNDA */ \
	  0xA75B, /* LATIN SMALL LETTER R ROTUNDA */ }, \
	{ 0x0154, /* LATIN CAPITAL LETTER R WITH ACUTE */ \
	  0x0155, /* LATIN SMALL LETTER R WITH ACUTE */ }, \
	{ 0x0158, /* LATIN CAPITAL LETTER R WITH CARON */ \
	  0x0159, /* LATIN SMALL LETTER R WITH CARON */ }, \
	{ 0x0156, /* LATIN CAPITAL LETTER R WITH CEDILLA */ \
	  0x0157, /* LATIN SMALL LETTER R WITH CEDILLA */ }, \
	{ 0x1E58, /* LATIN CAPITAL LETTER R WITH DOT ABOVE */ \
	  0x1E59, /* LATIN SMALL LETTER R WITH DOT ABOVE */ }, \
	{ 0x1E5A, /* LATIN CAPITAL LETTER R WITH DOT BELOW */ \
	  0x1E5B, /* LATIN SMALL LETTER R WITH DOT BELOW */ }, \
	{ 0x1E5C, /* LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON */ \
	  0x1E5D, /* LATIN SMALL LETTER R WITH DOT BELOW AND MACRON */ }, \
	{ 0x0210, /* LATIN CAPITAL LETTER R WITH DOUBLE GRAVE */ \
	  0x0211, /* LATIN SMALL LETTER R WITH DOUBLE GRAVE */ }, \
	{ 0x0212, /* LATIN CAPITAL LETTER R WITH INVERTED BREVE */ \
	  0x0213, /* LATIN SMALL LETTER R WITH INVERTED BREVE */ }, \
	{ 0x1E5E, /* LATIN CAPITAL LETTER R WITH LINE BELOW */ \
	  0x1E5F, /* LATIN SMALL LETTER R WITH LINE BELOW */ }, \
	{ 0xA7A6, /* LATIN CAPITAL LETTER R WITH OBLIQUE STROKE */ \
	  0xA7A7, /* LATIN SMALL LETTER R WITH OBLIQUE STROKE */ }, \
	{ 0x024C, /* LATIN CAPITAL LETTER R WITH STROKE */ \
	  0x024D, /* LATIN SMALL LETTER R WITH STROKE */ }, \
	{ 0x2C64, /* LATIN CAPITAL LETTER R WITH TAIL */ \
	  0x027D, /* LATIN SMALL LETTER R WITH TAIL */ }, \
	{ 0xA73E, /* LATIN CAPITAL LETTER REVERSED C WITH DOT */ \
	  0xA73F, /* LATIN SMALL LETTER REVERSED C WITH DOT */ }, \
	{ 0x018E, /* LATIN CAPITAL LETTER REVERSED E */ \
	  0x0258, /* LATIN SMALL LETTER REVERSED E */ }, \
	{ 0xA7AB, /* LATIN CAPITAL LETTER REVERSED OPEN E */ \
	  0x025C, /* LATIN SMALL LETTER REVERSED OPEN E */ }, \
	{ 0xA75C, /* LATIN CAPITAL LETTER RUM ROTUNDA */ \
	  0xA75D, /* LATIN SMALL LETTER RUM ROTUNDA */ }, \
	{ 0x0053, /* LATIN CAPITAL LETTER S */ \
	  0x0073, /* LATIN SMALL LETTER S */ }, \
	{ 0x015A, /* LATIN CAPITAL LETTER S WITH ACUTE */ \
	  0x015B, /* LATIN SMALL LETTER S WITH ACUTE */ }, \
	{ 0x1E64, /* LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE */ \
	  0x1E65, /* LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE */ }, \
	{ 0x0160, /* LATIN CAPITAL LETTER S WITH CARON */ \
	  0x0161, /* LATIN SMALL LETTER S WITH CARON */ }, \
	{ 0x1E66, /* LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE */ \
	  0x1E67, /* LATIN SMALL LETTER S WITH CARON AND DOT ABOVE */ }, \
	{ 0x015E, /* LATIN CAPITAL LETTER S WITH CEDILLA */ \
	  0x015F, /* LATIN SMALL LETTER S WITH CEDILLA */ }, \
	{ 0x015C, /* LATIN CAPITAL LETTER S WITH CIRCUMFLEX */ \
	  0x015D, /* LATIN SMALL LETTER S WITH CIRCUMFLEX */ }, \
	{ 0x0218, /* LATIN CAPITAL LETTER S WITH COMMA BELOW */ \
	  0x0219, /* LATIN SMALL LETTER S WITH COMMA BELOW */ }, \
	{ 0x1E60, /* LATIN CAPITAL LETTER S WITH DOT ABOVE */ \
	  0x1E61, /* LATIN SMALL LETTER S WITH DOT ABOVE */ }, \
	{ 0x1E62, /* LATIN CAPITAL LETTER S WITH DOT BELOW */ \
	  0x1E63, /* LATIN SMALL LETTER S WITH DOT BELOW */ }, \
	{ 0x1E68, /* LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE */ \
	  0x1E69, /* LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE */ }, \
	{ 0xA7A8, /* LATIN CAPITAL LETTER S WITH OBLIQUE STROKE */ \
	  0xA7A9, /* LATIN SMALL LETTER S WITH OBLIQUE STROKE */ }, \
	{ 0x2C7E, /* LATIN CAPITAL LETTER S WITH SWASH TAIL */ \
	  0x023F, /* LATIN SMALL LETTER S WITH SWASH TAIL */ }, \
	{ 0xA78B, /* LATIN CAPITAL LETTER SALTILLO */ \
	  0xA78C, /* LATIN SMALL LETTER SALTILLO */ }, \
	{ 0x018F, /* LATIN CAPITAL LETTER SCHWA */ \
	  0x0259, /* LATIN SMALL LETTER SCHWA */ }, \
	{ 0xA7AC, /* LATIN CAPITAL LETTER SCRIPT G */ \
	  0x0261, /* LATIN SMALL LETTER SCRIPT G */ }, \
	{ 0x1E9E, /* LATIN CAPITAL LETTER SHARP S */ \
	  0x00DF, /* LATIN SMALL LETTER SHARP S */ }, \
	{ 0x0054, /* LATIN CAPITAL LETTER T */ \
	  0x0074, /* LATIN SMALL LETTER T */ }, \
	{ 0x0164, /* LATIN CAPITAL LETTER T WITH CARON */ \
	  0x0165, /* LATIN SMALL LETTER T WITH CARON */ }, \
	{ 0x0162, /* LATIN CAPITAL LETTER T WITH CEDILLA */ \
	  0x0163, /* LATIN SMALL LETTER T WITH CEDILLA */ }, \
	{ 0x1E70, /* LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW */ \
	  0x1E71, /* LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW */ }, \
	{ 0x021A, /* LATIN CAPITAL LETTER T WITH COMMA BELOW */ \
	  0x021B, /* LATIN SMALL LETTER T WITH COMMA BELOW */ }, \
	{ 0x023E, /* LATIN CAPITAL LETTER T WITH DIAGONAL STROKE */ \
	  0x2C66, /* LATIN SMALL LETTER T WITH DIAGONAL STROKE */ }, \
	{ 0x1E6A, /* LATIN CAPITAL LETTER T WITH DOT ABOVE */ \
	  0x1E6B, /* LATIN SMALL LETTER T WITH DOT ABOVE */ }, \
	{ 0x1E6C, /* LATIN CAPITAL LETTER T WITH DOT BELOW */ \
	  0x1E6D, /* LATIN SMALL LETTER T WITH DOT BELOW */ }, \
	{ 0x01AC, /* LATIN CAPITAL LETTER T WITH HOOK */ \
	  0x01AD, /* LATIN SMALL LETTER T WITH HOOK */ }, \
	{ 0x1E6E, /* LATIN CAPITAL LETTER T WITH LINE BELOW */ \
	  0x1E6F, /* LATIN SMALL LETTER T WITH LINE BELOW */ }, \
	{ 0x01AE, /* LATIN CAPITAL LETTER T WITH RETROFLEX HOOK */ \
	  0x0288, /* LATIN SMALL LETTER T WITH RETROFLEX HOOK */ }, \
	{ 0x0166, /* LATIN CAPITAL LETTER T WITH STROKE */ \
	  0x0167, /* LATIN SMALL LETTER T WITH STROKE */ }, \
	{ 0x00DE, /* LATIN CAPITAL LETTER THORN */ \
	  0x00FE, /* LATIN SMALL LETTER THORN */ }, \
	{ 0xA764, /* LATIN CAPITAL LETTER THORN WITH STROKE */ \
	  0xA765, /* LATIN SMALL LETTER THORN WITH STROKE */ }, \
	{ 0xA766, /* LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER */ \
	  0xA767, /* LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER */ }, \
	{ 0x01BC, /* LATIN CAPITAL LETTER TONE FIVE */ \
	  0x01BD, /* LATIN SMALL LETTER TONE FIVE */ }, \
	{ 0x0184, /* LATIN CAPITAL LETTER TONE SIX */ \
	  0x0185, /* LATIN SMALL LETTER TONE SIX */ }, \
	{ 0x01A7, /* LATIN CAPITAL LETTER TONE TWO */ \
	  0x01A8, /* LATIN SMALL LETTER TONE TWO */ }, \
	{ 0xA72A, /* LATIN CAPITAL LETTER TRESILLO */ \
	  0xA72B, /* LATIN SMALL LETTER TRESILLO */ }, \
	{ 0x2C6F, /* LATIN CAPITAL LETTER TURNED A */ \
	  0x0250, /* LATIN SMALL LETTER TURNED A */ }, \
	{ 0x2C70, /* LATIN CAPITAL LETTER TURNED ALPHA */ \
	  0x0252, /* LATIN SMALL LETTER TURNED ALPHA */ }, \
	{ 0xA78D, /* LATIN CAPITAL LETTER TURNED H */ \
	  0x0265, /* LATIN SMALL LETTER TURNED H */ }, \
	{ 0xA77E, /* LATIN CAPITAL LETTER TURNED INSULAR G */ \
	  0xA77F, /* LATIN SMALL LETTER TURNED INSULAR G */ }, \
	{ 0xA7B0, /* LATIN CAPITAL LETTER TURNED K */ \
	  0x029E, /* LATIN SMALL LETTER TURNED K */ }, \
	{ 0xA780, /* LATIN CAPITAL LETTER TURNED L */ \
	  0xA781, /* LATIN SMALL LETTER TURNED L */ }, \
	{ 0x019C, /* LATIN CAPITAL LETTER TURNED M */ \
	  0x026F, /* LATIN SMALL LETTER TURNED M */ }, \
	{ 0xA7B1, /* LATIN CAPITAL LETTER TURNED T */ \
	  0x0287, /* LATIN SMALL LETTER TURNED T */ }, \
	{ 0x0245, /* LATIN CAPITAL LETTER TURNED V */ \
	  0x028C, /* LATIN SMALL LETTER TURNED V */ }, \
	{ 0xA728, /* LATIN CAPITAL LETTER TZ */ \
	  0xA729, /* LATIN SMALL LETTER TZ */ }, \
	{ 0x0055, /* LATIN CAPITAL LETTER U */ \
	  0x0075, /* LATIN SMALL LETTER U */ }, \
	{ 0x0244, /* LATIN CAPITAL LETTER U BAR */ \
	  0x0289, /* LATIN SMALL LETTER U BAR */ }, \
	{ 0x00DA, /* LATIN CAPITAL LETTER U WITH ACUTE */ \
	  0x00FA, /* LATIN SMALL LETTER U WITH ACUTE */ }, \
	{ 0x016C, /* LATIN CAPITAL LETTER U WITH BREVE */ \
	  0x016D, /* LATIN SMALL LETTER U WITH BREVE */ }, \
	{ 0x01D3, /* LATIN CAPITAL LETTER U WITH CARON */ \
	  0x01D4, /* LATIN SMALL LETTER U WITH CARON */ }, \
	{ 0x00DB, /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */ \
	  0x00FB, /* LATIN SMALL LETTER U WITH CIRCUMFLEX */ }, \
	{ 0x1E76, /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW */ \
	  0x1E77, /* LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW */ }, \
	{ 0x00DC, /* LATIN CAPITAL LETTER U WITH DIAERESIS */ \
	  0x00FC, /* LATIN SMALL LETTER U WITH DIAERESIS */ }, \
	{ 0x01D7, /* LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE */ \
	  0x01D8, /* LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE */ }, \
	{ 0x01D9, /* LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON */ \
	  0x01DA, /* LATIN SMALL LETTER U WITH DIAERESIS AND CARON */ }, \
	{ 0x01DB, /* LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE */ \
	  0x01DC, /* LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE */ }, \
	{ 0x01D5, /* LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON */ \
	  0x01D6, /* LATIN SMALL LETTER U WITH DIAERESIS AND MACRON */ }, \
	{ 0x1E72, /* LATIN CAPITAL LETTER U WITH DIAERESIS BELOW */ \
	  0x1E73, /* LATIN SMALL LETTER U WITH DIAERESIS BELOW */ }, \
	{ 0x1EE4, /* LATIN CAPITAL LETTER U WITH DOT BELOW */ \
	  0x1EE5, /* LATIN SMALL LETTER U WITH DOT BELOW */ }, \
	{ 0x0170, /* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */ \
	  0x0171, /* LATIN SMALL LETTER U WITH DOUBLE ACUTE */ }, \
	{ 0x0214, /* LATIN CAPITAL LETTER U WITH DOUBLE GRAVE */ \
	  0x0215, /* LATIN SMALL LETTER U WITH DOUBLE GRAVE */ }, \
	{ 0x00D9, /* LATIN CAPITAL LETTER U WITH GRAVE */ \
	  0x00F9, /* LATIN SMALL LETTER U WITH GRAVE */ }, \
	{ 0x1EE6, /* LATIN CAPITAL LETTER U WITH HOOK ABOVE */ \
	  0x1EE7, /* LATIN SMALL LETTER U WITH HOOK ABOVE */ }, \
	{ 0x01AF, /* LATIN CAPITAL LETTER U WITH HORN */ \
	  0x01B0, /* LATIN SMALL LETTER U WITH HORN */ }, \
	{ 0x1EE8, /* LATIN CAPITAL LETTER U WITH HORN AND ACUTE */ \
	  0x1EE9, /* LATIN SMALL LETTER U WITH HORN AND ACUTE */ }, \
	{ 0x1EF0, /* LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW */ \
	  0x1EF1, /* LATIN SMALL LETTER U WITH HORN AND DOT BELOW */ }, \
	{ 0x1EEA, /* LATIN CAPITAL LETTER U WITH HORN AND GRAVE */ \
	  0x1EEB, /* LATIN SMALL LETTER U WITH HORN AND GRAVE */ }, \
	{ 0x1EEC, /* LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE */ \
	  0x1EED, /* LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE */ }, \
	{ 0x1EEE, /* LATIN CAPITAL LETTER U WITH HORN AND TILDE */ \
	  0x1EEF, /* LATIN SMALL LETTER U WITH HORN AND TILDE */ }, \
	{ 0x0216, /* LATIN CAPITAL LETTER U WITH INVERTED BREVE */ \
	  0x0217, /* LATIN SMALL LETTER U WITH INVERTED BREVE */ }, \
	{ 0x016A, /* LATIN CAPITAL LETTER U WITH MACRON */ \
	  0x016B, /* LATIN SMALL LETTER U WITH MACRON */ }, \
	{ 0x1E7A, /* LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS */ \
	  0x1E7B, /* LATIN SMALL LETTER U WITH MACRON AND DIAERESIS */ }, \
	{ 0x0172, /* LATIN CAPITAL LETTER U WITH OGONEK */ \
	  0x0173, /* LATIN SMALL LETTER U WITH OGONEK */ }, \
	{ 0x016E, /* LATIN CAPITAL LETTER U WITH RING ABOVE */ \
	  0x016F, /* LATIN SMALL LETTER U WITH RING ABOVE */ }, \
	{ 0xA7B8, /* LATIN CAPITAL LETTER U WITH STROKE */ \
	  0xA7B9, /* LATIN SMALL LETTER U WITH STROKE */ }, \
	{ 0x0168, /* LATIN CAPITAL LETTER U WITH TILDE */ \
	  0x0169, /* LATIN SMALL LETTER U WITH TILDE */ }, \
	{ 0x1E78, /* LATIN CAPITAL LETTER U WITH TILDE AND ACUTE */ \
	  0x1E79, /* LATIN SMALL LETTER U WITH TILDE AND ACUTE */ }, \
	{ 0x1E74, /* LATIN CAPITAL LETTER U WITH TILDE BELOW */ \
	  0x1E75, /* LATIN SMALL LETTER U WITH TILDE BELOW */ }, \
	{ 0x01B1, /* LATIN CAPITAL LETTER UPSILON */ \
	  0x028A, /* LATIN SMALL LETTER UPSILON */ }, \
	{ 0x0056, /* LATIN CAPITAL LETTER V */ \
	  0x0076, /* LATIN SMALL LETTER V */ }, \
	{ 0xA75E, /* LATIN CAPITAL LETTER V WITH DIAGONAL STROKE */ \
	  0xA75F, /* LATIN SMALL LETTER V WITH DIAGONAL STROKE */ }, \
	{ 0x1E7E, /* LATIN CAPITAL LETTER V WITH DOT BELOW */ \
	  0x1E7F, /* LATIN SMALL LETTER V WITH DOT BELOW */ }, \
	{ 0x01B2, /* LATIN CAPITAL LETTER V WITH HOOK */ \
	  0x028B, /* LATIN SMALL LETTER V WITH HOOK */ }, \
	{ 0x1E7C, /* LATIN CAPITAL LETTER V WITH TILDE */ \
	  0x1E7D, /* LATIN SMALL LETTER V WITH TILDE */ }, \
	{ 0xA768, /* LATIN CAPITAL LETTER VEND */ \
	  0xA769, /* LATIN SMALL LETTER VEND */ }, \
	{ 0xA762, /* LATIN CAPITAL LETTER VISIGOTHIC Z */ \
	  0xA763, /* LATIN SMALL LETTER VISIGOTHIC Z */ }, \
	{ 0xA79A, /* LATIN CAPITAL LETTER VOLAPUK AE */ \
	  0xA79B, /* LATIN SMALL LETTER VOLAPUK AE */ }, \
	{ 0xA79C, /* LATIN CAPITAL LETTER VOLAPUK OE */ \
	  0xA79D, /* LATIN SMALL LETTER VOLAPUK OE */ }, \
	{ 0xA79E, /* LATIN CAPITAL LETTER VOLAPUK UE */ \
	  0xA79F, /* LATIN SMALL LETTER VOLAPUK UE */ }, \
	{ 0xA760, /* LATIN CAPITAL LETTER VY */ \
	  0xA761, /* LATIN SMALL LETTER VY */ }, \
	{ 0x0057, /* LATIN CAPITAL LETTER W */ \
	  0x0077, /* LATIN SMALL LETTER W */ }, \
	{ 0x1E82, /* LATIN CAPITAL LETTER W WITH ACUTE */ \
	  0x1E83, /* LATIN SMALL LETTER W WITH ACUTE */ }, \
	{ 0x0174, /* LATIN CAPITAL LETTER W WITH CIRCUMFLEX */ \
	  0x0175, /* LATIN SMALL LETTER W WITH CIRCUMFLEX */ }, \
	{ 0x1E84, /* LATIN CAPITAL LETTER W WITH DIAERESIS */ \
	  0x1E85, /* LATIN SMALL LETTER W WITH DIAERESIS */ }, \
	{ 0x1E86, /* LATIN CAPITAL LETTER W WITH DOT ABOVE */ \
	  0x1E87, /* LATIN SMALL LETTER W WITH DOT ABOVE */ }, \
	{ 0x1E88, /* LATIN CAPITAL LETTER W WITH DOT BELOW */ \
	  0x1E89, /* LATIN SMALL LETTER W WITH DOT BELOW */ }, \
	{ 0x1E80, /* LATIN CAPITAL LETTER W WITH GRAVE */ \
	  0x1E81, /* LATIN SMALL LETTER W WITH GRAVE */ }, \
	{ 0x2C72, /* LATIN CAPITAL LETTER W WITH HOOK */ \
	  0x2C73, /* LATIN SMALL LETTER W WITH HOOK */ }, \
	{ 0x0058, /* LATIN CAPITAL LETTER X */ \
	  0x0078, /* LATIN SMALL LETTER X */ }, \
	{ 0x1E8C, /* LATIN CAPITAL LETTER X WITH DIAERESIS */ \
	  0x1E8D, /* LATIN SMALL LETTER X WITH DIAERESIS */ }, \
	{ 0x1E8A, /* LATIN CAPITAL LETTER X WITH DOT ABOVE */ \
	  0x1E8B, /* LATIN SMALL LETTER X WITH DOT ABOVE */ }, \
	{ 0x0059, /* LATIN CAPITAL LETTER Y */ \
	  0x0079, /* LATIN SMALL LETTER Y */ }, \
	{ 0x00DD, /* LATIN CAPITAL LETTER Y WITH ACUTE */ \
	  0x00FD, /* LATIN SMALL LETTER Y WITH ACUTE */ }, \
	{ 0x0176, /* LATIN CAPITAL LETTER Y WITH CIRCUMFLEX */ \
	  0x0177, /* LATIN SMALL LETTER Y WITH CIRCUMFLEX */ }, \
	{ 0x0178, /* LATIN CAPITAL LETTER Y WITH DIAERESIS */ \
	  0x00FF, /* LATIN SMALL LETTER Y WITH DIAERESIS */ }, \
	{ 0x1E8E, /* LATIN CAPITAL LETTER Y WITH DOT ABOVE */ \
	  0x1E8F, /* LATIN SMALL LETTER Y WITH DOT ABOVE */ }, \
	{ 0x1EF4, /* LATIN CAPITAL LETTER Y WITH DOT BELOW */ \
	  0x1EF5, /* LATIN SMALL LETTER Y WITH DOT BELOW */ }, \
	{ 0x1EF2, /* LATIN CAPITAL LETTER Y WITH GRAVE */ \
	  0x1EF3, /* LATIN SMALL LETTER Y WITH GRAVE */ }, \
	{ 0x01B3, /* LATIN CAPITAL LETTER Y WITH HOOK */ \
	  0x01B4, /* LATIN SMALL LETTER Y WITH HOOK */ }, \
	{ 0x1EF6, /* LATIN CAPITAL LETTER Y WITH HOOK ABOVE */ \
	  0x1EF7, /* LATIN SMALL LETTER Y WITH HOOK ABOVE */ }, \
	{ 0x1EFE, /* LATIN CAPITAL LETTER Y WITH LOOP */ \
	  0x1EFF, /* LATIN SMALL LETTER Y WITH LOOP */ }, \
	{ 0x0232, /* LATIN CAPITAL LETTER Y WITH MACRON */ \
	  0x0233, /* LATIN SMALL LETTER Y WITH MACRON */ }, \
	{ 0x024E, /* LATIN CAPITAL LETTER Y WITH STROKE */ \
	  0x024F, /* LATIN SMALL LETTER Y WITH STROKE */ }, \
	{ 0x1EF8, /* LATIN CAPITAL LETTER Y WITH TILDE */ \
	  0x1EF9, /* LATIN SMALL LETTER Y WITH TILDE */ }, \
	{ 0x021C, /* LATIN CAPITAL LETTER YOGH */ \
	  0x021D, /* LATIN SMALL LETTER YOGH */ }, \
	{ 0x005A, /* LATIN CAPITAL LETTER Z */ \
	  0x007A, /* LATIN SMALL LETTER Z */ }, \
	{ 0x0179, /* LATIN CAPITAL LETTER Z WITH ACUTE */ \
	  0x017A, /* LATIN SMALL LETTER Z WITH ACUTE */ }, \
	{ 0x017D, /* LATIN CAPITAL LETTER Z WITH CARON */ \
	  0x017E, /* LATIN SMALL LETTER Z WITH CARON */ }, \
	{ 0x1E90, /* LATIN CAPITAL LETTER Z WITH CIRCUMFLEX */ \
	  0x1E91, /* LATIN SMALL LETTER Z WITH CIRCUMFLEX */ }, \
	{ 0x2C6B, /* LATIN CAPITAL LETTER Z WITH DESCENDER */ \
	  0x2C6C, /* LATIN SMALL LETTER Z WITH DESCENDER */ }, \
	{ 0x017B, /* LATIN CAPITAL LETTER Z WITH DOT ABOVE */ \
	  0x017C, /* LATIN SMALL LETTER Z WITH DOT ABOVE */ }, \
	{ 0x1E92, /* LATIN CAPITAL LETTER Z WITH DOT BELOW */ \
	  0x1E93, /* LATIN SMALL LETTER Z WITH DOT BELOW */ }, \
	{ 0x0224, /* LATIN CAPITAL LETTER Z WITH HOOK */ \
	  0x0225, /* LATIN SMALL LETTER Z WITH HOOK */ }, \
	{ 0x1E94, /* LATIN CAPITAL LETTER Z WITH LINE BELOW */ \
	  0x1E95, /* LATIN SMALL LETTER Z WITH LINE BELOW */ }, \
	{ 0x01B5, /* LATIN CAPITAL LETTER Z WITH STROKE */ \
	  0x01B6, /* LATIN SMALL LETTER Z WITH STROKE */ }, \
	{ 0x2C7F, /* LATIN CAPITAL LETTER Z WITH SWASH TAIL */ \
	  0x0240, /* LATIN SMALL LETTER Z WITH SWASH TAIL */ }, \
	{ 0x0000, /* END OF LIST CAPITAL LETTERS */ \
	  0x0000, /* END OF LIST SMALL LETTERS */ }, \
}

/*
 * Correspondence table for small and capital letters of codepage 437.
 * Letters A-Z are handled in code.
 */
#define CP437_CAPITALIZATION_TABLE { \
	{ 0x00C4, /* LATIN CAPITAL LETTER A WITH DIAERESIS */ \
	  0x00E4, /* LATIN SMALL LETTER A WITH DIAERESIS */ }, \
	{ 0x00C5, /* LATIN CAPITAL LETTER A WITH RING ABOVE */ \
	  0x00E5, /* LATIN SMALL LETTER A WITH RING ABOVE */ }, \
	{ 0x00C6, /* LATIN CAPITAL LETTER AE */ \
	  0x00E6, /* LATIN SMALL LETTER AE */ }, \
	{ 0x00C7, /* LATIN CAPITAL LETTER C WITH CEDILLA */ \
	  0x00E7, /* LATIN SMALL LETTER C WITH CEDILLA */ }, \
	{ 0x00C9, /* LATIN CAPITAL LETTER E WITH ACUTE */ \
	  0x00E9, /* LATIN SMALL LETTER E WITH ACUTE */ }, \
	{ 0x00D1, /* LATIN CAPITAL LETTER N WITH TILDE */ \
	  0x00F1, /* LATIN SMALL LETTER N WITH TILDE */ }, \
	{ 0x00D6, /* LATIN CAPITAL LETTER O WITH DIAERESIS */ \
	  0x00F6, /* LATIN SMALL LETTER O WITH DIAERESIS */ }, \
	{ 0x00DC, /* LATIN CAPITAL LETTER U WITH DIAERESIS */ \
	  0x00FC, /* LATIN SMALL LETTER U WITH DIAERESIS */ }, \
	{ 0x03A3, /* GREEK CAPITAL LETTER SIGMA */ \
	  0x03C3, /* GREEK SMALL LETTER SIGMA */ }, \
	{ 0x03A6, /* GREEK CAPITAL LETTER PHI */ \
	  0x03C6, /* GREEK SMALL LETTER PHI */ }, \
	{ 0x0000, 0x0000, }, \
}

/*
 * Correspondence table for small and capital letters of codepage 1250.
 * Letters A-Z are handled in code.
 */
#define CP1250_CAPITALIZATION_TABLE { \
	{ 0x00C1, /* LATIN CAPITAL LETTER A WITH ACUTE */ \
	  0x00E1, /* LATIN SMALL LETTER A WITH ACUTE */ }, \
	{ 0x00C2, /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */ \
	  0x00E2, /* LATIN SMALL LETTER A WITH CIRCUMFLEX */ }, \
	{ 0x00C4, /* LATIN CAPITAL LETTER A WITH DIAERESIS */ \
	  0x00E4, /* LATIN SMALL LETTER A WITH DIAERESIS */ }, \
	{ 0x00C7, /* LATIN CAPITAL LETTER C WITH CEDILLA */ \
	  0x00E7, /* LATIN SMALL LETTER C WITH CEDILLA */ }, \
	{ 0x00C9, /* LATIN CAPITAL LETTER E WITH ACUTE */ \
	  0x00E9, /* LATIN SMALL LETTER E WITH ACUTE */ }, \
	{ 0x00CB, /* LATIN CAPITAL LETTER E WITH DIAERESIS */ \
	  0x00EB, /* LATIN SMALL LETTER E WITH DIAERESIS */ }, \
	{ 0x00CD, /* LATIN CAPITAL LETTER I WITH ACUTE */ \
	  0x00ED, /* LATIN SMALL LETTER I WITH ACUTE */ }, \
	{ 0x00CE, /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */ \
	  0x00EE, /* LATIN SMALL LETTER I WITH CIRCUMFLEX */ }, \
	{ 0x00D3, /* LATIN CAPITAL LETTER O WITH ACUTE */ \
	  0x00F3, /* LATIN SMALL LETTER O WITH ACUTE */ }, \
	{ 0x00D4, /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */ \
	  0x00F4, /* LATIN SMALL LETTER O WITH CIRCUMFLEX */ }, \
	{ 0x00D6, /* LATIN CAPITAL LETTER O WITH DIAERESIS */ \
	  0x00F6, /* LATIN SMALL LETTER O WITH DIAERESIS */ }, \
	{ 0x00DA, /* LATIN CAPITAL LETTER U WITH ACUTE */ \
	  0x00FA, /* LATIN SMALL LETTER U WITH ACUTE */ }, \
	{ 0x00DC, /* LATIN CAPITAL LETTER U WITH DIAERESIS */ \
	  0x00FC, /* LATIN SMALL LETTER U WITH DIAERESIS */ }, \
	{ 0x00DD, /* LATIN CAPITAL LETTER Y WITH ACUTE */ \
	  0x00FD, /* LATIN SMALL LETTER Y WITH ACUTE */ }, \
	{ 0x0102, /* LATIN CAPITAL LETTER A WITH BREVE */ \
	  0x0103, /* LATIN SMALL LETTER A WITH BREVE */ }, \
	{ 0x0104, /* LATIN CAPITAL LETTER A WITH OGONEK */ \
	  0x0105, /* LATIN SMALL LETTER A WITH OGONEK */ }, \
	{ 0x0106, /* LATIN CAPITAL LETTER C WITH ACUTE */ \
	  0x0107, /* LATIN SMALL LETTER C WITH ACUTE */ }, \
	{ 0x010C, /* LATIN CAPITAL LETTER C WITH CARON */ \
	  0x010D, /* LATIN SMALL LETTER C WITH CARON */ }, \
	{ 0x010E, /* LATIN CAPITAL LETTER D WITH CARON */ \
	  0x010F, /* LATIN SMALL LETTER D WITH CARON */ }, \
	{ 0x0110, /* LATIN CAPITAL LETTER D WITH STROKE */ \
	  0x0111, /* LATIN SMALL LETTER D WITH STROKE */ }, \
	{ 0x0118, /* LATIN CAPITAL LETTER E WITH OGONEK */ \
	  0x0119, /* LATIN SMALL LETTER E WITH OGONEK */ }, \
	{ 0x011A, /* LATIN CAPITAL LETTER E WITH CARON */ \
	  0x011B, /* LATIN SMALL LETTER E WITH CARON */ }, \
	{ 0x0139, /* LATIN CAPITAL LETTER L WITH ACUTE */ \
	  0x013A, /* LATIN SMALL LETTER L WITH ACUTE */ }, \
	{ 0x013D, /* LATIN CAPITAL LETTER L WITH CARON */ \
	  0x013E, /* LATIN SMALL LETTER L WITH CARON */ }, \
	{ 0x0141, /* LATIN CAPITAL LETTER L WITH STROKE */ \
	  0x0142, /* LATIN SMALL LETTER L WITH STROKE */ }, \
	{ 0x0143, /* LATIN CAPITAL LETTER N WITH ACUTE */ \
	  0x0144, /* LATIN SMALL LETTER N WITH ACUTE */ }, \
	{ 0x0147, /* LATIN CAPITAL LETTER N WITH CARON */ \
	  0x0148, /* LATIN SMALL LETTER N WITH CARON */ }, \
	{ 0x0150, /* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */ \
	  0x0151, /* LATIN SMALL LETTER O WITH DOUBLE ACUTE */ }, \
	{ 0x0154, /* LATIN CAPITAL LETTER R WITH ACUTE */ \
	  0x0155, /* LATIN SMALL LETTER R WITH ACUTE */ }, \
	{ 0x0158, /* LATIN CAPITAL LETTER R WITH CARON */ \
	  0x0159, /* LATIN SMALL LETTER R WITH CARON */ }, \
	{ 0x015A, /* LATIN CAPITAL LETTER S WITH ACUTE */ \
	  0x015B, /* LATIN SMALL LETTER S WITH ACUTE */ }, \
	{ 0x015E, /* LATIN CAPITAL LETTER S WITH CEDILLA */ \
	  0x015F, /* LATIN SMALL LETTER S WITH CEDILLA */ }, \
	{ 0x0160, /* LATIN CAPITAL LETTER S WITH CARON */ \
	  0x0161, /* LATIN SMALL LETTER S WITH CARON */ }, \
	{ 0x0162, /* LATIN CAPITAL LETTER T WITH CEDILLA */ \
	  0x0163, /* LATIN SMALL LETTER T WITH CEDILLA */ }, \
	{ 0x0164, /* LATIN CAPITAL LETTER T WITH CARON */ \
	  0x0165, /* LATIN SMALL LETTER T WITH CARON */ }, \
	{ 0x016E, /* LATIN CAPITAL LETTER U WITH RING ABOVE */ \
	  0x016F, /* LATIN SMALL LETTER U WITH RING ABOVE */ }, \
	{ 0x0170, /* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */ \
	  0x0171, /* LATIN SMALL LETTER U WITH DOUBLE ACUTE */ }, \
	{ 0x0179, /* LATIN CAPITAL LETTER Z WITH ACUTE */ \
	  0x017A, /* LATIN SMALL LETTER Z WITH ACUTE */ }, \
	{ 0x017B, /* LATIN CAPITAL LETTER Z WITH DOT ABOVE */ \
	  0x017C, /* LATIN SMALL LETTER Z WITH DOT ABOVE */ }, \
	{ 0x017D, /* LATIN CAPITAL LETTER Z WITH CARON */ \
	  0x017E, /* LATIN SMALL LETTER Z WITH CARON */ }, \
	{ 0x0000, 0x0000, }, \
}
