/***************************************************************************
 *	Copyright (C) 2004 by karye												*
 *	karye@users.sourceforge.net												*
 *																			*
 *	This program is free software; you can redistribute it and/or modify	*
 *	it under the terms of the GNU General Public License as published by	*
 *	the Free Software Foundation; either version 2 of the License, or		*
 *	(at your option) any later version.										*
 *																			*
 *	This program is distributed in the hope that it will be useful,			*
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of			*
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *	GNU General Public License for more details.							*
 *																			*
 *	You should have received a copy of the GNU General Public License		*
 *	along with this program; if not, write to the							*
 *	Free Software Foundation, Inc.,											*
 *	59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.				*
 ***************************************************************************/

#pragma once

#include <QTextStream>
#include <ThreadWeaver/Job>
#include <ThreadWeaver/JobPointer>
#include <ThreadWeaver/QObjectDecorator>
#include <ThreadWeaver/Thread>

#include "common.h"
#include "portagefiles.h"

class LoadPackageUseJobImpl : public ThreadWeaver::Job
{
public:
	LoadPackageUseJobImpl() = default;

	void run( ThreadWeaver::JobPointer, ThreadWeaver::Thread* ) override {

		QFileInfo fileInfo( KurooConfig::defaultFilePackageUserUse() );
		if( fileInfo.isDir() ) {
			qDebug() << KurooConfig::defaultFilePackageUserUse() << " is a dir";
			if( !mergeDirIntoFile( KurooConfig::defaultFilePackageUserUse() ) ) {
				return;
			}
		}

		QFile file( KurooConfig::defaultFilePackageUserUse() );
		QStringList linesUse;
		if ( !file.open( QIODevice::ReadOnly ) )
			qCritical() << "Parsing user package.use. Reading: %1." << KurooConfig::defaultFilePackageUserUse();
		else {
			QTextStream stream( &file );
			while ( !stream.atEnd() )
				linesUse += stream.readLine();
			file.close();
		}

		// Something is wrong, no files found, get outta here
		if ( linesUse.isEmpty() )
			return;

		DbConnection* const m_db = KurooDBSingleton::Instance()->getStaticDbConnection();
		KurooDBSingleton::Instance()->singleQuery(	QStringLiteral("CREATE TEMP TABLE packageUse_temp ( "
													"idPackage INTEGER UNIQUE, "
													"use VARCHAR(255) );")
													, m_db);

		KurooDBSingleton::Instance()->singleQuery( QStringLiteral("BEGIN TRANSACTION;"), m_db );

		for ( QStringList::Iterator it = linesUse.begin(), end = linesUse.end(); it != end; ++it ) {
			if( !(*it).trimmed().startsWith( u'#' ) && !(*it).trimmed().isEmpty() ) {
				QString category = (*it).section( u'/', 0, 0 );
				QString name = ( (*it).section( u'/', 1 ) ).section( u' ', 0, 0 );
				QString use = (*it).section( u' ', 1 ).simplified();

				QString id = KurooDBSingleton::Instance()->singleQuery(
					QStringLiteral("SELECT id FROM package WHERE name = '") + name + QStringLiteral("' AND category = '") + category + QStringLiteral("' LIMIT 1;"), m_db );

				if ( id.isEmpty() )
					qWarning() << QStringLiteral("Parsing user package.use. Can not find id in database for package %1/%2.")
						.arg( category, name );
				else
					KurooDBSingleton::Instance()->insert( QStringLiteral( "INSERT INTO packageUse_temp (idPackage, use) VALUES ('%1', '%2');" )
									.arg( id, use ), m_db );
			}
		}
		file.close();
		KurooDBSingleton::Instance()->singleQuery( QStringLiteral("COMMIT TRANSACTION;"), m_db );

		// Move content from temporary table to installedPackages
		KurooDBSingleton::Instance()->singleQuery( QStringLiteral("DELETE FROM packageUse;"), m_db );
		KurooDBSingleton::Instance()->insert( QStringLiteral("INSERT INTO packageUse SELECT * FROM packageUse_temp;"), m_db );
		KurooDBSingleton::Instance()->singleQuery( QStringLiteral("DROP TABLE packageUse_temp;"), m_db );

		KurooDBSingleton::Instance()->returnStaticDbConnection( m_db );
// 		return;
// 	}
//
// 	virtual void completeJob() {
		PortageFilesSingleton::Instance()->refresh( PACKAGE_USER_USE_SCANNED );
	}
	Q_DISABLE_COPY(LoadPackageUseJobImpl)
};
/**
* @class: LoadPackageUseJob
* @short: Thread for loading packages use into db.
*/
class LoadPackageUseJob : public ThreadWeaver::QObjectDecorator//, public ThreadWeaver::Job
{
	Q_OBJECT
public:
	LoadPackageUseJob() : ThreadWeaver::QObjectDecorator(new LoadPackageUseJobImpl())//, ThreadWeaver::Job()
	{}
};
