/***********************************************************************************************************************
 * Copyright [2020-2021] Renesas Electronics Corporation and/or its affiliates.  All Rights Reserved.
 *
 * This software and documentation are supplied by Renesas Electronics America Inc. and may only be used with products
 * of Renesas Electronics Corp. and its affiliates ("Renesas").  No other uses are authorized.  Renesas products are
 * sold pursuant to Renesas terms and conditions of sale.  Purchasers are solely responsible for the selection and use
 * of Renesas products and Renesas assumes no liability.  No license, express or implied, to any intellectual property
 * right is granted by Renesas. This software is protected under all applicable laws, including copyright laws. Renesas
 * reserves the right to change or discontinue this software and/or this documentation. THE SOFTWARE AND DOCUMENTATION
 * IS DELIVERED TO YOU "AS IS," AND RENESAS MAKES NO REPRESENTATIONS OR WARRANTIES, AND TO THE FULLEST EXTENT
 * PERMISSIBLE UNDER APPLICABLE LAW, DISCLAIMS ALL WARRANTIES, WHETHER EXPLICITLY OR IMPLICITLY, INCLUDING WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NONINFRINGEMENT, WITH RESPECT TO THE SOFTWARE OR
 * DOCUMENTATION.  RENESAS SHALL HAVE NO LIABILITY ARISING OUT OF ANY SECURITY VULNERABILITY OR BREACH.  TO THE MAXIMUM
 * EXTENT PERMITTED BY LAW, IN NO EVENT WILL RENESAS BE LIABLE TO YOU IN CONNECTION WITH THE SOFTWARE OR DOCUMENTATION
 * (OR ANY PERSON OR ENTITY CLAIMING RIGHTS DERIVED FROM YOU) FOR ANY LOSS, DAMAGES, OR CLAIMS WHATSOEVER, INCLUDING,
 * WITHOUT LIMITATION, ANY DIRECT, CONSEQUENTIAL, SPECIAL, INDIRECT, PUNITIVE, OR INCIDENTAL DAMAGES; ANY LOST PROFITS,
 * OTHER ECONOMIC DAMAGE, PROPERTY DAMAGE, OR PERSONAL INJURY; AND EVEN IF RENESAS HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH LOSS, DAMAGES, CLAIMS OR COSTS.
 **********************************************************************************************************************/

#ifndef  __SCE_ProcCommon_h__
#define  __SCE_ProcCommon_h__

#include  <stdint.h>

#include "bsp_api.h"                   /* For Crypto Error codes */
#include "SCE_module.h"

/* ================================================================================ */
/* ================                      SCE                      ================ */
/* ================================================================================ */

/**
 * @brief Trusted Security IP (SCE)
 */
typedef struct
{
    union
    {
        __IOM uint32_t REG_00H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_00H_b;
    };
    union
    {
        __IOM uint32_t REG_04H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_04H_b;
    };
    union
    {
        __IOM uint32_t REG_08H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_08H_b;
    };
    union
    {
        __IOM uint32_t REG_0CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_0CH_b;
    };
    union
    {
        __IOM uint32_t REG_10H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_10H_b;
    };
    union
    {
        __IOM uint32_t REG_14H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_14H_b;
    };
    union
    {
        __IOM uint32_t REG_18H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_18H_b;
    };
    union
    {
        __IOM uint32_t REG_1CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1CH_b;
    };
    union
    {
        __IOM uint32_t REG_20H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_20H_b;
    };
    union
    {
        __IOM uint32_t REG_24H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_24H_b;
    };
    union
    {
        __IOM uint32_t REG_28H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_28H_b;
    };
    union
    {
        __IOM uint32_t REG_2CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2CH_b;
    };
    union
    {
        __IOM uint32_t REG_30H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_30H_b;
    };
    union
    {
        __IOM uint32_t REG_34H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_34H_b;
    };
    union
    {
        __IOM uint32_t REG_38H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_38H_b;
    };
    union
    {
        __IOM uint32_t REG_3CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3CH_b;
    };
    union
    {
        __IOM uint32_t REG_40H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_40H_b;
    };
    union
    {
        __IOM uint32_t REG_44H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_44H_b;
    };
    union
    {
        __IOM uint32_t REG_48H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_48H_b;
    };
    union
    {
        __IOM uint32_t REG_4CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4CH_b;
    };
    union
    {
        __IOM uint32_t REG_50H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_50H_b;
    };
    union
    {
        __IOM uint32_t REG_54H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_54H_b;
    };
    union
    {
        __IOM uint32_t REG_58H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_58H_b;
    };
    union
    {
        __IOM uint32_t REG_5CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5CH_b;
    };
    union
    {
        __IOM uint32_t REG_60H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_60H_b;
    };
    union
    {
        __IOM uint32_t REG_64H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_64H_b;
    };
    union
    {
        __IOM uint32_t REG_68H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_68H_b;
    };
    union
    {
        __IOM uint32_t REG_6CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6CH_b;
    };
    union
    {
        __IOM uint32_t REG_70H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_70H_b;
    };
    union
    {
        __IOM uint32_t REG_74H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_74H_b;
    };
    union
    {
        __IOM uint32_t REG_78H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_78H_b;
    };
    union
    {
        __IOM uint32_t REG_7CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7CH_b;
    };
    union
    {
        __IOM uint32_t REG_80H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_80H_b;
    };
    union
    {
        __IOM uint32_t REG_84H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_84H_b;
    };
    union
    {
        __IOM uint32_t REG_88H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_88H_b;
    };
    union
    {
        __IOM uint32_t REG_8CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8CH_b;
    };
    union
    {
        __IOM uint32_t REG_90H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_90H_b;
    };
    union
    {
        __IOM uint32_t REG_94H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_94H_b;
    };
    union
    {
        __IOM uint32_t REG_98H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_98H_b;
    };
    union
    {
        __IOM uint32_t REG_9CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9CH_b;
    };
    union
    {
        __IOM uint32_t REG_A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A0H_b;
    };
    union
    {
        __IOM uint32_t REG_A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A4H_b;
    };
    union
    {
        __IOM uint32_t REG_A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A8H_b;
    };
    union
    {
        __IOM uint32_t REG_ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_ACH_b;
    };
    union
    {
        __IOM uint32_t REG_B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B0H_b;
    };
    union
    {
        __IOM uint32_t REG_B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B4H_b;
    };
    union
    {
        __IOM uint32_t REG_B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B8H_b;
    };
    union
    {
        __IOM uint32_t REG_BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BCH_b;
    };
    union
    {
        __IOM uint32_t REG_C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C0H_b;
    };
    union
    {
        __IOM uint32_t REG_C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C4H_b;
    };
    union
    {
        __IOM uint32_t REG_C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C8H_b;
    };
    union
    {
        __IOM uint32_t REG_CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_CCH_b;
    };
    union
    {
        __IOM uint32_t REG_D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_D0H_b;
    };
    union
    {
        __IOM uint32_t REG_D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_D4H_b;
    };
    union
    {
        __IOM uint32_t REG_D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_D8H_b;
    };
    union
    {
        __IOM uint32_t REG_DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_DCH_b;
    };
    union
    {
        __IOM uint32_t REG_E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_E0H_b;
    };
    union
    {
        __IOM uint32_t REG_E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_E4H_b;
    };
    union
    {
        __IOM uint32_t REG_E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_E8H_b;
    };
    union
    {
        __IOM uint32_t REG_ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_ECH_b;
    };
    union
    {
        __IOM uint32_t REG_F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_F0H_b;
    };
    union
    {
        __IOM uint32_t REG_F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_F4H_b;
    };
    union
    {
        __IOM uint32_t REG_F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_F8H_b;
    };
    union
    {
        __IOM uint32_t REG_FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_FCH_b;
    };
    union
    {
        __IOM uint32_t REG_100H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_100H_b;
    };
    union
    {
        __IOM uint32_t REG_104H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_104H_b;
    };
    union
    {
        __IOM uint32_t REG_108H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_108H_b;
    };
    union
    {
        __IOM uint32_t REG_10CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_10CH_b;
    };
    union
    {
        __IOM uint32_t REG_110H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_110H_b;
    };
    union
    {
        __IOM uint32_t REG_114H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_114H_b;
    };
    union
    {
        __IOM uint32_t REG_118H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_118H_b;
    };
    union
    {
        __IOM uint32_t REG_11CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_11CH_b;
    };
    union
    {
        __IOM uint32_t REG_120H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_120H_b;
    };
    union
    {
        __IOM uint32_t REG_124H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_124H_b;
    };
    union
    {
        __IOM uint32_t REG_128H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_128H_b;
    };
    union
    {
        __IOM uint32_t REG_12CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_12CH_b;
    };
    union
    {
        __IOM uint32_t REG_130H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_130H_b;
    };
    union
    {
        __IOM uint32_t REG_134H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_134H_b;
    };
    union
    {
        __IOM uint32_t REG_138H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_138H_b;
    };
    union
    {
        __IOM uint32_t REG_13CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_13CH_b;
    };
    union
    {
        __IOM uint32_t REG_140H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_140H_b;
    };
    union
    {
        __IOM uint32_t REG_144H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_144H_b;
    };
    union
    {
        __IOM uint32_t REG_148H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_148H_b;
    };
    union
    {
        __IOM uint32_t REG_14CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_14CH_b;
    };
    union
    {
        __IOM uint32_t REG_150H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_150H_b;
    };
    union
    {
        __IOM uint32_t REG_154H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_154H_b;
    };
    union
    {
        __IOM uint32_t REG_158H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_158H_b;
    };
    union
    {
        __IOM uint32_t REG_15CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_15CH_b;
    };
    union
    {
        __IOM uint32_t REG_160H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_160H_b;
    };
    union
    {
        __IOM uint32_t REG_164H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_164H_b;
    };
    union
    {
        __IOM uint32_t REG_168H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_168H_b;
    };
    union
    {
        __IOM uint32_t REG_16CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_16CH_b;
    };
    union
    {
        __IOM uint32_t REG_170H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_170H_b;
    };
    union
    {
        __IOM uint32_t REG_174H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_174H_b;
    };
    union
    {
        __IOM uint32_t REG_178H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_178H_b;
    };
    union
    {
        __IOM uint32_t REG_17CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_17CH_b;
    };
    union
    {
        __IOM uint32_t REG_180H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_180H_b;
    };
    union
    {
        __IOM uint32_t REG_184H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_184H_b;
    };
    union
    {
        __IOM uint32_t REG_188H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_188H_b;
    };
    union
    {
        __IOM uint32_t REG_18CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_18CH_b;
    };
    union
    {
        __IOM uint32_t REG_190H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_190H_b;
    };
    union
    {
        __IOM uint32_t REG_194H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_194H_b;
    };
    union
    {
        __IOM uint32_t REG_198H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_198H_b;
    };
    union
    {
        __IOM uint32_t REG_19CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_19CH_b;
    };
    union
    {
        __IOM uint32_t REG_1A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1A0H_b;
    };
    union
    {
        __IOM uint32_t REG_1A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1A4H_b;
    };
    union
    {
        __IOM uint32_t REG_1A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1A8H_b;
    };
    union
    {
        __IOM uint32_t REG_1ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1ACH_b;
    };
    union
    {
        __IOM uint32_t REG_1B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1B0H_b;
    };
    union
    {
        __IOM uint32_t REG_1B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1B4H_b;
    };
    union
    {
        __IOM uint32_t REG_1B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1B8H_b;
    };
    union
    {
        __IOM uint32_t REG_1BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1BCH_b;
    };
    union
    {
        __IOM uint32_t REG_1C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1C0H_b;
    };
    union
    {
        __IOM uint32_t REG_1C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1C4H_b;
    };
    union
    {
        __IOM uint32_t REG_1C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1C8H_b;
    };
    union
    {
        __IOM uint32_t REG_1CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1CCH_b;
    };
    union
    {
        __IOM uint32_t REG_1D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1D0H_b;
    };
    union
    {
        __IOM uint32_t REG_1D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1D4H_b;
    };
    union
    {
        __IOM uint32_t REG_1D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1D8H_b;
    };
    union
    {
        __IOM uint32_t REG_1DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1DCH_b;
    };
    union
    {
        __IOM uint32_t REG_1E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1E0H_b;
    };
    union
    {
        __IOM uint32_t REG_1E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1E4H_b;
    };
    union
    {
        __IOM uint32_t REG_1E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1E8H_b;
    };
    union
    {
        __IOM uint32_t REG_1ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1ECH_b;
    };
    union
    {
        __IOM uint32_t REG_1F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1F0H_b;
    };
    union
    {
        __IOM uint32_t REG_1F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1F4H_b;
    };
    union
    {
        __IOM uint32_t REG_1F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1F8H_b;
    };
    union
    {
        __IOM uint32_t REG_1FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_1FCH_b;
    };
    union
    {
        __IOM uint32_t REG_200H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_200H_b;
    };
    union
    {
        __IOM uint32_t REG_204H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_204H_b;
    };
    union
    {
        __IOM uint32_t REG_208H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_208H_b;
    };
    union
    {
        __IOM uint32_t REG_20CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_20CH_b;
    };
    union
    {
        __IOM uint32_t REG_210H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_210H_b;
    };
    union
    {
        __IOM uint32_t REG_214H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_214H_b;
    };
    union
    {
        __IOM uint32_t REG_218H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_218H_b;
    };
    union
    {
        __IOM uint32_t REG_21CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_21CH_b;
    };
    union
    {
        __IOM uint32_t REG_220H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_220H_b;
    };
    union
    {
        __IOM uint32_t REG_224H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_224H_b;
    };
    union
    {
        __IOM uint32_t REG_228H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_228H_b;
    };
    union
    {
        __IOM uint32_t REG_22CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_22CH_b;
    };
    union
    {
        __IOM uint32_t REG_230H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_230H_b;
    };
    union
    {
        __IOM uint32_t REG_234H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_234H_b;
    };
    union
    {
        __IOM uint32_t REG_238H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_238H_b;
    };
    union
    {
        __IOM uint32_t REG_23CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_23CH_b;
    };
    union
    {
        __IOM uint32_t REG_240H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_240H_b;
    };
    union
    {
        __IOM uint32_t REG_244H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_244H_b;
    };
    union
    {
        __IOM uint32_t REG_248H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_248H_b;
    };
    union
    {
        __IOM uint32_t REG_24CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_24CH_b;
    };
    union
    {
        __IOM uint32_t REG_250H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_250H_b;
    };
    union
    {
        __IOM uint32_t REG_254H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_254H_b;
    };
    union
    {
        __IOM uint32_t REG_258H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_258H_b;
    };
    union
    {
        __IOM uint32_t REG_25CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_25CH_b;
    };
    union
    {
        __IOM uint32_t REG_260H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_260H_b;
    };
    union
    {
        __IOM uint32_t REG_264H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_264H_b;
    };
    union
    {
        __IOM uint32_t REG_268H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_268H_b;
    };
    union
    {
        __IOM uint32_t REG_26CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_26CH_b;
    };
    union
    {
        __IOM uint32_t REG_270H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_270H_b;
    };
    union
    {
        __IOM uint32_t REG_274H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_274H_b;
    };
    union
    {
        __IOM uint32_t REG_278H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_278H_b;
    };
    union
    {
        __IOM uint32_t REG_27CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_27CH_b;
    };
    union
    {
        __IOM uint32_t REG_280H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_280H_b;
    };
    union
    {
        __IOM uint32_t REG_284H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_284H_b;
    };
    union
    {
        __IOM uint32_t REG_288H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_288H_b;
    };
    union
    {
        __IOM uint32_t REG_28CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_28CH_b;
    };
    union
    {
        __IOM uint32_t REG_290H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_290H_b;
    };
    union
    {
        __IOM uint32_t REG_294H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_294H_b;
    };
    union
    {
        __IOM uint32_t REG_298H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_298H_b;
    };
    union
    {
        __IOM uint32_t REG_29CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_29CH_b;
    };
    union
    {
        __IOM uint32_t REG_2A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2A0H_b;
    };
    union
    {
        __IOM uint32_t REG_2A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2A4H_b;
    };
    union
    {
        __IOM uint32_t REG_2A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2A8H_b;
    };
    union
    {
        __IOM uint32_t REG_2ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2ACH_b;
    };
    union
    {
        __IOM uint32_t REG_2B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2B0H_b;
    };
    union
    {
        __IOM uint32_t REG_2B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2B4H_b;
    };
    union
    {
        __IOM uint32_t REG_2B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2B8H_b;
    };
    union
    {
        __IOM uint32_t REG_2BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2BCH_b;
    };
    union
    {
        __IOM uint32_t REG_2C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2C0H_b;
    };
    union
    {
        __IOM uint32_t REG_2C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2C4H_b;
    };
    union
    {
        __IOM uint32_t REG_2C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2C8H_b;
    };
    union
    {
        __IOM uint32_t REG_2CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2CCH_b;
    };
    union
    {
        __IOM uint32_t REG_2D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2D0H_b;
    };
    union
    {
        __IOM uint32_t REG_2D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2D4H_b;
    };
    union
    {
        __IOM uint32_t REG_2D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2D8H_b;
    };
    union
    {
        __IOM uint32_t REG_2DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2DCH_b;
    };
    union
    {
        __IOM uint32_t REG_2E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2E0H_b;
    };
    union
    {
        __IOM uint32_t REG_2E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2E4H_b;
    };
    union
    {
        __IOM uint32_t REG_2E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2E8H_b;
    };
    union
    {
        __IOM uint32_t REG_2ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2ECH_b;
    };
    union
    {
        __IOM uint32_t REG_2F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2F0H_b;
    };
    union
    {
        __IOM uint32_t REG_2F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2F4H_b;
    };
    union
    {
        __IOM uint32_t REG_2F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2F8H_b;
    };
    union
    {
        __IOM uint32_t REG_2FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_2FCH_b;
    };
    union
    {
        __IOM uint32_t REG_300H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_300H_b;
    };
    union
    {
        __IOM uint32_t REG_304H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_304H_b;
    };
    union
    {
        __IOM uint32_t REG_308H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_308H_b;
    };
    union
    {
        __IOM uint32_t REG_30CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_30CH_b;
    };
    union
    {
        __IOM uint32_t REG_310H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_310H_b;
    };
    union
    {
        __IOM uint32_t REG_314H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_314H_b;
    };
    union
    {
        __IOM uint32_t REG_318H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_318H_b;
    };
    union
    {
        __IOM uint32_t REG_31CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_31CH_b;
    };
    union
    {
        __IOM uint32_t REG_320H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_320H_b;
    };
    union
    {
        __IOM uint32_t REG_324H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_324H_b;
    };
    union
    {
        __IOM uint32_t REG_328H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_328H_b;
    };
    union
    {
        __IOM uint32_t REG_32CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_32CH_b;
    };
    union
    {
        __IOM uint32_t REG_330H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_330H_b;
    };
    union
    {
        __IOM uint32_t REG_334H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_334H_b;
    };
    union
    {
        __IOM uint32_t REG_338H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_338H_b;
    };
    union
    {
        __IOM uint32_t REG_33CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_33CH_b;
    };
    union
    {
        __IOM uint32_t REG_340H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_340H_b;
    };
    union
    {
        __IOM uint32_t REG_344H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_344H_b;
    };
    union
    {
        __IOM uint32_t REG_348H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_348H_b;
    };
    union
    {
        __IOM uint32_t REG_34CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_34CH_b;
    };
    union
    {
        __IOM uint32_t REG_350H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_350H_b;
    };
    union
    {
        __IOM uint32_t REG_354H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_354H_b;
    };
    union
    {
        __IOM uint32_t REG_358H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_358H_b;
    };
    union
    {
        __IOM uint32_t REG_35CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_35CH_b;
    };
    union
    {
        __IOM uint32_t REG_360H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_360H_b;
    };
    union
    {
        __IOM uint32_t REG_364H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_364H_b;
    };
    union
    {
        __IOM uint32_t REG_368H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_368H_b;
    };
    union
    {
        __IOM uint32_t REG_36CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_36CH_b;
    };
    union
    {
        __IOM uint32_t REG_370H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_370H_b;
    };
    union
    {
        __IOM uint32_t REG_374H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_374H_b;
    };
    union
    {
        __IOM uint32_t REG_378H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_378H_b;
    };
    union
    {
        __IOM uint32_t REG_37CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_37CH_b;
    };
    union
    {
        __IOM uint32_t REG_380H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_380H_b;
    };
    union
    {
        __IOM uint32_t REG_384H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_384H_b;
    };
    union
    {
        __IOM uint32_t REG_388H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_388H_b;
    };
    union
    {
        __IOM uint32_t REG_38CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_38CH_b;
    };
    union
    {
        __IOM uint32_t REG_390H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_390H_b;
    };
    union
    {
        __IOM uint32_t REG_394H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_394H_b;
    };
    union
    {
        __IOM uint32_t REG_398H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_398H_b;
    };
    union
    {
        __IOM uint32_t REG_39CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_39CH_b;
    };
    union
    {
        __IOM uint32_t REG_3A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3A0H_b;
    };
    union
    {
        __IOM uint32_t REG_3A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3A4H_b;
    };
    union
    {
        __IOM uint32_t REG_3A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3A8H_b;
    };
    union
    {
        __IOM uint32_t REG_3ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3ACH_b;
    };
    union
    {
        __IOM uint32_t REG_3B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3B0H_b;
    };
    union
    {
        __IOM uint32_t REG_3B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3B4H_b;
    };
    union
    {
        __IOM uint32_t REG_3B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3B8H_b;
    };
    union
    {
        __IOM uint32_t REG_3BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3BCH_b;
    };
    union
    {
        __IOM uint32_t REG_3C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3C0H_b;
    };
    union
    {
        __IOM uint32_t REG_3C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3C4H_b;
    };
    union
    {
        __IOM uint32_t REG_3C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3C8H_b;
    };
    union
    {
        __IOM uint32_t REG_3CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3CCH_b;
    };
    union
    {
        __IOM uint32_t REG_3D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3D0H_b;
    };
    union
    {
        __IOM uint32_t REG_3D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3D4H_b;
    };
    union
    {
        __IOM uint32_t REG_3D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3D8H_b;
    };
    union
    {
        __IOM uint32_t REG_3DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3DCH_b;
    };
    union
    {
        __IOM uint32_t REG_3E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3E0H_b;
    };
    union
    {
        __IOM uint32_t REG_3E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3E4H_b;
    };
    union
    {
        __IOM uint32_t REG_3E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3E8H_b;
    };
    union
    {
        __IOM uint32_t REG_3ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3ECH_b;
    };
    union
    {
        __IOM uint32_t REG_3F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3F0H_b;
    };
    union
    {
        __IOM uint32_t REG_3F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3F4H_b;
    };
    union
    {
        __IOM uint32_t REG_3F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3F8H_b;
    };
    union
    {
        __IOM uint32_t REG_3FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_3FCH_b;
    };
    union
    {
        __IOM uint32_t REG_400H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_400H_b;
    };
    union
    {
        __IOM uint32_t REG_404H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_404H_b;
    };
    union
    {
        __IOM uint32_t REG_408H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_408H_b;
    };
    union
    {
        __IOM uint32_t REG_40CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_40CH_b;
    };
    union
    {
        __IOM uint32_t REG_410H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_410H_b;
    };
    union
    {
        __IOM uint32_t REG_414H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_414H_b;
    };
    union
    {
        __IOM uint32_t REG_418H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_418H_b;
    };
    union
    {
        __IOM uint32_t REG_41CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_41CH_b;
    };
    union
    {
        __IOM uint32_t REG_420H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_420H_b;
    };
    union
    {
        __IOM uint32_t REG_424H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_424H_b;
    };
    union
    {
        __IOM uint32_t REG_428H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_428H_b;
    };
    union
    {
        __IOM uint32_t REG_42CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_42CH_b;
    };
    union
    {
        __IOM uint32_t REG_430H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_430H_b;
    };
    union
    {
        __IOM uint32_t REG_434H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_434H_b;
    };
    union
    {
        __IOM uint32_t REG_438H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_438H_b;
    };
    union
    {
        __IOM uint32_t REG_43CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_43CH_b;
    };
    union
    {
        __IOM uint32_t REG_440H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_440H_b;
    };
    union
    {
        __IOM uint32_t REG_444H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_444H_b;
    };
    union
    {
        __IOM uint32_t REG_448H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_448H_b;
    };
    union
    {
        __IOM uint32_t REG_44CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_44CH_b;
    };
    union
    {
        __IOM uint32_t REG_450H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_450H_b;
    };
    union
    {
        __IOM uint32_t REG_454H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_454H_b;
    };
    union
    {
        __IOM uint32_t REG_458H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_458H_b;
    };
    union
    {
        __IOM uint32_t REG_45CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_45CH_b;
    };
    union
    {
        __IOM uint32_t REG_460H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_460H_b;
    };
    union
    {
        __IOM uint32_t REG_464H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_464H_b;
    };
    union
    {
        __IOM uint32_t REG_468H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_468H_b;
    };
    union
    {
        __IOM uint32_t REG_46CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_46CH_b;
    };
    union
    {
        __IOM uint32_t REG_470H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_470H_b;
    };
    union
    {
        __IOM uint32_t REG_474H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_474H_b;
    };
    union
    {
        __IOM uint32_t REG_478H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_478H_b;
    };
    union
    {
        __IOM uint32_t REG_47CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_47CH_b;
    };
    union
    {
        __IOM uint32_t REG_480H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_480H_b;
    };
    union
    {
        __IOM uint32_t REG_484H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_484H_b;
    };
    union
    {
        __IOM uint32_t REG_488H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_488H_b;
    };
    union
    {
        __IOM uint32_t REG_48CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_48CH_b;
    };
    union
    {
        __IOM uint32_t REG_490H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_490H_b;
    };
    union
    {
        __IOM uint32_t REG_494H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_494H_b;
    };
    union
    {
        __IOM uint32_t REG_498H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_498H_b;
    };
    union
    {
        __IOM uint32_t REG_49CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_49CH_b;
    };
    union
    {
        __IOM uint32_t REG_4A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4A0H_b;
    };
    union
    {
        __IOM uint32_t REG_4A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4A4H_b;
    };
    union
    {
        __IOM uint32_t REG_4A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4A8H_b;
    };
    union
    {
        __IOM uint32_t REG_4ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4ACH_b;
    };
    union
    {
        __IOM uint32_t REG_4B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4B0H_b;
    };
    union
    {
        __IOM uint32_t REG_4B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4B4H_b;
    };
    union
    {
        __IOM uint32_t REG_4B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4B8H_b;
    };
    union
    {
        __IOM uint32_t REG_4BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4BCH_b;
    };
    union
    {
        __IOM uint32_t REG_4C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4C0H_b;
    };
    union
    {
        __IOM uint32_t REG_4C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4C4H_b;
    };
    union
    {
        __IOM uint32_t REG_4C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4C8H_b;
    };
    union
    {
        __IOM uint32_t REG_4CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4CCH_b;
    };
    union
    {
        __IOM uint32_t REG_4D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4D0H_b;
    };
    union
    {
        __IOM uint32_t REG_4D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4D4H_b;
    };
    union
    {
        __IOM uint32_t REG_4D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4D8H_b;
    };
    union
    {
        __IOM uint32_t REG_4DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4DCH_b;
    };
    union
    {
        __IOM uint32_t REG_4E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4E0H_b;
    };
    union
    {
        __IOM uint32_t REG_4E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4E4H_b;
    };
    union
    {
        __IOM uint32_t REG_4E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4E8H_b;
    };
    union
    {
        __IOM uint32_t REG_4ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4ECH_b;
    };
    union
    {
        __IOM uint32_t REG_4F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4F0H_b;
    };
    union
    {
        __IOM uint32_t REG_4F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4F4H_b;
    };
    union
    {
        __IOM uint32_t REG_4F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4F8H_b;
    };
    union
    {
        __IOM uint32_t REG_4FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_4FCH_b;
    };
    union
    {
        __IOM uint32_t REG_500H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_500H_b;
    };
    union
    {
        __IOM uint32_t REG_504H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_504H_b;
    };
    union
    {
        __IOM uint32_t REG_508H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_508H_b;
    };
    union
    {
        __IOM uint32_t REG_50CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_50CH_b;
    };
    union
    {
        __IOM uint32_t REG_510H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_510H_b;
    };
    union
    {
        __IOM uint32_t REG_514H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_514H_b;
    };
    union
    {
        __IOM uint32_t REG_518H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_518H_b;
    };
    union
    {
        __IOM uint32_t REG_51CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_51CH_b;
    };
    union
    {
        __IOM uint32_t REG_520H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_520H_b;
    };
    union
    {
        __IOM uint32_t REG_524H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_524H_b;
    };
    union
    {
        __IOM uint32_t REG_528H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_528H_b;
    };
    union
    {
        __IOM uint32_t REG_52CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_52CH_b;
    };
    union
    {
        __IOM uint32_t REG_530H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_530H_b;
    };
    union
    {
        __IOM uint32_t REG_534H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_534H_b;
    };
    union
    {
        __IOM uint32_t REG_538H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_538H_b;
    };
    union
    {
        __IOM uint32_t REG_53CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_53CH_b;
    };
    union
    {
        __IOM uint32_t REG_540H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_540H_b;
    };
    union
    {
        __IOM uint32_t REG_544H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_544H_b;
    };
    union
    {
        __IOM uint32_t REG_548H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_548H_b;
    };
    union
    {
        __IOM uint32_t REG_54CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_54CH_b;
    };
    union
    {
        __IOM uint32_t REG_550H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_550H_b;
    };
    union
    {
        __IOM uint32_t REG_554H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_554H_b;
    };
    union
    {
        __IOM uint32_t REG_558H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_558H_b;
    };
    union
    {
        __IOM uint32_t REG_55CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_55CH_b;
    };
    union
    {
        __IOM uint32_t REG_560H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_560H_b;
    };
    union
    {
        __IOM uint32_t REG_564H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_564H_b;
    };
    union
    {
        __IOM uint32_t REG_568H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_568H_b;
    };
    union
    {
        __IOM uint32_t REG_56CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_56CH_b;
    };
    union
    {
        __IOM uint32_t REG_570H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_570H_b;
    };
    union
    {
        __IOM uint32_t REG_574H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_574H_b;
    };
    union
    {
        __IOM uint32_t REG_578H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_578H_b;
    };
    union
    {
        __IOM uint32_t REG_57CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_57CH_b;
    };
    union
    {
        __IOM uint32_t REG_580H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_580H_b;
    };
    union
    {
        __IOM uint32_t REG_584H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_584H_b;
    };
    union
    {
        __IOM uint32_t REG_588H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_588H_b;
    };
    union
    {
        __IOM uint32_t REG_58CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_58CH_b;
    };
    union
    {
        __IOM uint32_t REG_590H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_590H_b;
    };
    union
    {
        __IOM uint32_t REG_594H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_594H_b;
    };
    union
    {
        __IOM uint32_t REG_598H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_598H_b;
    };
    union
    {
        __IOM uint32_t REG_59CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_59CH_b;
    };
    union
    {
        __IOM uint32_t REG_5A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5A0H_b;
    };
    union
    {
        __IOM uint32_t REG_5A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5A4H_b;
    };
    union
    {
        __IOM uint32_t REG_5A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5A8H_b;
    };
    union
    {
        __IOM uint32_t REG_5ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5ACH_b;
    };
    union
    {
        __IOM uint32_t REG_5B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5B0H_b;
    };
    union
    {
        __IOM uint32_t REG_5B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5B4H_b;
    };
    union
    {
        __IOM uint32_t REG_5B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5B8H_b;
    };
    union
    {
        __IOM uint32_t REG_5BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5BCH_b;
    };
    union
    {
        __IOM uint32_t REG_5C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5C0H_b;
    };
    union
    {
        __IOM uint32_t REG_5C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5C4H_b;
    };
    union
    {
        __IOM uint32_t REG_5C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5C8H_b;
    };
    union
    {
        __IOM uint32_t REG_5CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5CCH_b;
    };
    union
    {
        __IOM uint32_t REG_5D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5D0H_b;
    };
    union
    {
        __IOM uint32_t REG_5D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5D4H_b;
    };
    union
    {
        __IOM uint32_t REG_5D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5D8H_b;
    };
    union
    {
        __IOM uint32_t REG_5DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5DCH_b;
    };
    union
    {
        __IOM uint32_t REG_5E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5E0H_b;
    };
    union
    {
        __IOM uint32_t REG_5E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5E4H_b;
    };
    union
    {
        __IOM uint32_t REG_5E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5E8H_b;
    };
    union
    {
        __IOM uint32_t REG_5ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5ECH_b;
    };
    union
    {
        __IOM uint32_t REG_5F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5F0H_b;
    };
    union
    {
        __IOM uint32_t REG_5F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5F4H_b;
    };
    union
    {
        __IOM uint32_t REG_5F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5F8H_b;
    };
    union
    {
        __IOM uint32_t REG_5FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_5FCH_b;
    };
    union
    {
        __IOM uint32_t REG_600H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_600H_b;
    };
    union
    {
        __IOM uint32_t REG_604H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_604H_b;
    };
    union
    {
        __IOM uint32_t REG_608H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_608H_b;
    };
    union
    {
        __IOM uint32_t REG_60CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_60CH_b;
    };
    union
    {
        __IOM uint32_t REG_610H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_610H_b;
    };
    union
    {
        __IOM uint32_t REG_614H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_614H_b;
    };
    union
    {
        __IOM uint32_t REG_618H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_618H_b;
    };
    union
    {
        __IOM uint32_t REG_61CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_61CH_b;
    };
    union
    {
        __IOM uint32_t REG_620H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_620H_b;
    };
    union
    {
        __IOM uint32_t REG_624H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_624H_b;
    };
    union
    {
        __IOM uint32_t REG_628H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_628H_b;
    };
    union
    {
        __IOM uint32_t REG_62CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_62CH_b;
    };
    union
    {
        __IOM uint32_t REG_630H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_630H_b;
    };
    union
    {
        __IOM uint32_t REG_634H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_634H_b;
    };
    union
    {
        __IOM uint32_t REG_638H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_638H_b;
    };
    union
    {
        __IOM uint32_t REG_63CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_63CH_b;
    };
    union
    {
        __IOM uint32_t REG_640H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_640H_b;
    };
    union
    {
        __IOM uint32_t REG_644H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_644H_b;
    };
    union
    {
        __IOM uint32_t REG_648H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_648H_b;
    };
    union
    {
        __IOM uint32_t REG_64CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_64CH_b;
    };
    union
    {
        __IOM uint32_t REG_650H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_650H_b;
    };
    union
    {
        __IOM uint32_t REG_654H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_654H_b;
    };
    union
    {
        __IOM uint32_t REG_658H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_658H_b;
    };
    union
    {
        __IOM uint32_t REG_65CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_65CH_b;
    };
    union
    {
        __IOM uint32_t REG_660H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_660H_b;
    };
    union
    {
        __IOM uint32_t REG_664H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_664H_b;
    };
    union
    {
        __IOM uint32_t REG_668H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_668H_b;
    };
    union
    {
        __IOM uint32_t REG_66CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_66CH_b;
    };
    union
    {
        __IOM uint32_t REG_670H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_670H_b;
    };
    union
    {
        __IOM uint32_t REG_674H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_674H_b;
    };
    union
    {
        __IOM uint32_t REG_678H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_678H_b;
    };
    union
    {
        __IOM uint32_t REG_67CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_67CH_b;
    };
    union
    {
        __IOM uint32_t REG_680H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_680H_b;
    };
    union
    {
        __IOM uint32_t REG_684H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_684H_b;
    };
    union
    {
        __IOM uint32_t REG_688H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_688H_b;
    };
    union
    {
        __IOM uint32_t REG_68CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_68CH_b;
    };
    union
    {
        __IOM uint32_t REG_690H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_690H_b;
    };
    union
    {
        __IOM uint32_t REG_694H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_694H_b;
    };
    union
    {
        __IOM uint32_t REG_698H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_698H_b;
    };
    union
    {
        __IOM uint32_t REG_69CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_69CH_b;
    };
    union
    {
        __IOM uint32_t REG_6A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6A0H_b;
    };
    union
    {
        __IOM uint32_t REG_6A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6A4H_b;
    };
    union
    {
        __IOM uint32_t REG_6A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6A8H_b;
    };
    union
    {
        __IOM uint32_t REG_6ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6ACH_b;
    };
    union
    {
        __IOM uint32_t REG_6B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6B0H_b;
    };
    union
    {
        __IOM uint32_t REG_6B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6B4H_b;
    };
    union
    {
        __IOM uint32_t REG_6B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6B8H_b;
    };
    union
    {
        __IOM uint32_t REG_6BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6BCH_b;
    };
    union
    {
        __IOM uint32_t REG_6C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6C0H_b;
    };
    union
    {
        __IOM uint32_t REG_6C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6C4H_b;
    };
    union
    {
        __IOM uint32_t REG_6C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6C8H_b;
    };
    union
    {
        __IOM uint32_t REG_6CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6CCH_b;
    };
    union
    {
        __IOM uint32_t REG_6D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6D0H_b;
    };
    union
    {
        __IOM uint32_t REG_6D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6D4H_b;
    };
    union
    {
        __IOM uint32_t REG_6D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6D8H_b;
    };
    union
    {
        __IOM uint32_t REG_6DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6DCH_b;
    };
    union
    {
        __IOM uint32_t REG_6E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6E0H_b;
    };
    union
    {
        __IOM uint32_t REG_6E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6E4H_b;
    };
    union
    {
        __IOM uint32_t REG_6E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6E8H_b;
    };
    union
    {
        __IOM uint32_t REG_6ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6ECH_b;
    };
    union
    {
        __IOM uint32_t REG_6F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6F0H_b;
    };
    union
    {
        __IOM uint32_t REG_6F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6F4H_b;
    };
    union
    {
        __IOM uint32_t REG_6F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6F8H_b;
    };
    union
    {
        __IOM uint32_t REG_6FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_6FCH_b;
    };
    union
    {
        __IOM uint32_t REG_700H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_700H_b;
    };
    union
    {
        __IOM uint32_t REG_704H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_704H_b;
    };
    union
    {
        __IOM uint32_t REG_708H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_708H_b;
    };
    union
    {
        __IOM uint32_t REG_70CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_70CH_b;
    };
    union
    {
        __IOM uint32_t REG_710H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_710H_b;
    };
    union
    {
        __IOM uint32_t REG_714H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_714H_b;
    };
    union
    {
        __IOM uint32_t REG_718H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_718H_b;
    };
    union
    {
        __IOM uint32_t REG_71CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_71CH_b;
    };
    union
    {
        __IOM uint32_t REG_720H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_720H_b;
    };
    union
    {
        __IOM uint32_t REG_724H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_724H_b;
    };
    union
    {
        __IOM uint32_t REG_728H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_728H_b;
    };
    union
    {
        __IOM uint32_t REG_72CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_72CH_b;
    };
    union
    {
        __IOM uint32_t REG_730H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_730H_b;
    };
    union
    {
        __IOM uint32_t REG_734H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_734H_b;
    };
    union
    {
        __IOM uint32_t REG_738H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_738H_b;
    };
    union
    {
        __IOM uint32_t REG_73CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_73CH_b;
    };
    union
    {
        __IOM uint32_t REG_740H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_740H_b;
    };
    union
    {
        __IOM uint32_t REG_744H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_744H_b;
    };
    union
    {
        __IOM uint32_t REG_748H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_748H_b;
    };
    union
    {
        __IOM uint32_t REG_74CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_74CH_b;
    };
    union
    {
        __IOM uint32_t REG_750H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_750H_b;
    };
    union
    {
        __IOM uint32_t REG_754H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_754H_b;
    };
    union
    {
        __IOM uint32_t REG_758H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_758H_b;
    };
    union
    {
        __IOM uint32_t REG_75CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_75CH_b;
    };
    union
    {
        __IOM uint32_t REG_760H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_760H_b;
    };
    union
    {
        __IOM uint32_t REG_764H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_764H_b;
    };
    union
    {
        __IOM uint32_t REG_768H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_768H_b;
    };
    union
    {
        __IOM uint32_t REG_76CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_76CH_b;
    };
    union
    {
        __IOM uint32_t REG_770H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_770H_b;
    };
    union
    {
        __IOM uint32_t REG_774H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_774H_b;
    };
    union
    {
        __IOM uint32_t REG_778H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_778H_b;
    };
    union
    {
        __IOM uint32_t REG_77CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_77CH_b;
    };
    union
    {
        __IOM uint32_t REG_780H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_780H_b;
    };
    union
    {
        __IOM uint32_t REG_784H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_784H_b;
    };
    union
    {
        __IOM uint32_t REG_788H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_788H_b;
    };
    union
    {
        __IOM uint32_t REG_78CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_78CH_b;
    };
    union
    {
        __IOM uint32_t REG_790H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_790H_b;
    };
    union
    {
        __IOM uint32_t REG_794H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_794H_b;
    };
    union
    {
        __IOM uint32_t REG_798H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_798H_b;
    };
    union
    {
        __IOM uint32_t REG_79CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_79CH_b;
    };
    union
    {
        __IOM uint32_t REG_7A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7A0H_b;
    };
    union
    {
        __IOM uint32_t REG_7A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7A4H_b;
    };
    union
    {
        __IOM uint32_t REG_7A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7A8H_b;
    };
    union
    {
        __IOM uint32_t REG_7ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7ACH_b;
    };
    union
    {
        __IOM uint32_t REG_7B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7B0H_b;
    };
    union
    {
        __IOM uint32_t REG_7B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7B4H_b;
    };
    union
    {
        __IOM uint32_t REG_7B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7B8H_b;
    };
    union
    {
        __IOM uint32_t REG_7BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7BCH_b;
    };
    union
    {
        __IOM uint32_t REG_7C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7C0H_b;
    };
    union
    {
        __IOM uint32_t REG_7C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7C4H_b;
    };
    union
    {
        __IOM uint32_t REG_7C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7C8H_b;
    };
    union
    {
        __IOM uint32_t REG_7CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7CCH_b;
    };
    union
    {
        __IOM uint32_t REG_7D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7D0H_b;
    };
    union
    {
        __IOM uint32_t REG_7D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7D4H_b;
    };
    union
    {
        __IOM uint32_t REG_7D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7D8H_b;
    };
    union
    {
        __IOM uint32_t REG_7DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7DCH_b;
    };
    union
    {
        __IOM uint32_t REG_7E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7E0H_b;
    };
    union
    {
        __IOM uint32_t REG_7E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7E4H_b;
    };
    union
    {
        __IOM uint32_t REG_7E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7E8H_b;
    };
    union
    {
        __IOM uint32_t REG_7ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7ECH_b;
    };
    union
    {
        __IOM uint32_t REG_7F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7F0H_b;
    };
    union
    {
        __IOM uint32_t REG_7F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7F4H_b;
    };
    union
    {
        __IOM uint32_t REG_7F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7F8H_b;
    };
    union
    {
        __IOM uint32_t REG_7FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_7FCH_b;
    };
    union
    {
        __IOM uint32_t REG_800H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_800H_b;
    };
    union
    {
        __IOM uint32_t REG_804H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_804H_b;
    };
    union
    {
        __IOM uint32_t REG_808H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_808H_b;
    };
    union
    {
        __IOM uint32_t REG_80CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_80CH_b;
    };
    union
    {
        __IOM uint32_t REG_810H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_810H_b;
    };
    union
    {
        __IOM uint32_t REG_814H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_814H_b;
    };
    union
    {
        __IOM uint32_t REG_818H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_818H_b;
    };
    union
    {
        __IOM uint32_t REG_81CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_81CH_b;
    };
    union
    {
        __IOM uint32_t REG_820H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_820H_b;
    };
    union
    {
        __IOM uint32_t REG_824H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_824H_b;
    };
    union
    {
        __IOM uint32_t REG_828H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_828H_b;
    };
    union
    {
        __IOM uint32_t REG_82CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_82CH_b;
    };
    union
    {
        __IOM uint32_t REG_830H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_830H_b;
    };
    union
    {
        __IOM uint32_t REG_834H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_834H_b;
    };
    union
    {
        __IOM uint32_t REG_838H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_838H_b;
    };
    union
    {
        __IOM uint32_t REG_83CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_83CH_b;
    };
    union
    {
        __IOM uint32_t REG_840H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_840H_b;
    };
    union
    {
        __IOM uint32_t REG_844H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_844H_b;
    };
    union
    {
        __IOM uint32_t REG_848H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_848H_b;
    };
    union
    {
        __IOM uint32_t REG_84CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_84CH_b;
    };
    union
    {
        __IOM uint32_t REG_850H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_850H_b;
    };
    union
    {
        __IOM uint32_t REG_854H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_854H_b;
    };
    union
    {
        __IOM uint32_t REG_858H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_858H_b;
    };
    union
    {
        __IOM uint32_t REG_85CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_85CH_b;
    };
    union
    {
        __IOM uint32_t REG_860H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_860H_b;
    };
    union
    {
        __IOM uint32_t REG_864H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_864H_b;
    };
    union
    {
        __IOM uint32_t REG_868H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_868H_b;
    };
    union
    {
        __IOM uint32_t REG_86CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_86CH_b;
    };
    union
    {
        __IOM uint32_t REG_870H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_870H_b;
    };
    union
    {
        __IOM uint32_t REG_874H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_874H_b;
    };
    union
    {
        __IOM uint32_t REG_878H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_878H_b;
    };
    union
    {
        __IOM uint32_t REG_87CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_87CH_b;
    };
    union
    {
        __IOM uint32_t REG_880H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_880H_b;
    };
    union
    {
        __IOM uint32_t REG_884H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_884H_b;
    };
    union
    {
        __IOM uint32_t REG_888H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_888H_b;
    };
    union
    {
        __IOM uint32_t REG_88CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_88CH_b;
    };
    union
    {
        __IOM uint32_t REG_890H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_890H_b;
    };
    union
    {
        __IOM uint32_t REG_894H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_894H_b;
    };
    union
    {
        __IOM uint32_t REG_898H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_898H_b;
    };
    union
    {
        __IOM uint32_t REG_89CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_89CH_b;
    };
    union
    {
        __IOM uint32_t REG_8A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8A0H_b;
    };
    union
    {
        __IOM uint32_t REG_8A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8A4H_b;
    };
    union
    {
        __IOM uint32_t REG_8A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8A8H_b;
    };
    union
    {
        __IOM uint32_t REG_8ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8ACH_b;
    };
    union
    {
        __IOM uint32_t REG_8B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8B0H_b;
    };
    union
    {
        __IOM uint32_t REG_8B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8B4H_b;
    };
    union
    {
        __IOM uint32_t REG_8B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8B8H_b;
    };
    union
    {
        __IOM uint32_t REG_8BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8BCH_b;
    };
    union
    {
        __IOM uint32_t REG_8C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8C0H_b;
    };
    union
    {
        __IOM uint32_t REG_8C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8C4H_b;
    };
    union
    {
        __IOM uint32_t REG_8C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8C8H_b;
    };
    union
    {
        __IOM uint32_t REG_8CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8CCH_b;
    };
    union
    {
        __IOM uint32_t REG_8D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8D0H_b;
    };
    union
    {
        __IOM uint32_t REG_8D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8D4H_b;
    };
    union
    {
        __IOM uint32_t REG_8D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8D8H_b;
    };
    union
    {
        __IOM uint32_t REG_8DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8DCH_b;
    };
    union
    {
        __IOM uint32_t REG_8E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8E0H_b;
    };
    union
    {
        __IOM uint32_t REG_8E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8E4H_b;
    };
    union
    {
        __IOM uint32_t REG_8E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8E8H_b;
    };
    union
    {
        __IOM uint32_t REG_8ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8ECH_b;
    };
    union
    {
        __IOM uint32_t REG_8F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8F0H_b;
    };
    union
    {
        __IOM uint32_t REG_8F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8F4H_b;
    };
    union
    {
        __IOM uint32_t REG_8F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8F8H_b;
    };
    union
    {
        __IOM uint32_t REG_8FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_8FCH_b;
    };
    union
    {
        __IOM uint32_t REG_900H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_900H_b;
    };
    union
    {
        __IOM uint32_t REG_904H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_904H_b;
    };
    union
    {
        __IOM uint32_t REG_908H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_908H_b;
    };
    union
    {
        __IOM uint32_t REG_90CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_90CH_b;
    };
    union
    {
        __IOM uint32_t REG_910H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_910H_b;
    };
    union
    {
        __IOM uint32_t REG_914H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_914H_b;
    };
    union
    {
        __IOM uint32_t REG_918H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_918H_b;
    };
    union
    {
        __IOM uint32_t REG_91CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_91CH_b;
    };
    union
    {
        __IOM uint32_t REG_920H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_920H_b;
    };
    union
    {
        __IOM uint32_t REG_924H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_924H_b;
    };
    union
    {
        __IOM uint32_t REG_928H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_928H_b;
    };
    union
    {
        __IOM uint32_t REG_92CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_92CH_b;
    };
    union
    {
        __IOM uint32_t REG_930H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_930H_b;
    };
    union
    {
        __IOM uint32_t REG_934H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_934H_b;
    };
    union
    {
        __IOM uint32_t REG_938H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_938H_b;
    };
    union
    {
        __IOM uint32_t REG_93CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_93CH_b;
    };
    union
    {
        __IOM uint32_t REG_940H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_940H_b;
    };
    union
    {
        __IOM uint32_t REG_944H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_944H_b;
    };
    union
    {
        __IOM uint32_t REG_948H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_948H_b;
    };
    union
    {
        __IOM uint32_t REG_94CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_94CH_b;
    };
    union
    {
        __IOM uint32_t REG_950H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_950H_b;
    };
    union
    {
        __IOM uint32_t REG_954H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_954H_b;
    };
    union
    {
        __IOM uint32_t REG_958H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_958H_b;
    };
    union
    {
        __IOM uint32_t REG_95CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_95CH_b;
    };
    union
    {
        __IOM uint32_t REG_960H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_960H_b;
    };
    union
    {
        __IOM uint32_t REG_964H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_964H_b;
    };
    union
    {
        __IOM uint32_t REG_968H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_968H_b;
    };
    union
    {
        __IOM uint32_t REG_96CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_96CH_b;
    };
    union
    {
        __IOM uint32_t REG_970H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_970H_b;
    };
    union
    {
        __IOM uint32_t REG_974H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_974H_b;
    };
    union
    {
        __IOM uint32_t REG_978H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_978H_b;
    };
    union
    {
        __IOM uint32_t REG_97CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_97CH_b;
    };
    union
    {
        __IOM uint32_t REG_980H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_980H_b;
    };
    union
    {
        __IOM uint32_t REG_984H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_984H_b;
    };
    union
    {
        __IOM uint32_t REG_988H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_988H_b;
    };
    union
    {
        __IOM uint32_t REG_98CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_98CH_b;
    };
    union
    {
        __IOM uint32_t REG_990H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_990H_b;
    };
    union
    {
        __IOM uint32_t REG_994H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_994H_b;
    };
    union
    {
        __IOM uint32_t REG_998H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_998H_b;
    };
    union
    {
        __IOM uint32_t REG_99CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_99CH_b;
    };
    union
    {
        __IOM uint32_t REG_9A0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9A0H_b;
    };
    union
    {
        __IOM uint32_t REG_9A4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9A4H_b;
    };
    union
    {
        __IOM uint32_t REG_9A8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9A8H_b;
    };
    union
    {
        __IOM uint32_t REG_9ACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9ACH_b;
    };
    union
    {
        __IOM uint32_t REG_9B0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9B0H_b;
    };
    union
    {
        __IOM uint32_t REG_9B4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9B4H_b;
    };
    union
    {
        __IOM uint32_t REG_9B8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9B8H_b;
    };
    union
    {
        __IOM uint32_t REG_9BCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9BCH_b;
    };
    union
    {
        __IOM uint32_t REG_9C0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9C0H_b;
    };
    union
    {
        __IOM uint32_t REG_9C4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9C4H_b;
    };
    union
    {
        __IOM uint32_t REG_9C8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9C8H_b;
    };
    union
    {
        __IOM uint32_t REG_9CCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9CCH_b;
    };
    union
    {
        __IOM uint32_t REG_9D0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9D0H_b;
    };
    union
    {
        __IOM uint32_t REG_9D4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9D4H_b;
    };
    union
    {
        __IOM uint32_t REG_9D8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9D8H_b;
    };
    union
    {
        __IOM uint32_t REG_9DCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9DCH_b;
    };
    union
    {
        __IOM uint32_t REG_9E0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9E0H_b;
    };
    union
    {
        __IOM uint32_t REG_9E4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9E4H_b;
    };
    union
    {
        __IOM uint32_t REG_9E8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9E8H_b;
    };
    union
    {
        __IOM uint32_t REG_9ECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9ECH_b;
    };
    union
    {
        __IOM uint32_t REG_9F0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9F0H_b;
    };
    union
    {
        __IOM uint32_t REG_9F4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9F4H_b;
    };
    union
    {
        __IOM uint32_t REG_9F8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9F8H_b;
    };
    union
    {
        __IOM uint32_t REG_9FCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_9FCH_b;
    };
    union
    {
        __IOM uint32_t REG_A00H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A00H_b;
    };
    union
    {
        __IOM uint32_t REG_A04H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A04H_b;
    };
    union
    {
        __IOM uint32_t REG_A08H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A08H_b;
    };
    union
    {
        __IOM uint32_t REG_A0CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A0CH_b;
    };
    union
    {
        __IOM uint32_t REG_A10H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A10H_b;
    };
    union
    {
        __IOM uint32_t REG_A14H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A14H_b;
    };
    union
    {
        __IOM uint32_t REG_A18H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A18H_b;
    };
    union
    {
        __IOM uint32_t REG_A1CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A1CH_b;
    };
    union
    {
        __IOM uint32_t REG_A20H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A20H_b;
    };
    union
    {
        __IOM uint32_t REG_A24H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A24H_b;
    };
    union
    {
        __IOM uint32_t REG_A28H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A28H_b;
    };
    union
    {
        __IOM uint32_t REG_A2CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A2CH_b;
    };
    union
    {
        __IOM uint32_t REG_A30H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A30H_b;
    };
    union
    {
        __IOM uint32_t REG_A34H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A34H_b;
    };
    union
    {
        __IOM uint32_t REG_A38H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A38H_b;
    };
    union
    {
        __IOM uint32_t REG_A3CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A3CH_b;
    };
    union
    {
        __IOM uint32_t REG_A40H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A40H_b;
    };
    union
    {
        __IOM uint32_t REG_A44H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A44H_b;
    };
    union
    {
        __IOM uint32_t REG_A48H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A48H_b;
    };
    union
    {
        __IOM uint32_t REG_A4CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A4CH_b;
    };
    union
    {
        __IOM uint32_t REG_A50H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A50H_b;
    };
    union
    {
        __IOM uint32_t REG_A54H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A54H_b;
    };
    union
    {
        __IOM uint32_t REG_A58H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A58H_b;
    };
    union
    {
        __IOM uint32_t REG_A5CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A5CH_b;
    };
    union
    {
        __IOM uint32_t REG_A60H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A60H_b;
    };
    union
    {
        __IOM uint32_t REG_A64H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A64H_b;
    };
    union
    {
        __IOM uint32_t REG_A68H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A68H_b;
    };
    union
    {
        __IOM uint32_t REG_A6CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A6CH_b;
    };
    union
    {
        __IOM uint32_t REG_A70H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A70H_b;
    };
    union
    {
        __IOM uint32_t REG_A74H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A74H_b;
    };
    union
    {
        __IOM uint32_t REG_A78H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A78H_b;
    };
    union
    {
        __IOM uint32_t REG_A7CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A7CH_b;
    };
    union
    {
        __IOM uint32_t REG_A80H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A80H_b;
    };
    union
    {
        __IOM uint32_t REG_A84H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A84H_b;
    };
    union
    {
        __IOM uint32_t REG_A88H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A88H_b;
    };
    union
    {
        __IOM uint32_t REG_A8CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A8CH_b;
    };
    union
    {
        __IOM uint32_t REG_A90H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A90H_b;
    };
    union
    {
        __IOM uint32_t REG_A94H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A94H_b;
    };
    union
    {
        __IOM uint32_t REG_A98H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A98H_b;
    };
    union
    {
        __IOM uint32_t REG_A9CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_A9CH_b;
    };
    union
    {
        __IOM uint32_t REG_AA0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AA0H_b;
    };
    union
    {
        __IOM uint32_t REG_AA4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AA4H_b;
    };
    union
    {
        __IOM uint32_t REG_AA8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AA8H_b;
    };
    union
    {
        __IOM uint32_t REG_AACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AACH_b;
    };
    union
    {
        __IOM uint32_t REG_AB0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AB0H_b;
    };
    union
    {
        __IOM uint32_t REG_AB4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AB4H_b;
    };
    union
    {
        __IOM uint32_t REG_AB8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AB8H_b;
    };
    union
    {
        __IOM uint32_t REG_ABCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_ABCH_b;
    };
    union
    {
        __IOM uint32_t REG_AC0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AC0H_b;
    };
    union
    {
        __IOM uint32_t REG_AC4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AC4H_b;
    };
    union
    {
        __IOM uint32_t REG_AC8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AC8H_b;
    };
    union
    {
        __IOM uint32_t REG_ACCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_ACCH_b;
    };
    union
    {
        __IOM uint32_t REG_AD0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AD0H_b;
    };
    union
    {
        __IOM uint32_t REG_AD4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AD4H_b;
    };
    union
    {
        __IOM uint32_t REG_AD8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AD8H_b;
    };
    union
    {
        __IOM uint32_t REG_ADCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_ADCH_b;
    };
    union
    {
        __IOM uint32_t REG_AE0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AE0H_b;
    };
    union
    {
        __IOM uint32_t REG_AE4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AE4H_b;
    };
    union
    {
        __IOM uint32_t REG_AE8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AE8H_b;
    };
    union
    {
        __IOM uint32_t REG_AECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AECH_b;
    };
    union
    {
        __IOM uint32_t REG_AF0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AF0H_b;
    };
    union
    {
        __IOM uint32_t REG_AF4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AF4H_b;
    };
    union
    {
        __IOM uint32_t REG_AF8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AF8H_b;
    };
    union
    {
        __IOM uint32_t REG_AFCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_AFCH_b;
    };
    union
    {
        __IOM uint32_t REG_B00H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B00H_b;
    };
    union
    {
        __IOM uint32_t REG_B04H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B04H_b;
    };
    union
    {
        __IOM uint32_t REG_B08H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B08H_b;
    };
    union
    {
        __IOM uint32_t REG_B0CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B0CH_b;
    };
    union
    {
        __IOM uint32_t REG_B10H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B10H_b;
    };
    union
    {
        __IOM uint32_t REG_B14H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B14H_b;
    };
    union
    {
        __IOM uint32_t REG_B18H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B18H_b;
    };
    union
    {
        __IOM uint32_t REG_B1CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B1CH_b;
    };
    union
    {
        __IOM uint32_t REG_B20H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B20H_b;
    };
    union
    {
        __IOM uint32_t REG_B24H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B24H_b;
    };
    union
    {
        __IOM uint32_t REG_B28H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B28H_b;
    };
    union
    {
        __IOM uint32_t REG_B2CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B2CH_b;
    };
    union
    {
        __IOM uint32_t REG_B30H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B30H_b;
    };
    union
    {
        __IOM uint32_t REG_B34H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B34H_b;
    };
    union
    {
        __IOM uint32_t REG_B38H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B38H_b;
    };
    union
    {
        __IOM uint32_t REG_B3CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B3CH_b;
    };
    union
    {
        __IOM uint32_t REG_B40H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B40H_b;
    };
    union
    {
        __IOM uint32_t REG_B44H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B44H_b;
    };
    union
    {
        __IOM uint32_t REG_B48H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B48H_b;
    };
    union
    {
        __IOM uint32_t REG_B4CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B4CH_b;
    };
    union
    {
        __IOM uint32_t REG_B50H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B50H_b;
    };
    union
    {
        __IOM uint32_t REG_B54H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B54H_b;
    };
    union
    {
        __IOM uint32_t REG_B58H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B58H_b;
    };
    union
    {
        __IOM uint32_t REG_B5CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B5CH_b;
    };
    union
    {
        __IOM uint32_t REG_B60H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B60H_b;
    };
    union
    {
        __IOM uint32_t REG_B64H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B64H_b;
    };
    union
    {
        __IOM uint32_t REG_B68H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B68H_b;
    };
    union
    {
        __IOM uint32_t REG_B6CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B6CH_b;
    };
    union
    {
        __IOM uint32_t REG_B70H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B70H_b;
    };
    union
    {
        __IOM uint32_t REG_B74H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B74H_b;
    };
    union
    {
        __IOM uint32_t REG_B78H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B78H_b;
    };
    union
    {
        __IOM uint32_t REG_B7CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B7CH_b;
    };
    union
    {
        __IOM uint32_t REG_B80H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B80H_b;
    };
    union
    {
        __IOM uint32_t REG_B84H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B84H_b;
    };
    union
    {
        __IOM uint32_t REG_B88H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B88H_b;
    };
    union
    {
        __IOM uint32_t REG_B8CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B8CH_b;
    };
    union
    {
        __IOM uint32_t REG_B90H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B90H_b;
    };
    union
    {
        __IOM uint32_t REG_B94H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B94H_b;
    };
    union
    {
        __IOM uint32_t REG_B98H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B98H_b;
    };
    union
    {
        __IOM uint32_t REG_B9CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_B9CH_b;
    };
    union
    {
        __IOM uint32_t REG_BA0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BA0H_b;
    };
    union
    {
        __IOM uint32_t REG_BA4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BA4H_b;
    };
    union
    {
        __IOM uint32_t REG_BA8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BA8H_b;
    };
    union
    {
        __IOM uint32_t REG_BACH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BACH_b;
    };
    union
    {
        __IOM uint32_t REG_BB0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BB0H_b;
    };
    union
    {
        __IOM uint32_t REG_BB4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BB4H_b;
    };
    union
    {
        __IOM uint32_t REG_BB8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BB8H_b;
    };
    union
    {
        __IOM uint32_t REG_BBCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BBCH_b;
    };
    union
    {
        __IOM uint32_t REG_BC0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BC0H_b;
    };
    union
    {
        __IOM uint32_t REG_BC4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BC4H_b;
    };
    union
    {
        __IOM uint32_t REG_BC8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BC8H_b;
    };
    union
    {
        __IOM uint32_t REG_BCCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BCCH_b;
    };
    union
    {
        __IOM uint32_t REG_BD0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BD0H_b;
    };
    union
    {
        __IOM uint32_t REG_BD4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BD4H_b;
    };
    union
    {
        __IOM uint32_t REG_BD8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BD8H_b;
    };
    union
    {
        __IOM uint32_t REG_BDCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BDCH_b;
    };
    union
    {
        __IOM uint32_t REG_BE0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BE0H_b;
    };
    union
    {
        __IOM uint32_t REG_BE4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BE4H_b;
    };
    union
    {
        __IOM uint32_t REG_BE8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BE8H_b;
    };
    union
    {
        __IOM uint32_t REG_BECH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BECH_b;
    };
    union
    {
        __IOM uint32_t REG_BF0H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BF0H_b;
    };
    union
    {
        __IOM uint32_t REG_BF4H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BF4H_b;
    };
    union
    {
        __IOM uint32_t REG_BF8H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BF8H_b;
    };
    union
    {
        __IOM uint32_t REG_BFCH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_BFCH_b;
    };
    union
    {
        __IOM uint32_t REG_C00H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C00H_b;
    };
    union
    {
        __IOM uint32_t REG_C04H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C04H_b;
    };
    union
    {
        __IOM uint32_t REG_C08H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C08H_b;
    };
    union
    {
        __IOM uint32_t REG_C0CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C0CH_b;
    };
    union
    {
        __IOM uint32_t REG_C10H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C10H_b;
    };
    union
    {
        __IOM uint32_t REG_C14H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C14H_b;
    };
    union
    {
        __IOM uint32_t REG_C18H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C18H_b;
    };
    union
    {
        __IOM uint32_t REG_C1CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C1CH_b;
    };
    union
    {
        __IOM uint32_t REG_C20H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C20H_b;
    };
    union
    {
        __IOM uint32_t REG_C24H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C24H_b;
    };
    union
    {
        __IOM uint32_t REG_C28H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C28H_b;
    };
    union
    {
        __IOM uint32_t REG_C2CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C2CH_b;
    };
    union
    {
        __IOM uint32_t REG_C30H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C30H_b;
    };
    union
    {
        __IOM uint32_t REG_C34H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C34H_b;
    };
    union
    {
        __IOM uint32_t REG_C38H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C38H_b;
    };
    union
    {
        __IOM uint32_t REG_C3CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C3CH_b;
    };
    union
    {
        __IOM uint32_t REG_C40H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C40H_b;
    };
    union
    {
        __IOM uint32_t REG_C44H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C44H_b;
    };
    union
    {
        __IOM uint32_t REG_C48H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C48H_b;
    };
    union
    {
        __IOM uint32_t REG_C4CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C4CH_b;
    };
    union
    {
        __IOM uint32_t REG_C50H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C50H_b;
    };
    union
    {
        __IOM uint32_t REG_C54H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C54H_b;
    };
    union
    {
        __IOM uint32_t REG_C58H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C58H_b;
    };
    union
    {
        __IOM uint32_t REG_C5CH;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C5CH_b;
    };
    union
    {
        __IOM uint32_t REG_C60H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C60H_b;
    };
    union
    {
        __IOM uint32_t REG_C64H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
            __IOM uint32_t B29 : 1;
            __IOM uint32_t B30 : 1;
            __IOM uint32_t B31 : 1;
        } REG_C64H_b;
    };
    union
    {
        __IOM uint32_t REG_C68H;
        struct
        {
            __IOM uint32_t B0  : 1;
            __IOM uint32_t B1  : 1;
            __IOM uint32_t B2  : 1;
            __IOM uint32_t B3  : 1;
            __IOM uint32_t B4  : 1;
            __IOM uint32_t B5  : 1;
            __IOM uint32_t B6  : 1;
            __IOM uint32_t B7  : 1;
            __IOM uint32_t B8  : 1;
            __IOM uint32_t B9  : 1;
            __IOM uint32_t B10 : 1;
            __IOM uint32_t B11 : 1;
            __IOM uint32_t B12 : 1;
            __IOM uint32_t B13 : 1;
            __IOM uint32_t B14 : 1;
            __IOM uint32_t B15 : 1;
            __IOM uint32_t B16 : 1;
            __IOM uint32_t B17 : 1;
            __IOM uint32_t B18 : 1;
            __IOM uint32_t B19 : 1;
            __IOM uint32_t B20 : 1;
            __IOM uint32_t B21 : 1;
            __IOM uint32_t B22 : 1;
            __IOM uint32_t B23 : 1;
            __IOM uint32_t B24 : 1;
            __IOM uint32_t B25 : 1;
            __IOM uint32_t B26 : 1;
            __IOM uint32_t B27 : 1;
            __IOM uint32_t B28 : 1;
    