(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.

Axiom t : Type.
Parameter t_WhyType : WhyType t.
Existing Instance t_WhyType.

Axiom structure : Type.
Parameter structure_WhyType : WhyType structure.
Existing Instance structure_WhyType.

Parameter infix_breq: structure -> t -> Prop.

Parameter ffalse: t.

Parameter ttrue: t.

Parameter neg: t -> t.

Parameter and: t -> t -> t.

Parameter or: t -> t -> t.

Axiom extensionality : forall (f1:t) (f2:t), (forall (m:structure),
  (infix_breq m f1) <-> (infix_breq m f2)) -> (f1 = f2).

Axiom structure_exists : exists m:structure, exists f:t, (infix_breq m f).

Axiom true_false : ~ (ttrue = ffalse).

Axiom model_true : forall (m:structure), (infix_breq m ttrue).

Axiom model_false : forall (m:structure), ~ (infix_breq m ffalse).

Axiom model_neg : forall (m:structure), forall (f:t), (infix_breq m
  (neg f)) <-> ~ (infix_breq m f).

Axiom model_and : forall (m:structure), forall (f1:t) (f2:t), (infix_breq m
  (and f1 f2)) <-> ((infix_breq m f1) /\ (infix_breq m f2)).

Axiom model_or : forall (m:structure), forall (f1:t) (f2:t), (infix_breq m
  (or f1 f2)) <-> ((infix_breq m f1) \/ (infix_breq m f2)).

(* Why3 assumption *)
Definition sat (f:t): Prop := exists m:structure, (infix_breq m f).

(* Why3 assumption *)
Definition valid (f:t): Prop := ~ (sat (neg f)).

Axiom valid_def : forall (f:t), (valid f) <-> forall (m:structure),
  (infix_breq m f).

Axiom negneg : forall (f:t), ((neg (neg f)) = f).

Axiom and_a : forall (f1:t) (f2:t) (f3:t), ((and (and f1 f2) f3) = (and f1
  (and f2 f3))).

Axiom and_c : forall (f1:t) (f2:t), ((and f1 f2) = (and f2 f1)).

Axiom or_a : forall (f1:t) (f2:t) (f3:t), ((or (or f1 f2) f3) = (or f1 (or f2
  f3))).

Axiom or_c : forall (f1:t) (f2:t), ((or f1 f2) = (or f2 f1)).

Axiom distr_and : forall (f1:t) (f2:t) (f3:t), ((and f1 (or f2
  f3)) = (or (and f1 f2) (and f1 f3))).

Axiom distr_or : forall (f1:t) (f2:t) (f3:t), ((or f1 (and f2
  f3)) = (and (or f1 f2) (or f1 f3))).

Axiom neutral_and : forall (f:t), ((and f ttrue) = f).

Axiom neutral_or : forall (f:t), ((or f ffalse) = f).

Axiom absorb_and : forall (f:t), ((and f ffalse) = ffalse).

Axiom absorb_or : forall (f:t), ((or f ttrue) = ttrue).

Axiom sat_def : forall (f:t), (sat f) <-> ~ (valid (neg f)).

Axiom unsat_invalid : forall (f:t), (~ (valid f)) -> (sat (neg f)).

Axiom valid_sat : forall (f:t), (valid f) -> (sat f).

Axiom ttrue_valid : (valid ttrue).

Axiom ffaslse_invalid : ~ (valid ffalse).

Axiom ttrue_sat : (sat ttrue).

Axiom ffalse_unsat : ~ (sat ffalse).

Axiom sat_neg : forall (f:t), (~ (sat f)) -> (sat (neg f)).

Axiom valid_neg : forall (f:t), (valid (neg f)) -> ~ (valid f).

Axiom sat_or : forall (f1:t) (f2:t), (sat (or f1 f2)) <-> ((sat f1) \/ (sat
  f2)).

Axiom valid_and : forall (f1:t) (f2:t), (valid (and f1 f2)) <-> ((valid
  f1) /\ (valid f2)).

Axiom valid_or : forall (f1:t) (f2:t), ((valid f1) \/ (valid f2)) -> (valid
  (or f1 f2)).

Axiom sat_and : forall (f1:t) (f2:t), (sat (and f1 f2)) -> ((sat f1) /\ (sat
  f2)).

Axiom forget_subsumed : forall (f:t) (v:t), (valid (or (neg f) v)) -> ((or f
  v) = v).

Axiom classic_neg : forall (f:t), ((or (neg f) f) = ttrue).

Parameter pre: t -> t.

Axiom pre_false : ((pre ffalse) = ffalse).

Parameter pre_star: t -> t.

Axiom pre_star_def1 : forall (f:t), (valid (or (neg f) (pre_star f))).

Axiom pre_star_def2 : forall (f:t), ((pre (pre_star f)) = (pre_star f)).

Axiom pre_star_def3 : forall (f:t), ((pre_star (pre_star f)) = (pre_star f)).

Axiom pre_star_def4 : forall (f:t), ((or (pre_star (pre f))
  f) = (pre_star f)).

Axiom pre_and : forall (f1:t) (f2:t), ((pre (and f1 f2)) = (and (pre f1)
  (pre f2))).

Axiom pre_or : forall (f1:t) (f2:t), ((pre (or f1 f2)) = (or (pre f1)
  (pre f2))).

Axiom pre_star_false : ((pre_star ffalse) = ffalse).

Axiom pre_star_and : forall (f1:t) (f2:t), ((pre_star (and f1
  f2)) = (and (pre_star f1) (pre_star f2))).

Axiom pre_star_or : forall (f1:t) (f2:t), ((pre_star (or f1
  f2)) = (or (pre_star f1) (pre_star f2))).

(* Why3 assumption *)
Definition reachable (init:t) (f:t): Prop := (sat (and (pre_star f) init)).

Axiom directly_reachable : forall (init:t) (f:t), (sat (and init f)) ->
  (reachable init f).

Axiom false_unreachable : forall (init:t), ~ (reachable init ffalse).

(* Why3 goal *)
Theorem reachable_or : forall (f1:t) (f2:t) (init:t), (reachable init (or f1
  f2)) -> ((reachable init f1) \/ (reachable init f2)).
(* Why3 intros f1 f2 init h1. *)
intros f1 f2 init h1.

unfold reachable in h1.
unfold reachable.
destruct h1.
apply model_and in H.
destruct H.
rewrite pre_star_or in H.
apply model_or in H. destruct H.
left. unfold sat.
exists x. apply model_and. auto.

right. unfold sat.
exists x. apply model_and. auto.

Qed.

