(**************************************************************************)
(*                                                                        *)
(*                              Cubicle                                   *)
(*                                                                        *)
(*                       Copyright (C) 2011-2014                          *)
(*                                                                        *)
(*                  Sylvain Conchon and Alain Mebsout                     *)
(*                       Universite Paris-Sud 11                          *)
(*                                                                        *)
(*                                                                        *)
(*  This file is distributed under the terms of the Apache Software       *)
(*  License version 2.0                                                   *)
(*                                                                        *)
(**************************************************************************)

module type S = sig
  val start : unit -> unit
  val pause : unit -> unit
  val get : unit -> float    
end

module Make (X : sig val profiling : bool end) = struct

  open Unix
    
  let u = ref 0.0

  let cpt = ref 0.0
    
  let start = 
    if not (X.profiling) then fun () -> ()
    else fun () -> u:=(times()).tms_utime

  let pause =
    if not (X.profiling) then fun () -> ()
    else fun () -> cpt := !cpt +. ((times()).tms_utime -. !u)

  let get () = 
    !cpt

end
