"use strict";(self.webpackChunkinfluxdb_ui=self.webpackChunkinfluxdb_ui||[]).push([[18],{30168:(n,e,t)=>{t.d(e,{G:()=>h,E:()=>b});const i=t.p+"32ce7f466b..svg";const r=t.p+"77d49e31be..svg";const o=t.p+"ceba84d297..svg";const a=t.p+"7af85ea3c3..svg";const l=t.p+"2df90d0fd4..svg";const s=t.p+"e1f1538f14..svg";const c=t.p+"50b203f76e..svg";const u=t.p+"007cb7f359..svg";const d=t.p+"f1d484cd66..svg";const m=t.p+"a447648c99..svg";const p=t.p+"bc0675cc4d..svg";const g=t.p+"6dff9c59d6..svg";const f=t.p+"75f20f67a7..svg";const h={arduino:new class{constructor(){this.id="arduino",this.name="Arduino",this.description="For more detailed and up to date information check out the [GitHub Repository](https://github.com/tobiasschuerg/InfluxDB-Client-for-Arduino)\n\n##### Install Library\n\nLibrary Manager\n\n```\n1. Open the Arduino IDE and click to the \"Sketch\" menu and then Include Library > Manage Libraries.\n2. Type 'influxdb' in the search box\n3. Install the 'InfluxDBClient for Arduino' library\n```\n\nManual Installation\n\n```\n1. cd <arduino-sketch-location>/library.\n2. git clone https://github.com/tobiasschuerg/InfluxDB-Client-for-Arduino\n3. Restart the Arduino IDE\n```\n",this.logo=i,this.initialize='#if defined(ESP32)\n#include <WiFiMulti.h>\nWiFiMulti wifiMulti;\n#define DEVICE "ESP32"\n#elif defined(ESP8266)\n#include <ESP8266WiFiMulti.h>\nESP8266WiFiMulti wifiMulti;\n#define DEVICE "ESP8266"\n#endif\n\n#include <InfluxDbClient.h>\n#include <InfluxDbCloud.h>\n\n// WiFi AP SSID\n#define WIFI_SSID "SSID"\n// WiFi password\n#define WIFI_PASSWORD "PASSWORD"\n// InfluxDB v2 server url, e.g. https://eu-central-1-1.aws.cloud2.influxdata.com (Use: InfluxDB UI -> Load Data -> Client Libraries)\n#define INFLUXDB_URL "<%= server %>"\n// InfluxDB v2 server or cloud API token (Use: InfluxDB UI -> Data -> API Tokens -> Generate API Token)\n#define INFLUXDB_TOKEN "<INFLUX_TOKEN>"\n// InfluxDB v2 organization id (Use: InfluxDB UI -> User -> About -> Common Ids )\n#define INFLUXDB_ORG "<%= org %>"\n// InfluxDB v2 bucket name (Use: InfluxDB UI ->  Data -> Buckets)\n#define INFLUXDB_BUCKET "<%= bucket %>"\n\n// Set timezone string according to https://www.gnu.org/software/libc/manual/html_node/TZ-Variable.html\n// Examples:\n//  Pacific Time: "PST8PDT"\n//  Eastern: "EST5EDT"\n//  Japanesse: "JST-9"\n//  Central Europe: "CET-1CEST,M3.5.0,M10.5.0/3"\n#define TZ_INFO "CET-1CEST,M3.5.0,M10.5.0/3"\n\n// InfluxDB client instance with preconfigured InfluxCloud certificate\nInfluxDBClient client(INFLUXDB_URL, INFLUXDB_ORG, INFLUXDB_BUCKET, INFLUXDB_TOKEN, InfluxDbCloud2CACert);\n\n// Data point\nPoint sensor("wifi_status");\n\nvoid setup() {\n  Serial.begin(115200);\n\n  // Setup wifi\n  WiFi.mode(WIFI_STA);\n  wifiMulti.addAP(WIFI_SSID, WIFI_PASSWORD);\n\n  Serial.print("Connecting to wifi");\n  while (wifiMulti.run() != WL_CONNECTED) {\n    Serial.print(".");\n    delay(100);\n  }\n  Serial.println();\n\n  // Add tags\n  sensor.addTag("device", DEVICE);\n  sensor.addTag("SSID", WiFi.SSID());\n\n  // Accurate time is necessary for certificate validation and writing in batches\n  // For the fastest time sync find NTP servers in your area: https://www.pool.ntp.org/zone/\n  // Syncing progress and the time will be printed to Serial.\n  timeSync(TZ_INFO, "pool.ntp.org", "time.nis.gov");\n\n  // Check server connection\n  if (client.validateConnection()) {\n    Serial.print("Connected to InfluxDB: ");\n    Serial.println(client.getServerUrl());\n  } else {\n    Serial.print("InfluxDB connection failed: ");\n    Serial.println(client.getLastErrorMessage());\n  }\n}\n\n',this.write='void loop() {\n  // Clear fields for reusing the point. Tags will remain untouched\n  sensor.clearFields();\n\n  // Store measured value into point\n  // Report RSSI of currently connected network\n  sensor.addField("rssi", WiFi.RSSI());\n\n  // Print what are we exactly writing\n  Serial.print("Writing: ");\n  Serial.println(sensor.toLineProtocol());\n\n  // Check WiFi connection and reconnect if needed\n  if (wifiMulti.run() != WL_CONNECTED) {\n    Serial.println("Wifi connection lost");\n  }\n\n  // Write point\n  if (!client.writePoint(sensor)) {\n    Serial.print("InfluxDB write failed: ");\n    Serial.println(client.getLastErrorMessage());\n  }\n\n  Serial.println("Wait 10s");\n  delay(10000);\n}\n\n',this.execute='void loop() {\n  // Construct a Flux query\n  // Query will find the worst RSSI for last hour for each connected WiFi network with this device\n  String query = "<%= query %>";\n\n  // Print composed query\n  Serial.print("Querying with: ");\n  Serial.println(query);\n\n  // Print ouput header\n  Serial.print("==========");\n  // Send query to the server and get result\n  FluxQueryResult result = client.query(query);\n\n  // Iterate over rows. Even there is just one row, next() must be called at least once.\n  while (result.next()) {\n    // Get converted value for flux result column \'SSID\'\n    String ssid = result.getValueByName("SSID").getString();\n    Serial.print("SSID \'");\n    Serial.print(ssid);\n\n    Serial.print("\' with RSSI ");\n    // Get converted value for flux result column \'_value\' where there is RSSI value\n    long value = result.getValueByName("_value").getLong();\n    Serial.print(value);\n\n    // Get converted value for the _time column\n    FluxDateTime time = result.getValueByName("_time").getDateTime();\n\n    // Format date-time for printing\n    // Format string according to http://www.cplusplus.com/reference/ctime/strftime/\n    String timeStr = time.format("%F %T");\n\n    Serial.print(" at ");\n    Serial.print(timeStr);\n\n    Serial.println();\n  }\n\n  // Check if there was an error\n  if(result.getError() != "") {\n    Serial.print("Query result error: ");\n    Serial.println(result.getError());\n  }\n\n  // Close the result\n  result.close();\n\n  Serial.println("Wait 10s");\n  delay(10000);\n}\n\n',this.query='from(bucket: \\"<%= bucket %>\\") \\\n    |> range(start: -1h) \\\n    |> filter(fn: (r) => r._measurement == \\"wifi_status\\" and r._field == \\"rssi\\") \\\n    |> min()',this.querySanitize=n=>n.replace(/"/g,'\\"').split("\n").map(((n,e,t)=>{let i;return i=t.length==e+1?"":" \\",`${n}${i}`})).join("\n"),this.executeFull='\nInfluxDBClient client("<%= server %>", "<%= org %>", "<%= bucket %>", "<%= token %>", InfluxDbCloud2CACert);\n\nvoid loop {\n\n  // Construct a Flux query\n  String query = "<%= query %>";\n\n  // Print composed query\n  Serial.print("Querying with: ");\n  Serial.println(query);\n\n  // Send query to the server and get result\n  FluxQueryResult result = client.query(query);\n\n  // Iterate over rows. Even there is just one row, next() must be called at least once.\n  while (result.next()) {\n    // If there is a new table definition\n    if(result.hasTableChanged()) {\n      // Print table metadata\n      Serial.println();\n      for (String col: result.getColumnsName()) {\n        Serial.printf("%10s ", col.c_str());\n      }\n      Serial.println();\n      for (String typ: result.getColumnsDatatype()) {\n        Serial.printf("%10s ", typ.c_str());\n      }\n      Serial.println();\n    }\n    // Print raw, String, value\n    // converted value is retrieved using function FluxValue::getTYPE,\n    // where, depending on the column type,  TYPE can be Long, UnsignedLong, String, Bool, Double or DateTime,\n    for (FluxValue val: result.getValues()) {\n      Serial.printf("%10s ", val.getRawValue().c_str());\n    }\n    Serial.println();\n  }\n\n  // Check if there was an error\n  if(result.getError() != "") {\n    Serial.print("Query result error: ");\n    Serial.println(result.getError());\n  }\n\n  // Close the result\n  result.close();\n\n  delay(15000);\n}'}},csharp:new class{constructor(){this.id="csharp",this.name="C#",this.description='For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-csharp)\n\n##### Install Package\n\nLibrary Manager\n\n```\nInstall-Package InfluxDB.Client\n```\n\n.NET CLI\n\n```\ndotnet add package InfluxDB.Client\n```\n\nPackage Reference\n\n```\n<PackageReference Include="InfluxDB.Client" />\n```\n',this.logo=r,this.initialize='using System;\nusing System.Linq;\nusing System.Threading.Tasks;\nusing InfluxDB.Client;\nusing InfluxDB.Client.Api.Domain;\nusing InfluxDB.Client.Core;\nusing InfluxDB.Client.Writes;\n\nnamespace Examples\n{\n  public class Examples\n  {\n    public static async Task Main(string[] args)\n    {\n      // You can generate an API token from the "API Tokens Tab" in the UI\n      var token = Environment.GetEnvironmentVariable("INFLUX_TOKEN")!;\n      const string bucket = "<%= bucket %>";\n      const string org = "<%= org %>";\n\n      using var client = new InfluxDBClient("<%= server %>", token);\n    }\n  }\n}\n\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'const string data = "mem,host=host1 used_percent=23.43234543";\nusing (var writeApi = client.GetWriteApi())\n{\n  writeApi.WriteRecord(bucket, org, WritePrecision.Ns, data);\n}\n\n'},{title:"Use a Data Point to write data",code:'var point = PointData\n  .Measurement("mem")\n  .Tag("host", "host1")\n  .Field("used_percent", 23.43234543)\n  .Timestamp(DateTime.UtcNow, WritePrecision.Ns);\n\nusing (var writeApi = client.GetWriteApi())\n{\n  writeApi.WritePoint(bucket, org, point);\n}\n\n'},{title:"Use POCO and corresponding class to write data",code:'var mem = new Mem { Host = "host1", UsedPercent = 23.43234543, Time = DateTime.UtcNow };\n\nusing (var writeApi = client.GetWriteApi())\n{\n  writeApi.WriteMeasurement(bucket, org, WritePrecision.Ns, mem);\n}\n\n\n[Measurement("mem")]\nprivate class Mem\n{\n  [Column("host", IsTag = true)] public string Host { get; set; }\n  [Column("used_percent")] public double? UsedPercent { get; set; }\n  [Column(IsTimestamp = true)] public DateTime Time { get; set; }\n}\n'}],this.execute='var query = "<%= query %>";\nvar tables = await client.GetQueryApi().QueryAsync(query, org);\n\nforeach (var record in tables.SelectMany(table => table.Records))\n{\n    Console.WriteLine($"{record}");\n}\n',this.query='from(bucket: \\"<%= bucket %>\\") |> range(start: -1h)',this.querySanitize=n=>n.replace(/"/g,'""'),this.executeFull='using System;\nusing System.Linq;\nusing System.Threading.Tasks;\nusing InfluxDB.Client;\n\nnamespace Examples\n{\n  public class Examples\n  {\n    public static async Task Main(string[] args)\n    {\n      // You can generate a Token from the "Tokens Tab" in the UI\n      const string token = "<%= token %>";\n      const string org = "<%= org %>";\n\n      using var client = new InfluxDBClient("<%= server %>", token);\n\n      const string query = @"\n      <%= query %>\n      ";\n\n      var tables = await client.GetQueryApi().QueryAsync(query, org);\n\n      foreach (var record in tables.SelectMany(table => table.Records))\n      {\n        Console.WriteLine($"{record}");\n      }\n    }\n  }\n}\n\n'}},dart:new class{constructor(){this.id="dart",this.name="Dart",this.description="For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-dart).\n\n##### Use this package as a library\n\nFor Dart run this command:\n\n```\ndart pub add influxdb_client\n```\n\nFor Flutter run this command:\n\n```\nflutter pub add influxdb_client\n```\n\nThis will add a line like this to your package's `pubspec.yaml`:\n\n```\ndependencies:\n  influxdb_client: ^2.6.0\n```\n",this.logo=o,this.initialize="import 'dart:io' show Platform;\n\nimport 'package:influxdb_client/api.dart';\n\nvoid main() async {\n\n  // You can generate an API token from the \"API Tokens Tab\" in the UI\n  var token = Platform.environment['INFLUX_TOKEN'];\n  var bucket = '<%= bucket %>';\n  var org = '<%= org %>';\n\n  var client = InfluxDBClient(\n      url: '<%= server %>',\n      token: token,\n      org: org,\n      bucket: bucket);\n}\n",this.write=[{title:"Use InfluxDB Line Protocol to write data",code:"var record = 'mem,host=host1 used_percent=23.43234543';\n\nvar writeService = client.getWriteService();\nawait writeService.write(record).then((value) {\n  print('Write completed');\n}).catchError((exception) {\n  print(exception);\n});\n"},{title:"Use a Data Point to write data",code:"var point = Point('h2o')\n    .addTag('location', 'Prague')\n    .addField('level', 1.12345)\n    .time(DateTime.now().toUtc());\n\nvar writeService = client.getWriteService();\nawait writeService.write(point).then((value) {\n  print('Write completed');\n}).catchError((exception) {\n  print(exception);\n});\n"}],this.execute="var query = '''\n  <%= query %>\n''';\n\nvar queryService = client.getQueryService();\n\nvar records = await queryService.query(query);\nawait records.forEach((record) {\n  print('${record['_time']}: ${record['_field']} = ${record['_value']}');\n});\n",this.query='from(bucket: "<%= bucket %>") |> range(start: -1h)\n',this.executeFull="import 'dart:io' show Platform;\n\nimport 'package:influxdb_client/api.dart';\n\nvoid main() async {\n\n  // You can generate an API token from the \"API Tokens Tab\" in the UI\n  var token = Platform.environment['INFLUX_TOKEN'];\n  var bucket = '<%= bucket %>';\n  var org = '<%= org %>';\n\n  var client = InfluxDBClient(\n      url: '<%= server %>',\n      token: token,\n      org: org,\n      bucket: bucket);\n\n  var query = '''\n    <%= query %>\n  ''';\n\n  var queryService = client.getQueryService();\n\n  var records = await queryService.query(query);\n  await records.forEach((record) {\n    print('${record['_time']}: ${record['_field']} = ${record['_value']}');\n  });\n\n  client.close();\n}\n",this.dispose="client.close();\n"}},go:new class{constructor(){this.id="go",this.name="GO",this.description="For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-go)\n",this.logo=a,this.initialize='package main\n\nimport (\n  "context"\n  "fmt"\n  "os"\n  "time"\n\n   "github.com/influxdata/influxdb-client-go/v2"\n)\n\nfunc main() {\n  // Create a client\n  // You can generate an API Token from the "API Tokens Tab" in the UI\n  client := influxdb2.NewClient("<%= server %>", os.Getenv("INFLUX_TOKEN"))\n  // always close client at the end\n  defer client.Close()\n}\n\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'// get non-blocking write client\nwriteAPI := client.WriteAPI("<%= org %>", "<%= bucket %>")\n\n// write line protocol\nwriteAPI.WriteRecord(fmt.Sprintf("stat,unit=temperature avg=%f,max=%f", 23.5, 45.0))\n// Flush writes\nwriteAPI.Flush()\n\n'},{title:"Use a Data Point to write data",code:'// get non-blocking write client\nwriteAPI := client.WriteAPI("<%= org %>", "<%= bucket %>")\n\np := influxdb2.NewPoint("stat",\n  map[string]string{"unit": "temperature"},\n  map[string]interface{}{"avg": 24.5, "max": 45},\n  time.Now())\n// write point asynchronously\nwriteAPI.WritePoint(p)\n// create point using fluent style\np = influxdb2.NewPointWithMeasurement("stat").\n  AddTag("unit", "temperature").\n  AddField("avg", 23.2).\n  AddField("max", 45).\n  SetTime(time.Now())\n// write point asynchronously\nwriteAPI.WritePoint(p)\n// Flush writes\nwriteAPI.Flush()\n\n'}],this.execute='// Get query client\nqueryAPI := client.QueryAPI("<%= org %>")\n\nquery := `<%= query %>`\n\n// get QueryTableResult\nresult, err := queryAPI.Query(context.Background(), query)\nif err != nil {\n  panic(err)\n}\n\n// Iterate over query response\nfor result.Next() {\n  // Notice when group key has changed\n  if result.TableChanged() {\n    fmt.Printf("table: %s\\n", result.TableMetadata().String())\n  }\n  // Access data\n  fmt.Printf("value: %v\\n", result.Record().Value())\n}\n// check for an error\nif result.Err() != nil {\n  fmt.Printf("query parsing error: %\\n", result.Err().Error())\n}\n\n',this.query='from(bucket:"<%= bucket %>")|> range(start: -1h) |> filter(fn: (r) => r._measurement == "stat")',this.executeFull='package main\n\nimport (\n  "context"\n  "fmt"\n\n  "github.com/influxdata/influxdb-client-go/v2"\n)\n\nfunc main() {\n  // Create a client\n  // You can generate a Token from the "Tokens Tab" in the UI\n  client := influxdb2.NewClient("<%= server %>", "<%= token %>")\n  // always close client at the end\n  defer client.Close()\n\n  // Get query client\n  queryAPI := client.QueryAPI("<%= org %>")\n\n  query := `<%= query %>`\n  // get QueryTableResult\n  result, err := queryAPI.Query(context.Background(), query)\n  if err != nil {\n    panic(err)\n  }\n\n  // Iterate over query response\n  for result.Next() {\n    // Notice when group key has changed\n    if result.TableChanged() {\n      fmt.Printf("table: %s\\n", result.TableMetadata().String())\n    }\n    // Access data\n    fmt.Printf("value: %v\\n", result.Record().Value())\n  }\n  // check for an error\n  if result.Err() != nil {\n    fmt.Printf("query parsing error: %\\n", result.Err().Error())\n  }\n}\n\n'}},java:new class{constructor(){this.id="java",this.name="Java",this.description='For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-java)\n\n##### Add Dependency\n\nBuild with Maven\n\n```\n<dependency>\n  <groupId>com.influxdb</groupId>\n  <artifactId>influxdb-client-java</artifactId>\n  <version>6.6.0</version>\n</dependency>\n```\n\nBuild with Gradle\n\n```\ndependencies {\n  implementation "com.influxdb:influxdb-client-java:6.6.0"\n}\n```\n',this.logo=l,this.initialize='package example;\n\nimport java.time.Instant;\nimport java.util.List;\n\nimport com.influxdb.annotations.Column;\nimport com.influxdb.annotations.Measurement;\nimport com.influxdb.client.InfluxDBClient;\nimport com.influxdb.client.InfluxDBClientFactory;\nimport com.influxdb.client.WriteApi;\nimport com.influxdb.client.domain.WritePrecision;\nimport com.influxdb.client.write.Point;\nimport com.influxdb.query.FluxTable;\n\npublic class InfluxDB2Example {\n  public static void main(final String[] args) {\n\n    // You can generate an API token from the "API Tokens Tab" in the UI\n    String token = System.getenv("INFLUX_TOKEN");\n    String bucket = "<%= bucket %>";\n    String org = "<%= org %>";\n\n    InfluxDBClient client = InfluxDBClientFactory.create("<%= server %>", token.toCharArray());\n  }\n}\n\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'String data = "mem,host=host1 used_percent=23.43234543";\n\nWriteApiBlocking writeApi = client.getWriteApiBlocking();\nwriteApi.writeRecord(bucket, org, WritePrecision.NS, data);\n\n'},{title:"Use a Data Point to write data",code:'Point point = Point\n  .measurement("mem")\n  .addTag("host", "host1")\n  .addField("used_percent", 23.43234543)\n  .time(Instant.now(), WritePrecision.NS);\n\nWriteApiBlocking writeApi = client.getWriteApiBlocking();\nwriteApi.writePoint(bucket, org, point);\n\n'},{title:"Use POJO and corresponding class to write data",code:'Mem mem = new Mem();\nmem.host = "host1";\nmem.used_percent = 23.43234543;\nmem.time = Instant.now();\n\nWriteApiBlocking writeApi = client.getWriteApiBlocking();\nwriteApi.writeMeasurement(bucket, org, WritePrecision.NS, mem);\n\n\n\n@Measurement(name = "mem")\npublic static class Mem {\n  @Column(tag = true)\n  String host;\n  @Column\n  Double used_percent;\n  @Column(timestamp = true)\n  Instant time;\n}\n\n'}],this.execute='String query = "<%= query %>";\nList<FluxTable> tables = client.getQueryApi().query(query, org);\n\nfor (FluxTable table : tables) {\n  for (FluxRecord record : table.getRecords()) {\n    System.out.println(record);\n  }\n}\n',this.query='from(bucket: \\"<%= bucket %>\\") |> range(start: -1h)',this.querySanitize=n=>n.replace(/"/g,'\\"').split("\n").map(((n,e,t)=>{let i;return i=t.length==e+1?'"':'\\n" +',`"${n}${i}`})).join("\n"),this.executeFull='package example;\n\nimport java.util.List;\n\nimport com.influxdb.client.InfluxDBClient;\nimport com.influxdb.client.InfluxDBClientFactory;\nimport com.influxdb.query.FluxRecord;\nimport com.influxdb.query.FluxTable;\n\npublic class InfluxDB2Example {\n  public static void main(final String[] args) {\n\n    // You can generate a Token from the "Tokens Tab" in the UI\n    String token = "<%= token %>";\n    String org = "<%= org %>";\n\n    try (InfluxDBClient client = InfluxDBClientFactory.create("<%= server %>", token.toCharArray())) {\n\n      String query = <%= query %>;\n      List<FluxTable> tables = client.getQueryApi().query(query, org);\n\n      for (FluxTable table : tables) {\n        for (FluxRecord record : table.getRecords()) {\n          System.out.println(record);\n        }\n      }\n    }\n  }\n}\n\n',this.dispose="client.close();\n"}},"javascript-node":new class{constructor(){this.id="javascript-node",this.name="Node.js",this.description="For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-js)\n\n##### Install via NPM\n\n```\nnpm i @influxdata/influxdb-client\n```\n",this.logo=s,this.initialize="const {InfluxDB} = require('@influxdata/influxdb-client')\n\n// You can generate an API token from the \"API Tokens Tab\" in the UI\nconst token = process.env.INFLUX_TOKEN\nconst org = '<%= org %>'\nconst bucket = '<%= bucket %>'\n\nconst client = new InfluxDB({url: '<%= server %>', token: token})\n\n",this.write="const {Point} = require('@influxdata/influxdb-client')\nconst writeApi = client.getWriteApi(org, bucket)\nwriteApi.useDefaultTags({host: 'host1'})\n\nconst point = new Point('mem').floatField('used_percent', 23.43234543)\nwriteApi.writePoint(point)\n\nwriteApi\n    .close()\n    .then(() => {\n        console.log('FINISHED')\n    })\n    .catch(e => {\n        console.error(e)\n        console.log('Finished ERROR')\n    })\n",this.execute="const queryApi = client.getQueryApi(org)\n\nconst query = `<%= query %>`\nqueryApi.queryRows(query, {\n  next: (row, tableMeta) => {\n    const o = tableMeta.toObject(row)\n    console.log(`${o._time} ${o._measurement}: ${o._field}=${o._value}`)\n  },\n  error: (error) => {\n    console.error(error)\n    console.log('Finished ERROR')\n  },\n  complete: () => {\n    console.log('Finished SUCCESS')\n  },\n})\n\n",this.query='from(bucket: "<%= bucket %>") |> range(start: -1h)',this.executeFull="const {InfluxDB} = require('@influxdata/influxdb-client')\n\n// You can generate a Token from the \"Tokens Tab\" in the UI\nconst token = '<%= token %>'\nconst org = '<%= org %>'\n\nconst client = new InfluxDB({url: '<%= server %>', token: token})\n\nconst queryApi = client.getQueryApi(org)\n\nconst query = `<%= query %>`\nqueryApi.queryRows(query, {\n  next: (row, tableMeta) => {\n    const o = tableMeta.toObject(row)\n    console.log(`${o._time} ${o._measurement}: ${o._field}=${o._value}`)\n  },\n  error: (error) => {\n    console.error(error)\n    console.log('Finished ERROR')\n  },\n  complete: () => {\n    console.log('Finished SUCCESS')\n  },\n})\n"}},kotlin:new class{constructor(){this.id="kotlin",this.name="Kotlin",this.description='For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-java/tree/master/client-kotlin)\n\n##### Add Dependency\n\nBuild with Maven\n\n```\n<dependency>\n  <groupId>com.influxdb</groupId>\n  <artifactId>influxdb-client-kotlin</artifactId>\n  <version>6.6.0</version>\n</dependency>\n```\n\nBuild with Gradle\n\n```\ndependencies {\n  implementation "com.influxdb:influxdb-client-kotlin:6.6.0"\n}\n```\n',this.logo=c,this.initialize='package example\n\nimport com.influxdb.annotations.Column\nimport com.influxdb.annotations.Measurement\nimport com.influxdb.client.domain.WritePrecision\nimport com.influxdb.client.kotlin.InfluxDBClientKotlinFactory\nimport com.influxdb.client.write.Point\nimport kotlinx.coroutines.flow.collect\nimport kotlinx.coroutines.flow.consumeAsFlow\nimport kotlinx.coroutines.runBlocking\nimport java.time.Instant\n\nfun main() = runBlocking {\n\n    // You can generate an API token from the "API Tokens Tab" in the UI\n    val token = System.getenv()["INFLUX_TOKEN"]\n    val org = "<%= org %>"\n    val bucket = "<%= bucket %>"\n\n    val client = InfluxDBClientKotlinFactory.create("<%= server %>", token.toCharArray(), org, bucket)\n    client.use {\n\n    }\n}\n\n',this.execute='val query = """<%= query %>"""\n\n// Result is returned as a stream\nval results = client.getQueryKotlinApi().query(query)\n\nresults\n  .consumeAsFlow()\n  .collect { println("$it") }\n',this.query='from(bucket: "<%= bucket %>")\n    |> range(start: -1d)\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'val writeApi = client.getWriteKotlinApi()\n\nval record = "mem,host=host1 used_percent=23.43234543"\nwriteApi.writeRecord(record, WritePrecision.NS)\n'},{title:"Use a Data Point to write data",code:'val point = Point\n  .measurement("mem")\n  .addTag("host", "host1")\n  .addField("used_percent", 23.43234543)\n  .time(Instant.now(), WritePrecision.NS);\n\nwriteApi.writePoint(point)\n'},{title:"Use POJO and corresponding class to write data",code:'val mem = Mem("host1", 23.43234543, Instant.now())\nwriteApi.writeMeasurement(mem, WritePrecision.NS)\n\n\n@Measurement(name = "mem")\ndata class Mem(\n  @Column(tag = true) val host: String,\n  @Column val used_percent: Double,\n  @Column(timestamp = true) val time: Instant\n)\n'}],this.dispose="client.close()\n",this.executeFull='package example\n\nimport com.influxdb.client.kotlin.InfluxDBClientKotlinFactory\nimport kotlinx.coroutines.flow.collect\nimport kotlinx.coroutines.flow.consumeAsFlow\nimport kotlinx.coroutines.runBlocking\n\nfun main() = runBlocking {\n\n    // You can generate a Token from the "Tokens Tab" in the UI\n    val token = "<%= token %>"\n    val org = "<%= org %>"\n\n    val client = InfluxDBClientKotlinFactory.create("<%= server %>", token.toCharArray(), org)\n    client.use {\n        val query = """<%= query %>"""\n\n        val results = client.getQueryKotlinApi().query(query)\n        results\n          .consumeAsFlow()\n          .collect { println("$it") }\n    }\n}\n\n'}},php:new class{constructor(){this.id="php",this.name="PHP",this.description="For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-php)\n\n##### Install via Composer\n\n```\ncomposer require influxdata/influxdb-client-php guzzlehttp/guzzle\n```\n",this.logo=u,this.initialize='use InfluxDB2\\Client;\nuse InfluxDB2\\Model\\WritePrecision;\nuse InfluxDB2\\Point;\n\n# You can generate an API token from the "API Tokens Tab" in the UI\n$token = getenv(\'INFLUX_TOKEN\');\n$org = \'<%= org %>\';\n$bucket = \'<%= bucket %>\';\n\n$client = new Client([\n    "url" => "<%= server %>",\n    "token" => $token,\n]);\n\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'$writeApi = $client->createWriteApi();\n\n$data = "mem,host=host1 used_percent=23.43234543";\n\n$writeApi->write($data, WritePrecision::S, $bucket, $org);\n\n'},{title:"Use a Data Point to write data",code:"$point = Point::measurement('mem')\n  ->addTag('host', 'host1')\n  ->addField('used_percent', 23.43234543)\n  ->time(microtime(true));\n\n$writeApi->write($point, WritePrecision::S, $bucket, $org);\n\n"},{title:"Use Array structure to write data",code:"$dataArray = ['name' => 'cpu',\n  'tags' => ['host' => 'server_nl', 'region' => 'us'],\n  'fields' => ['internal' => 5, 'external' => 6],\n  'time' => microtime(true)];\n\n$writeApi->write($dataArray, WritePrecision::S, $bucket, $org);\n\n"}],this.execute='$query = "<%= query %>";\n$tables = $client->createQueryApi()->query($query, $org);\n\nforeach ($tables as $table) {\n    foreach ($table->records as $record) {\n        $time = $record->getTime();\n        $measurement = $record->getMeasurement();\n        $field = $record->getField();\n        $value = $record->getValue();\n        print "$time $measurement: $field=$value\\n";\n    }\n}\n',this.query='from(bucket: \\"<%= bucket %>\\") |> range(start: -1h)',this.dispose="$client->close();\n",this.executeFull='use InfluxDB2\\Client;\n\n# You can generate a Token from the "Tokens Tab" in the UI\n$token = \'<%= token %>\';\n$org = \'<%= org %>\';\n\n$client = new Client([\n    "url" => "<%= server %>",\n    "token" => $token,\n]);\n\n$query = "<%= query %>";\n$tables = $client->createQueryApi()->query($query, $org);\n\nforeach ($tables as $table) {\n    foreach ($table->records as $record) {\n        $time = $record->getTime();\n        $measurement = $record->getMeasurement();\n        $field = $record->getField();\n        $value = $record->getValue();\n        print "$time $measurement: $field=$value\\n";\n    }\n}\n\n$client->close();\n',this.querySanitize=n=>n.replace(/"/g,'\\"')}},python:new class{constructor(){this.id="python",this.name="Python",this.description="For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-python)\n\n##### Install Package\n\n```\npip install influxdb-client\n```\n",this.logo=d,this.initialize='from datetime import datetime\nimport os\n\nfrom influxdb_client import InfluxDBClient, Point, WritePrecision\nfrom influxdb_client.client.write_api import SYNCHRONOUS\n\n# You can generate an API token from the "API Tokens Tab" in the UI\ntoken = os.getenv("INFLUX_TOKEN")\norg = "<%= org %>"\nbucket = "<%= bucket %>"\n\nwith InfluxDBClient(url="<%= server %>", token=token, org=org) as client:\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'    write_api = client.write_api(write_options=SYNCHRONOUS)\n\n    data = "mem,host=host1 used_percent=23.43234543"\n    write_api.write(bucket, org, data)\n\n'},{title:"Use a Data Point to write data",code:'    point = Point("mem") \\\n        .tag("host", "host1") \\\n        .field("used_percent", 23.43234543) \\\n        .time(datetime.utcnow(), WritePrecision.NS)\n\n    write_api.write(bucket, org, point)\n\n'},{title:"Use a Batch Sequence to write data",code:'    sequence = ["mem,host=host1 used_percent=23.43234543",\n            "mem,host=host1 available_percent=15.856523"]\n    write_api.write(bucket, org, sequence)\n\n'}],this.execute='    query = """<%= query %>"""\n    tables = client.query_api().query(query, org=org)\n    for table in tables:\n        for record in table.records:\n            print(record)\n',this.query='from(bucket: "<%= bucket %>") |> range(start: -1h)',this.dispose="    client.close()\n",this.executeFull='from influxdb_client import InfluxDBClient\n\n# You can generate a Token from the "Tokens Tab" in the UI\ntoken = "<%= token %>"\norg = "<%= org %>"\nbucket = "<%= bucket %>"\n\nwith InfluxDBClient(url="<%= server %>", token=token, org=org) as client:\n    query = """<%= query %>"""\n    tables = client.query_api().query(query, org=org)\n    for table in tables:\n        for record in table.records:\n            print(record)\n'}},r:new class{constructor(){this.id="r",this.name="R",this.featureFlag="client-library--r",this.description='For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-r)\n\n##### Install Package\n\nReleased version published on CRAN\n\n```R\ninstall.packages("influxdbclient")\n```\n\nLatest development version\n\n```R\n# install.packages("remotes")\nremotes::install_github("influxdata/influxdb-client-r")\n```\n',this.logo=m,this.initialize='library("influxdbclient")\n\n# You can generate an API token from the "API Tokens Tab" in the UI\ntoken <- Sys.getenv("INFLUX_TOKEN")\n\nclient <- InfluxDBClient$new(url = "<%= server %>",\n    token = token,\n    org = "<%= org %>")\n',this.write='data <- data.frame(\n    name = replicate(2, "sensors"),\n    sensor_id = c("LM101", "LM102"),\n    temperature = c(71.4, 67.3),\n    humidity = c(47, 59),\n    time = c(Sys.time(),Sys.time())\n)\n\nclient$write(data,bucket = "<%= bucket %>", precision = "ms",\n    measurementCol = "name",\n    tagCols = c("sensor_id"),\n    fieldCols = c("temperature", "humidity"),\n    timeCol = "time")\n\n',this.execute="tables <- client$query('<%= query %>')\ntables\n\n",this.query='from(bucket: "<%= bucket %>") |> range(start: -1h)'}},ruby:new class{constructor(){this.id="ruby",this.name="Ruby",this.description="For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-ruby)\n\n##### Install the Gem\n\n```\ngem install influxdb-client\n```\n",this.logo=p,this.initialize="require 'influxdb-client'\n\n# You can generate an API token from the \"API Tokens Tab\" in the UI\ntoken = ENV[\"INFLUX_TOKEN\"]\norg = '<%= org %>'\nbucket = '<%= bucket %>'\n\nclient = InfluxDB2::Client.new('<%= server %>', token,\n  precision: InfluxDB2::WritePrecision::NANOSECOND)\n\n",this.write=[{title:"Use InfluxDB Line Protocol to write data",code:"write_api = client.create_write_api\n\ndata = 'mem,host=host1 used_percent=23.43234543'\nwrite_api.write(data: data, bucket: bucket, org: org)\n\n"},{title:"Use a Data Point to write data",code:"point = InfluxDB2::Point.new(name: 'mem')\n  .add_tag('host', 'host1')\n  .add_field('used_percent', 23.43234543)\n  .time(Time.now.utc, InfluxDB2::WritePrecision::NANOSECOND)\n\nwrite_api.write(data: point, bucket: bucket, org: org)\n\n"},{title:"Use a Hash to write data",code:"hash = {name: 'h2o',\n  tags: {host: 'aws', region: 'us'},\n  fields: {level: 5, saturation: '99%'},\n  time: Time.now.utc}\n\nwrite_api.write(data: hash, bucket: bucket, org: org)\n\n"},{title:"Use a Batch Sequence to write data",code:"point = InfluxDB2::Point.new(name: 'mem')\n  .add_tag('host', 'host1')\n  .add_field('used_percent', 23.43234543)\n  .time(Time.now.utc, InfluxDB2::WritePrecision::NANOSECOND)\n\nhash = {name: 'h2o',\n  tags: {host: 'aws', region: 'us'},\n  fields: {level: 5, saturation: '99%'},\n  time: Time.now.utc}\n\ndata = 'mem,host=host1 used_percent=23.23234543'\n\nwrite_api.write(data: [point, hash, data], bucket: bucket, org: org)\n\n"}],this.execute='query = "<%= query %>"\n\ntables = client.create_query_api.query(query: query, org: org)\ntables.each do |_, table|\n  table.records.each do |record|\n    puts "#{record.time} #{record.measurement}: #{record.field}=#{record.value}"\n  end\nend\n',this.query='from(bucket: \\"<%= bucket %>\\") |> range(start: -1h)',this.dispose="client.close!\n",this.executeFull="require 'influxdb-client'\n\n# You can generate a Token from the \"Tokens Tab\" in the UI\ntoken = '<%= token %>'\norg = '<%= org %>'\n\nInfluxDB2::Client.use('<%= server %>',\n                      token,\n                      precision: InfluxDB2::WritePrecision::NANOSECOND) do |client|\n\n    query = %{<%= query %>}\n\n    tables = client.create_query_api.query(query: query, org: org)\n    tables.each do |_, table|\n      table.records.each do |record|\n        puts \"#{record.time} #{record.measurement}: #{record.field}=#{record.value}\"\n      end\n    end\nend\n"}},scala:new class{constructor(){this.id="scala",this.name="Scala",this.description='For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-java/tree/master/client-scala)\n\n##### Add Dependency\n\nBuild with sbt\n\n```\nlibraryDependencies += "com.influxdb" % "influxdb-client-scala" % "6.6.0"\n```\n\nBuild with Maven\n\n```\n<dependency>\n  <groupId>com.influxdb</groupId>\n  <artifactId>influxdb-client-scala</artifactId>\n  <version>6.6.0</version>\n</dependency>\n```\n\nBuild with Gradle\n\n```\ndependencies {\n  implementation "com.influxdb:influxdb-client-scala:6.6.0"\n}\n```\n',this.logo=g,this.initialize='package example\n\nimport akka.actor.ActorSystem\nimport akka.stream.scaladsl.{Keep, Sink, Source}\nimport com.influxdb.annotations.{Column, Measurement}\nimport com.influxdb.client.domain.WritePrecision\nimport com.influxdb.client.scala.InfluxDBClientScalaFactory\nimport com.influxdb.query.FluxRecord\nimport com.influxdb.client.write.Point\n\nimport java.time.Instant\nimport scala.concurrent.Await\nimport scala.concurrent.duration.Duration\n\nobject InfluxDB2ScalaExample {\n\n  implicit val system: ActorSystem = ActorSystem("examples")\n\n  def main(args: Array[String]): Unit = {\n\n    // You can generate an API token from the "API Tokens Tab" in the UI\n    val token = sys.env.get("INFLUX_TOKEN")\n    val org = "<%= org %>"\n    val bucket = "<%= bucket %>"\n\n    val client = InfluxDBClientScalaFactory.create("<%= server %>", token.get.toCharArray, org, bucket)\n  }\n}\n\n',this.execute='val query = """<%= query %>"""\n\n// Result is returned as a stream\nval results = client.getQueryScalaApi().query(query)\n\nval sink = results\n  // print results\n  .runWith(Sink.foreach[FluxRecord](it => println(s"$it")\n  ))\n\n// wait to finish\nAwait.result(sink, Duration.Inf)\n',this.query='from(bucket: "<%= bucket %>")\n    |> range(start: -1d)\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'val record = "mem,host=host1 used_percent=23.43234543"\n\nval source = Source.single(record)\nval sink = client.getWriteScalaApi.writeRecord()\nval materialized = source.toMat(sink)(Keep.right)\n\nAwait.result(materialized.run(), Duration.Inf)\n'},{title:"Use a Data Point to write data",code:'val point = Point\n  .measurement("mem")\n  .addTag("host", "host1")\n  .addField("used_percent", 23.43234543)\n  .time(Instant.now(), WritePrecision.NS)\n\nval source = Source.single(point)\nval sink = client.getWriteScalaApi.writePoint()\nval materialized = source.toMat(sink)(Keep.right)\n\nAwait.result(materialized.run(), Duration.Inf)\n'},{title:"Use POJO and corresponding class to write data",code:'val mem = new Mem()\nmem.host = "host1"\nmem.used_percent = 23.43234543\nmem.time = Instant.now\n\nval source = Source.single(mem)\nval sink = client.getWriteScalaApi.writeMeasurement()\nval materialized = source.toMat(sink)(Keep.right)\nAwait.result(materialized.run(), Duration.Inf)\n\n\n\n@Measurement(name = "mem")\nclass Mem() {\n  @Column(tag = true)\n  var host: String = _\n  @Column\n  var used_percent: Double = _\n  @Column(timestamp = true)\n  var time: Instant = _\n}\n'}],this.dispose="client.close()\nsystem.terminate()\n",this.executeFull='package example\n\nimport akka.actor.ActorSystem\nimport akka.stream.scaladsl.Sink\nimport com.influxdb.client.scala.InfluxDBClientScalaFactory\nimport com.influxdb.query.FluxRecord\n\nimport scala.concurrent.Await\nimport scala.concurrent.duration.Duration\n\nobject InfluxDB2ScalaExample {\n\n  implicit val system: ActorSystem = ActorSystem("examples")\n\n  def main(args: Array[String]): Unit = {\n\n    // You can generate a Token from the "Tokens Tab" in the UI\n    val token = "<%= token %>"\n    val org = "<%= org %>"\n\n    val client = InfluxDBClientScalaFactory.create("<%= server %>", token.toCharArray, org)\n\n    val query = """<%= query %>"""\n\n    // Result is returned as a stream\n    val results = client.getQueryScalaApi().query(query)\n\n    val sink = results\n      // print results\n      .runWith(Sink.foreach[FluxRecord](it => println(s"$it")\n      ))\n\n    // wait to finish\n    Await.result(sink, Duration.Inf)\n\n    client.close()\n    system.terminate()\n  }\n}\n\n'}},swift:new class{constructor(){this.id="swift",this.name="Swift",this.description='For more detailed and up to date information check out the [GitHub Repository](https://github.com/influxdata/influxdb-client-swift/)\n\n##### Install via Swift Package Manager\n\nAdd this line to your `Package.swift`:\n\n```swift\n// swift-tools-version:5.3\nimport PackageDescription\n\nlet package = Package(\n    name: "MyPackage",\n    platforms: [\n        .macOS(.v12),\n        .iOS(.v15)\n    ],\n    dependencies: [\n        .package(name: "influxdb-client-swift", url: "https://github.com/influxdata/influxdb-client-swift", from: "1.4.0"),\n    ],\n    targets: [\n        .target(name: "MyModule", dependencies: [\n          .product(name: "InfluxDBSwift", package: "influxdb-client-swift"),\n          // or InfluxDBSwiftApis for management API\n          .product(name: "InfluxDBSwiftApis", package: "influxdb-client-swift")\n        ])\n    ]\n)\n```\n',this.logo=f,this.initialize='import Foundation\nimport InfluxDBSwift\n\n@main\nclass Example {\n    static func main() async throws {\n\n        let url = "<%= server %>"\n        let token = ProcessInfo.processInfo.environment["INFLUX_TOKEN"]!\n        let bucket = "<%= bucket %>"\n        let org = "<%= org %>"\n\n        let client = InfluxDBClient(url: url, token: token)\n\n    }\n}\n',this.write=[{title:"Use InfluxDB Line Protocol to write data",code:'let recordString = "demo,type=string value=1i"\n\ntry await client.makeWriteAPI().write(bucket: bucket, org: org, record: recordString)\n\n'},{title:"Use a Data Point to write data",code:'let recordPoint = InfluxDBClient\n        .Point("demo")\n        .addTag(key: "type", value: "point-timestamp")\n        .addField(key: "value", value: .int(2))\n        .time(time: .date(Date()))\n\ntry await client.makeWriteAPI().write(bucket: bucket, org: org, points: [recordPoint])\n\n'},{title:"Use Tuple to write data",code:'let recordTuple: InfluxDBClient.Point.Tuple\n        = (measurement: "demo", tags: ["type": "tuple"], fields: ["value": .int(3)], time: nil)\n\ntry await client.makeWriteAPI().write(bucket: bucket, org: org, tuple: recordTuple)\n\n'}],this.execute='let query = """\n            <%= query %>"""\n\nlet records = try await client.queryAPI.query(query: query, org: org)\ntry records.forEach { print(" > \\($0.values["_field"]!): \\($0.values["_value"]!)") }\n\n',this.query='from(bucket: "<%= bucket %>") |> range(start: -1h)\n',this.dispose="client.close()\n",this.executeFull='import Foundation\nimport InfluxDBSwift\n\n@main\nclass Example {\n    static func main() async throws {\n\n        let url = "<%= server %>"\n        let token = "<%= token %>"\n        let org = "<%= org %>"\n\n        let client = InfluxDBClient(url: url, token: token)\n\n        let query = """\n                    <%= query %>\n                    """\n\n        let records = try await client.queryAPI.query(query: query, org: org)\n        try records.forEach {\n          let time = $0.values["_time"]!\n          let measurement = $0.values["_measurement"]!\n          let field = $0.values["_field"]!\n          let value = $0.values["_value"]!\n          print("\\(time) \\(measurement): \\(field)=\\(value)")\n        }\n\n        client.close()\n    }\n}\n'}}},b=n=>Object.values(h).filter((e=>e.name.toLowerCase().includes(n.toLowerCase()))).sort(((n,e)=>n.name.toLowerCase().localeCompare(e.name.toLowerCase())))},54954:(n,e,t)=>{n.exports=t.p+"7e3f8f19d5..svg"}}]);
//# sourceMappingURL=a3403f9e5c.js.map