// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_V1_WEB_SECURITY_SCANNER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_V1_WEB_SECURITY_SCANNER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/websecurityscanner/v1/web_security_scanner.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace websecurityscanner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class WebSecurityScannerConnectionIdempotencyPolicy {
 public:
  virtual ~WebSecurityScannerConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<WebSecurityScannerConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateScanConfig(
      google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&
          request);

  virtual google::cloud::Idempotency DeleteScanConfig(
      google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&
          request);

  virtual google::cloud::Idempotency GetScanConfig(
      google::cloud::websecurityscanner::v1::GetScanConfigRequest const&
          request);

  virtual google::cloud::Idempotency ListScanConfigs(
      google::cloud::websecurityscanner::v1::ListScanConfigsRequest request);

  virtual google::cloud::Idempotency UpdateScanConfig(
      google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&
          request);

  virtual google::cloud::Idempotency StartScanRun(
      google::cloud::websecurityscanner::v1::StartScanRunRequest const&
          request);

  virtual google::cloud::Idempotency GetScanRun(
      google::cloud::websecurityscanner::v1::GetScanRunRequest const& request);

  virtual google::cloud::Idempotency ListScanRuns(
      google::cloud::websecurityscanner::v1::ListScanRunsRequest request);

  virtual google::cloud::Idempotency StopScanRun(
      google::cloud::websecurityscanner::v1::StopScanRunRequest const& request);

  virtual google::cloud::Idempotency ListCrawledUrls(
      google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest request);

  virtual google::cloud::Idempotency GetFinding(
      google::cloud::websecurityscanner::v1::GetFindingRequest const& request);

  virtual google::cloud::Idempotency ListFindings(
      google::cloud::websecurityscanner::v1::ListFindingsRequest request);

  virtual google::cloud::Idempotency ListFindingTypeStats(
      google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest const&
          request);
};

std::unique_ptr<WebSecurityScannerConnectionIdempotencyPolicy>
MakeDefaultWebSecurityScannerConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace websecurityscanner_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WEBSECURITYSCANNER_V1_WEB_SECURITY_SCANNER_CONNECTION_IDEMPOTENCY_POLICY_H
