// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/retail/v2/product_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_MOCKS_MOCK_PRODUCT_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_MOCKS_MOCK_PRODUCT_CONNECTION_H

#include "google/cloud/retail/v2/product_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace retail_v2_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `ProductServiceConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `ProductServiceClient`. To do so,
 * construct an object of type `ProductServiceClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockProductServiceConnection
    : public retail_v2::ProductServiceConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(StatusOr<google::cloud::retail::v2::Product>, CreateProduct,
              (google::cloud::retail::v2::CreateProductRequest const& request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::retail::v2::Product>, GetProduct,
              (google::cloud::retail::v2::GetProductRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::cloud::retail::v2::Product>), ListProducts,
              (google::cloud::retail::v2::ListProductsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::retail::v2::Product>, UpdateProduct,
              (google::cloud::retail::v2::UpdateProductRequest const& request),
              (override));

  MOCK_METHOD(Status, DeleteProduct,
              (google::cloud::retail::v2::DeleteProductRequest const& request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::retail::v2::ImportProductsResponse>>,
      ImportProducts,
      (google::cloud::retail::v2::ImportProductsRequest const& request),
      (override));

  MOCK_METHOD(future<StatusOr<google::cloud::retail::v2::SetInventoryResponse>>,
              SetInventory,
              (google::cloud::retail::v2::SetInventoryRequest const& request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::retail::v2::AddFulfillmentPlacesResponse>>,
      AddFulfillmentPlaces,
      (google::cloud::retail::v2::AddFulfillmentPlacesRequest const& request),
      (override));

  MOCK_METHOD(
      future<
          StatusOr<google::cloud::retail::v2::RemoveFulfillmentPlacesResponse>>,
      RemoveFulfillmentPlaces,
      (google::cloud::retail::v2::RemoveFulfillmentPlacesRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::retail::v2::AddLocalInventoriesResponse>>,
      AddLocalInventories,
      (google::cloud::retail::v2::AddLocalInventoriesRequest const& request),
      (override));

  MOCK_METHOD(
      future<
          StatusOr<google::cloud::retail::v2::RemoveLocalInventoriesResponse>>,
      RemoveLocalInventories,
      (google::cloud::retail::v2::RemoveLocalInventoriesRequest const& request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace retail_v2_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RETAIL_V2_MOCKS_MOCK_PRODUCT_CONNECTION_H
