// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/metric_service.proto

#include "google/cloud/monitoring/v3/internal/metric_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/monitoring/v3/metric_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetricServiceLogging::MetricServiceLogging(
    std::shared_ptr<MetricServiceStub> child, TracingOptions tracing_options,
    std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::monitoring::v3::ListMonitoredResourceDescriptorsResponse>
MetricServiceLogging::ListMonitoredResourceDescriptors(
    grpc::ClientContext& context,
    google::monitoring::v3::ListMonitoredResourceDescriptorsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::ListMonitoredResourceDescriptorsRequest const&
              request) {
        return child_->ListMonitoredResourceDescriptors(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::api::MonitoredResourceDescriptor>
MetricServiceLogging::GetMonitoredResourceDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::GetMonitoredResourceDescriptorRequest const&
              request) {
        return child_->GetMonitoredResourceDescriptor(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ListMetricDescriptorsResponse>
MetricServiceLogging::ListMetricDescriptors(
    grpc::ClientContext& context,
    google::monitoring::v3::ListMetricDescriptorsRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::ListMetricDescriptorsRequest const& request) {
        return child_->ListMetricDescriptors(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::api::MetricDescriptor>
MetricServiceLogging::GetMetricDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::GetMetricDescriptorRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::monitoring::v3::GetMetricDescriptorRequest const& request) {
        return child_->GetMetricDescriptor(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::api::MetricDescriptor>
MetricServiceLogging::CreateMetricDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateMetricDescriptorRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateMetricDescriptorRequest const&
                 request) {
        return child_->CreateMetricDescriptor(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status MetricServiceLogging::DeleteMetricDescriptor(
    grpc::ClientContext& context,
    google::monitoring::v3::DeleteMetricDescriptorRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::DeleteMetricDescriptorRequest const&
                 request) {
        return child_->DeleteMetricDescriptor(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::monitoring::v3::ListTimeSeriesResponse>
MetricServiceLogging::ListTimeSeries(
    grpc::ClientContext& context,
    google::monitoring::v3::ListTimeSeriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::ListTimeSeriesRequest const& request) {
        return child_->ListTimeSeries(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status MetricServiceLogging::CreateTimeSeries(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateTimeSeriesRequest const& request) {
        return child_->CreateTimeSeries(context, request);
      },
      context, request, __func__, tracing_options_);
}

Status MetricServiceLogging::CreateServiceTimeSeries(
    grpc::ClientContext& context,
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::monitoring::v3::CreateTimeSeriesRequest const& request) {
        return child_->CreateServiceTimeSeries(context, request);
      },
      context, request, __func__, tracing_options_);
}

future<Status> MetricServiceLogging::AsyncCreateTimeSeries(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::monitoring::v3::CreateTimeSeriesRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](google::cloud::CompletionQueue& cq,
             std::shared_ptr<grpc::ClientContext> context,
             google::monitoring::v3::CreateTimeSeriesRequest const& request) {
        return child_->AsyncCreateTimeSeries(cq, std::move(context), request);
      },
      cq, std::move(context), request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
