// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_MOCKS_MOCK_MIGRATION_CENTER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_MOCKS_MOCK_MIGRATION_CENTER_CONNECTION_H

#include "google/cloud/migrationcenter/v1/migration_center_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace migrationcenter_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `MigrationCenterConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `MigrationCenterClient`. To do so,
 * construct an object of type `MigrationCenterClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockMigrationCenterConnection
    : public migrationcenter_v1::MigrationCenterConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD((StreamRange<google::cloud::migrationcenter::v1::Asset>),
              ListAssets,
              (google::cloud::migrationcenter::v1::ListAssetsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::Asset>, GetAsset,
      (google::cloud::migrationcenter::v1::GetAssetRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::Asset>, UpdateAsset,
      (google::cloud::migrationcenter::v1::UpdateAssetRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>,
      BatchUpdateAssets,
      (google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const&
           request),
      (override));

  MOCK_METHOD(
      Status, DeleteAsset,
      (google::cloud::migrationcenter::v1::DeleteAssetRequest const& request),
      (override));

  MOCK_METHOD(
      Status, BatchDeleteAssets,
      (google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::ReportAssetFramesResponse>,
      ReportAssetFrames,
      (google::cloud::migrationcenter::v1::ReportAssetFramesRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<
          google::cloud::migrationcenter::v1::AggregateAssetsValuesResponse>,
      AggregateAssetsValues,
      (google::cloud::migrationcenter::v1::AggregateAssetsValuesRequest const&
           request),
      (override));

  MOCK_METHOD(future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>,
              CreateImportJob,
              (google::cloud::migrationcenter::v1::CreateImportJobRequest const&
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::migrationcenter::v1::ImportJob>),
      ListImportJobs,
      (google::cloud::migrationcenter::v1::ListImportJobsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::ImportJob>, GetImportJob,
      (google::cloud::migrationcenter::v1::GetImportJobRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      DeleteImportJob,
      (google::cloud::migrationcenter::v1::DeleteImportJobRequest const&
           request),
      (override));

  MOCK_METHOD(future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>,
              UpdateImportJob,
              (google::cloud::migrationcenter::v1::UpdateImportJobRequest const&
                   request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      ValidateImportJob,
      (google::cloud::migrationcenter::v1::ValidateImportJobRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      RunImportJob,
      (google::cloud::migrationcenter::v1::RunImportJobRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>,
      GetImportDataFile,
      (google::cloud::migrationcenter::v1::GetImportDataFileRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>),
      ListImportDataFiles,
      (google::cloud::migrationcenter::v1::ListImportDataFilesRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>,
      CreateImportDataFile,
      (google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      DeleteImportDataFile,
      (google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
           request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::migrationcenter::v1::Group>),
              ListGroups,
              (google::cloud::migrationcenter::v1::ListGroupsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::Group>, GetGroup,
      (google::cloud::migrationcenter::v1::GetGroupRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::Group>>, CreateGroup,
      (google::cloud::migrationcenter::v1::CreateGroupRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::Group>>, UpdateGroup,
      (google::cloud::migrationcenter::v1::UpdateGroupRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      DeleteGroup,
      (google::cloud::migrationcenter::v1::DeleteGroupRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::Group>>,
      AddAssetsToGroup,
      (google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::Group>>,
      RemoveAssetsFromGroup,
      (google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::migrationcenter::v1::ErrorFrame>),
      ListErrorFrames,
      (google::cloud::migrationcenter::v1::ListErrorFramesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::ErrorFrame>, GetErrorFrame,
      (google::cloud::migrationcenter::v1::GetErrorFrameRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::migrationcenter::v1::Source>),
              ListSources,
              (google::cloud::migrationcenter::v1::ListSourcesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::Source>, GetSource,
      (google::cloud::migrationcenter::v1::GetSourceRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::Source>>,
      CreateSource,
      (google::cloud::migrationcenter::v1::CreateSourceRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::Source>>,
      UpdateSource,
      (google::cloud::migrationcenter::v1::UpdateSourceRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      DeleteSource,
      (google::cloud::migrationcenter::v1::DeleteSourceRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>),
      ListPreferenceSets,
      (google::cloud::migrationcenter::v1::ListPreferenceSetsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>,
      GetPreferenceSet,
      (google::cloud::migrationcenter::v1::GetPreferenceSetRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>,
      CreatePreferenceSet,
      (google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>,
      UpdatePreferenceSet,
      (google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      DeletePreferenceSet,
      (google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::Settings>, GetSettings,
      (google::cloud::migrationcenter::v1::GetSettingsRequest const& request),
      (override));

  MOCK_METHOD(future<StatusOr<google::cloud::migrationcenter::v1::Settings>>,
              UpdateSettings,
              (google::cloud::migrationcenter::v1::UpdateSettingsRequest const&
                   request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>,
      CreateReportConfig,
      (google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
           request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::migrationcenter::v1::ReportConfig>,
              GetReportConfig,
              (google::cloud::migrationcenter::v1::GetReportConfigRequest const&
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::migrationcenter::v1::ReportConfig>),
      ListReportConfigs,
      (google::cloud::migrationcenter::v1::ListReportConfigsRequest request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      DeleteReportConfig,
      (google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
           request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::Report>>,
      CreateReport,
      (google::cloud::migrationcenter::v1::CreateReportRequest const& request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::migrationcenter::v1::Report>, GetReport,
      (google::cloud::migrationcenter::v1::GetReportRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::migrationcenter::v1::Report>),
              ListReports,
              (google::cloud::migrationcenter::v1::ListReportsRequest request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>,
      DeleteReport,
      (google::cloud::migrationcenter::v1::DeleteReportRequest const& request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MIGRATIONCENTER_V1_MOCKS_MOCK_MIGRATION_CENTER_CONNECTION_H
