// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/gkebackup/v1/gkebackup.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEBACKUP_V1_MOCKS_MOCK_BACKUP_FOR_GKE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEBACKUP_V1_MOCKS_MOCK_BACKUP_FOR_GKE_CONNECTION_H

#include "google/cloud/gkebackup/v1/backup_for_gke_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace gkebackup_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `BackupForGKEConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `BackupForGKEClient`. To do so,
 * construct an object of type `BackupForGKEClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockBackupForGKEConnection : public gkebackup_v1::BackupForGKEConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>,
      CreateBackupPlan,
      (google::cloud::gkebackup::v1::CreateBackupPlanRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::gkebackup::v1::BackupPlan>),
              ListBackupPlans,
              (google::cloud::gkebackup::v1::ListBackupPlansRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkebackup::v1::BackupPlan>, GetBackupPlan,
      (google::cloud::gkebackup::v1::GetBackupPlanRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::BackupPlan>>,
      UpdateBackupPlan,
      (google::cloud::gkebackup::v1::UpdateBackupPlanRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>,
      DeleteBackupPlan,
      (google::cloud::gkebackup::v1::DeleteBackupPlanRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::Backup>>, CreateBackup,
      (google::cloud::gkebackup::v1::CreateBackupRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::gkebackup::v1::Backup>), ListBackups,
              (google::cloud::gkebackup::v1::ListBackupsRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::gkebackup::v1::Backup>, GetBackup,
              (google::cloud::gkebackup::v1::GetBackupRequest const& request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::Backup>>, UpdateBackup,
      (google::cloud::gkebackup::v1::UpdateBackupRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>,
      DeleteBackup,
      (google::cloud::gkebackup::v1::DeleteBackupRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::gkebackup::v1::VolumeBackup>),
              ListVolumeBackups,
              (google::cloud::gkebackup::v1::ListVolumeBackupsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkebackup::v1::VolumeBackup>, GetVolumeBackup,
      (google::cloud::gkebackup::v1::GetVolumeBackupRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>,
      CreateRestorePlan,
      (google::cloud::gkebackup::v1::CreateRestorePlanRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::gkebackup::v1::RestorePlan>),
              ListRestorePlans,
              (google::cloud::gkebackup::v1::ListRestorePlansRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkebackup::v1::RestorePlan>, GetRestorePlan,
      (google::cloud::gkebackup::v1::GetRestorePlanRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::RestorePlan>>,
      UpdateRestorePlan,
      (google::cloud::gkebackup::v1::UpdateRestorePlanRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>,
      DeleteRestorePlan,
      (google::cloud::gkebackup::v1::DeleteRestorePlanRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::Restore>>, CreateRestore,
      (google::cloud::gkebackup::v1::CreateRestoreRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::gkebackup::v1::Restore>),
              ListRestores,
              (google::cloud::gkebackup::v1::ListRestoresRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::gkebackup::v1::Restore>, GetRestore,
              (google::cloud::gkebackup::v1::GetRestoreRequest const& request),
              (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::Restore>>, UpdateRestore,
      (google::cloud::gkebackup::v1::UpdateRestoreRequest const& request),
      (override));

  MOCK_METHOD(
      future<StatusOr<google::cloud::gkebackup::v1::OperationMetadata>>,
      DeleteRestore,
      (google::cloud::gkebackup::v1::DeleteRestoreRequest const& request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::gkebackup::v1::VolumeRestore>),
              ListVolumeRestores,
              (google::cloud::gkebackup::v1::ListVolumeRestoresRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::gkebackup::v1::VolumeRestore>, GetVolumeRestore,
      (google::cloud::gkebackup::v1::GetVolumeRestoreRequest const& request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace gkebackup_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_GKEBACKUP_V1_MOCKS_MOCK_BACKUP_FOR_GKE_CONNECTION_H
