// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgecontainer/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGECONTAINER_V1_EDGE_CONTAINER_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGECONTAINER_V1_EDGE_CONTAINER_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/edgecontainer/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace edgecontainer_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class EdgeContainerConnectionIdempotencyPolicy {
 public:
  virtual ~EdgeContainerConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<EdgeContainerConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency ListClusters(
      google::cloud::edgecontainer::v1::ListClustersRequest request);

  virtual google::cloud::Idempotency GetCluster(
      google::cloud::edgecontainer::v1::GetClusterRequest const& request);

  virtual google::cloud::Idempotency CreateCluster(
      google::cloud::edgecontainer::v1::CreateClusterRequest const& request);

  virtual google::cloud::Idempotency UpdateCluster(
      google::cloud::edgecontainer::v1::UpdateClusterRequest const& request);

  virtual google::cloud::Idempotency DeleteCluster(
      google::cloud::edgecontainer::v1::DeleteClusterRequest const& request);

  virtual google::cloud::Idempotency GenerateAccessToken(
      google::cloud::edgecontainer::v1::GenerateAccessTokenRequest const&
          request);

  virtual google::cloud::Idempotency ListNodePools(
      google::cloud::edgecontainer::v1::ListNodePoolsRequest request);

  virtual google::cloud::Idempotency GetNodePool(
      google::cloud::edgecontainer::v1::GetNodePoolRequest const& request);

  virtual google::cloud::Idempotency CreateNodePool(
      google::cloud::edgecontainer::v1::CreateNodePoolRequest const& request);

  virtual google::cloud::Idempotency UpdateNodePool(
      google::cloud::edgecontainer::v1::UpdateNodePoolRequest const& request);

  virtual google::cloud::Idempotency DeleteNodePool(
      google::cloud::edgecontainer::v1::DeleteNodePoolRequest const& request);

  virtual google::cloud::Idempotency ListMachines(
      google::cloud::edgecontainer::v1::ListMachinesRequest request);

  virtual google::cloud::Idempotency GetMachine(
      google::cloud::edgecontainer::v1::GetMachineRequest const& request);

  virtual google::cloud::Idempotency ListVpnConnections(
      google::cloud::edgecontainer::v1::ListVpnConnectionsRequest request);

  virtual google::cloud::Idempotency GetVpnConnection(
      google::cloud::edgecontainer::v1::GetVpnConnectionRequest const& request);

  virtual google::cloud::Idempotency CreateVpnConnection(
      google::cloud::edgecontainer::v1::CreateVpnConnectionRequest const&
          request);

  virtual google::cloud::Idempotency DeleteVpnConnection(
      google::cloud::edgecontainer::v1::DeleteVpnConnectionRequest const&
          request);
};

std::unique_ptr<EdgeContainerConnectionIdempotencyPolicy>
MakeDefaultEdgeContainerConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgecontainer_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_EDGECONTAINER_V1_EDGE_CONTAINER_CONNECTION_IDEMPOTENCY_POLICY_H
