// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/documentai/v1/document_processor_service.proto

#include "google/cloud/documentai/v1/internal/document_processor_option_defaults.h"
#include "google/cloud/documentai/v1/document_processor_connection.h"
#include "google/cloud/documentai/v1/document_processor_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace documentai_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options DocumentProcessorServiceDefaultOptions(std::string const& location,
                                               Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options),
      "GOOGLE_CLOUD_CPP_DOCUMENT_PROCESSOR_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_DOCUMENT_PROCESSOR_SERVICE_AUTHORITY",
      absl::StrCat(location, location.empty() ? "" : "-",
                   "documentai.googleapis.com"));
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options
           .has<documentai_v1::DocumentProcessorServiceRetryPolicyOption>()) {
    options.set<documentai_v1::DocumentProcessorServiceRetryPolicyOption>(
        documentai_v1::DocumentProcessorServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options
           .has<documentai_v1::DocumentProcessorServiceBackoffPolicyOption>()) {
    options.set<documentai_v1::DocumentProcessorServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options
           .has<documentai_v1::DocumentProcessorServicePollingPolicyOption>()) {
    options.set<documentai_v1::DocumentProcessorServicePollingPolicyOption>(
        GenericPollingPolicy<
            documentai_v1::DocumentProcessorServiceRetryPolicyOption::Type,
            documentai_v1::DocumentProcessorServiceBackoffPolicyOption::Type>(
            options
                .get<documentai_v1::DocumentProcessorServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          documentai_v1::
              DocumentProcessorServiceConnectionIdempotencyPolicyOption>()) {
    options.set<documentai_v1::
                    DocumentProcessorServiceConnectionIdempotencyPolicyOption>(
        documentai_v1::
            MakeDefaultDocumentProcessorServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace documentai_v1_internal
}  // namespace cloud
}  // namespace google
