// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_url_maps/v1/region_url_maps.proto

#include "google/cloud/compute/region_url_maps/v1/region_url_maps_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_url_maps_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionUrlMapsClient::RegionUrlMapsClient(
    std::shared_ptr<RegionUrlMapsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionUrlMapsClient::~RegionUrlMapsClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::DeleteUrlMap(std::string const& project,
                                  std::string const& region,
                                  std::string const& url_map, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_url_maps::v1::DeleteUrlMapRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_url_map(url_map);
  return connection_->DeleteUrlMap(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::DeleteUrlMap(
    google::cloud::cpp::compute::region_url_maps::v1::DeleteUrlMapRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteUrlMap(request);
}

StatusOr<google::cloud::cpp::compute::v1::UrlMap>
RegionUrlMapsClient::GetUrlMap(std::string const& project,
                               std::string const& region,
                               std::string const& url_map, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_url_maps::v1::GetUrlMapRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_url_map(url_map);
  return connection_->GetUrlMap(request);
}

StatusOr<google::cloud::cpp::compute::v1::UrlMap>
RegionUrlMapsClient::GetUrlMap(
    google::cloud::cpp::compute::region_url_maps::v1::GetUrlMapRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetUrlMap(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::InsertUrlMap(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::UrlMap const& url_map_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_url_maps::v1::InsertUrlMapRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_url_map_resource() = url_map_resource;
  return connection_->InsertUrlMap(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::InsertUrlMap(
    google::cloud::cpp::compute::region_url_maps::v1::InsertUrlMapRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertUrlMap(request);
}

StreamRange<google::cloud::cpp::compute::v1::UrlMap>
RegionUrlMapsClient::ListRegionUrlMaps(std::string const& project,
                                       std::string const& region,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_url_maps::v1::ListRegionUrlMapsRequest
      request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionUrlMaps(request);
}

StreamRange<google::cloud::cpp::compute::v1::UrlMap>
RegionUrlMapsClient::ListRegionUrlMaps(
    google::cloud::cpp::compute::region_url_maps::v1::ListRegionUrlMapsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionUrlMaps(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::PatchUrlMap(
    std::string const& project, std::string const& region,
    std::string const& url_map,
    google::cloud::cpp::compute::v1::UrlMap const& url_map_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_url_maps::v1::PatchUrlMapRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_url_map(url_map);
  *request.mutable_url_map_resource() = url_map_resource;
  return connection_->PatchUrlMap(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::PatchUrlMap(
    google::cloud::cpp::compute::region_url_maps::v1::PatchUrlMapRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchUrlMap(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::UpdateUrlMap(
    std::string const& project, std::string const& region,
    std::string const& url_map,
    google::cloud::cpp::compute::v1::UrlMap const& url_map_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_url_maps::v1::UpdateUrlMapRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_url_map(url_map);
  *request.mutable_url_map_resource() = url_map_resource;
  return connection_->UpdateUrlMap(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionUrlMapsClient::UpdateUrlMap(
    google::cloud::cpp::compute::region_url_maps::v1::UpdateUrlMapRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateUrlMap(request);
}

StatusOr<google::cloud::cpp::compute::v1::UrlMapsValidateResponse>
RegionUrlMapsClient::Validate(
    std::string const& project, std::string const& region,
    std::string const& url_map,
    google::cloud::cpp::compute::v1::RegionUrlMapsValidateRequest const&
        region_url_maps_validate_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_url_maps::v1::ValidateRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_url_map(url_map);
  *request.mutable_region_url_maps_validate_request_resource() =
      region_url_maps_validate_request_resource;
  return connection_->Validate(request);
}

StatusOr<google::cloud::cpp::compute::v1::UrlMapsValidateResponse>
RegionUrlMapsClient::Validate(
    google::cloud::cpp::compute::region_url_maps::v1::ValidateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->Validate(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_url_maps_v1
}  // namespace cloud
}  // namespace google
