// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#include "google/cloud/bigquery/biglake/v1/internal/metastore_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/bigquery/biglake/v1/metastore.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_biglake_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MetastoreServiceStub::~MetastoreServiceStub() = default;

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
DefaultMetastoreServiceStub::CreateCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateCatalogRequest const& request) {
  google::cloud::bigquery::biglake::v1::Catalog response;
  auto status = grpc_stub_->CreateCatalog(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
DefaultMetastoreServiceStub::DeleteCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const& request) {
  google::cloud::bigquery::biglake::v1::Catalog response;
  auto status = grpc_stub_->DeleteCatalog(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Catalog>
DefaultMetastoreServiceStub::GetCatalog(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetCatalogRequest const& request) {
  google::cloud::bigquery::biglake::v1::Catalog response;
  auto status = grpc_stub_->GetCatalog(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::ListCatalogsResponse>
DefaultMetastoreServiceStub::ListCatalogs(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListCatalogsRequest const& request) {
  google::cloud::bigquery::biglake::v1::ListCatalogsResponse response;
  auto status = grpc_stub_->ListCatalogs(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
DefaultMetastoreServiceStub::CreateDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&
        request) {
  google::cloud::bigquery::biglake::v1::Database response;
  auto status = grpc_stub_->CreateDatabase(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
DefaultMetastoreServiceStub::DeleteDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&
        request) {
  google::cloud::bigquery::biglake::v1::Database response;
  auto status = grpc_stub_->DeleteDatabase(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
DefaultMetastoreServiceStub::UpdateDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&
        request) {
  google::cloud::bigquery::biglake::v1::Database response;
  auto status = grpc_stub_->UpdateDatabase(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Database>
DefaultMetastoreServiceStub::GetDatabase(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetDatabaseRequest const& request) {
  google::cloud::bigquery::biglake::v1::Database response;
  auto status = grpc_stub_->GetDatabase(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::ListDatabasesResponse>
DefaultMetastoreServiceStub::ListDatabases(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListDatabasesRequest const& request) {
  google::cloud::bigquery::biglake::v1::ListDatabasesResponse response;
  auto status = grpc_stub_->ListDatabases(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
DefaultMetastoreServiceStub::CreateTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::CreateTableRequest const& request) {
  google::cloud::bigquery::biglake::v1::Table response;
  auto status = grpc_stub_->CreateTable(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
DefaultMetastoreServiceStub::DeleteTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::DeleteTableRequest const& request) {
  google::cloud::bigquery::biglake::v1::Table response;
  auto status = grpc_stub_->DeleteTable(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
DefaultMetastoreServiceStub::UpdateTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::UpdateTableRequest const& request) {
  google::cloud::bigquery::biglake::v1::Table response;
  auto status = grpc_stub_->UpdateTable(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
DefaultMetastoreServiceStub::RenameTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::RenameTableRequest const& request) {
  google::cloud::bigquery::biglake::v1::Table response;
  auto status = grpc_stub_->RenameTable(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::Table>
DefaultMetastoreServiceStub::GetTable(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::GetTableRequest const& request) {
  google::cloud::bigquery::biglake::v1::Table response;
  auto status = grpc_stub_->GetTable(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::bigquery::biglake::v1::ListTablesResponse>
DefaultMetastoreServiceStub::ListTables(
    grpc::ClientContext& context,
    google::cloud::bigquery::biglake::v1::ListTablesRequest const& request) {
  google::cloud::bigquery::biglake::v1::ListTablesResponse response;
  auto status = grpc_stub_->ListTables(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1_internal
}  // namespace cloud
}  // namespace google
