// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/match_service.proto

#include "google/cloud/aiplatform/v1/match_connection.h"
#include "google/cloud/aiplatform/v1/internal/match_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/match_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/match_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/match_tracing_connection.h"
#include "google/cloud/aiplatform/v1/match_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MatchServiceConnection::~MatchServiceConnection() = default;

StatusOr<google::cloud::aiplatform::v1::FindNeighborsResponse>
MatchServiceConnection::FindNeighbors(
    google::cloud::aiplatform::v1::FindNeighborsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::aiplatform::v1::ReadIndexDatapointsResponse>
MatchServiceConnection::ReadIndexDatapoints(
    google::cloud::aiplatform::v1::ReadIndexDatapointsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<MatchServiceConnection> MakeMatchServiceConnection(
    std::string const& location, Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 MatchServicePolicyOptionList>(options,
                                                               __func__);
  options = aiplatform_v1_internal::MatchServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = aiplatform_v1_internal::CreateDefaultMatchServiceStub(
      background->cq(), options);
  return aiplatform_v1_internal::MakeMatchServiceTracingConnection(
      std::make_shared<aiplatform_v1_internal::MatchServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
