// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/advisorynotifications/v1/service.proto

#include "google/cloud/advisorynotifications/v1/internal/advisory_notifications_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/advisorynotifications/v1/service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace advisorynotifications_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

AdvisoryNotificationsServiceLogging::AdvisoryNotificationsServiceLogging(
    std::shared_ptr<AdvisoryNotificationsServiceStub> child,
    TracingOptions tracing_options, std::set<std::string> const& components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      stream_logging_(components.find("rpc-streams") != components.end()) {}

StatusOr<google::cloud::advisorynotifications::v1::ListNotificationsResponse>
AdvisoryNotificationsServiceLogging::ListNotifications(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::ListNotificationsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::advisorynotifications::v1::
                 ListNotificationsRequest const& request) {
        return child_->ListNotifications(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::advisorynotifications::v1::Notification>
AdvisoryNotificationsServiceLogging::GetNotification(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::GetNotificationRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::advisorynotifications::v1::
                 GetNotificationRequest const& request) {
        return child_->GetNotification(context, request);
      },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::advisorynotifications::v1::Settings>
AdvisoryNotificationsServiceLogging::GetSettings(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::GetSettingsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context,
             google::cloud::advisorynotifications::v1::GetSettingsRequest const&
                 request) { return child_->GetSettings(context, request); },
      context, request, __func__, tracing_options_);
}

StatusOr<google::cloud::advisorynotifications::v1::Settings>
AdvisoryNotificationsServiceLogging::UpdateSettings(
    grpc::ClientContext& context,
    google::cloud::advisorynotifications::v1::UpdateSettingsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context,
          google::cloud::advisorynotifications::v1::UpdateSettingsRequest const&
              request) { return child_->UpdateSettings(context, request); },
      context, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace advisorynotifications_v1_internal
}  // namespace cloud
}  // namespace google
