// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/ad_group_bid_modifier.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents an ad group bid modifier.
type AdGroupBidModifier struct {
	// Immutable. The resource name of the ad group bid modifier.
	// Ad group bid modifier resource names have the form:
	//
	// `customers/{customer_id}/adGroupBidModifiers/{ad_group_id}~{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Immutable. The ad group to which this criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,2,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Output only. The ID of the criterion to bid modify.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,3,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. The range is 1.0 - 6.0 for PreferredContent.
	// Use 0 to opt out of a Device type.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// Output only. The base ad group from which this draft/trial adgroup bid modifier was
	// created. If ad_group is a base ad group then this field will be equal to
	// ad_group. If the ad group was created in the draft or trial and has no
	// corresponding base ad group, then this field will be null.
	// This field is readonly.
	BaseAdGroup *wrappers.StringValue `protobuf:"bytes,9,opt,name=base_ad_group,json=baseAdGroup,proto3" json:"base_ad_group,omitempty"`
	// Output only. Bid modifier source.
	BidModifierSource enums.BidModifierSourceEnum_BidModifierSource `protobuf:"varint,10,opt,name=bid_modifier_source,json=bidModifierSource,proto3,enum=google.ads.googleads.v2.enums.BidModifierSourceEnum_BidModifierSource" json:"bid_modifier_source,omitempty"`
	// The criterion of this ad group bid modifier.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupBidModifier_HotelDateSelectionType
	//	*AdGroupBidModifier_HotelAdvanceBookingWindow
	//	*AdGroupBidModifier_HotelLengthOfStay
	//	*AdGroupBidModifier_HotelCheckInDay
	//	*AdGroupBidModifier_Device
	//	*AdGroupBidModifier_PreferredContent
	Criterion            isAdGroupBidModifier_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AdGroupBidModifier) Reset()         { *m = AdGroupBidModifier{} }
func (m *AdGroupBidModifier) String() string { return proto.CompactTextString(m) }
func (*AdGroupBidModifier) ProtoMessage()    {}
func (*AdGroupBidModifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_77d645d3b51cc0a0, []int{0}
}

func (m *AdGroupBidModifier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupBidModifier.Unmarshal(m, b)
}
func (m *AdGroupBidModifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupBidModifier.Marshal(b, m, deterministic)
}
func (m *AdGroupBidModifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupBidModifier.Merge(m, src)
}
func (m *AdGroupBidModifier) XXX_Size() int {
	return xxx_messageInfo_AdGroupBidModifier.Size(m)
}
func (m *AdGroupBidModifier) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupBidModifier.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupBidModifier proto.InternalMessageInfo

func (m *AdGroupBidModifier) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupBidModifier) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupBidModifier) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupBidModifier) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupBidModifier) GetBaseAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.BaseAdGroup
	}
	return nil
}

func (m *AdGroupBidModifier) GetBidModifierSource() enums.BidModifierSourceEnum_BidModifierSource {
	if m != nil {
		return m.BidModifierSource
	}
	return enums.BidModifierSourceEnum_UNSPECIFIED
}

type isAdGroupBidModifier_Criterion interface {
	isAdGroupBidModifier_Criterion()
}

type AdGroupBidModifier_HotelDateSelectionType struct {
	HotelDateSelectionType *common.HotelDateSelectionTypeInfo `protobuf:"bytes,5,opt,name=hotel_date_selection_type,json=hotelDateSelectionType,proto3,oneof"`
}

type AdGroupBidModifier_HotelAdvanceBookingWindow struct {
	HotelAdvanceBookingWindow *common.HotelAdvanceBookingWindowInfo `protobuf:"bytes,6,opt,name=hotel_advance_booking_window,json=hotelAdvanceBookingWindow,proto3,oneof"`
}

type AdGroupBidModifier_HotelLengthOfStay struct {
	HotelLengthOfStay *common.HotelLengthOfStayInfo `protobuf:"bytes,7,opt,name=hotel_length_of_stay,json=hotelLengthOfStay,proto3,oneof"`
}

type AdGroupBidModifier_HotelCheckInDay struct {
	HotelCheckInDay *common.HotelCheckInDayInfo `protobuf:"bytes,8,opt,name=hotel_check_in_day,json=hotelCheckInDay,proto3,oneof"`
}

type AdGroupBidModifier_Device struct {
	Device *common.DeviceInfo `protobuf:"bytes,11,opt,name=device,proto3,oneof"`
}

type AdGroupBidModifier_PreferredContent struct {
	PreferredContent *common.PreferredContentInfo `protobuf:"bytes,12,opt,name=preferred_content,json=preferredContent,proto3,oneof"`
}

func (*AdGroupBidModifier_HotelDateSelectionType) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelAdvanceBookingWindow) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelLengthOfStay) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_HotelCheckInDay) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_Device) isAdGroupBidModifier_Criterion() {}

func (*AdGroupBidModifier_PreferredContent) isAdGroupBidModifier_Criterion() {}

func (m *AdGroupBidModifier) GetCriterion() isAdGroupBidModifier_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelDateSelectionType() *common.HotelDateSelectionTypeInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelDateSelectionType); ok {
		return x.HotelDateSelectionType
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelAdvanceBookingWindow() *common.HotelAdvanceBookingWindowInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelAdvanceBookingWindow); ok {
		return x.HotelAdvanceBookingWindow
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelLengthOfStay() *common.HotelLengthOfStayInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelLengthOfStay); ok {
		return x.HotelLengthOfStay
	}
	return nil
}

func (m *AdGroupBidModifier) GetHotelCheckInDay() *common.HotelCheckInDayInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_HotelCheckInDay); ok {
		return x.HotelCheckInDay
	}
	return nil
}

func (m *AdGroupBidModifier) GetDevice() *common.DeviceInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_Device); ok {
		return x.Device
	}
	return nil
}

func (m *AdGroupBidModifier) GetPreferredContent() *common.PreferredContentInfo {
	if x, ok := m.GetCriterion().(*AdGroupBidModifier_PreferredContent); ok {
		return x.PreferredContent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupBidModifier) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupBidModifier_HotelDateSelectionType)(nil),
		(*AdGroupBidModifier_HotelAdvanceBookingWindow)(nil),
		(*AdGroupBidModifier_HotelLengthOfStay)(nil),
		(*AdGroupBidModifier_HotelCheckInDay)(nil),
		(*AdGroupBidModifier_Device)(nil),
		(*AdGroupBidModifier_PreferredContent)(nil),
	}
}

func init() {
	proto.RegisterType((*AdGroupBidModifier)(nil), "google.ads.googleads.v2.resources.AdGroupBidModifier")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/ad_group_bid_modifier.proto", fileDescriptor_77d645d3b51cc0a0)
}

var fileDescriptor_77d645d3b51cc0a0 = []byte{
	// 794 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0x6f, 0x6f, 0xdb, 0x44,
	0x18, 0x27, 0x09, 0xed, 0xd6, 0x4b, 0x07, 0xd4, 0x20, 0xf0, 0x4a, 0x05, 0xdd, 0xa4, 0x49, 0x15,
	0x68, 0xb6, 0x94, 0x0e, 0x90, 0x8c, 0x26, 0x70, 0x5a, 0xe8, 0x82, 0xf8, 0x53, 0xa5, 0xa8, 0x20,
	0x54, 0xe9, 0x74, 0xf6, 0x3d, 0x71, 0x8e, 0xd9, 0x77, 0xd6, 0xdd, 0x39, 0x55, 0x54, 0xf6, 0x0e,
	0xbe, 0x08, 0x2f, 0xf9, 0x28, 0xbc, 0xe6, 0x03, 0xec, 0xf5, 0x3e, 0x02, 0xaf, 0x90, 0xef, 0x6c,
	0xcf, 0x6d, 0x1a, 0x9a, 0xbd, 0x7b, 0xe2, 0xe7, 0xf7, 0xef, 0xb9, 0xbb, 0xdc, 0xa1, 0xc7, 0x89,
	0x10, 0x49, 0x0a, 0x3e, 0xa1, 0xca, 0xb7, 0x65, 0x59, 0xcd, 0x06, 0xbe, 0x04, 0x25, 0x0a, 0x19,
	0x83, 0xf2, 0x09, 0xc5, 0x89, 0x14, 0x45, 0x8e, 0x23, 0x46, 0x71, 0x26, 0x28, 0x9b, 0x30, 0x90,
	0x5e, 0x2e, 0x85, 0x16, 0xce, 0x3d, 0xcb, 0xf1, 0x08, 0x55, 0x5e, 0x43, 0xf7, 0x66, 0x03, 0xaf,
	0xa1, 0x6f, 0x3f, 0x5c, 0xe6, 0x10, 0x8b, 0x2c, 0x13, 0xdc, 0x8f, 0x25, 0xd3, 0x20, 0x19, 0xb1,
	0x8a, 0xdb, 0x9f, 0x2d, 0x83, 0x03, 0x2f, 0x32, 0xe5, 0xb7, 0x33, 0x60, 0x6b, 0x51, 0x11, 0x3f,
	0xac, 0x89, 0x39, 0xf3, 0x27, 0x0c, 0x52, 0x8a, 0x23, 0x98, 0x92, 0x19, 0x13, 0x55, 0xd6, 0xed,
	0xbb, 0x2d, 0x40, 0x1d, 0xaf, 0x6a, 0x7d, 0x50, 0xb5, 0xcc, 0xaf, 0xa8, 0x98, 0xf8, 0xe7, 0x92,
	0xe4, 0x39, 0x48, 0x55, 0xf5, 0x77, 0x5a, 0x54, 0xc2, 0xb9, 0xd0, 0x44, 0x33, 0xc1, 0xab, 0xee,
	0xfd, 0x7f, 0x10, 0x72, 0x42, 0x7a, 0x54, 0xae, 0xd1, 0x90, 0xd1, 0xef, 0xaa, 0x74, 0xce, 0xcf,
	0xe8, 0x4e, 0x6d, 0x83, 0x39, 0xc9, 0xc0, 0xed, 0xec, 0x76, 0xf6, 0x36, 0x86, 0xfb, 0xcf, 0xc3,
	0xb5, 0x7f, 0xc3, 0x87, 0xe8, 0xe3, 0x97, 0xeb, 0x55, 0x55, 0x39, 0x53, 0x5e, 0x2c, 0x32, 0x7f,
	0x51, 0x6b, 0xbc, 0x59, 0x2b, 0x7d, 0x4f, 0x32, 0x70, 0x08, 0xba, 0x5d, 0x6f, 0x8a, 0xdb, 0xdd,
	0xed, 0xec, 0xf5, 0x07, 0x3b, 0x95, 0x86, 0x57, 0x4f, 0xe0, 0x9d, 0x68, 0xc9, 0x78, 0x72, 0x4a,
	0xd2, 0x02, 0x86, 0x7b, 0xc6, 0xf2, 0x3e, 0xda, 0xbd, 0xc9, 0x72, 0x7c, 0x8b, 0xd8, 0xc2, 0x39,
	0x40, 0x9b, 0xd5, 0xc6, 0x08, 0x8e, 0x19, 0x75, 0x7b, 0xc6, 0xe6, 0xfd, 0x05, 0x9b, 0x11, 0xd7,
	0x9f, 0x3e, 0xb2, 0x2e, 0xbd, 0xe7, 0x61, 0x6f, 0xdc, 0x6f, 0x58, 0x23, 0xea, 0x7c, 0x81, 0x36,
	0xdb, 0xfb, 0xe5, 0xbe, 0xbe, 0x24, 0xeb, 0xa1, 0x28, 0xa2, 0x14, 0x8c, 0xca, 0xb8, 0x1f, 0xb5,
	0x96, 0xf0, 0x57, 0x74, 0x27, 0x22, 0x0a, 0x70, 0x33, 0xed, 0xc6, 0x6a, 0xd3, 0xf6, 0x56, 0x9b,
	0xb6, 0x5f, 0x8a, 0x57, 0x3f, 0x9c, 0x0b, 0xf4, 0xf6, 0x35, 0x87, 0xcb, 0x45, 0xbb, 0x9d, 0xbd,
	0x37, 0x06, 0x5f, 0x7b, 0xcb, 0x0e, 0xba, 0x39, 0x96, 0x5e, 0x6b, 0xaf, 0x4e, 0x0c, 0xef, 0x2b,
	0x5e, 0x64, 0x8b, 0x5f, 0xed, 0x1a, 0x6d, 0x45, 0x57, 0xbf, 0x3b, 0xbf, 0xa1, 0xbb, 0x53, 0xa1,
	0x21, 0xc5, 0x94, 0x68, 0xc0, 0x0a, 0x52, 0x88, 0xcb, 0x13, 0x86, 0xf5, 0x3c, 0x07, 0x77, 0xcd,
	0x0c, 0x1d, 0x2c, 0x8d, 0x60, 0xff, 0x48, 0xde, 0x93, 0x52, 0xe0, 0x90, 0x68, 0x38, 0xa9, 0xe9,
	0x3f, 0xce, 0x73, 0x18, 0xf1, 0x89, 0x28, 0x6d, 0xd7, 0x9e, 0xbc, 0x36, 0x7e, 0x77, 0x7a, 0x2d,
	0xc4, 0xf9, 0xa3, 0x83, 0x76, 0xac, 0x3d, 0xa1, 0x33, 0xc2, 0x63, 0xc0, 0x91, 0x10, 0x4f, 0x19,
	0x4f, 0xf0, 0x39, 0xe3, 0x54, 0x9c, 0xbb, 0xeb, 0x26, 0xc1, 0xe3, 0x95, 0x12, 0x84, 0x56, 0x62,
	0x68, 0x15, 0x7e, 0x32, 0x02, 0xed, 0x10, 0x76, 0xd0, 0xeb, 0x50, 0x4e, 0x86, 0xde, 0xb1, 0x31,
	0x52, 0xe0, 0x89, 0x9e, 0x62, 0x31, 0xc1, 0x4a, 0x93, 0xb9, 0x7b, 0xcb, 0xd8, 0x7f, 0xb2, 0x92,
	0xfd, 0xb7, 0x86, 0xfa, 0xc3, 0xe4, 0x44, 0x93, 0x79, 0xdb, 0x76, 0x6b, 0x7a, 0xb5, 0xeb, 0x24,
	0xc8, 0xb1, 0x76, 0xf1, 0x14, 0xe2, 0xa7, 0x98, 0x71, 0x4c, 0xc9, 0xdc, 0xbd, 0x6d, 0xcc, 0xf6,
	0x57, 0x32, 0x3b, 0x28, 0x89, 0x23, 0x7e, 0x78, 0xd9, 0xea, 0xcd, 0xe9, 0xe5, 0x9e, 0x33, 0x42,
	0xeb, 0x14, 0x66, 0x2c, 0x06, 0xb7, 0x6f, 0xc4, 0x3f, 0xba, 0x49, 0xfc, 0xd0, 0xa0, 0xdb, 0x9a,
	0x95, 0x80, 0x33, 0x45, 0x5b, 0xb9, 0x84, 0x09, 0x48, 0x09, 0x14, 0xc7, 0x82, 0x6b, 0xe0, 0xda,
	0xdd, 0x34, 0xaa, 0x8f, 0x6e, 0x52, 0x3d, 0xae, 0x89, 0x07, 0x96, 0xd7, 0xd6, 0x7f, 0x2b, 0xbf,
	0xd2, 0x0c, 0xe4, 0x8b, 0x50, 0xbc, 0xd2, 0x25, 0xe5, 0x7c, 0x19, 0x17, 0x4a, 0x8b, 0x0c, 0xa4,
	0xf2, 0x2f, 0xea, 0xf2, 0x99, 0x4f, 0x16, 0x80, 0xca, 0xbf, 0xb8, 0xf6, 0x4d, 0x79, 0x36, 0xec,
	0xa3, 0x8d, 0xe6, 0xfe, 0x18, 0xfe, 0xde, 0x45, 0x0f, 0x62, 0x91, 0x79, 0x37, 0x3e, 0x31, 0xc3,
	0xf7, 0x16, 0xc3, 0x1c, 0x97, 0x37, 0xc3, 0x71, 0xe7, 0x97, 0x6f, 0x2a, 0x76, 0x22, 0x52, 0xc2,
	0x13, 0x4f, 0xc8, 0xc4, 0x4f, 0x80, 0x9b, 0x7b, 0xc3, 0x7f, 0x39, 0xd1, 0xff, 0x3c, 0x7f, 0x9f,
	0x37, 0xd5, 0x9f, 0xdd, 0xde, 0x51, 0x18, 0xfe, 0xd5, 0xbd, 0x77, 0x64, 0x25, 0x43, 0xaa, 0x3c,
	0x5b, 0x96, 0xd5, 0xe9, 0xc0, 0x1b, 0xd7, 0xc8, 0xbf, 0x6b, 0xcc, 0x59, 0x48, 0xd5, 0x59, 0x83,
	0x39, 0x3b, 0x1d, 0x9c, 0x35, 0x98, 0x17, 0xdd, 0x07, 0xb6, 0x11, 0x04, 0x21, 0x55, 0x41, 0xd0,
	0xa0, 0x82, 0xe0, 0x74, 0x10, 0x04, 0x0d, 0x2e, 0x5a, 0x37, 0x61, 0xf7, 0xff, 0x0b, 0x00, 0x00,
	0xff, 0xff, 0xd8, 0x2f, 0x35, 0xc9, 0xaa, 0x07, 0x00, 0x00,
}
