// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 4
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
	// OCR text detection and tracking.
	Feature_TEXT_DETECTION Feature = 7
	// Object detection and tracking.
	Feature_OBJECT_TRACKING Feature = 9
	// Logo detection, tracking, and recognition.
	Feature_LOGO_RECOGNITION Feature = 12
)

var Feature_name = map[int32]string{
	0:  "FEATURE_UNSPECIFIED",
	1:  "LABEL_DETECTION",
	2:  "SHOT_CHANGE_DETECTION",
	3:  "EXPLICIT_CONTENT_DETECTION",
	4:  "FACE_DETECTION",
	6:  "SPEECH_TRANSCRIPTION",
	7:  "TEXT_DETECTION",
	9:  "OBJECT_TRACKING",
	12: "LOGO_RECOGNITION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             4,
	"SPEECH_TRANSCRIPTION":       6,
	"TEXT_DETECTION":             7,
	"OBJECT_TRACKING":            9,
	"LOGO_RECOGNITION":           12,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Required. Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional. Location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](https://cloud.google.com/storage/docs/request-endpoints).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional. Cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig,proto3" json:"face_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
	// Config for TEXT_DETECTION.
	TextDetectionConfig *TextDetectionConfig `protobuf:"bytes,8,opt,name=text_detection_config,json=textDetectionConfig,proto3" json:"text_detection_config,omitempty"`
	// Config for OBJECT_TRACKING.
	ObjectTrackingConfig *ObjectTrackingConfig `protobuf:"bytes,13,opt,name=object_tracking_config,json=objectTrackingConfig,proto3" json:"object_tracking_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

func (m *VideoContext) GetTextDetectionConfig() *TextDetectionConfig {
	if m != nil {
		return m.TextDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetObjectTrackingConfig() *ObjectTrackingConfig {
	if m != nil {
		return m.ObjectTrackingConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// frame-level detection. If not set, it is set to 0.4 by default. The valid
	// range for this threshold is [0.1, 0.9]. Any value set outside of this
	// range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	FrameConfidenceThreshold float32 `protobuf:"fixed32,4,opt,name=frame_confidence_threshold,json=frameConfidenceThreshold,proto3" json:"frame_confidence_threshold,omitempty"`
	// The confidence threshold we perform filtering on the labels from
	// video-level and shot-level detections. If not set, it is set to 0.3 by
	// default. The valid range for this threshold is [0.1, 0.9]. Any value set
	// outside of this range will be clipped.
	// Note: for best results please follow the default threshold. We will update
	// the default threshold everytime when we release a new model.
	VideoConfidenceThreshold float32  `protobuf:"fixed32,5,opt,name=video_confidence_threshold,json=videoConfidenceThreshold,proto3" json:"video_confidence_threshold,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{2}
}

func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(m, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *LabelDetectionConfig) GetFrameConfidenceThreshold() float32 {
	if m != nil {
		return m.FrameConfidenceThreshold
	}
	return 0
}

func (m *LabelDetectionConfig) GetVideoConfidenceThreshold() float32 {
	if m != nil {
		return m.VideoConfidenceThreshold
	}
	return 0
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{3}
}

func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(m, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for OBJECT_TRACKING.
type ObjectTrackingConfig struct {
	// Model to use for object tracking.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectTrackingConfig) Reset()         { *m = ObjectTrackingConfig{} }
func (m *ObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingConfig) ProtoMessage()    {}
func (*ObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{4}
}

func (m *ObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingConfig.Unmarshal(m, b)
}
func (m *ObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingConfig.Merge(m, src)
}
func (m *ObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingConfig.Size(m)
}
func (m *ObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingConfig proto.InternalMessageInfo

func (m *ObjectTrackingConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool     `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceDetectionConfig) Reset()         { *m = FaceDetectionConfig{} }
func (m *FaceDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*FaceDetectionConfig) ProtoMessage()    {}
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{5}
}

func (m *FaceDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceDetectionConfig.Unmarshal(m, b)
}
func (m *FaceDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceDetectionConfig.Marshal(b, m, deterministic)
}
func (m *FaceDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceDetectionConfig.Merge(m, src)
}
func (m *FaceDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_FaceDetectionConfig.Size(m)
}
func (m *FaceDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FaceDetectionConfig proto.InternalMessageInfo

func (m *FaceDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{6}
}

func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(m, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for TEXT_DETECTION.
type TextDetectionConfig struct {
	// Language hint can be specified if the language to be detected is known a
	// priori. It can increase the accuracy of the detection. Language hint must
	// be language code in BCP-47 format.
	//
	// Automatic language detection is performed if no hint is provided.
	LanguageHints []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	// Model to use for text detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextDetectionConfig) Reset()         { *m = TextDetectionConfig{} }
func (m *TextDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*TextDetectionConfig) ProtoMessage()    {}
func (*TextDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{7}
}

func (m *TextDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextDetectionConfig.Unmarshal(m, b)
}
func (m *TextDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextDetectionConfig.Marshal(b, m, deterministic)
}
func (m *TextDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextDetectionConfig.Merge(m, src)
}
func (m *TextDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_TextDetectionConfig.Size(m)
}
func (m *TextDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TextDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TextDetectionConfig proto.InternalMessageInfo

func (m *TextDetectionConfig) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

func (m *TextDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{8}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{9}
}

func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (m *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(m, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{10}
}

func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (m *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(m, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{11}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{12}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{13}
}

func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (m *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(m, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{14}
}

func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (m *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(m, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{15}
}

func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(m, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	// Video segment where a face was detected.
	Segment              *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *FaceSegment) Reset()         { *m = FaceSegment{} }
func (m *FaceSegment) String() string { return proto.CompactTextString(m) }
func (*FaceSegment) ProtoMessage()    {}
func (*FaceSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{16}
}

func (m *FaceSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceSegment.Unmarshal(m, b)
}
func (m *FaceSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceSegment.Marshal(b, m, deterministic)
}
func (m *FaceSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceSegment.Merge(m, src)
}
func (m *FaceSegment) XXX_Size() int {
	return xxx_messageInfo_FaceSegment.Size(m)
}
func (m *FaceSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceSegment.DiscardUnknown(m)
}

var xxx_messageInfo_FaceSegment proto.InternalMessageInfo

func (m *FaceSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceFrame struct {
	// Normalized Bounding boxes in a frame.
	// There can be more than one boxes if the same face is detected in multiple
	// locations within the current frame.
	NormalizedBoundingBoxes []*NormalizedBoundingBox `protobuf:"bytes,1,rep,name=normalized_bounding_boxes,json=normalizedBoundingBoxes,proto3" json:"normalized_bounding_boxes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *FaceFrame) Reset()         { *m = FaceFrame{} }
func (m *FaceFrame) String() string { return proto.CompactTextString(m) }
func (*FaceFrame) ProtoMessage()    {}
func (*FaceFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{17}
}

func (m *FaceFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceFrame.Unmarshal(m, b)
}
func (m *FaceFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceFrame.Marshal(b, m, deterministic)
}
func (m *FaceFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceFrame.Merge(m, src)
}
func (m *FaceFrame) XXX_Size() int {
	return xxx_messageInfo_FaceFrame.Size(m)
}
func (m *FaceFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceFrame.DiscardUnknown(m)
}

var xxx_messageInfo_FaceFrame proto.InternalMessageInfo

func (m *FaceFrame) GetNormalizedBoundingBoxes() []*NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBoxes
	}
	return nil
}

func (m *FaceFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format).
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames               []*FaceFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{18}
}

func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (m *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(m, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

func (m *FaceAnnotation) GetSegments() []*FaceSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetFrames() []*FaceFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// For tracking related features.
// An object at time_offset with attributes, and located with
// normalized_bounding_box.
type TimestampedObject struct {
	// Normalized Bounding box in a frame, where the object is located.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this object.
	TimeOffset *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Optional. The attributes of the object in the bounding box.
	Attributes []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. The detected landmarks.
	Landmarks            []*DetectedLandmark `protobuf:"bytes,4,rep,name=landmarks,proto3" json:"landmarks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *TimestampedObject) Reset()         { *m = TimestampedObject{} }
func (m *TimestampedObject) String() string { return proto.CompactTextString(m) }
func (*TimestampedObject) ProtoMessage()    {}
func (*TimestampedObject) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{19}
}

func (m *TimestampedObject) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampedObject.Unmarshal(m, b)
}
func (m *TimestampedObject) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampedObject.Marshal(b, m, deterministic)
}
func (m *TimestampedObject) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampedObject.Merge(m, src)
}
func (m *TimestampedObject) XXX_Size() int {
	return xxx_messageInfo_TimestampedObject.Size(m)
}
func (m *TimestampedObject) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampedObject.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampedObject proto.InternalMessageInfo

func (m *TimestampedObject) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *TimestampedObject) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *TimestampedObject) GetAttributes() []*DetectedAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *TimestampedObject) GetLandmarks() []*DetectedLandmark {
	if m != nil {
		return m.Landmarks
	}
	return nil
}

// A track of an object instance.
type Track struct {
	// Video segment of a track.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// The object with timestamp and attributes per frame in the track.
	TimestampedObjects []*TimestampedObject `protobuf:"bytes,2,rep,name=timestamped_objects,json=timestampedObjects,proto3" json:"timestamped_objects,omitempty"`
	// Optional. Attributes in the track level.
	Attributes []*DetectedAttribute `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. The confidence score of the tracked object.
	Confidence           float32  `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Track) Reset()         { *m = Track{} }
func (m *Track) String() string { return proto.CompactTextString(m) }
func (*Track) ProtoMessage()    {}
func (*Track) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{20}
}

func (m *Track) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Track.Unmarshal(m, b)
}
func (m *Track) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Track.Marshal(b, m, deterministic)
}
func (m *Track) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Track.Merge(m, src)
}
func (m *Track) XXX_Size() int {
	return xxx_messageInfo_Track.Size(m)
}
func (m *Track) XXX_DiscardUnknown() {
	xxx_messageInfo_Track.DiscardUnknown(m)
}

var xxx_messageInfo_Track proto.InternalMessageInfo

func (m *Track) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *Track) GetTimestampedObjects() []*TimestampedObject {
	if m != nil {
		return m.TimestampedObjects
	}
	return nil
}

func (m *Track) GetAttributes() []*DetectedAttribute {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Track) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// A generic detected attribute represented by name in string format.
type DetectedAttribute struct {
	// The name of the attribute, i.e. glasses, dark_glasses, mouth_open etc.
	// A full list of supported type names will be provided in the document.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Detected attribute confidence. Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Text value of the detection result. For example, the value for "HairColor"
	// can be "black", "blonde", etc.
	Value                string   `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectedAttribute) Reset()         { *m = DetectedAttribute{} }
func (m *DetectedAttribute) String() string { return proto.CompactTextString(m) }
func (*DetectedAttribute) ProtoMessage()    {}
func (*DetectedAttribute) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{21}
}

func (m *DetectedAttribute) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedAttribute.Unmarshal(m, b)
}
func (m *DetectedAttribute) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedAttribute.Marshal(b, m, deterministic)
}
func (m *DetectedAttribute) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedAttribute.Merge(m, src)
}
func (m *DetectedAttribute) XXX_Size() int {
	return xxx_messageInfo_DetectedAttribute.Size(m)
}
func (m *DetectedAttribute) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedAttribute.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedAttribute proto.InternalMessageInfo

func (m *DetectedAttribute) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DetectedAttribute) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *DetectedAttribute) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A generic detected landmark represented by name in string format and a 2D
// location.
type DetectedLandmark struct {
	// The name of this landmark, i.e. left_hand, right_shoulder.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The 2D point of the detected landmark using the normalized image
	// coordindate system. The normalized coordinates have the range from 0 to 1.
	Point *NormalizedVertex `protobuf:"bytes,2,opt,name=point,proto3" json:"point,omitempty"`
	// The confidence score of the detected landmark. Range [0, 1].
	Confidence           float32  `protobuf:"fixed32,3,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectedLandmark) Reset()         { *m = DetectedLandmark{} }
func (m *DetectedLandmark) String() string { return proto.CompactTextString(m) }
func (*DetectedLandmark) ProtoMessage()    {}
func (*DetectedLandmark) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{22}
}

func (m *DetectedLandmark) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectedLandmark.Unmarshal(m, b)
}
func (m *DetectedLandmark) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectedLandmark.Marshal(b, m, deterministic)
}
func (m *DetectedLandmark) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectedLandmark.Merge(m, src)
}
func (m *DetectedLandmark) XXX_Size() int {
	return xxx_messageInfo_DetectedLandmark.Size(m)
}
func (m *DetectedLandmark) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectedLandmark.DiscardUnknown(m)
}

var xxx_messageInfo_DetectedLandmark proto.InternalMessageInfo

func (m *DetectedLandmark) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DetectedLandmark) GetPoint() *NormalizedVertex {
	if m != nil {
		return m.Point
	}
	return nil
}

func (m *DetectedLandmark) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Video segment on which the annotation is run.
	Segment *VideoSegment `protobuf:"bytes,10,opt,name=segment,proto3" json:"segment,omitempty"`
	// Topical label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Presence label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label. Compared to the
	// existing topical `segment_label_annotations`, this field presents more
	// fine-grained, segment-level labels detected in video content and is made
	// available only when the client sets `LabelDetectionConfig.model` to
	// "builtin/latest" in the request.
	SegmentPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,23,rep,name=segment_presence_label_annotations,json=segmentPresenceLabelAnnotations,proto3" json:"segment_presence_label_annotations,omitempty"`
	// Topical label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Presence label annotations on shot level. There is exactly one element for
	// each unique label. Compared to the existing topical
	// `shot_label_annotations`, this field presents more fine-grained, shot-level
	// labels detected in video content and is made available only when the client
	// sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
	ShotPresenceLabelAnnotations []*LabelAnnotation `protobuf:"bytes,24,rep,name=shot_presence_label_annotations,json=shotPresenceLabelAnnotations,proto3" json:"shot_presence_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,5,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// OCR text detection and tracking.
	// Annotations for list of detected text snippets. Each will have list of
	// frame information associated with it.
	TextAnnotations []*TextAnnotation `protobuf:"bytes,12,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// Annotations for list of objects detected and tracked in video.
	ObjectAnnotations []*ObjectTrackingAnnotation `protobuf:"bytes,14,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	// Annotations for list of logos detected, tracked and recognized in video.
	LogoRecognitionAnnotations []*LogoRecognitionAnnotation `protobuf:"bytes,19,rep,name=logo_recognition_annotations,json=logoRecognitionAnnotations,proto3" json:"logo_recognition_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{23}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetSegmentPresenceLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentPresenceLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotPresenceLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotPresenceLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetTextAnnotations() []*TextAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetLogoRecognitionAnnotations() []*LogoRecognitionAnnotation {
	if m != nil {
		return m.LogoRecognitionAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{24}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Specifies which feature is being tracked if the request contains more than
	// one features.
	Feature Feature `protobuf:"varint,5,opt,name=feature,proto3,enum=google.cloud.videointelligence.v1.Feature" json:"feature,omitempty"`
	// Specifies which segment is being tracked if the request contains more than
	// one segments.
	Segment              *VideoSegment `protobuf:"bytes,6,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{25}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetFeature() Feature {
	if m != nil {
		return m.Feature
	}
	return Feature_FEATURE_UNSPECIFIED
}

func (m *VideoAnnotationProgress) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{26}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// Required. *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechTranscription`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// Optional. If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// Optional. A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// Optional. If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// Optional. For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
	// Optional. If 'true', enables speaker detection for each recognized word in
	// the top alternative of the recognition result using a speaker_tag provided
	// in the WordInfo.
	// Note: When this is true, we send all the words from the beginning of the
	// audio for the top alternative in every consecutive responses.
	// This is done in order to improve our speaker tags as our models learn to
	// identify the speakers in the conversation over time.
	EnableSpeakerDiarization bool `protobuf:"varint,7,opt,name=enable_speaker_diarization,json=enableSpeakerDiarization,proto3" json:"enable_speaker_diarization,omitempty"`
	// Optional. If set, specifies the estimated number of speakers in the conversation.
	// If not set, defaults to '2'.
	// Ignored unless enable_speaker_diarization is set to true.
	DiarizationSpeakerCount int32 `protobuf:"varint,8,opt,name=diarization_speaker_count,json=diarizationSpeakerCount,proto3" json:"diarization_speaker_count,omitempty"`
	// Optional. If `true`, the top result includes a list of words and the
	// confidence for those words. If `false`, no word-level confidence
	// information is returned. The default is `false`.
	EnableWordConfidence bool     `protobuf:"varint,9,opt,name=enable_word_confidence,json=enableWordConfidence,proto3" json:"enable_word_confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscriptionConfig) Reset()         { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()    {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{27}
}

func (m *SpeechTranscriptionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscriptionConfig.Unmarshal(m, b)
}
func (m *SpeechTranscriptionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscriptionConfig.Marshal(b, m, deterministic)
}
func (m *SpeechTranscriptionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscriptionConfig.Merge(m, src)
}
func (m *SpeechTranscriptionConfig) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscriptionConfig.Size(m)
}
func (m *SpeechTranscriptionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscriptionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscriptionConfig proto.InternalMessageInfo

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if m != nil {
		return m.EnableAutomaticPunctuation
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableSpeakerDiarization() bool {
	if m != nil {
		return m.EnableSpeakerDiarization
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetDiarizationSpeakerCount() int32 {
	if m != nil {
		return m.DiarizationSpeakerCount
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetEnableWordConfidence() bool {
	if m != nil {
		return m.EnableWordConfidence
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// Optional. A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{28}
}

func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (m *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(m, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// May contain one or more recognition hypotheses (up to the maximum specified
	// in `max_alternatives`).  These alternatives are ordered in terms of
	// accuracy, with the top (first) alternative being the most probable, as
	// ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// Output only. The [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag of
	// the language in this result. This language code was detected to have the
	// most likelihood of being spoken in the audio.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscription) Reset()         { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()    {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{29}
}

func (m *SpeechTranscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscription.Unmarshal(m, b)
}
func (m *SpeechTranscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscription.Marshal(b, m, deterministic)
}
func (m *SpeechTranscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscription.Merge(m, src)
}
func (m *SpeechTranscription) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscription.Size(m)
}
func (m *SpeechTranscription) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscription.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscription proto.InternalMessageInfo

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

func (m *SpeechTranscription) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	// Note: When `enable_speaker_diarization` is true, you will see all the words
	// from the beginning of the audio.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{30}
}

func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (m *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(m, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A distinct integer value is assigned for every speaker within
	// the audio. This field specifies which one of those speakers was detected to
	// have spoken this word. Value ranges from 1 up to diarization_speaker_count,
	// and is only set if speaker diarization is enabled.
	SpeakerTag           int32    `protobuf:"varint,5,opt,name=speaker_tag,json=speakerTag,proto3" json:"speaker_tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{31}
}

func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (m *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(m, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func (m *WordInfo) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *WordInfo) GetSpeakerTag() int32 {
	if m != nil {
		return m.SpeakerTag
	}
	return 0
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y                    float32  `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedVertex) Reset()         { *m = NormalizedVertex{} }
func (m *NormalizedVertex) String() string { return proto.CompactTextString(m) }
func (*NormalizedVertex) ProtoMessage()    {}
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{32}
}

func (m *NormalizedVertex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedVertex.Unmarshal(m, b)
}
func (m *NormalizedVertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedVertex.Marshal(b, m, deterministic)
}
func (m *NormalizedVertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedVertex.Merge(m, src)
}
func (m *NormalizedVertex) XXX_Size() int {
	return xxx_messageInfo_NormalizedVertex.Size(m)
}
func (m *NormalizedVertex) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedVertex.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedVertex proto.InternalMessageInfo

func (m *NormalizedVertex) GetX() float32 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *NormalizedVertex) GetY() float32 {
	if m != nil {
		return m.Y
	}
	return 0
}

// Normalized bounding polygon for text (that might not be aligned with axis).
// Contains list of the corner points in clockwise order starting from
// top-left corner. For example, for a rectangular bounding box:
// When the text is horizontal it might look like:
//         0----1
//         |    |
//         3----2
//
// When it's clockwise rotated 180 degrees around the top-left corner it
// becomes:
//         2----3
//         |    |
//         1----0
//
// and the vertex order will still be (0, 1, 2, 3). Note that values can be less
// than 0, or greater than 1 due to trignometric calculations for location of
// the box.
type NormalizedBoundingPoly struct {
	// Normalized vertices of the bounding polygon.
	Vertices             []*NormalizedVertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NormalizedBoundingPoly) Reset()         { *m = NormalizedBoundingPoly{} }
func (m *NormalizedBoundingPoly) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingPoly) ProtoMessage()    {}
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{33}
}

func (m *NormalizedBoundingPoly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingPoly.Unmarshal(m, b)
}
func (m *NormalizedBoundingPoly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingPoly.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingPoly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingPoly.Merge(m, src)
}
func (m *NormalizedBoundingPoly) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingPoly.Size(m)
}
func (m *NormalizedBoundingPoly) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingPoly.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingPoly proto.InternalMessageInfo

func (m *NormalizedBoundingPoly) GetVertices() []*NormalizedVertex {
	if m != nil {
		return m.Vertices
	}
	return nil
}

// Video segment level annotation results for text detection.
type TextSegment struct {
	// Video segment where a text snippet was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence for the track of detected text. It is calculated as the highest
	// over all frames where OCR detected text appears.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information related to the frames where OCR detected text appears.
	Frames               []*TextFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *TextSegment) Reset()         { *m = TextSegment{} }
func (m *TextSegment) String() string { return proto.CompactTextString(m) }
func (*TextSegment) ProtoMessage()    {}
func (*TextSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{34}
}

func (m *TextSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextSegment.Unmarshal(m, b)
}
func (m *TextSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextSegment.Marshal(b, m, deterministic)
}
func (m *TextSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextSegment.Merge(m, src)
}
func (m *TextSegment) XXX_Size() int {
	return xxx_messageInfo_TextSegment.Size(m)
}
func (m *TextSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_TextSegment.DiscardUnknown(m)
}

var xxx_messageInfo_TextSegment proto.InternalMessageInfo

func (m *TextSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *TextSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *TextSegment) GetFrames() []*TextFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for text annotation (OCR).
// Contains information regarding timestamp and bounding box locations for the
// frames containing detected OCR text snippets.
type TextFrame struct {
	// Bounding polygon of the detected text for this frame.
	RotatedBoundingBox *NormalizedBoundingPoly `protobuf:"bytes,1,opt,name=rotated_bounding_box,json=rotatedBoundingBox,proto3" json:"rotated_bounding_box,omitempty"`
	// Timestamp of this frame.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TextFrame) Reset()         { *m = TextFrame{} }
func (m *TextFrame) String() string { return proto.CompactTextString(m) }
func (*TextFrame) ProtoMessage()    {}
func (*TextFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{35}
}

func (m *TextFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextFrame.Unmarshal(m, b)
}
func (m *TextFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextFrame.Marshal(b, m, deterministic)
}
func (m *TextFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextFrame.Merge(m, src)
}
func (m *TextFrame) XXX_Size() int {
	return xxx_messageInfo_TextFrame.Size(m)
}
func (m *TextFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_TextFrame.DiscardUnknown(m)
}

var xxx_messageInfo_TextFrame proto.InternalMessageInfo

func (m *TextFrame) GetRotatedBoundingBox() *NormalizedBoundingPoly {
	if m != nil {
		return m.RotatedBoundingBox
	}
	return nil
}

func (m *TextFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations related to one detected OCR text snippet. This will contain the
// corresponding text, confidence value, and frame level information for each
// detection.
type TextAnnotation struct {
	// The detected text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// All video segments where OCR detected text appears.
	Segments             []*TextSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TextAnnotation) Reset()         { *m = TextAnnotation{} }
func (m *TextAnnotation) String() string { return proto.CompactTextString(m) }
func (*TextAnnotation) ProtoMessage()    {}
func (*TextAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{36}
}

func (m *TextAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAnnotation.Unmarshal(m, b)
}
func (m *TextAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAnnotation.Marshal(b, m, deterministic)
}
func (m *TextAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAnnotation.Merge(m, src)
}
func (m *TextAnnotation) XXX_Size() int {
	return xxx_messageInfo_TextAnnotation.Size(m)
}
func (m *TextAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TextAnnotation proto.InternalMessageInfo

func (m *TextAnnotation) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextAnnotation) GetSegments() []*TextSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

// Video frame level annotations for object detection and tracking. This field
// stores per frame location, time offset, and confidence.
type ObjectTrackingFrame struct {
	// The normalized bounding box location of this object track for the frame.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// The timestamp of the frame in microseconds.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ObjectTrackingFrame) Reset()         { *m = ObjectTrackingFrame{} }
func (m *ObjectTrackingFrame) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingFrame) ProtoMessage()    {}
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{37}
}

func (m *ObjectTrackingFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingFrame.Unmarshal(m, b)
}
func (m *ObjectTrackingFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingFrame.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingFrame.Merge(m, src)
}
func (m *ObjectTrackingFrame) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingFrame.Size(m)
}
func (m *ObjectTrackingFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingFrame proto.InternalMessageInfo

func (m *ObjectTrackingFrame) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *ObjectTrackingFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations corresponding to one tracked object.
type ObjectTrackingAnnotation struct {
	// Different representation of tracking info in non-streaming batch
	// and streaming modes.
	//
	// Types that are valid to be assigned to TrackInfo:
	//	*ObjectTrackingAnnotation_Segment
	//	*ObjectTrackingAnnotation_TrackId
	TrackInfo isObjectTrackingAnnotation_TrackInfo `protobuf_oneof:"track_info"`
	// Entity to specify the object category that this track is labeled as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Object category's labeling confidence of this track.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information corresponding to all frames where this object track appears.
	// Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
	// messages in frames.
	// Streaming mode: it can only be one ObjectTrackingFrame message in frames.
	Frames               []*ObjectTrackingFrame `protobuf:"bytes,2,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ObjectTrackingAnnotation) Reset()         { *m = ObjectTrackingAnnotation{} }
func (m *ObjectTrackingAnnotation) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingAnnotation) ProtoMessage()    {}
func (*ObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{38}
}

func (m *ObjectTrackingAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingAnnotation.Unmarshal(m, b)
}
func (m *ObjectTrackingAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingAnnotation.Marshal(b, m, deterministic)
}
func (m *ObjectTrackingAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingAnnotation.Merge(m, src)
}
func (m *ObjectTrackingAnnotation) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingAnnotation.Size(m)
}
func (m *ObjectTrackingAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingAnnotation proto.InternalMessageInfo

type isObjectTrackingAnnotation_TrackInfo interface {
	isObjectTrackingAnnotation_TrackInfo()
}

type ObjectTrackingAnnotation_Segment struct {
	Segment *VideoSegment `protobuf:"bytes,3,opt,name=segment,proto3,oneof"`
}

type ObjectTrackingAnnotation_TrackId struct {
	TrackId int64 `protobuf:"varint,5,opt,name=track_id,json=trackId,proto3,oneof"`
}

func (*ObjectTrackingAnnotation_Segment) isObjectTrackingAnnotation_TrackInfo() {}

func (*ObjectTrackingAnnotation_TrackId) isObjectTrackingAnnotation_TrackInfo() {}

func (m *ObjectTrackingAnnotation) GetTrackInfo() isObjectTrackingAnnotation_TrackInfo {
	if m != nil {
		return m.TrackInfo
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetSegment() *VideoSegment {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_Segment); ok {
		return x.Segment
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetTrackId() int64 {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_TrackId); ok {
		return x.TrackId
	}
	return 0
}

func (m *ObjectTrackingAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *ObjectTrackingAnnotation) GetFrames() []*ObjectTrackingFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ObjectTrackingAnnotation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ObjectTrackingAnnotation_Segment)(nil),
		(*ObjectTrackingAnnotation_TrackId)(nil),
	}
}

// Annotation corresponding to one detected, tracked and recognized logo class.
type LogoRecognitionAnnotation struct {
	// Entity category information to specify the logo class that all the logo
	// tracks within this LogoRecognitionAnnotation are recognized as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// All logo tracks where the recognized logo appears. Each track corresponds
	// to one logo instance appearing in consecutive frames.
	Tracks []*Track `protobuf:"bytes,2,rep,name=tracks,proto3" json:"tracks,omitempty"`
	// All video segments where the recognized logo appears. There might be
	// multiple instances of the same logo class appearing in one VideoSegment.
	Segments             []*VideoSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *LogoRecognitionAnnotation) Reset()         { *m = LogoRecognitionAnnotation{} }
func (m *LogoRecognitionAnnotation) String() string { return proto.CompactTextString(m) }
func (*LogoRecognitionAnnotation) ProtoMessage()    {}
func (*LogoRecognitionAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7638dbca9a7e63fa, []int{39}
}

func (m *LogoRecognitionAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogoRecognitionAnnotation.Unmarshal(m, b)
}
func (m *LogoRecognitionAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogoRecognitionAnnotation.Marshal(b, m, deterministic)
}
func (m *LogoRecognitionAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogoRecognitionAnnotation.Merge(m, src)
}
func (m *LogoRecognitionAnnotation) XXX_Size() int {
	return xxx_messageInfo_LogoRecognitionAnnotation.Size(m)
}
func (m *LogoRecognitionAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LogoRecognitionAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LogoRecognitionAnnotation proto.InternalMessageInfo

func (m *LogoRecognitionAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LogoRecognitionAnnotation) GetTracks() []*Track {
	if m != nil {
		return m.Tracks
	}
	return nil
}

func (m *LogoRecognitionAnnotation) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1.ShotChangeDetectionConfig")
	proto.RegisterType((*ObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1.ObjectTrackingConfig")
	proto.RegisterType((*FaceDetectionConfig)(nil), "google.cloud.videointelligence.v1.FaceDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1.ExplicitContentDetectionConfig")
	proto.RegisterType((*TextDetectionConfig)(nil), "google.cloud.videointelligence.v1.TextDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1.NormalizedBoundingBox")
	proto.RegisterType((*FaceSegment)(nil), "google.cloud.videointelligence.v1.FaceSegment")
	proto.RegisterType((*FaceFrame)(nil), "google.cloud.videointelligence.v1.FaceFrame")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1.FaceAnnotation")
	proto.RegisterType((*TimestampedObject)(nil), "google.cloud.videointelligence.v1.TimestampedObject")
	proto.RegisterType((*Track)(nil), "google.cloud.videointelligence.v1.Track")
	proto.RegisterType((*DetectedAttribute)(nil), "google.cloud.videointelligence.v1.DetectedAttribute")
	proto.RegisterType((*DetectedLandmark)(nil), "google.cloud.videointelligence.v1.DetectedLandmark")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1.WordInfo")
	proto.RegisterType((*NormalizedVertex)(nil), "google.cloud.videointelligence.v1.NormalizedVertex")
	proto.RegisterType((*NormalizedBoundingPoly)(nil), "google.cloud.videointelligence.v1.NormalizedBoundingPoly")
	proto.RegisterType((*TextSegment)(nil), "google.cloud.videointelligence.v1.TextSegment")
	proto.RegisterType((*TextFrame)(nil), "google.cloud.videointelligence.v1.TextFrame")
	proto.RegisterType((*TextAnnotation)(nil), "google.cloud.videointelligence.v1.TextAnnotation")
	proto.RegisterType((*ObjectTrackingFrame)(nil), "google.cloud.videointelligence.v1.ObjectTrackingFrame")
	proto.RegisterType((*ObjectTrackingAnnotation)(nil), "google.cloud.videointelligence.v1.ObjectTrackingAnnotation")
	proto.RegisterType((*LogoRecognitionAnnotation)(nil), "google.cloud.videointelligence.v1.LogoRecognitionAnnotation")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1/video_intelligence.proto", fileDescriptor_7638dbca9a7e63fa)
}

var fileDescriptor_7638dbca9a7e63fa = []byte{
	// 2985 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5a, 0xcd, 0x73, 0xe3, 0xc6,
	0xb1, 0x37, 0x40, 0x7d, 0xb6, 0xbe, 0xb8, 0x23, 0x4a, 0xa2, 0xe4, 0xf5, 0x5a, 0x86, 0xd7, 0xaf,
	0xd6, 0x6b, 0x9b, 0x7a, 0xbb, 0xf6, 0xb3, 0xbd, 0xb2, 0xab, 0xfc, 0x28, 0x8a, 0xda, 0xa5, 0x57,
	0x16, 0x55, 0x10, 0x57, 0xcf, 0x76, 0xed, 0x0b, 0x0a, 0x02, 0x86, 0x24, 0x2c, 0x10, 0xc3, 0x00,
	0x43, 0xad, 0xe4, 0xca, 0x47, 0x25, 0x95, 0x5b, 0x72, 0x49, 0xe5, 0x92, 0x4b, 0x6e, 0x39, 0x25,
	0xc7, 0xe4, 0x90, 0x1c, 0xe2, 0x72, 0x55, 0xca, 0x17, 0x57, 0x72, 0x49, 0x4e, 0xc9, 0x25, 0x39,
	0xe4, 0xe4, 0xaa, 0xdc, 0xf2, 0x07, 0xa4, 0xe6, 0x03, 0x1f, 0x24, 0xc8, 0x15, 0xa4, 0xdd, 0xa4,
	0x2a, 0x37, 0xa0, 0xa7, 0xfb, 0xd7, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x0d, 0xc0, 0x66, 0x8b, 0x90,
	0x96, 0x8b, 0x37, 0x2c, 0x97, 0xf4, 0xec, 0x8d, 0x13, 0xc7, 0xc6, 0xc4, 0xf1, 0x28, 0x76, 0x5d,
	0xa7, 0x85, 0x3d, 0x0b, 0x6f, 0x9c, 0xdc, 0x12, 0x44, 0x23, 0x49, 0x2d, 0x75, 0x7d, 0x42, 0x09,
	0x7a, 0x41, 0xc8, 0x96, 0xb8, 0x6c, 0x29, 0x25, 0x5b, 0x3a, 0xb9, 0xb5, 0x76, 0x55, 0xc2, 0x9b,
	0x5d, 0x67, 0xc3, 0xf4, 0x3c, 0x42, 0x4d, 0xea, 0x10, 0x2f, 0x10, 0x00, 0x6b, 0x2b, 0x89, 0x51,
	0xcb, 0x75, 0xb0, 0x47, 0xe5, 0xc0, 0xf3, 0x89, 0x81, 0xa6, 0x83, 0x5d, 0xdb, 0x38, 0xc2, 0x6d,
	0xf3, 0xc4, 0x21, 0xbe, 0x64, 0x78, 0x51, 0x32, 0xb8, 0xc4, 0x6b, 0xf9, 0x3d, 0xcf, 0x73, 0xbc,
	0xd6, 0x06, 0xe9, 0x62, 0xbf, 0x0f, 0xfe, 0x9a, 0x64, 0xe2, 0x6f, 0x47, 0xbd, 0xe6, 0x86, 0xdd,
	0x13, 0x0c, 0x03, 0x5a, 0xa2, 0x71, 0xea, 0x74, 0x70, 0x40, 0xcd, 0x4e, 0x77, 0xc0, 0x3e, 0xbf,
	0x6b, 0x6d, 0x04, 0xd4, 0xa4, 0x3d, 0x89, 0xac, 0x7d, 0xa1, 0x42, 0xa1, 0x2c, 0xa6, 0x83, 0x0f,
	0xd9, 0xbc, 0x75, 0xfc, 0xf5, 0x1e, 0x0e, 0x28, 0x7a, 0x16, 0xa6, 0x1d, 0xaf, 0xdb, 0xa3, 0x46,
	0xcf, 0x77, 0x8a, 0xca, 0xba, 0x72, 0x63, 0x5a, 0x9f, 0xe2, 0x84, 0x07, 0xbe, 0x83, 0x5e, 0x84,
	0x39, 0x31, 0x68, 0x11, 0x8f, 0x62, 0x8f, 0x16, 0x27, 0xd6, 0x95, 0x1b, 0xb3, 0xfa, 0x2c, 0x27,
	0x56, 0x04, 0x0d, 0xdd, 0x87, 0xa9, 0x26, 0x36, 0x69, 0xcf, 0xc7, 0x41, 0x51, 0x5d, 0xcf, 0xdd,
	0x98, 0xbf, 0x7d, 0xb3, 0x74, 0xae, 0x9f, 0x4b, 0x3b, 0x42, 0x64, 0x2b, 0xf7, 0xd7, 0xb2, 0xaa,
	0x47, 0x00, 0xa8, 0x01, 0x73, 0x62, 0xf5, 0xb8, 0xc6, 0x53, 0x5a, 0xcc, 0xad, 0x2b, 0x37, 0x66,
	0x6e, 0x6f, 0x64, 0x40, 0xe4, 0xd3, 0xaa, 0x08, 0x31, 0x7d, 0xf6, 0x24, 0xf1, 0x86, 0x34, 0x00,
	0xd2, 0xa3, 0xe1, 0x2c, 0xc7, 0xd8, 0x2c, 0x99, 0x62, 0x45, 0x9f, 0x16, 0x64, 0x36, 0xd7, 0xeb,
	0x30, 0xe3, 0x12, 0x8b, 0x7b, 0xdb, 0x70, 0xec, 0xe2, 0x78, 0xcc, 0x04, 0x21, 0xbd, 0x66, 0x6b,
	0x3f, 0x99, 0x84, 0xd9, 0xa4, 0x22, 0x36, 0xfb, 0x00, 0xb7, 0x3a, 0xd8, 0xa3, 0x41, 0x51, 0x59,
	0xcf, 0x5d, 0xc4, 0xd6, 0x03, 0x21, 0xa7, 0x47, 0x00, 0xa8, 0x03, 0xcb, 0xae, 0x79, 0x84, 0x5d,
	0xc3, 0xc6, 0x14, 0x5b, 0xdc, 0x14, 0x8b, 0x78, 0x4d, 0xa7, 0x55, 0x54, 0xb9, 0x1b, 0xde, 0xca,
	0x00, 0xbd, 0xcb, 0x00, 0xb6, 0x43, 0xf9, 0x0a, 0x17, 0xd7, 0x0b, 0xee, 0x10, 0x2a, 0xfa, 0x26,
	0x5c, 0x0d, 0xda, 0x84, 0x1a, 0x56, 0xdb, 0xf4, 0x5a, 0x38, 0xad, 0x54, 0xf8, 0xfe, 0xdd, 0x0c,
	0x4a, 0x0f, 0xda, 0x84, 0x56, 0x38, 0xca, 0xa0, 0xe6, 0xd5, 0x60, 0xd4, 0x10, 0xfa, 0x81, 0x02,
	0x2f, 0xe0, 0xd3, 0xae, 0xeb, 0x58, 0x4e, 0x14, 0x61, 0x69, 0x23, 0xc6, 0xb8, 0x11, 0xe5, 0x0c,
	0x46, 0x54, 0x25, 0x96, 0x0c, 0xcc, 0x41, 0x4b, 0xae, 0xe1, 0xc7, 0x8e, 0xa3, 0x4f, 0x60, 0xa9,
	0x69, 0x5a, 0x43, 0xdc, 0x30, 0xce, 0x2d, 0x78, 0x33, 0x4b, 0x50, 0x9b, 0x56, 0xca, 0x01, 0x8b,
	0xcd, 0x34, 0x11, 0x7d, 0x03, 0x9e, 0x0d, 0xba, 0x18, 0x5b, 0x6d, 0x83, 0xfa, 0xa6, 0x17, 0x58,
	0xbe, 0xd3, 0x4d, 0x6a, 0x9c, 0xc8, 0xee, 0x78, 0x8e, 0xd2, 0x48, 0x82, 0x44, 0x8e, 0x1f, 0x35,
	0xc4, 0x66, 0xca, 0x62, 0x37, 0x3d, 0xd3, 0xa9, 0xcc, 0x33, 0x6d, 0xe0, 0xd3, 0x94, 0x83, 0x17,
	0x69, 0x9a, 0xc8, 0x42, 0x9a, 0x1c, 0x7d, 0x82, 0x2d, 0xca, 0x66, 0x6a, 0x1d, 0x3b, 0x5e, 0x2b,
	0x54, 0x36, 0x97, 0x39, 0xa4, 0xeb, 0x1c, 0xa0, 0x21, 0xe5, 0xc3, 0x90, 0x26, 0x43, 0xa8, 0xda,
	0x67, 0x2a, 0x14, 0x86, 0xed, 0x00, 0xd4, 0x82, 0xc2, 0xe0, 0xd6, 0xea, 0x10, 0x1b, 0xf3, 0x94,
	0x37, 0x7f, 0xfb, 0x7f, 0x2e, 0xbc, 0xb1, 0x3e, 0x20, 0x36, 0xd6, 0x91, 0x9b, 0xa2, 0xa1, 0x57,
	0xe0, 0x4a, 0x20, 0x0e, 0x0d, 0xd3, 0x3f, 0x33, 0x2c, 0xb3, 0x83, 0x7d, 0x93, 0x6f, 0xdf, 0x29,
	0x3d, 0x1f, 0x0f, 0x54, 0x38, 0x1d, 0x15, 0x60, 0x9c, 0x59, 0xe1, 0xf2, 0xad, 0x36, 0xad, 0x8b,
	0x17, 0xf4, 0x2e, 0xac, 0x35, 0x7d, 0xb3, 0x83, 0x85, 0xa7, 0x6c, 0x66, 0x80, 0x41, 0xdb, 0x3e,
	0x0e, 0xda, 0xc4, 0xb5, 0xf9, 0x86, 0x50, 0xf5, 0x22, 0xe7, 0xa8, 0x44, 0x0c, 0x8d, 0x70, 0x9c,
	0x49, 0x47, 0x29, 0x34, 0x2d, 0x3d, 0x2e, 0xa4, 0xc3, 0xf4, 0x38, 0x28, 0xad, 0xdd, 0x82, 0xd5,
	0x91, 0x9b, 0x39, 0x36, 0x57, 0x49, 0x98, 0xab, 0xbd, 0x0a, 0x85, 0x61, 0x2b, 0x34, 0x82, 0xdb,
	0x84, 0xc5, 0x21, 0xdb, 0x64, 0x38, 0x33, 0x7a, 0x03, 0x96, 0x1d, 0xcf, 0x72, 0x7b, 0x36, 0x36,
	0x8e, 0x48, 0xcf, 0xb3, 0x59, 0xf8, 0x1c, 0x91, 0x53, 0x7e, 0xd2, 0x30, 0x8f, 0x16, 0xe4, 0xe8,
	0x96, 0x1c, 0xdc, 0x62, 0x63, 0xda, 0x9b, 0x70, 0xed, 0xf1, 0xb9, 0x60, 0x84, 0x69, 0x3a, 0x2c,
	0x0e, 0x89, 0x6b, 0xf4, 0x12, 0xcc, 0xbb, 0xa6, 0xd7, 0xea, 0x99, 0x2d, 0x6c, 0xb4, 0x9d, 0x30,
	0xd1, 0x4f, 0xeb, 0x73, 0x21, 0xf5, 0x1e, 0x23, 0xc6, 0x98, 0x6a, 0x12, 0xf3, 0xc7, 0x8a, 0x3c,
	0x30, 0x64, 0xb6, 0x47, 0x55, 0x1e, 0x1f, 0x3e, 0x35, 0xd8, 0xd9, 0x6d, 0x90, 0x66, 0x33, 0xc0,
	0x94, 0x9b, 0x31, 0x73, 0x7b, 0x35, 0x8c, 0xc2, 0xf0, 0x7c, 0x2f, 0x6d, 0xcb, 0xf3, 0x5f, 0x5f,
	0xe0, 0x32, 0x0d, 0xa7, 0x83, 0xeb, 0x5c, 0x02, 0x95, 0x61, 0x01, 0x7b, 0x76, 0x1f, 0x88, 0x7a,
	0x1e, 0xc8, 0x1c, 0xf6, 0xec, 0x18, 0x42, 0x3b, 0x83, 0x59, 0x1e, 0xd3, 0xa1, 0x65, 0x35, 0x98,
	0x94, 0x27, 0x91, 0xb4, 0xe7, 0xc2, 0x27, 0x59, 0x28, 0x8f, 0xae, 0x01, 0xc4, 0xd1, 0xc7, 0x0d,
	0x53, 0xf5, 0x04, 0x45, 0x6b, 0x03, 0x70, 0xd5, 0x3b, 0x2c, 0x88, 0xd1, 0x26, 0xcc, 0x5c, 0xc8,
	0x19, 0x40, 0x63, 0x3f, 0x9c, 0xa7, 0xc9, 0x85, 0x89, 0xaa, 0x47, 0x1d, 0x7a, 0xc6, 0x2a, 0x1d,
	0xcc, 0x9f, 0xd8, 0xf1, 0x2e, 0x2b, 0x1d, 0x41, 0xa8, 0xd9, 0x68, 0x1d, 0x66, 0x6c, 0x1c, 0xe5,
	0x49, 0xb9, 0x84, 0x49, 0x12, 0xab, 0x85, 0xa2, 0x28, 0xb0, 0x58, 0xe6, 0x10, 0x5b, 0x76, 0x36,
	0x24, 0x56, 0x88, 0x8d, 0xb5, 0xcf, 0x55, 0x58, 0xe0, 0x13, 0x2b, 0x47, 0xa5, 0x23, 0x2a, 0xc3,
	0x84, 0x50, 0x23, 0x27, 0xf6, 0x72, 0x96, 0xa3, 0x8c, 0x0b, 0xe8, 0x52, 0x10, 0x1d, 0xc2, 0x15,
	0xcb, 0xa4, 0xb8, 0x45, 0xfc, 0x33, 0x83, 0x93, 0x1c, 0x59, 0x6b, 0x5d, 0x08, 0x2d, 0x1f, 0x62,
	0x54, 0x25, 0x44, 0x5f, 0xf1, 0x92, 0xcb, 0x5c, 0xbc, 0x24, 0x83, 0x26, 0x51, 0xbc, 0x54, 0x61,
	0x82, 0xe7, 0xa4, 0xa0, 0x38, 0xc6, 0xa1, 0x5e, 0xcb, 0x0a, 0xc5, 0x83, 0x40, 0x97, 0xc2, 0xda,
	0xaf, 0x14, 0x28, 0x0c, 0xec, 0xde, 0x27, 0x8f, 0x12, 0x1b, 0x96, 0xbb, 0xc4, 0xf7, 0x48, 0xcb,
	0x37, 0xbb, 0xed, 0x33, 0xc3, 0x75, 0x8e, 0xb1, 0xeb, 0xb4, 0x09, 0xb1, 0xf9, 0x4a, 0xcf, 0x67,
	0xb3, 0x35, 0x12, 0xd2, 0x97, 0x12, 0x60, 0x31, 0x59, 0x73, 0x61, 0x75, 0xc0, 0xf2, 0x44, 0x18,
	0xd4, 0x23, 0xf7, 0x88, 0x32, 0xf1, 0xad, 0x8b, 0x57, 0x34, 0xfd, 0x8e, 0x3a, 0x86, 0xa5, 0x3d,
	0xe2, 0x77, 0x4c, 0xd7, 0xf9, 0x14, 0xdb, 0x89, 0x04, 0x88, 0x10, 0x8c, 0xb9, 0xb8, 0x29, 0x3c,
	0xa4, 0xea, 0xfc, 0x19, 0xe5, 0x21, 0x47, 0x49, 0x57, 0xee, 0x0f, 0xf6, 0xc8, 0xd2, 0x95, 0xef,
	0xb4, 0xda, 0xa2, 0xc2, 0x56, 0x75, 0xf1, 0x82, 0x96, 0x61, 0xe2, 0x88, 0x50, 0x4a, 0x3a, 0xf2,
	0x98, 0x91, 0x6f, 0xda, 0x87, 0x30, 0xc3, 0xb2, 0xf6, 0xd3, 0x4f, 0x15, 0xda, 0x6f, 0x14, 0x98,
	0x66, 0xd0, 0x62, 0x91, 0x29, 0xac, 0x7a, 0xd1, 0xa4, 0x06, 0x73, 0xbe, 0x70, 0xdc, 0xdb, 0x19,
	0x54, 0x0d, 0x75, 0x8c, 0xbe, 0xe2, 0x0d, 0x23, 0xe3, 0x60, 0x30, 0xb4, 0xd4, 0x0b, 0x84, 0x96,
	0xf6, 0xb9, 0x02, 0xf3, 0xcc, 0xfe, 0xc4, 0x52, 0x5f, 0x85, 0x69, 0xda, 0xee, 0x75, 0x8e, 0x3c,
	0xd3, 0x11, 0x27, 0xcc, 0xac, 0x1e, 0x13, 0xd0, 0xfb, 0x89, 0x4d, 0x27, 0xf6, 0x70, 0x29, 0x63,
	0x69, 0x99, 0xde, 0x73, 0xdb, 0x51, 0x50, 0x89, 0xed, 0xfb, 0x6a, 0x46, 0xa4, 0xfe, 0x48, 0xfa,
	0x87, 0x0a, 0x57, 0x1a, 0xe1, 0x4d, 0x12, 0xdb, 0xe2, 0x30, 0x47, 0x5d, 0x58, 0x19, 0xb1, 0x14,
	0x72, 0xcd, 0x2f, 0xbf, 0x10, 0x4b, 0x43, 0x17, 0xe2, 0x49, 0x96, 0x01, 0x7d, 0x04, 0x60, 0x52,
	0xea, 0x3b, 0x47, 0x3d, 0x1a, 0x79, 0xe3, 0x8d, 0x0c, 0x06, 0x8a, 0xc3, 0x1e, 0xdb, 0xe5, 0x50,
	0x58, 0xde, 0xf9, 0x62, 0x30, 0x74, 0x08, 0xd3, 0xae, 0xe9, 0xd9, 0x1d, 0xd3, 0x3f, 0x0e, 0x73,
	0xdb, 0xeb, 0x17, 0x40, 0xde, 0x95, 0xb2, 0xf2, 0xc6, 0x19, 0x41, 0x69, 0xbf, 0x56, 0x61, 0x9c,
	0x97, 0x4c, 0x4f, 0xf3, 0xe4, 0xc5, 0xb0, 0x48, 0xe3, 0xa5, 0x34, 0x44, 0x91, 0x1c, 0x06, 0x5a,
	0x16, 0x87, 0xa4, 0x02, 0x41, 0x47, 0x74, 0x90, 0x14, 0xfc, 0x2b, 0xdd, 0xfd, 0x62, 0xdf, 0x89,
	0xce, 0xd3, 0x90, 0x64, 0x4a, 0x1c, 0xeb, 0xff, 0x0f, 0x57, 0x52, 0x50, 0x2c, 0xf1, 0x79, 0x66,
	0x07, 0xcb, 0xc3, 0x9d, 0x3f, 0x9f, 0x57, 0x1f, 0xb0, 0x34, 0x78, 0x62, 0xba, 0xbd, 0xf0, 0x38,
	0x17, 0x2f, 0xda, 0x0f, 0x15, 0xc8, 0x0f, 0xae, 0xdf, 0x50, 0xf8, 0x1a, 0x8c, 0x77, 0xd9, 0x24,
	0x65, 0xb0, 0xbe, 0x7e, 0xa1, 0x2d, 0x71, 0x88, 0x7d, 0x8a, 0x4f, 0x75, 0x81, 0x30, 0x60, 0x69,
	0x2e, 0x55, 0xc9, 0xfc, 0x6e, 0x06, 0x96, 0xf9, 0x9a, 0xc7, 0x99, 0x46, 0xc7, 0x41, 0xcf, 0xa5,
	0xc1, 0xe3, 0x9b, 0x38, 0x89, 0xe0, 0x82, 0x27, 0x0c, 0x2e, 0x0f, 0x56, 0xe5, 0xa3, 0x21, 0x2e,
	0x53, 0x89, 0x0e, 0x99, 0x0c, 0xb1, 0xdb, 0x59, 0x4f, 0xfd, 0xc4, 0x2c, 0x56, 0x24, 0xe8, 0x00,
	0x3d, 0x40, 0xdf, 0x06, 0x2d, 0xd4, 0xd7, 0xf5, 0x71, 0xc0, 0xaf, 0x32, 0x69, 0xc5, 0x2b, 0x97,
	0x56, 0xfc, 0xbc, 0x44, 0xdf, 0x97, 0xe0, 0x29, 0x03, 0xda, 0xb0, 0xcc, 0x3b, 0x24, 0x69, 0xa5,
	0xb9, 0x4b, 0x2b, 0x2d, 0x30, 0xc4, 0x94, 0xa6, 0x33, 0x78, 0x9e, 0x6b, 0x7a, 0xcc, 0x3c, 0x8b,
	0x97, 0x56, 0xc9, 0xdb, 0x3c, 0x23, 0x27, 0xf9, 0x09, 0xac, 0x88, 0xeb, 0x66, 0x5a, 0xe5, 0xd8,
	0xa5, 0x55, 0x2e, 0x71, 0xc8, 0x94, 0xae, 0x87, 0x90, 0xe7, 0x4d, 0x96, 0xa4, 0x92, 0x71, 0xae,
	0xe4, 0x56, 0xc6, 0xa3, 0x2b, 0xa1, 0x63, 0xa1, 0xd9, 0xf7, 0x1e, 0xa0, 0x8f, 0x21, 0xcf, 0x9d,
	0x98, 0x44, 0x9f, 0xb8, 0x5c, 0x53, 0x6e, 0x81, 0x01, 0x25, 0xb1, 0x3b, 0xb0, 0x18, 0x35, 0xab,
	0x62, 0xfc, 0xe2, 0x64, 0xe6, 0x56, 0xcd, 0xc8, 0xd2, 0x50, 0x47, 0x21, 0x70, 0xa2, 0x86, 0x38,
	0x86, 0xa5, 0x61, 0x1d, 0xa2, 0xa0, 0x38, 0xc3, 0xe7, 0xf3, 0xe6, 0xe5, 0x7a, 0x43, 0x7a, 0x61,
	0x48, 0x57, 0x88, 0xaf, 0x0a, 0x6f, 0x08, 0x25, 0xfd, 0x36, 0x9b, 0x79, 0x55, 0xd8, 0x9d, 0x39,
	0xb9, 0x2a, 0xb4, 0xef, 0x9d, 0xc5, 0x17, 0x92, 0x2d, 0xa0, 0x24, 0xfe, 0x3c, 0xc7, 0x7f, 0xe7,
	0xc2, 0xed, 0x9f, 0x84, 0xa6, 0x2b, 0x02, 0x36, 0xa9, 0xeb, 0x5b, 0x70, 0xd5, 0x25, 0x2d, 0x62,
	0xf8, 0xd8, 0x22, 0x2d, 0xcf, 0xe1, 0x7d, 0x9e, 0xa4, 0xd6, 0x45, 0xae, 0x35, 0xcb, 0x72, 0xed,
	0x92, 0x16, 0xd1, 0x63, 0x94, 0x84, 0xda, 0x35, 0x77, 0xd4, 0x50, 0x80, 0x6e, 0xc0, 0x38, 0xf6,
	0x7d, 0xe2, 0x17, 0xa7, 0x79, 0x5c, 0xa0, 0x50, 0x91, 0xdf, 0xb5, 0x4a, 0x07, 0xbc, 0x21, 0xaf,
	0x0b, 0x06, 0xed, 0x3b, 0x0a, 0x2c, 0x0d, 0x74, 0xe4, 0x83, 0x2e, 0xf1, 0x02, 0x8c, 0xda, 0x80,
	0x62, 0x93, 0x0d, 0x5f, 0xe4, 0x78, 0x59, 0xfc, 0xde, 0xc9, 0x1a, 0xc7, 0xa9, 0x43, 0x42, 0xbf,
	0x62, 0x0e, 0x92, 0xb4, 0xaf, 0x54, 0x58, 0x19, 0xe0, 0xde, 0xf7, 0x49, 0xcb, 0xc7, 0xc1, 0x39,
	0x67, 0xca, 0xcb, 0x90, 0xef, 0x4a, 0x46, 0xa3, 0x8b, 0x7d, 0x0b, 0xcb, 0x13, 0x70, 0x5c, 0x5f,
	0x08, 0xe9, 0xfb, 0x82, 0x8c, 0xee, 0x00, 0xc4, 0xfd, 0x0e, 0xd9, 0x52, 0x5e, 0x4b, 0xd5, 0x74,
	0x51, 0xd5, 0xa1, 0x4f, 0x47, 0x9d, 0x0e, 0xf4, 0x0e, 0xcc, 0xf4, 0xba, 0xb6, 0x49, 0xb1, 0x90,
	0x1d, 0x3b, 0x57, 0x16, 0x04, 0x3b, 0x17, 0xde, 0x86, 0x49, 0xf9, 0x55, 0x81, 0xf7, 0xbc, 0x2e,
	0xf4, 0x55, 0x42, 0x0f, 0x45, 0x93, 0x87, 0xe7, 0xc4, 0x13, 0x5e, 0x74, 0xbe, 0x37, 0xb8, 0xe0,
	0x91, 0xab, 0x8f, 0x61, 0x31, 0xb1, 0xe0, 0xa1, 0x03, 0xe5, 0x8a, 0x6f, 0x5e, 0x7c, 0xc5, 0x43,
	0x60, 0x3d, 0x11, 0x47, 0x21, 0x4d, 0xfb, 0xc5, 0x18, 0xac, 0x8e, 0xec, 0x1a, 0xa3, 0x1b, 0x83,
	0x5d, 0x0e, 0x25, 0xfc, 0x0e, 0xa2, 0xf6, 0xb7, 0x3a, 0x50, 0x09, 0xf2, 0x1d, 0xf3, 0xd4, 0x30,
	0x5d, 0x8a, 0x7d, 0xcf, 0xa4, 0xce, 0x89, 0x6c, 0xca, 0x8d, 0x8b, 0x62, 0x6d, 0xa1, 0x63, 0x9e,
	0x96, 0x13, 0x63, 0x8c, 0xbf, 0xe9, 0x30, 0x02, 0x9b, 0x60, 0xd3, 0xf4, 0x1c, 0x7a, 0xc6, 0xa3,
	0x61, 0x4a, 0xf2, 0x8b, 0xc1, 0xfd, 0x70, 0x0c, 0x7d, 0x0d, 0x16, 0x64, 0x02, 0x94, 0x9f, 0x82,
	0xc2, 0xd3, 0xe8, 0xbf, 0x33, 0xa7, 0x3e, 0xf9, 0x8d, 0x46, 0x28, 0x98, 0x0f, 0x92, 0xb4, 0x00,
	0x55, 0xe1, 0x2a, 0xf6, 0xcc, 0x23, 0x17, 0x1b, 0x66, 0x8f, 0x92, 0x8e, 0x49, 0x1d, 0xcb, 0xe8,
	0xf6, 0x3c, 0x8b, 0xf6, 0x44, 0x62, 0x1f, 0x8f, 0x6d, 0x5b, 0x13, 0x8c, 0xe5, 0x90, 0x6f, 0x3f,
	0x66, 0x43, 0xff, 0x05, 0xb3, 0x66, 0xcf, 0x76, 0x88, 0x68, 0x6f, 0x8b, 0xe3, 0x46, 0xba, 0x60,
	0x86, 0x0f, 0xf0, 0xbc, 0x15, 0xa0, 0x32, 0x48, 0x14, 0x23, 0xe8, 0x62, 0xf3, 0x18, 0xfb, 0x86,
	0xed, 0x98, 0xbe, 0xf3, 0x69, 0x7c, 0x8a, 0x48, 0x65, 0x45, 0xc1, 0x76, 0x20, 0xb8, 0xb6, 0x63,
	0x26, 0xf4, 0x1e, 0xac, 0x26, 0x64, 0x22, 0x1c, 0x8b, 0xf4, 0x3c, 0xca, 0x5b, 0xf7, 0x52, 0xef,
	0x4a, 0x82, 0x4b, 0xc2, 0x54, 0x18, 0x0f, 0xba, 0x03, 0xcb, 0xd2, 0x86, 0x47, 0xc4, 0xb7, 0x13,
	0xfd, 0x61, 0x9e, 0xad, 0xa4, 0xfe, 0x82, 0x60, 0xf9, 0x3f, 0xe2, 0xdb, 0x71, 0x7f, 0x58, 0x2b,
	0xc1, 0x5c, 0x9f, 0x4f, 0xd1, 0x73, 0x30, 0xd9, 0x6d, 0xfb, 0x66, 0x20, 0xaf, 0xe5, 0xf2, 0x53,
	0x59, 0x48, 0xd3, 0x7e, 0xaa, 0xc0, 0xe2, 0x90, 0x28, 0x43, 0x16, 0xcc, 0xf6, 0x45, 0x8c, 0x88,
	0xf1, 0xf7, 0x32, 0x2f, 0x69, 0x32, 0xed, 0xc6, 0x38, 0x7a, 0x1f, 0x68, 0x3a, 0x88, 0xd5, 0x30,
	0x88, 0x73, 0x03, 0xfd, 0xba, 0x9f, 0x2b, 0x70, 0xf5, 0x71, 0xc0, 0xac, 0x28, 0x8f, 0xcf, 0x5f,
	0x99, 0x06, 0x13, 0x94, 0x81, 0xcb, 0x8a, 0x1a, 0x5e, 0x56, 0x72, 0x7d, 0x77, 0x8c, 0x1d, 0x18,
	0x67, 0x0e, 0x0f, 0x8b, 0xc6, 0x57, 0x32, 0xcc, 0x96, 0xb9, 0xbf, 0xe6, 0x35, 0x89, 0x00, 0x13,
	0xe2, 0xda, 0x9f, 0x14, 0x98, 0x0a, 0x07, 0xd0, 0xdb, 0x7d, 0x79, 0xf5, 0xdc, 0x6e, 0x58, 0x22,
	0xad, 0xbe, 0x01, 0x53, 0x61, 0xeb, 0xf8, 0xfc, 0x3b, 0xf6, 0xa4, 0xec, 0x19, 0xb3, 0xdb, 0x0f,
	0xb3, 0x42, 0xde, 0x93, 0xf8, 0xf3, 0xa8, 0xab, 0x5a, 0xff, 0xec, 0xaf, 0xc3, 0x4c, 0x18, 0xaa,
	0xd4, 0x14, 0x5f, 0xd3, 0xc6, 0x25, 0x97, 0xa4, 0x37, 0xcc, 0x96, 0x56, 0x82, 0xfc, 0xe0, 0xc5,
	0x08, 0xcd, 0x82, 0x72, 0x2a, 0xbb, 0x58, 0x0a, 0x7f, 0x3b, 0x93, 0x17, 0x38, 0xe5, 0x4c, 0x73,
	0x60, 0x39, 0xdd, 0x5b, 0xd8, 0x27, 0xee, 0x19, 0xaa, 0xc3, 0xd4, 0x09, 0xf6, 0xa9, 0x63, 0x45,
	0xe1, 0x75, 0xa9, 0x5b, 0x59, 0x04, 0xa2, 0x7d, 0xa6, 0xc0, 0x0c, 0xab, 0x71, 0xfe, 0xfd, 0x7d,
	0xf2, 0x4b, 0xf5, 0x77, 0x98, 0xa9, 0xfd, 0xfd, 0x9d, 0x5f, 0x2a, 0x30, 0x1d, 0x51, 0xd1, 0x31,
	0x14, 0x7c, 0x7e, 0x08, 0x0d, 0x6d, 0xea, 0xdc, 0xb9, 0x54, 0x53, 0x87, 0x39, 0x5e, 0x47, 0x12,
	0xf6, 0x29, 0xb5, 0x74, 0xb4, 0x2e, 0xcc, 0xf7, 0x97, 0x96, 0x2c, 0x06, 0xf9, 0x4f, 0x01, 0xf2,
	0x06, 0xce, 0x13, 0xd1, 0xe5, 0xda, 0x69, 0x89, 0xf5, 0x8c, 0xdb, 0x69, 0xda, 0x6f, 0x15, 0x58,
	0xec, 0xaf, 0x36, 0x85, 0xcb, 0xfe, 0xa3, 0x5a, 0x61, 0xda, 0x17, 0x2a, 0x14, 0x47, 0xd5, 0xcc,
	0xe8, 0x7e, 0x1c, 0xbc, 0xb9, 0x4b, 0x05, 0xef, 0xbd, 0x67, 0xe2, 0xf0, 0x7d, 0x16, 0xa6, 0xf8,
	0xb1, 0x17, 0xfe, 0x30, 0x91, 0x63, 0x83, 0x9c, 0x52, 0xb3, 0x9f, 0xc6, 0x77, 0x8f, 0x6b, 0xe9,
	0xfc, 0xd2, 0xb7, 0x3d, 0xf6, 0xa2, 0xed, 0xa1, 0x66, 0xbe, 0x15, 0x0d, 0x59, 0xdf, 0x70, 0xa3,
	0x6c, 0xcd, 0xf2, 0x6c, 0xcf, 0xe6, 0xe3, 0x35, 0x89, 0xf6, 0x77, 0x05, 0x56, 0x47, 0xde, 0x02,
	0x9e, 0xc6, 0xf4, 0xfe, 0x17, 0x26, 0x64, 0xd5, 0x20, 0xcc, 0xbf, 0x91, 0x25, 0x70, 0x99, 0x80,
	0x2e, 0xe5, 0x2e, 0xf9, 0x01, 0x67, 0xf8, 0xdf, 0x27, 0x37, 0xff, 0xa2, 0xc0, 0xa4, 0x2c, 0x80,
	0xd1, 0x0a, 0x2c, 0xee, 0x54, 0xcb, 0x8d, 0x07, 0x7a, 0xd5, 0x78, 0xb0, 0x77, 0xb0, 0x5f, 0xad,
	0xd4, 0x76, 0x6a, 0xd5, 0xed, 0xfc, 0x33, 0x68, 0x11, 0x16, 0x76, 0xcb, 0x5b, 0xd5, 0x5d, 0x63,
	0xbb, 0xda, 0xa8, 0x56, 0x1a, 0xb5, 0xfa, 0x5e, 0x5e, 0x41, 0xab, 0xb0, 0x74, 0x70, 0xaf, 0xde,
	0x30, 0x2a, 0xf7, 0xca, 0x7b, 0x77, 0xab, 0x89, 0x21, 0x15, 0x5d, 0x83, 0xb5, 0xea, 0x87, 0xfb,
	0xbb, 0xb5, 0x4a, 0xad, 0x61, 0x54, 0xea, 0x7b, 0x8d, 0xea, 0x5e, 0x23, 0x31, 0x9e, 0x43, 0x08,
	0xe6, 0x77, 0xca, 0x95, 0xa4, 0xcc, 0x18, 0x2a, 0x42, 0xe1, 0x60, 0xbf, 0x5a, 0xad, 0xdc, 0x33,
	0x1a, 0x7a, 0x79, 0xef, 0xa0, 0xa2, 0xd7, 0xf6, 0xf9, 0xc8, 0x04, 0xe3, 0x6e, 0x54, 0x3f, 0x4c,
	0x22, 0x4c, 0x32, 0x8b, 0xea, 0x5b, 0xef, 0x57, 0x2b, 0x0d, 0xc6, 0x5d, 0xb9, 0x5f, 0xdb, 0xbb,
	0x9b, 0x9f, 0x46, 0x05, 0xc8, 0xef, 0xd6, 0xef, 0xd6, 0x0d, 0xbd, 0x5a, 0xa9, 0xdf, 0xdd, 0xab,
	0x71, 0xd6, 0xd9, 0x9b, 0x3e, 0xa0, 0xf4, 0x57, 0x7c, 0x74, 0x1d, 0xd6, 0x07, 0xa6, 0x64, 0x7c,
	0x50, 0xdf, 0x1e, 0x9c, 0xf8, 0x1c, 0x4c, 0xf3, 0x39, 0xb2, 0xa1, 0xbc, 0x82, 0xe6, 0x01, 0x76,
	0xf4, 0xf2, 0x07, 0x55, 0xf1, 0xae, 0x32, 0x87, 0xf1, 0xe1, 0xf2, 0xde, 0xb6, 0x91, 0x18, 0xc8,
	0xdd, 0xa4, 0x00, 0xf1, 0x27, 0x22, 0xb4, 0x06, 0xcb, 0xbb, 0xb5, 0xfb, 0xd5, 0xdd, 0xda, 0xbd,
	0x7a, 0x7d, 0x7b, 0x40, 0xc3, 0x15, 0x98, 0x3b, 0xac, 0xea, 0x1f, 0x19, 0x0f, 0xf6, 0x38, 0xcb,
	0x47, 0x79, 0x05, 0xcd, 0xc2, 0x54, 0xf4, 0xa6, 0xb2, 0xb7, 0xfd, 0xfa, 0xc1, 0x41, 0x6d, 0x6b,
	0xb7, 0x9a, 0xcf, 0x21, 0x80, 0x09, 0x39, 0x32, 0x86, 0x16, 0x60, 0x86, 0x8b, 0x4a, 0xc2, 0xf8,
	0xed, 0xcf, 0x55, 0x28, 0xf2, 0x65, 0xae, 0x25, 0xd6, 0xfe, 0x00, 0xfb, 0x27, 0x8e, 0x85, 0xd1,
	0xef, 0x15, 0x98, 0xeb, 0xbb, 0x89, 0xa0, 0x2c, 0x1f, 0xa3, 0x86, 0xfd, 0x3e, 0xb6, 0xf6, 0x5c,
	0x28, 0x98, 0xf8, 0xaf, 0xad, 0x54, 0x0f, 0xff, 0x6b, 0xd3, 0xec, 0x2f, 0xcb, 0xa5, 0x51, 0xd7,
	0xdc, 0xe1, 0x97, 0xa1, 0x3f, 0x97, 0x51, 0x74, 0xed, 0x7c, 0x35, 0xfc, 0x2d, 0xec, 0xbb, 0x7f,
	0xfc, 0xdb, 0x8f, 0xd4, 0xa2, 0xb6, 0x18, 0xfd, 0xdc, 0x17, 0x6c, 0xca, 0x9b, 0x0d, 0xde, 0x54,
	0x6e, 0xae, 0x35, 0xbe, 0x2c, 0xaf, 0xa7, 0x4d, 0x16, 0x86, 0x99, 0x5d, 0x27, 0x28, 0x59, 0xa4,
	0xf3, 0x87, 0x72, 0xa9, 0x4d, 0x69, 0x37, 0xd8, 0xdc, 0xd8, 0x78, 0xf4, 0xe8, 0xd1, 0xc0, 0xe0,
	0x86, 0xd9, 0xa3, 0x6d, 0xf1, 0x47, 0xe1, 0x6b, 0x5d, 0xd7, 0xa4, 0x4d, 0xe2, 0x77, 0xb6, 0xbe,
	0xaf, 0xc2, 0x4b, 0x16, 0xe9, 0x9c, 0xef, 0x99, 0xad, 0xe7, 0x46, 0x79, 0x7a, 0x9f, 0xe5, 0xe9,
	0x7d, 0xe5, 0x63, 0x5d, 0x62, 0xb4, 0x08, 0xab, 0x3e, 0x4b, 0xc4, 0x6f, 0x6d, 0xb4, 0xb0, 0xc7,
	0xb3, 0xf8, 0x46, 0x6c, 0xc9, 0x63, 0x7e, 0x69, 0x7c, 0x27, 0x45, 0xfc, 0x99, 0xfa, 0xc2, 0x5d,
	0x01, 0x5a, 0xe1, 0x86, 0xa5, 0x4c, 0x28, 0x1d, 0xde, 0xfa, 0x32, 0xe4, 0x79, 0xc8, 0x79, 0x1e,
	0xa6, 0x78, 0x1e, 0x1e, 0xde, 0xfa, 0x4a, 0xbd, 0x2e, 0x78, 0x36, 0x37, 0x39, 0xd3, 0xe6, 0x66,
	0x8a, 0x6b, 0x73, 0xf3, 0xf0, 0xd6, 0xd1, 0x04, 0xb7, 0xf6, 0xf5, 0x7f, 0x06, 0x00, 0x00, 0xff,
	0xff, 0xaf, 0xa7, 0xc0, 0x77, 0x7f, 0x29, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoIntelligenceServiceClient(cc grpc.ClientConnInterface) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(ctx context.Context, req *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1/video_intelligence.proto",
}
