#! /bin/sh

usage() {
	echo "USAGE: update.sh MAJOR MINOR MICRO"
}

if [ "$#" -ne 3 ]; then
	usage
	exit 0
fi

if [ "$1" = "-h" ]
then
	usage
	exit 0
fi

EPIAR_VERSION_OLD=`awk '$2 == "EPIAR_VERSION_FULL" {print $3}' source/version.h | tr -d '"'`

MAJOR=$1
MINOR=$2
MICRO=$3

EPIAR_VERSION_NEW="$MAJOR.$MINOR.$MICRO"

echo "Old Version: $EPIAR_VERSION_FULL"
echo "New Version: $MAJOR.$MINOR.$MICRO"

echo "Updating the version number in version.h"
cat source/version.h | \
	sed "s/EPIAR_VERSION_MAJOR.*$/EPIAR_VERSION_MAJOR $MAJOR/" | \
	sed "s/EPIAR_VERSION_MINOR.*$/EPIAR_VERSION_MINOR $MINOR/" | \
	sed "s/EPIAR_VERSION_MICRO.*$/EPIAR_VERSION_MICRO $MICRO/" | \
	sed "s/EPIAR_VERSION_FULL.*$/EPIAR_VERSION_FULL \"$EPIAR_VERSION_NEW\"/" \
	> source/newversion.h
mv source/newversion.h source/version.h

echo "Updating the version number in the README"
sed "s/Version .*/Version $EPIAR_VERSION_NEW/" < README > README.new
mv README.new README

if hash defaults 2>/dev/null; then
	echo "Update the version Number in the Info.plist to $EPIAR_VERSION_NEW."
	defaults write `pwd`/Build/OS\ X/Info CFBundleShortVersionString "$EPIAR_VERSION_NEW"
	defaults read `pwd`/Build/OS\ X/Info
else
	echo "Warning: Unable to update OS X Info.plist as your system does not have the OS X 'defaults' utility."
fi

echo "TODO: Update all of the .xml files to $EPIAR_VERSION_NEW."
