import React from "react";
import PropTypes from "prop-types";
import { asNumber, guessType } from "../../utils";
var nums = new Set(["number", "integer"]);
/**
 * This is a silly limitation in the DOM where option change event values are
 * always retrieved as strings.
 */

function processValue(schema, value) {
  // "enum" is a reserved word, so only "type" and "items" can be destructured
  var type = schema.type,
      items = schema.items;

  if (value === "") {
    return undefined;
  } else if (type === "array" && items && nums.has(items.type)) {
    return value.map(asNumber);
  } else if (type === "boolean") {
    return value === "true";
  } else if (type === "number") {
    return asNumber(value);
  } // If type is undefined, but an enum is present, try and infer the type from
  // the enum values


  if (schema["enum"]) {
    if (schema["enum"].every(function (x) {
      return guessType(x) === "number";
    })) {
      return asNumber(value);
    } else if (schema["enum"].every(function (x) {
      return guessType(x) === "boolean";
    })) {
      return value === "true";
    }
  }

  return value;
}

function getValue(event, multiple) {
  if (multiple) {
    return [].slice.call(event.target.options).filter(function (o) {
      return o.selected;
    }).map(function (o) {
      return o.value;
    });
  } else {
    return event.target.value;
  }
}

function SelectWidget(props) {
  var schema = props.schema,
      id = props.id,
      options = props.options,
      value = props.value,
      required = props.required,
      disabled = props.disabled,
      readonly = props.readonly,
      multiple = props.multiple,
      autofocus = props.autofocus,
      _onChange = props.onChange,
      onBlur = props.onBlur,
      onFocus = props.onFocus,
      placeholder = props.placeholder;
  var enumOptions = options.enumOptions,
      enumDisabled = options.enumDisabled;
  var emptyValue = multiple ? [] : "";
  return React.createElement("select", {
    id: id,
    multiple: multiple,
    className: "form-control",
    value: typeof value === "undefined" ? emptyValue : value,
    required: required,
    disabled: disabled || readonly,
    autoFocus: autofocus,
    onBlur: onBlur && function (event) {
      var newValue = getValue(event, multiple);
      onBlur(id, processValue(schema, newValue));
    },
    onFocus: onFocus && function (event) {
      var newValue = getValue(event, multiple);
      onFocus(id, processValue(schema, newValue));
    },
    onChange: function onChange(event) {
      var newValue = getValue(event, multiple);

      _onChange(processValue(schema, newValue));
    }
  }, !multiple && schema["default"] === undefined && React.createElement("option", {
    value: ""
  }, placeholder), enumOptions.map(function (_ref, i) {
    var value = _ref.value,
        label = _ref.label;
    var disabled = enumDisabled && enumDisabled.indexOf(value) != -1;
    return React.createElement("option", {
      key: i,
      value: value,
      disabled: disabled
    }, label);
  }));
}

SelectWidget.defaultProps = {
  autofocus: false
};

if (process.env.NODE_ENV !== "production") {
  SelectWidget.propTypes = {
    schema: PropTypes.object.isRequired,
    id: PropTypes.string.isRequired,
    options: PropTypes.shape({
      enumOptions: PropTypes.array
    }).isRequired,
    value: PropTypes.any,
    required: PropTypes.bool,
    disabled: PropTypes.bool,
    readonly: PropTypes.bool,
    multiple: PropTypes.bool,
    autofocus: PropTypes.bool,
    onChange: PropTypes.func,
    onBlur: PropTypes.func,
    onFocus: PropTypes.func
  };
}

export default SelectWidget;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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