/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.properties;

import java.util.Map;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.properties.SystemPropertiesInstaller;
import org.gradle.internal.Cast;

public class DefaultSystemPropertiesInstaller
implements SystemPropertiesInstaller {
    private final StartParameterInternal startParameter;

    public DefaultSystemPropertiesInstaller(StartParameterInternal startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public void setSystemPropertiesFrom(GradleProperties gradleProperties) {
        DefaultSystemPropertiesInstaller.setSystemPropertiesFromGradleProperties(gradleProperties);
        this.setSystemPropertiesFromStartParameter();
    }

    private void setSystemPropertiesFromStartParameter() {
        Map systemPropertiesArgs = this.startParameter.getSystemPropertiesArgs();
        System.getProperties().putAll((Map<?, ?>)systemPropertiesArgs);
    }

    private static void setSystemPropertiesFromGradleProperties(GradleProperties properties) {
        String prefix = "systemProp.";
        int prefixLength = prefix.length();
        Map prefixedProperties = properties.getPropertiesWithPrefix(prefix);
        for (Map.Entry entry : prefixedProperties.entrySet()) {
            String prefixedPropertyName = (String)entry.getKey();
            String systemPropertyKey = prefixedPropertyName.substring(prefixLength);
            String propertyValue = (String)entry.getValue();
            System.setProperty(systemPropertyKey, (String)Cast.uncheckedNonnullCast((Object)propertyValue));
        }
    }
}

